/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.formplugin.DSField;
import kd.fi.ai.formplugin.FactorInfo;
import kd.fi.ai.formplugin.importhandler.BaseDataMapTypeImportHandler;
import kd.fi.ai.util.AiDynamicObjectSerializeUtil;
import kd.fi.ai.util.BaseDataMappingUtil;
import kd.fi.ai.util.GLUtil;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;

public class BasedataMappingEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BOS_ORG = "bos_org";
    private static final String BOS_ADMINORG_STRUCTURE = "bos_adminorg_structure";
    private static final String Rule = "rule";
    private static final String RuleField = "rulemappingfield";
    private static final String CustomField = "custommappingfield";
    private static final String PluginField = "pluginmappingfield";
    private static final String KEY_AI_BDMCOPYID = "ai_bdm_copyid";
    private static final String DS_FIELDS = "DSFields";
    private static final String CENTER = "center";

    public void afterBindData(EventObject e) {
        String idPk;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        OperationStatus stat = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)stat)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save"});
        }
        Long id = 0L;
        Object objId = model.getValue("id");
        if (objId != null) {
            id = (Long)objId;
        }
        if (null != id && id == 0L && (idPk = this.getPageCache().get(KEY_AI_BDMCOPYID)) != null) {
            id = Long.parseLong(idPk.toString());
        }
        if (null != id && id == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PluginField, CustomField});
            Boolean bycustom = (Boolean)model.getValue("bycustom");
            this.getView().setVisible(bycustom, new String[]{CustomField});
        } else {
            String type = (String)model.getValue("type");
            if (Rule.equalsIgnoreCase(type)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{PluginField});
                Boolean bycustom = (Boolean)model.getValue("bycustom");
                this.getView().setVisible(bycustom, new String[]{CustomField});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{RuleField, CustomField});
            }
        }
        String factorValue = (String)this.getModel().getValue("factorvalue");
        if (StringUtils.isNotEmpty((CharSequence)factorValue)) {
            String[] factorValues = factorValue.split(",");
            Object[] factorNames = FahEntityMetaHelper.batchGetFactorName((String[])factorValues);
            String nameStr = StringUtils.join((Object[])factorNames, (String)",");
            this.getModel().setValue("factorname", (Object)nameStr);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        OperationStatus stat = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.VIEW.equals((Object)stat)) {
            this.addClickListeners(new String[]{"factorname"});
            BasedataEdit destBaseDataEdit = (BasedataEdit)this.getView().getControl("destbasedata");
            destBaseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void setSouceData(String dataStr, String typeStr, List<Long> idList) {
        if (null == dataStr || null == typeStr) {
            return;
        }
        DynamicObjectType type = (DynamicObjectType)SerializationUtils.deSerializeFromBase64((String)typeStr);
        DynamicObject editdata = AiDynamicObjectSerializeUtil.deserialize(dataStr, type);
        IDataModel model = this.getModel();
        DynamicObjectCollection mapdatas = editdata.getDynamicObjectCollection("fieldmapentry");
        ArrayList<DSField> list = new ArrayList<DSField>();
        for (DynamicObject map : mapdatas) {
            DSField ds = new DSField();
            ds.setDataType(map.getString("datatype"));
            ds.setEntityId(map.getString("entityid"));
            ds.setFieldKey(map.getString("fieldkey"));
            ds.setFieldName(new LocaleString(map.getString("fieldname")));
            list.add(ds);
        }
        DynamicObjectCollection coll = editdata.getDynamicObjectCollection("entryentity");
        if (coll != null && coll.size() > 0) {
            int[] index = model.batchCreateNewEntryRow("entryentity", coll.size());
            int i = 0;
            DynamicObjectType collType = coll.getDynamicObjectType();
            for (DynamicObject row : coll) {
                for (DSField field : list) {
                    DynamicObject fieldData;
                    String fieldKey = field.getFieldKey();
                    if (collType.getProperty(fieldKey) == null || (fieldData = row.getDynamicObject(fieldKey)) == null) continue;
                    model.setValue(fieldKey, (Object)fieldData.getLong("id"), index[i]);
                }
                if (!idList.isEmpty()) {
                    model.setValue("destdatamapping", (Object)idList.get(i), index[i]);
                }
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("factorname".equals(control.getKey())) {
            this.showFactorList();
        }
    }

    private void showFactorList() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_accountfactorlistf7");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObjectCollection fieldmapentry = this.getModel().getEntryEntity("fieldmapentry");
        if (null != fieldmapentry && fieldmapentry.size() != 0) {
            HashMap<String, FactorInfo> factorInfoMap = new HashMap<String, FactorInfo>();
            FactorInfo info = null;
            for (DynamicObject dyn : fieldmapentry) {
                info = new FactorInfo();
                info.setBDType(Integer.parseInt(dyn.getString("datatype")));
                info.setSrcEntityNumber(dyn.getString("entityid"));
                info.setSrcPropKey(dyn.getString("entityid"));
                String fieldname = 0 == info.getBDType() ? FahEntityMetaHelper.getEntityName((Object)info.getSrcEntityNumber()) : (1 == info.getBDType() ? FahEntityMetaHelper.getEntityName((Object)ObjectConverterFactory.getLong((Object)info.getSrcEntityNumber())) : dyn.getString("fieldname"));
                info.setSrcEntityName(fieldname);
                info.setFactorName(fieldname);
                factorInfoMap.put(dyn.getString("entityid"), info);
            }
            showParameter.setCustomParam("info", (Object)GLUtil.toSerializedString(factorInfoMap));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ai_accountfactorlistf7");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object ret = event.getReturnData();
        if ("ai_accountfactorlistf7".equals(event.getActionId()) && null != ret) {
            List factorItems = (List)ret;
            if (factorItems.size() > 10) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u76ee\u524d\u6700\u591a\u652f\u630110\u4e2a\u6e90\u6570\u636e\u3002", (String)"BasedataMappingEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            this.generateFactor(factorItems);
        }
    }

    private void generateFactor(List<Map<String, String>> factorItems) {
        IDataModel model = this.getModel();
        StringBuilder entityNumber = new StringBuilder();
        StringBuilder entityName = new StringBuilder();
        String bdType = "0";
        StringBuilder baseDataEntity = new StringBuilder();
        StringBuilder asstDataEntity = new StringBuilder();
        ArrayList<DSField> fields = new ArrayList<DSField>(factorItems.size());
        int i = 0;
        int j = 0;
        Map<String, String> fieldMaps = this.getFieldMap(factorItems);
        for (Map<String, String> map : factorItems) {
            String srcentitynumber = map.get("fsrcentitynumber");
            String srcentityname = map.get("fsrcentityname");
            entityNumber.append(srcentitynumber).append(",");
            entityName.append(srcentityname).append(",");
            bdType = map.get("fbdtype");
            DSField dsField = new DSField();
            dsField.setDataType(bdType);
            dsField.setEntityId(srcentitynumber);
            if (fieldMaps.get(srcentitynumber) == null) {
                String fieldKey = "";
                if ("0".equals(bdType)) {
                    baseDataEntity.append(srcentitynumber).append(",");
                    fieldKey = "srcdatamapping" + i;
                    while (fieldMaps.containsValue(fieldKey)) {
                        fieldKey = "srcdatamapping" + ++i;
                    }
                    dsField.setFieldKey(fieldKey);
                    ++i;
                } else if ("1".equals(bdType)) {
                    asstDataEntity.append(srcentitynumber).append(",");
                    fieldKey = "assistsouce" + j;
                    while (fieldMaps.containsValue(fieldKey)) {
                        fieldKey = "assistsouce" + ++j;
                    }
                    dsField.setFieldKey(fieldKey);
                    ++j;
                }
            } else {
                if ("0".equals(bdType)) {
                    baseDataEntity.append(srcentitynumber).append(",");
                } else if ("1".equals(bdType)) {
                    asstDataEntity.append(srcentitynumber).append(",");
                }
                dsField.setFieldKey(fieldMaps.get(srcentitynumber));
            }
            dsField.setFieldName(new LocaleString(srcentityname));
            fields.add(dsField);
        }
        if (factorItems.size() > 0) {
            model.setValue("factorname", (Object)entityName.substring(0, entityName.length() - 1));
            model.setValue("factorvalue", (Object)entityNumber.substring(0, entityNumber.length() - 1));
        }
        if (baseDataEntity.length() > 0) {
            model.setValue("factorvalue_base", (Object)baseDataEntity.substring(0, baseDataEntity.length() - 1));
        }
        if (asstDataEntity.length() > 0) {
            model.setValue("factorvalue_asst", (Object)asstDataEntity.substring(0, asstDataEntity.length() - 1));
        }
        DynamicObject oriEntity = model.getDataEntity(true);
        String dataStr = AiDynamicObjectSerializeUtil.serialize(oriEntity, oriEntity.getDynamicObjectType());
        String typeStr = SerializationUtils.serializeToBase64((Object)oriEntity.getDynamicObjectType());
        this.saveFactorDataToModel(fields);
        List<Long> idList = this.getNotChangeBaseDataIds("destdatamapping");
        model.deleteEntryData("entryentity");
        DynamicObject desttype = (DynamicObject)this.getModel().getValue("destbasedata");
        this.reBuildModelAndGrid(fields, model.getDataEntityType(), desttype, true);
        this.setSouceData(dataStr, typeStr, idList);
    }

    private Map<String, String> getFieldMap(List<Map<String, String>> factorItems) {
        HashMap<String, String> factors = new HashMap<String, String>(16);
        DynamicObjectCollection fieldMaps = this.getModel().getEntryEntity("fieldmapentry");
        for (DynamicObject fieldMap : fieldMaps) {
            factors.put(fieldMap.getString("entityid"), fieldMap.getString("fieldkey"));
        }
        HashSet<String> fields = new HashSet<String>(16);
        for (Map<String, String> factorItem : factorItems) {
            fields.add(factorItem.get("fsrcentitynumber"));
        }
        factors.keySet().retainAll(fields);
        return factors;
    }

    private void saveFactorDataToModel(List<DSField> refList) {
        IDataModel model = this.getModel();
        model.deleteEntryData("fieldmapentry");
        for (DSField field : refList) {
            int rowIndex = model.createNewEntryRow("fieldmapentry");
            model.setValue("datatype", (Object)field.getDataType(), rowIndex);
            model.setValue("entityid", (Object)field.getEntityId(), rowIndex);
            model.setValue("fieldname", (Object)field.getFieldName(), rowIndex);
            model.setValue("fieldkey", (Object)field.getFieldKey(), rowIndex);
        }
    }

    private void reBuildModelAndGrid(List<DSField> list, MainEntityType mainEntityType, DynamicObject desttype, boolean rebuildGrid) {
        this.setFactorColumnMeta(list, mainEntityType);
        this.drawGrid(list, mainEntityType, desttype, rebuildGrid);
        this.getPageCache().put(DS_FIELDS, SerializationUtils.toJsonString(list));
    }

    private void drawGrid(List<DSField> refList, MainEntityType mainEntityType, DynamicObject asstacttype, boolean rebuildGrid) {
        Map<String, Object> assCol;
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        cols.add(this.createSeqColumn());
        if (refList != null) {
            for (DSField ref : refList) {
                Map<String, Object> col = this.createBaseDataColumn(ref);
                cols.add(col);
            }
        }
        if ((assCol = this.createAssTypeColumn(mainEntityType, asstacttype)) != null) {
            cols.add(assCol);
        }
        if (rebuildGrid) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("rk", "rk");
            meta.put("seq", "fseq");
            meta.put("columns", cols);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod("entryentity", "createGridColumns", new Object[]{meta});
        }
    }

    private Map<String, Object> createSeqColumn() {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put("dataIndex", "seq");
        col.put("width", 60);
        col.put("header", new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"BasedataMappingEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0])));
        col.put("type", "numberfield");
        col.put("isColPageFixed", Boolean.TRUE);
        return col;
    }

    private Map<String, Object> createBaseDataColumn(DSField ds) {
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey(ds.getFieldKey());
        f7Field.setName(ds.getFieldName());
        f7Field.setFieldTextAlign(CENTER);
        f7Field.setTextAlign(CENTER);
        f7Field.setAlignSelf(CENTER);
        f7Field.setWidth(new LocaleString("300"));
        f7Field.setLock("");
        f7Field.setQuickAddNew(false);
        String displayProp = "number,name";
        if ("0".equals(ds.getDataType())) {
            BasedataField basedata = new BasedataField();
            if (BOS_ADMINORG_STRUCTURE.equalsIgnoreCase(ds.getEntityId())) {
                basedata.setBaseEntityId(BOS_ORG);
            } else {
                basedata.setBaseEntityId(ds.getEntityId());
            }
            basedata.setKey(ds.getFieldKey());
            basedata.setDisplayProp(displayProp);
            f7Field.setField((Field)basedata);
        } else {
            AssistantField asstData = new AssistantField();
            asstData.setAsstTypeId(ds.getEntityId());
            asstData.setAsstParentId(ds.getEntityId());
            asstData.setKey(ds.getFieldKey());
            asstData.setDisplayProp(displayProp);
            f7Field.setField((Field)asstData);
        }
        Map map = (Map)f7Field.createColumns().get(0);
        if (BOS_ADMINORG_STRUCTURE.equalsIgnoreCase(ds.getEntityId())) {
            map.put("type", "org");
        }
        return map;
    }

    private Map<String, Object> createAssTypeColumn(MainEntityType mainEntityType, DynamicObject asstacttype) {
        if (asstacttype == null) {
            return null;
        }
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setName(new LocaleString(asstacttype.getString("name")));
        f7Field.setFieldTextAlign(CENTER);
        f7Field.setTextAlign(CENTER);
        f7Field.setAlignSelf(CENTER);
        f7Field.setWidth(new LocaleString("300"));
        f7Field.setLock("");
        f7Field.setQuickAddNew(false);
        EntryProp entry = (EntryProp)mainEntityType.getProperty("entryentity");
        String entityNumber = asstacttype.getString("number");
        String displayProp = "number,name";
        if (entityNumber != null) {
            BasedataField basedata = new BasedataField();
            basedata.setBaseEntityId(entityNumber);
            basedata.setKey("destdatamapping");
            basedata.setDisplayProp(displayProp);
            f7Field.setKey("destdatamapping");
            f7Field.setField((Field)basedata);
            BasedataProp prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty("destdatamapping");
            prop.setBaseEntityId(entityNumber);
            prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber));
            return (Map)f7Field.createColumns().get(0);
        }
        return null;
    }

    private void setFactorColumnMeta(List<DSField> refList, MainEntityType mainEntityType) {
        EntryProp entry = (EntryProp)mainEntityType.getProperty("entryentity");
        for (DSField field : refList) {
            BasedataProp prop;
            if ("0".equals(field.getDataType())) {
                prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(field.getFieldKey());
                if (BOS_ADMINORG_STRUCTURE.equalsIgnoreCase(field.getEntityId())) {
                    prop.setBaseEntityId(BOS_ORG);
                    prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)BOS_ORG));
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)field.getEntityId())) continue;
                try {
                    prop.setBaseEntityId(field.getEntityId());
                    prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)field.getEntityId()));
                }
                catch (Exception e) {
                    this.getView().showTipNotification(e.getMessage());
                }
                continue;
            }
            if (!"1".equals(field.getDataType())) continue;
            prop = (AssistantProp)entry.getDynamicCollectionItemPropertyType().getProperty(field.getFieldKey());
            prop.setAsstParentId(field.getEntityId());
            prop.setAsstTypeId(field.getEntityId());
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        new BaseDataMapTypeImportHandler().setSourceDataToModel(this.getModel(), this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty prop = e.getProperty();
        ChangeData[] change = e.getChangeSet();
        if (prop.getName().equals("type")) {
            if (Rule.equalsIgnoreCase(change[0].getNewValue().toString())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{PluginField, CustomField});
                this.getView().setVisible(Boolean.TRUE, new String[]{RuleField});
                this.getView().setVisible((Boolean)this.getModel().getValue("bycustom"), new String[]{CustomField});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{RuleField, CustomField});
                this.getView().setVisible(Boolean.TRUE, new String[]{PluginField});
            }
        } else if (prop.getName().equals("bycustom")) {
            this.getView().setVisible((Boolean)change[0].getNewValue(), new String[]{CustomField});
        } else if (prop.getName().equals("destbasedata")) {
            String dsFields = this.getPageCache().get(DS_FIELDS);
            List dsFieldList = null;
            if (StringUtils.isNotEmpty((CharSequence)dsFields)) {
                dsFieldList = SerializationUtils.fromJsonStringToList((String)dsFields, DSField.class);
            }
            DynamicObject oriEntity = this.getModel().getDataEntity(true);
            String dataStr = AiDynamicObjectSerializeUtil.serialize(oriEntity, oriEntity.getDynamicObjectType());
            String typeStr = SerializationUtils.serializeToBase64((Object)oriEntity.getDynamicObjectType());
            this.getModel().deleteEntryData("entryentity");
            this.drawGrid(dsFieldList, this.getModel().getDataEntityType(), (DynamicObject)this.getModel().getValue("destbasedata"), true);
            this.setSouceData(dataStr, typeStr, Collections.EMPTY_LIST);
        }
    }

    private List<Long> getNotChangeBaseDataIds(String name) {
        int count = this.getModel().getEntryRowCount("entryentity");
        ArrayList<Long> idList = new ArrayList<Long>(count);
        for (int i = 0; i < count; ++i) {
            idList.add((Long)this.getModel().getValue(name + "_id", i));
        }
        return idList;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this.getPageCache().get("inited") == null) {
            MainEntityType entitytype = e.getOriginalEntityType();
            BaseShowParameter baseparam = (BaseShowParameter)this.getView().getFormShowParameter();
            Object pk = baseparam.getPkId();
            if (pk != null) {
                DynamicObject editdata = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entitytype.getName());
                DynamicObjectCollection mapdatas = editdata.getDynamicObjectCollection("fieldmapentry");
                ArrayList<DSField> list = new ArrayList<DSField>();
                for (DynamicObject map : mapdatas) {
                    DSField sd = new DSField();
                    sd.setDataType(map.getString("datatype"));
                    sd.setEntityId(map.getString("entityid"));
                    sd.setFieldKey(map.getString("fieldkey"));
                    if ("0".equals(sd.getDataType())) {
                        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)sd.getEntityId());
                        sd.setFieldName(dataEntityType.getDisplayName());
                    } else {
                        DynamicObject obj = QueryServiceHelper.queryOne((String)"bos_assistantdatagroup", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ObjectConverterFactory.getLong((Object)sd.getEntityId()))});
                        sd.setFieldName(new LocaleString(obj.getString("name")));
                    }
                    list.add(sd);
                }
                this.reBuildModelAndGrid(list, entitytype, editdata.getDynamicObject("destbasedata"), true);
                e.setNewEntityType(entitytype);
            }
            this.getPageCache().put("inited", "true");
        } else {
            DynamicObject asstacttype = (DynamicObject)this.getModel().getValue("destbasedata");
            DynamicObjectCollection mapdatas = this.getModel().getEntryEntity("fieldmapentry");
            ArrayList<DSField> list = new ArrayList<DSField>();
            for (DynamicObject map : mapdatas) {
                DSField sd = new DSField();
                sd.setDataType(map.getString("datatype"));
                sd.setEntityId(map.getString("entityid"));
                sd.setFieldKey(map.getString("fieldkey"));
                if ("0".equals(sd.getDataType())) {
                    MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)sd.getEntityId());
                    sd.setFieldName(dataEntityType.getDisplayName());
                } else {
                    DynamicObject obj = QueryServiceHelper.queryOne((String)"bos_assistantdatagroup", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ObjectConverterFactory.getLong((Object)sd.getEntityId()))});
                    String name = Optional.ofNullable(obj).map(o -> o.getString("name")).orElse("");
                    sd.setFieldName(new LocaleString(name));
                }
                if (!StringUtils.isNotBlank((CharSequence)map.getString("entityid"))) continue;
                list.add(sd);
            }
            MainEntityType entitytype = e.getOriginalEntityType();
            this.reBuildModelAndGrid(list, entitytype, asstacttype, true);
            e.setNewEntityType(entitytype);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"destbasedata")) {
            QFilter[] baseDataFilters = BaseDataMappingUtil.getFilters();
            beforeF7SelectEvent.setCustomQFilters(Arrays.asList(baseDataFilters));
        }
    }
}

