/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.fi.ai.enums.BillTypeEnum;
import kd.fi.ai.formplugin.BillType;
import kd.fi.ai.util.GLUtil;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;

public class BilllistF7Plugin
extends AbstractListPlugin
implements ClickListener,
RowClickEventListener,
TreeNodeClickListener,
HyperLinkClickListener,
ItemClickListener,
ListRowClickListener,
SearchEnterListener,
F7SelectedListRemoveListener {
    private static final String BILL_ROOT_ID = "1";
    private static final String EVENT_ROOT_ID = "2";
    public static final String FLAG_AI_EVENTGROUP = "@ai_eventgroup";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String ENTRY_DATA = "entryData";
    public static final String FormId_BIllsListF7 = "ai_billslistf7";

    public void initialize() {
        super.initialize();
        TreeView fieldTree = (TreeView)this.getView().getControl("treeviewap");
        fieldTree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        EntryGrid entryentity = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        entryentity.addRowClickListener((RowClickEventListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btnclose"});
    }

    public void afterCreateNewData(EventObject e) {
        String infoString;
        HashMap<String, List<String>> basedataInfo = new HashMap<String, List<String>>();
        String nodeId = this.getPageCache().get("nodeId");
        TreeNode firstRoot = this.initBillTree(basedataInfo);
        TreeView treev = (TreeView)this.getControl("treeviewap");
        treev.addNode(firstRoot);
        TreeNode aiEventRoot = this.initAIEventTree();
        treev.addNode(aiEventRoot);
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            treev.focusNode(firstRoot);
            nodeId = firstRoot.getId();
        }
        if (StringUtils.isNotBlank((CharSequence)(infoString = (String)this.getView().getFormShowParameter().getCustomParam("baseInfo")))) {
            Map billTypeInfoMap = (Map)GLUtil.fromSerializedString((String)infoString);
            ArrayList<Object> keyList = new ArrayList<Object>(billTypeInfoMap.keySet());
            this.getPageCache().put("keylist", GLUtil.toSerializedString(keyList));
            this.getPageCache().put("typeInfos", infoString);
            this.setSelectRows(keyList, 0);
            F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
            f7SelectedList.removeAllItems();
            ArrayList<ValueTextItem> items = new ArrayList<ValueTextItem>(keyList.size());
            for (Object e2 : keyList) {
                ValueTextItem item2 = new ValueTextItem(((BillType)billTypeInfoMap.get(e2)).getId(), ((BillType)billTypeInfoMap.get(e2)).getName());
                items.add(item2);
            }
            f7SelectedList.addItems(items);
        }
        this.initEntity(nodeId);
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private TreeNode initBillTree(Map<String, List<String>> basedataInfo) {
        TreeNode firstRoot = new TreeNode();
        firstRoot.setParentid("");
        firstRoot.setId(BILL_ROOT_ID);
        firstRoot.setText(BillTypeEnum.BILLLIST.getName());
        firstRoot.setIsOpened(true);
        DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
        DynamicObjectCollection dynamicApps = BizAppServiceHelp.getAllBizApps();
        HashMap<String, String> cloudAppMap = new HashMap<String, String>(dynamicApps.size());
        for (DynamicObject dynamicApp : dynamicApps) {
            cloudAppMap.put(dynamicApp.getString("id"), dynamicApp.getString("bizcloud"));
        }
        QFilter modeltypeQfilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        QFilter appFilter = new QFilter("bizappid.deploystatus", "=", (Object)EVENT_ROOT_ID);
        List<String> ids = this.existBill();
        if (!ids.isEmpty() && ids.size() > 0) {
            modeltypeQfilter.and(new QFilter("number", "not in", ids));
        }
        DynamicObject[] entitys = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id,name,bizappid.id,bizappid.name", (QFilter[])new QFilter[]{modeltypeQfilter, appFilter}, (String)"bizappid.number");
        TreeNode appNode = null;
        TreeNode node = null;
        HashSet<String> appMap = new HashSet<String>(entitys.length + dynamicObjects.size());
        for (DynamicObject dynamic : dynamicObjects) {
            String nodeId = dynamic.getString("id");
            for (DynamicObject entity : entitys) {
                String appid = entity.getString("bizappid.id");
                String cloudId = (String)cloudAppMap.get(appid);
                if (!nodeId.equals(cloudId)) continue;
                if (appMap.add(nodeId)) {
                    String name = dynamic.getString("name");
                    node = new TreeNode();
                    node.setId(nodeId);
                    node.setText(name);
                    node.setParentid(BILL_ROOT_ID);
                    firstRoot.addChild(node);
                }
                if (appMap.add(appid)) {
                    appNode = new TreeNode();
                    appNode.setParentid(cloudId);
                    appNode.setId(appid);
                    appNode.setText(entity.getString("bizappid.name"));
                    appNode.setIsOpened(false);
                    if (null != node) {
                        node.addChild(appNode);
                    }
                }
                if (basedataInfo.get(appid) == null) {
                    basedataInfo.put(appid, new ArrayList<String>(Collections.singletonList(entity.getString("id"))));
                } else {
                    basedataInfo.get(appid).add(entity.getString("id"));
                }
                if (basedataInfo.get(cloudId) == null) {
                    basedataInfo.put(cloudId, new ArrayList<String>(Collections.singletonList(entity.getString("id"))));
                    continue;
                }
                basedataInfo.get(cloudId).add(entity.getString("id"));
            }
        }
        return firstRoot;
    }

    private TreeNode initAIEventTree() {
        TreeNode aiEventRoot = new TreeNode();
        aiEventRoot.setParentid("");
        aiEventRoot.setId(EVENT_ROOT_ID);
        aiEventRoot.setText(BillTypeEnum.EVENTCLASS.getName());
        aiEventRoot.setIsOpened(true);
        DynamicObjectCollection eventClasses = DataModelDaoImpl.queryEnableModels((String)"group", (AppVersionEnum)AppVersionEnum.OLD_APP);
        Set groups = eventClasses.stream().map(e -> e.getLong("group")).collect(Collectors.toSet());
        DynamicObjectCollection eventGrps = QueryServiceHelper.query((String)"ai_eventgroup", (String)"id,parent,name", (QFilter[])new QFilter("id", "in", groups).toArray(), (String)"longnumber asc");
        HashMap<String, TreeNode> nodeCache = new HashMap<String, TreeNode>();
        for (DynamicObject eventGrp : eventGrps) {
            long parentId = eventGrp.getLong("parent");
            TreeNode node = new TreeNode();
            if (parentId == 0L) {
                aiEventRoot.addChild(node);
                node.setParentid(EVENT_ROOT_ID);
            } else {
                String parentNodeId = FLAG_AI_EVENTGROUP + parentId;
                ((TreeNode)nodeCache.get(parentNodeId)).addChild(node);
                node.setParentid(parentNodeId);
            }
            long id = eventGrp.getLong("id");
            String nodeId = FLAG_AI_EVENTGROUP + id;
            node.setId(nodeId);
            node.setText(eventGrp.getString("name"));
            node.setIsOpened(false);
            nodeCache.put(nodeId, node);
        }
        return aiEventRoot;
    }

    public void entryRowClick(RowClickEvent evt) {
        IDataModel model = this.getModel();
        String typeInfos = this.getPageCache().get("typeInfos");
        String keyListStr = this.getPageCache().get("keylist");
        Map<Object, BillType> billTypeMap = new HashMap();
        List<Object> keyList = new ArrayList();
        if (typeInfos != null) {
            billTypeMap = (Map)GLUtil.fromSerializedString((String)typeInfos);
            keyList = (List)GLUtil.fromSerializedString((String)keyListStr);
        }
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        int row = evt.getRow();
        Object key = model.getValue("id", row);
        BillType type = (BillType)billTypeMap.get(key);
        ArrayList<ValueTextItem> items = new ArrayList<ValueTextItem>();
        BillType type2 = new BillType();
        if (type != null || row == -1) {
            if (row == -1) {
                return;
            }
            billTypeMap.remove(key);
            keyList.remove(key);
            for (Object e : keyList) {
                type2 = (BillType)billTypeMap.get(e);
                ValueTextItem item2 = new ValueTextItem(type2.getId(), type2.getName());
                items.add(item2);
            }
        } else {
            type = new BillType();
            type.setId((String)model.getValue("id"));
            type.setNumber((String)model.getValue("number"));
            type.setName((String)model.getValue("name"));
            type.setType((String)model.getValue("type"));
            ValueTextItem item = new ValueTextItem(type.getId(), type.getName());
            for (Object mapKey : keyList) {
                type2 = (BillType)billTypeMap.get(mapKey);
                ValueTextItem item2 = new ValueTextItem(type2.getId(), type2.getName());
                items.add(item2);
            }
            items.add(item);
            billTypeMap.put(key, type);
            keyList.add(key);
        }
        f7SelectedList.removeAllItems();
        f7SelectedList.addItems(items);
        this.getPageCache().put("typeInfos", GLUtil.toSerializedString(billTypeMap));
        this.getPageCache().put("keylist", GLUtil.toSerializedString(keyList));
        this.setSelectRows(keyList, row);
    }

    public void RemoveClick(F7SelectedListRemoveEvent arg0) {
        String typeInfostr = this.getPageCache().get("typeInfos");
        String keyListStr = this.getPageCache().get("keylist");
        if (typeInfostr == null) {
            return;
        }
        Map typeInfoMap = (Map)GLUtil.fromSerializedString((String)typeInfostr);
        List keyList = (List)GLUtil.fromSerializedString((String)keyListStr);
        String param = (String)arg0.getParam();
        if (param == null) {
            typeInfoMap.clear();
            keyList.clear();
        } else {
            keyList.remove(param);
            typeInfoMap.remove(param);
        }
        this.setSelectRows(keyList, 0);
        this.getPageCache().put("typeInfos", GLUtil.toSerializedString((Object)typeInfoMap));
        this.getPageCache().put("keylist", GLUtil.toSerializedString((Object)keyList));
    }

    public void click(EventObject evt) {
        String key = ((Button)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            Map<String, String> map;
            List<Map<String, String>> list = this.getCurrentSelector();
            if (list != null && list.size() > 0 && "error".equals((map = list.get(0)).get("error"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u4e1a\u52a1\u4fe1\u606f\u53d6\u503c\u4ec5\u652f\u6301\u914d\u7f6e\u5355\u636e\u6216\u4e8b\u4ef6\u6a21\u578b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BilllistF7Plugin_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(list);
            this.getView().close();
        } else if (key.equals("btnclose")) {
            List<Map<String, String>> list = this.getCurrentSelector();
            this.getView().returnDataToParent(list);
            this.getView().close();
        }
    }

    private List<Map<String, String>> getCurrentSelector() {
        ArrayList<Map<String, String>> retList = new ArrayList<Map<String, String>>();
        String typeInfos = this.getPageCache().get("typeInfos");
        HashSet set = new HashSet();
        if (typeInfos != null) {
            Map typeInfoMap = (Map)GLUtil.fromSerializedString((String)typeInfos);
            BillType type = null;
            for (Map.Entry ety : typeInfoMap.entrySet()) {
                HashMap<String, String> ret = new HashMap<String, String>();
                type = (BillType)typeInfoMap.get(ety.getKey());
                ret.put("id", type.getId());
                ret.put("name", type.getName());
                ret.put("number", type.getNumber());
                if (BillTypeEnum.EVENT.getName().equals(type.getType()) || BillTypeEnum.EVENT.getValue().equals(type.getType())) {
                    ret.put("type", BillTypeEnum.EVENT.getValue());
                } else if (BillTypeEnum.BILL.getName().equals(type.getType()) || BillTypeEnum.BILL.getValue().equals(type.getType())) {
                    ret.put("type", BillTypeEnum.BILL.getValue());
                }
                set.add(ret.get("type"));
                retList.add(ret);
            }
        }
        if (set != null && set.size() > 1) {
            ArrayList<Map<String, String>> errorList = new ArrayList<Map<String, String>>(1);
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("error", "error");
            errorList.add(map);
            return errorList;
        }
        return retList;
    }

    public void search(SearchEnterEvent arg0) {
        String keyListStr;
        List searchFields = arg0.getSearchFields();
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        String entryDate = pageCache.get(ENTRY_DATA);
        if (entryDate == null || entryDate.length() == 0) {
            return;
        }
        List billTypeInfs = (List)GLUtil.fromSerializedString((String)entryDate);
        ArrayList<BillType> billTypeSelect = new ArrayList<BillType>(billTypeInfs.size());
        if (billTypeInfs == null || billTypeInfs.size() == 0) {
            return;
        }
        int rowIndex = 0;
        model.deleteEntryData(KEY_ENTRYENTITY);
        if (searchFields == null) {
            model.batchCreateNewEntryRow(KEY_ENTRYENTITY, billTypeInfs.size());
            for (BillType billType : billTypeInfs) {
                this.setValue(model, rowIndex++, billType);
            }
        } else {
            for (BillType billType : billTypeInfs) {
                String type = billType.getType();
                String id = billType.getId();
                String name = billType.getName();
                String number = billType.getNumber();
                boolean flag = true;
                block2: for (Map map : searchFields) {
                    List lfields = (List)map.get("fieldName");
                    String value = (String)((List)map.get("value")).get(0);
                    for (String field : lfields) {
                        if ("name".equals(field)) {
                            if (StringUtils.isNotEmpty((CharSequence)name) && name.indexOf(value) != -1) {
                                flag = true;
                                continue block2;
                            }
                        } else if (StringUtils.isNotEmpty((CharSequence)number) && number.indexOf(value) != -1) {
                            flag = true;
                            continue block2;
                        }
                        flag = false;
                    }
                }
                if (!flag) continue;
                BillType billTypeObject = new BillType();
                billTypeObject.setId(id);
                billTypeObject.setName(name);
                billTypeObject.setNumber(number);
                billTypeObject.setType(type);
                billTypeSelect.add(billTypeObject);
            }
            if (billTypeSelect.size() == 0) {
                return;
            }
            model.batchCreateNewEntryRow(KEY_ENTRYENTITY, billTypeSelect.size());
            for (BillType billType : billTypeSelect) {
                this.setValue(model, rowIndex++, billType);
            }
        }
        if ((keyListStr = pageCache.get("keylist")) != null && keyListStr.length() != 0) {
            List keyList = (List)GLUtil.fromSerializedString((String)keyListStr);
            this.setSelectRows(keyList, 0);
        }
    }

    private void setValue(IDataModel model, int rowIndex, BillType billType) {
        model.setValue("name", (Object)billType.getName(), rowIndex);
        model.setValue("number", (Object)billType.getNumber(), rowIndex);
        model.setValue("type", (Object)billType.getType(), rowIndex);
        model.setValue("id", (Object)billType.getId(), rowIndex);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
    }

    private void initEntity(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        this.setDefaultValue(nodeId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject[] collectionSearch = new DynamicObject[]{};
        ArrayList<BillType> collection = new ArrayList<BillType>(16);
        if (BILL_ROOT_ID.equals(nodeId)) {
            collectionSearch = this.getbillDyo(filters);
        } else if (EVENT_ROOT_ID.equals(nodeId)) {
            collectionSearch = this.geteventDyo(filters);
        } else if (nodeId.startsWith(FLAG_AI_EVENTGROUP)) {
            Long replaceNodeId = Long.parseLong(nodeId.replace(FLAG_AI_EVENTGROUP, ""));
            filters.add(new QFilter("group", "in", (Object)replaceNodeId));
            collectionSearch = this.geteventDyo(filters);
        } else {
            filters.add(new QFilter("number", "in", (Object)nodeId).or(new QFilter("bizappid", "in", (Object)nodeId)).or(new QFilter("bizappid.bizcloud", "in", (Object)nodeId)));
            collectionSearch = this.getbillDyo(filters);
        }
        if (collectionSearch.length == 0) {
            return;
        }
        int rowIndex = 0;
        this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, collectionSearch.length);
        for (DynamicObject object : collectionSearch) {
            BillType billType = new BillType();
            OrmLocaleValue name = (OrmLocaleValue)object.get("name");
            this.getModel().setValue("number", object.get("number"), rowIndex);
            this.getModel().setValue("name", (Object)name, rowIndex);
            this.getModel().setValue("id", object.get("id"), rowIndex);
            billType.setNumber((String)object.get("number"));
            billType.setName(name.toString());
            if (BILL_ROOT_ID.equals(nodeId)) {
                this.getModel().setValue("type", (Object)BillTypeEnum.BILL.getName(), rowIndex);
                billType.setType(BillTypeEnum.BILL.getName());
                billType.setId((String)object.get("id"));
            } else if (EVENT_ROOT_ID.equals(nodeId)) {
                this.getModel().setValue("type", (Object)BillTypeEnum.EVENT.getName(), rowIndex);
                billType.setType(BillTypeEnum.EVENT.getName());
                billType.setId((Long)object.get("id") + "");
            } else if (nodeId.startsWith("@ai_eventclass") || nodeId.startsWith(FLAG_AI_EVENTGROUP)) {
                this.getModel().setValue("type", (Object)BillTypeEnum.EVENT.getName(), rowIndex);
                billType.setType(BillTypeEnum.EVENT.getName());
                billType.setId((Long)object.get("id") + "");
            } else {
                this.getModel().setValue("type", (Object)BillTypeEnum.BILL.getName(), rowIndex);
                billType.setType(BillTypeEnum.BILL.getName());
                billType.setId((String)object.get("id"));
            }
            collection.add(billType);
            ++rowIndex;
        }
        this.getPageCache().put(ENTRY_DATA, GLUtil.toSerializedString(collection));
    }

    private void setDefaultValue(String nodeId) {
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRYENTITY);
    }

    private DynamicObject[] getbillDyo(List<QFilter> filters) {
        List<String> ids = this.existBill();
        if (!ids.isEmpty() && ids.size() > 0) {
            filters.add(new QFilter("number", "not in", ids));
            filters.add(new QFilter("modeltype", "=", (Object)"BillFormModel"));
        }
        QFilter appFilter = new QFilter("bizappid.number", "<>", (Object)"edah");
        DynamicObjectCollection eventClasses = DataModelDaoImpl.queryEnableModels((String)"number", (AppVersionEnum)AppVersionEnum.NEW_APP);
        if (!eventClasses.isEmpty()) {
            Set groups = eventClasses.stream().map(e -> "fah_e_" + e.getString("number")).collect(Collectors.toSet());
            appFilter.or(new QFilter("bizappid.number", "=", (Object)"edah").and(new QFilter("number", "in", groups)));
        }
        filters.add(appFilter);
        return BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id,number,name", (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    private DynamicObject[] geteventDyo(List<QFilter> filters) {
        List<Long> ids = this.existEvent();
        if (!ids.isEmpty() && ids.size() > 0) {
            filters.add(new QFilter("id", "not in", ids));
        }
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("appversion", "<>", (Object)String.valueOf(AppVersionEnum.NEW_APP.getCode())));
        return BusinessDataServiceHelper.load((String)"ai_eventclass", (String)"id,number,name", (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    private List<String> existBill() {
        String loadBillsSql = "select fbasedataid baseid from t_ai_morebilltype";
        ArrayList<String> ids = new ArrayList<String>(16);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.formplugin.AiStandardeventEdit", (DBRoute)DBRoute.of((String)"ai"), (String)loadBillsSql);){
            for (Row row : queryDataSet) {
                String baseid = row.getString("baseid");
                ids.add(baseid);
            }
        }
        return ids;
    }

    private List<Long> existEvent() {
        String loadBillsSql = "select fbasedataid baseid from t_ai_moreeventtype";
        ArrayList<Long> ids = new ArrayList<Long>(16);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.formplugin.AiStandardeventEdit", (DBRoute)DBRoute.of((String)"ai"), (String)loadBillsSql);){
            for (Row row : queryDataSet) {
                Long baseid = row.getLong("baseid");
                ids.add(baseid);
            }
        }
        return ids;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setFieldProperty("searchap", "selected", (Object)new Object[0]);
        String nodeId = (String)evt.getNodeId();
        this.initEntity(nodeId);
    }

    private void setSelectRows(List<Object> keyList, int curRow) {
        int[] selectRows = null;
        selectRows = this.getSelectRows(keyList);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        entryGrid.selectRows(selectRows, curRow);
    }

    private int[] getSelectRows(List<Object> keyList) {
        HashSet<Object> keySet = new HashSet<Object>(keyList);
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity(KEY_ENTRYENTITY);
        ArrayList<Integer> selectRowList = new ArrayList<Integer>();
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject dyn = (DynamicObject)entries.get(i);
            Object key = dyn.get("id");
            if (!keySet.contains(key)) continue;
            selectRowList.add(i);
        }
        if (selectRowList.size() == 0) {
            return new int[0];
        }
        return selectRowList.stream().mapToInt(Integer::valueOf).toArray();
    }
}

