/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.logbill.ESDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.model.common.PairTuple;

public class BuildReportDataProvider
extends ESDataProvider {
    public BuildReportDataProvider(IFormView formView) {
        super(formView);
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection data = super.getData(start, limit);
        if (data.isEmpty()) {
            return data;
        }
        HashSet<Long> periods = new HashSet<Long>();
        HashSet<Long> accountbooks = new HashSet<Long>();
        HashSet<String> srcbillnums = new HashSet<String>();
        for (DynamicObject obj : data) {
            periods.add(obj.getLong("periodid"));
            accountbooks.add(obj.getLong("accountbookid"));
            srcbillnums.add(obj.getString("sourcebillnumber"));
        }
        Map periodcol = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", periods)});
        HashMap periodMap = new HashMap(periodcol.size());
        periodcol.values().stream().forEach(o -> periodMap.put(o.getLong("id"), o.getString("name")));
        Map accountbookcol = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"id,bookstype.name", (QFilter[])new QFilter[]{new QFilter("id", "in", accountbooks)});
        HashMap accountBookMap = new HashMap(accountbookcol.size());
        accountbookcol.values().stream().forEach(o -> accountBookMap.put(o.getLong("id"), o.getString("bookstype.name")));
        Map srcbills = BusinessDataServiceHelper.loadFromCache((String)"bos_entityobject", (String)"id,name,bizappid.name", (QFilter[])new QFilter[]{new QFilter("id", "in", srcbillnums)});
        HashMap srcbillMap = new HashMap(accountbookcol.size());
        srcbills.values().stream().forEach(o -> srcbillMap.put(o.getString("id"), new PairTuple((Object)o.getString("name"), (Object)o.getString("bizappid.name"))));
        for (DynamicObject row : data) {
            row.set("period", periodMap.get(row.getLong("periodid")));
            row.set("accountbook", accountBookMap.get(row.getLong("accountbookid")));
            PairTuple pair = (PairTuple)srcbillMap.get(row.getString("sourcebillnumber"));
            row.set("sourcebill", pair.getKey());
            row.set("sourcesys", pair.getValue());
        }
        return data;
    }
}

