/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.ai.enums.PermissonType;
import kd.fi.ai.util.ContextUtil;

public class BuildVchSchemePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static String Key_EntityNumber = "ai_vchbuildscheme";
    private static String Key_TVScheme = "tv_scheme";
    private static String SchemeId_Default = "-1";
    private static String CacheKey_CurrSchemeId = "currschemeid";
    private Map<String, DynamicObject> buildVchSchemeCache = new HashMap<String, DynamicObject>(20);

    public void initialize() {
        super.initialize();
        TreeView fieldTree = (TreeView)this.getControl(Key_TVScheme);
        fieldTree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.buildVchSchemeCache.size() == 0) {
            this.fillSchemeList(false);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tView = (TreeView)this.getControl(Key_TVScheme);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String nodeId = (String)arg0.getNodeId();
        if (nodeId.isEmpty() || "0".equals(nodeId)) {
            return;
        }
        this.getPageCache().put(CacheKey_CurrSchemeId, nodeId);
        if (SchemeId_Default.equalsIgnoreCase(nodeId)) {
            this.getModel().setValue("schemename", null);
            this.getModel().deleteEntryData("acctbookentity");
            this.getView().updateView("srcbillsubentity");
        } else {
            if (this.buildVchSchemeCache.size() == 0) {
                QFilter createFilter = new QFilter("creatorid", "=", (Object)ContextUtil.getUserId());
                Map schemes = BusinessDataReader.loadFromCache((String)Key_EntityNumber, (QFilter[])new QFilter[]{createFilter});
                for (Map.Entry scheme : schemes.entrySet()) {
                    this.buildVchSchemeCache.put(scheme.getKey().toString(), (DynamicObject)scheme.getValue());
                }
            }
            this.setTemplateObj(this.buildVchSchemeCache.get(nodeId));
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent arg0) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        if (event.getOperationResult() == null || !event.getOperationResult().isSuccess()) {
            return;
        }
        long pkValue = 0L;
        String currSchemeId = this.getPageCache().get(CacheKey_CurrSchemeId);
        if (!StringUtils.isBlank((CharSequence)currSchemeId)) {
            pkValue = Long.parseLong(currSchemeId);
        }
        boolean refresh = false;
        String opKey = event.getOperateKey();
        if ("copyscheme".equals(opKey)) {
            refresh = this.SaveAsScheme(0L);
        } else if ("deletescheme".equals(opKey)) {
            if (pkValue > 0L) {
                this.DeleteScheme(pkValue);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f3a\u7701\u65b9\u6848\u4e0d\u80fd\u5220\u9664\u3002", (String)"BuildVchSchemePlugin_01", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
            refresh = true;
        } else if ("savescheme".equals(opKey)) {
            this.getPageCache().put("savescheme", pkValue + "");
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"BuildVchSchemePlugin_02", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"BuildVchSchemePlugin_03", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u540e\u5c06\u6e05\u7a7a\u5355\u636e\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"BuildVchSchemePlugin_04", (String)"fi-ai-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("savescheme"), btnNameMaps, SerializationUtils.toJsonString(new HashMap()));
        } else if ("newscheme".equals(opKey)) {
            refresh = true;
        }
        if (refresh) {
            if ("newscheme".equals(opKey)) {
                this.fillSchemeList(true);
            } else {
                this.fillSchemeList(false);
            }
        }
    }

    private void fillSchemeList(boolean isNewscheme) {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8\u65b9\u6848", (String)"BuildVchSchemePlugin_05", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        root.setChildren(new ArrayList());
        TreeNode defScheme = new TreeNode("0", SchemeId_Default, ResManager.loadKDString((String)"\u7f3a\u7701\u65b9\u6848", (String)"BuildVchSchemePlugin_06", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        root.addChild(defScheme);
        QFilter createFilter = new QFilter("creatorid", "=", (Object)ContextUtil.getUserId());
        Map schemes = BusinessDataReader.loadFromCache((String)Key_EntityNumber, (QFilter[])new QFilter[]{createFilter});
        if (!schemes.isEmpty()) {
            this.buildVchSchemeCache = new HashMap<String, DynamicObject>(schemes.size());
            Object[] schemeIds = schemes.keySet().toArray();
            Arrays.sort(schemeIds);
            for (Object schemeId : schemeIds) {
                DynamicObject dy = (DynamicObject)schemes.get(schemeId);
                TreeNode childNode = new TreeNode("0", schemeId.toString(), dy != null ? dy.getString("schemename") : "");
                root.addChild(childNode);
                this.buildVchSchemeCache.put(schemeId.toString(), dy);
            }
        }
        root.setIsOpened(true);
        TreeView tree = (TreeView)this.getView().getControl(Key_TVScheme);
        tree.deleteAllNodes();
        tree.addNode(root);
        if (isNewscheme) {
            List children = root.getChildren();
            TreeNode focusNode = null != children && !children.isEmpty() ? (TreeNode)children.get(0) : root;
            tree.focusNode(focusNode);
            tree.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        } else {
            TreeNode focusNode;
            String currId = this.getPageCache().get(CacheKey_CurrSchemeId);
            if (StringUtils.isNotBlank((CharSequence)currId) && (focusNode = root.getTreeNode(currId, 2)) != null) {
                tree.focusNode(focusNode);
                this.setTemplateObj(this.buildVchSchemeCache.get(currId));
            }
        }
    }

    private boolean SaveAsScheme(Long pkValue) {
        if (!this.checkSaveValidate()) {
            return false;
        }
        MainEntityType vchTemplateType = EntityMetadataCache.getDataEntityType((String)Key_EntityNumber);
        DynamicObject vchTempObj = pkValue > 0L ? BusinessDataReader.loadSingle((Object)pkValue, (DynamicObjectType)vchTemplateType) : this.createTmplateObj(vchTemplateType);
        this.getTemplateObj(vchTempObj);
        OperationResult operationResult = this.invokeOperationService(Key_EntityNumber, "save", new DynamicObject[]{vchTempObj});
        if (!operationResult.isSuccess()) {
            this.getView().showOperationResult(operationResult);
        } else if (operationResult.getSuccessPkIds().size() > 0) {
            pkValue = (Long)operationResult.getSuccessPkIds().get(0);
            this.getPageCache().put(CacheKey_CurrSchemeId, pkValue.toString());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BuildVchSchemePlugin_07", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        return operationResult.isSuccess();
    }

    private DynamicObject createTmplateObj(MainEntityType voucherBuildSchemeType) {
        DynamicObject vchTempObj = new DynamicObject((DynamicObjectType)voucherBuildSchemeType);
        BasedataProp creatorProp = (BasedataProp)voucherBuildSchemeType.getProperty("creatorid");
        creatorProp.getRefIdProp().setValue((Object)vchTempObj, (Object)ContextUtil.getUserId());
        vchTempObj.set("createtime", (Object)new Date());
        return vchTempObj;
    }

    private void getTemplateObj(DynamicObject voucherBuildSchemeObj) {
        voucherBuildSchemeObj.set("schemename", this.getModel().getValue("schemename"));
        DynamicObjectCollection voucherBuildSchEntryObjects = voucherBuildSchemeObj.getDynamicObjectCollection("acctbookentity");
        voucherBuildSchEntryObjects.clear();
        DynamicObjectCollection entryObjects = this.getModel().getEntryEntity("acctbookentity");
        int entryrow = 0;
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"ai", (String)this.getView().getEntityId(), (String)PermissonType.CREATEVOUCHER.getPermId());
        boolean hasAllOrgPerm = result.hasAllOrgPerm();
        List hasPermOrgs = result.getHasPermOrgs();
        for (DynamicObject entryObject : entryObjects) {
            if (!entryObject.getBoolean("fselectedbook")) continue;
            Long orgId = entryObject.getLong("bizorg_id");
            if (!hasAllOrgPerm && (hasPermOrgs == null || !hasPermOrgs.contains(orgId))) continue;
            DynamicObject voucherBuildSchEntryObject = voucherBuildSchEntryObjects.addNew();
            voucherBuildSchEntryObject.set("facctbook", entryObject.get("facctbook"));
            voucherBuildSchEntryObject.set("fperiod", entryObject.get("fperiod"));
            voucherBuildSchEntryObject.set("isrefresh", entryObject.get("isrefresh"));
            voucherBuildSchEntryObject.set("bizorg", entryObject.get("bizorg"));
            voucherBuildSchEntryObject.set("seq", (Object)entryrow);
            ++entryrow;
            DynamicObjectCollection voucherBuildSchSubObjects = voucherBuildSchEntryObject.getDynamicObjectCollection("srcbillsubentity");
            DynamicObjectCollection subEntryObjects = entryObject.getDynamicObjectCollection("srcbillsubentity");
            int subEntryRow = 0;
            for (DynamicObject subEntryObject : subEntryObjects) {
                if (!subEntryObject.getBoolean("fselectedbill")) continue;
                DynamicObject voucherBuildSchSubObject = voucherBuildSchSubObjects.addNew();
                voucherBuildSchSubObject.set("fsourcebill", subEntryObject.get("fsourcebill"));
                voucherBuildSchSubObject.set("funiontype", subEntryObject.get("funiontype"));
                voucherBuildSchSubObject.set("fmatchfieldname", subEntryObject.get("fmatchfieldname"));
                voucherBuildSchSubObject.set("fmatchfieldkey", subEntryObject.get("fmatchfieldkey"));
                voucherBuildSchSubObject.set("seq", (Object)subEntryRow);
                ++subEntryRow;
            }
        }
    }

    private void setTemplateObj(DynamicObject voucherBuildSchemeObj) {
        if (voucherBuildSchemeObj == null) {
            return;
        }
        DynamicObjectCollection voucherBuildSchEntryObjects = voucherBuildSchemeObj.getDynamicObjectCollection("acctbookentity");
        this.getModel().beginInit();
        OrmLocaleValue schemeName = (OrmLocaleValue)voucherBuildSchemeObj.get("schemename");
        if (null != schemeName && null == schemeName.getLocaleValue()) {
            schemeName.setLocaleValue(schemeName.getDefaultItem());
        }
        this.getModel().setValue("schemename", (Object)schemeName);
        this.getModel().deleteEntryData("acctbookentity");
        if (voucherBuildSchEntryObjects != null && voucherBuildSchEntryObjects.size() > 0 && voucherBuildSchEntryObjects != null && voucherBuildSchEntryObjects.size() > 0) {
            this.getModel().batchCreateNewEntryRow("acctbookentity", voucherBuildSchEntryObjects.size());
            for (DynamicObject voucherBuildSchEntryObject : voucherBuildSchEntryObjects) {
                this.Setacctbookentity(voucherBuildSchEntryObject, voucherBuildSchEntryObject.getInt("seq"));
            }
        }
        this.getModel().endInit();
        this.getModel().setEntryCurrentRowIndex("acctbookentity", 0);
        this.getView().updateView();
    }

    private void Setacctbookentity(DynamicObject voucherBuildSchEntryObject, int row) {
        this.getModel().setValue("facctbook", voucherBuildSchEntryObject.get("facctbook"), row);
        DynamicObject acctbookObject = (DynamicObject)this.getModel().getValue("facctbook", row);
        this.getModel().setValue("acctorg", (Object)acctbookObject.getLong("org.id"), row);
        this.getModel().setValue("booktype", (Object)acctbookObject.getLong("bookstype.id"), row);
        this.getModel().setValue("bizorg", voucherBuildSchEntryObject.get("bizorg"), row);
        this.getModel().setValue("isrefresh", voucherBuildSchEntryObject.get("isrefresh"), row);
        boolean isRefresh = (Boolean)voucherBuildSchEntryObject.get("isrefresh");
        if (!isRefresh) {
            this.getModel().setValue("fperiod", voucherBuildSchEntryObject.get("fperiod"), row);
        } else {
            QFilter h = new QFilter("org", "=", (Object)acctbookObject.getLong("org.id"));
            QFilter k = new QFilter("bookstype.accounttype", "=", (Object)"1");
            DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,bookstype.id,curperiod.id", (QFilter[])new QFilter[]{h, k});
            this.getModel().setValue("fperiod", (Object)((DynamicObject)books.get(0)).getLong("curperiod.id"), row);
        }
        this.getModel().setEntryCurrentRowIndex("acctbookentity", voucherBuildSchEntryObject.getInt("seq"));
        DynamicObjectCollection voucherBuildSchSubObjects = voucherBuildSchEntryObject.getDynamicObjectCollection("srcbillsubentity");
        this.getModel().deleteEntryData("srcbillsubentity");
        if (voucherBuildSchSubObjects != null && voucherBuildSchSubObjects.size() > 0) {
            this.getModel().batchCreateNewEntryRow("srcbillsubentity", voucherBuildSchSubObjects.size());
            for (DynamicObject voucherBuildSchSubObject : voucherBuildSchSubObjects) {
                this.Setsrcbillsubentity(voucherBuildSchSubObject, voucherBuildSchSubObject.getInt("seq"));
            }
        }
    }

    private void Setsrcbillsubentity(DynamicObject voucherBuildSchSubObject, int subEntryRow) {
        this.getModel().setValue("fsourcebill", voucherBuildSchSubObject.get("fsourcebill"), subEntryRow);
        this.getModel().setValue("funiontype", voucherBuildSchSubObject.get("funiontype"), subEntryRow);
        this.getModel().setValue("fmatchfieldname", voucherBuildSchSubObject.get("fmatchfieldname"), subEntryRow);
        this.getModel().setValue("fmatchfieldkey", voucherBuildSchSubObject.get("fmatchfieldkey"), subEntryRow);
    }

    private void DeleteScheme(Long schemeId) {
        DeleteServiceHelper.delete((String)Key_EntityNumber, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        this.getPageCache().put(CacheKey_CurrSchemeId, SchemeId_Default);
        TreeView tree = (TreeView)this.getView().getControl(Key_TVScheme);
        tree.deleteNode(schemeId.toString());
        TreeNode defScheme = new TreeNode("0", SchemeId_Default, ResManager.loadKDString((String)"\u7f3a\u7701\u65b9\u6848", (String)"BuildVchSchemePlugin_06", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        tree.focusNode(defScheme);
        this.getModel().deleteEntryData("acctbookentity");
        this.getView().updateView("srcbillsubentity");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BuildVchSchemePlugin_08", (String)"fi-ai-formplugin", (Object[])new Object[0]));
    }

    private boolean checkSaveValidate() {
        if (StringUtils.isBlank((Object)this.getModel().getValue("schemename"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4fe1\u606f\u4e2d\u65b9\u6848\u540d\u79f0\u5fc5\u5f55\u3002", (String)"BuildVchSchemePlugin_09", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection entryObjects = this.getModel().getEntryEntity("acctbookentity");
        long entrySize = entryObjects.stream().filter(p -> p.getBoolean("fselectedbook")).count();
        if (entrySize == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u8d26\u7c3f\u548c\u6765\u6e90\u5355\u636e\u540e\u624d\u53ef\u4fdd\u5b58\u65b9\u6848\u3002", (String)"BuildVchSchemePlugin_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (DynamicObject entryObject : entryObjects) {
            DynamicObjectCollection subEntryObjects = entryObject.getDynamicObjectCollection("srcbillsubentity");
            long subEntrySize = subEntryObjects.stream().filter(p -> p.getBoolean("fselectedbill")).count();
            if (subEntrySize != 0L) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u8d26\u7c3f\u548c\u6765\u6e90\u5355\u636e\u540e\u624d\u53ef\u4fdd\u5b58\u65b9\u6848\u3002", (String)"BuildVchSchemePlugin_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private OperationResult invokeOperationService(String entityNumber, String operKey, DynamicObject[] args) {
        Map op = EntityMetadataCache.getProvider().getDataEntityOperate(entityNumber, operKey);
        String type = (String)op.get("type");
        return OperationServiceHelper.executeOperate((String)type, (String)entityNumber, (DynamicObject[])args, (OperateOption)OperateOption.create());
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        MessageBoxResult result = arg0.getResult();
        boolean refresh = false;
        String pageCache = this.getPageCache().get("savescheme");
        if (MessageBoxResult.Yes.equals((Object)result) && StringUtils.isNotBlank((CharSequence)pageCache)) {
            refresh = this.SaveAsScheme(Long.parseLong(pageCache));
        }
        if (refresh) {
            this.fillSchemeList(false);
        }
    }
}

