/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.formplugin.BusinessVoucherListDataProvider;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class BusinessVoucherList
extends AbstractListPlugin {
    private static final String QUERY_SQL = "SELECT FID,FSOURCEBILL,FSOURCEBILLID,FGLVOUCHERID FROM T_AI_BIZVOUCHER WHERE ";
    private static final String UNITBUSINESSBILL = "unitbusinessbill";
    private static final String AUTHORIZED_ORG_CACHEKEY = "AUTHORIZED_ORG_CACHEKEY";
    private static final String BAL_DEL = "delete";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{UNITBUSINESSBILL});
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String field = args.getFieldName();
        if (null != field && field.startsWith("org.")) {
            List orgIds = DapBuildVoucherCommonUtil.getPermissionOpenOrgList();
            args.addCustomQFilter(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        if ("org.name".equals(args.getFieldName())) {
            List orgIds;
            String orgCache = this.getPageCache().get(AUTHORIZED_ORG_CACHEKEY);
            if (StringUtils.isNotEmpty((String)orgCache)) {
                orgIds = (List)JSON.parseObject((String)orgCache, List.class);
            } else {
                orgIds = DapBuildVoucherCommonUtil.getPermissionOpenOrgList();
                this.getPageCache().put(AUTHORIZED_ORG_CACHEKEY, JSON.toJSONString((Object)orgIds));
            }
            QFilter filter = new QFilter("id", "in", (Object)orgIds);
            args.getQFilters().add(filter);
            if (null == orgIds || orgIds.isEmpty()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u542f\u7528\u4e8b\u4ef6\u5e93\u3002", (String)"BusinessVoucherList_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new BusinessVoucherListDataProvider());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        HyperLinkClickEvent hyperEvt = args.getHyperLinkClickEvent();
        switch (fieldName = hyperEvt.getFieldName()) {
            case "glbillno": {
                BillList list = (BillList)hyperEvt.getSource();
                Object focusRowPkId = list.getFocusRowPkId();
                args.setCancel(true);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"ai_bizvoucher", (String)"glvoucherid");
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("gl_voucher");
                showParameter.setPkId(dynamicObject.get("glvoucherid"));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "sourcebillno": {
                BillList list = (BillList)hyperEvt.getSource();
                Object focusRowPkId = list.getFocusRowPkId();
                args.setCancel(true);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"ai_bizvoucher", (String)"sourcebill, sourcebillid");
                DynamicObject dynamic = (DynamicObject)dynamicObject.get("sourcebill");
                this.showBillShowParameter(dynamic.getString("number"), dynamicObject.get("sourcebillid"));
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (CommonFilterColumn commFilter : listFilterColumns) {
            String fieldName = commFilter.getFieldName();
            if (!"booktype.name".equals(fieldName)) continue;
            List comboItems = commFilter.getComboItems();
            String defBookType = ((ComboItem)comboItems.get(0)).getValue();
            commFilter.setDefaultValue(defBookType);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List orgFilter = e.getQFilters().stream().filter(filter -> filter.getProperty().equals("org.id")).collect(Collectors.toList());
        if (null != e.getMainOrgQFilter()) {
            orgFilter.add(e.getMainOrgQFilter());
        }
        if (!orgFilter.isEmpty()) {
            Date bizDate;
            QFilter qFilter = (QFilter)orgFilter.get(0);
            ArrayList<Long> orgIdList = new ArrayList<Long>(8);
            if ("=".equalsIgnoreCase(qFilter.getCP())) {
                orgIdList.add((Long)qFilter.getValue());
            } else if ("in".equalsIgnoreCase(qFilter.getCP())) {
                List orgIds = (List)qFilter.getValue();
                orgIdList.addAll(orgIds);
            }
            if (!orgIdList.isEmpty() && null != (bizDate = DapBuildVoucherCommonUtil.getBizVoucherDateSystemParam(orgIdList))) {
                QFilter filter2 = new QFilter("createtime", ">=", (Object)bizDate);
                e.getQFilters().add(filter2);
            }
        }
        e.setOrderBy("bookeddate DESC, billno DESC");
    }

    public List<Long> getCustomFilterIds(IFormView view, String fieldName) {
        IListView listView = (IListView)view;
        ControlFilters c = listView.getControlFilters();
        if (c == null) {
            return null;
        }
        List result = c.getFilter(fieldName);
        ArrayList<Long> ids = new ArrayList<Long>(result.size());
        for (Object v : result) {
            if ("".equals(v.toString())) continue;
            ids.add(Long.valueOf(v.toString()));
        }
        return ids;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "unitbusinessbill": {
                this.shwoUnitBusinessBill();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "delete": {
                Map<String, List<Object>> mapBills = this.getBizVoucherBill();
                List<Object> voucherIds = mapBills.get("voucherId");
                if (null == voucherIds || voucherIds.isEmpty()) break;
                Map<Long, List<Long>> bizIdMap = this.getBizIdByglIdList(voucherIds);
                boolean flag = false;
                for (List<Long> bizIds : bizIdMap.values()) {
                    if (bizIds.size() <= 1) continue;
                    flag = true;
                }
                if (!flag) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u51ed\u8bc1\u7531\u591a\u4e2a\u4e8b\u4ef6\u751f\u6210\uff0c\u5220\u9664\u5176\u4e2d\u4e00\u4e2a\u4f1a\u5bfc\u81f4\u5176\u4ed6\u4e8b\u4ef6\u53ca\u5bf9\u5e94\u51ed\u8bc1\u540c\u6b65\u5220\u9664\u3002", (String)"BusinessVoucherList_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("bizdeletevoucher".equals(operateKey) || "bizgeneratevoucher".equals(operateKey)) {
            this.reload();
            this.clearSelection();
        }
    }

    public Map<String, List<Object>> getBizVoucherBill() {
        List<Long> billIds = this.getSelectPrimaryKey();
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(billIds.size());
        if (billIds.isEmpty()) {
            return map;
        }
        ArrayList<Long> sourcebillIds = new ArrayList<Long>(billIds.size());
        ArrayList<String> bills = new ArrayList<String>(billIds.size());
        ArrayList<Long> voucherIds = new ArrayList<Long>(billIds.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(QUERY_SQL, new Object[0]).appendIn("FID", new ArrayList<Long>(billIds));
        try (DataSet qd = DB.queryDataSet((String)BusinessVoucherList.class.getName(), (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);){
            for (Row row : qd) {
                bills.add(row.getString("FSOURCEBILL"));
                sourcebillIds.add(row.getLong("FSOURCEBILLID"));
                if (0L == row.getLong("FGLVOUCHERID")) continue;
                voucherIds.add(row.getLong("FGLVOUCHERID"));
            }
        }
        map.put("voucherId", voucherIds);
        map.put("sourcebill", bills);
        map.put("sourcebillid", sourcebillIds);
        return map;
    }

    private Map<Long, List<Long>> getBizIdByglIdList(List<Object> glIds) {
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(glIds.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(QUERY_SQL, new Object[0]).appendIn("FGLVOUCHERID", new ArrayList<Object>(glIds));
        try (DataSet qd = DB.queryDataSet((String)BusinessVoucherList.class.getName(), (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);){
            for (Row row : qd) {
                Long glId = row.getLong("FGLVOUCHERID");
                map.computeIfAbsent(glId, key -> new ArrayList(10)).add(row.getLong("FID"));
            }
        }
        return map;
    }

    private List<Long> getSelectPrimaryKey() {
        BillList billList = (BillList)this.getControl("BillListAp");
        ListSelectedRowCollection selectRows = billList.getSelectedRows();
        ArrayList<Long> billIds = new ArrayList<Long>(selectRows.size());
        for (ListSelectedRow selectedRow : selectRows) {
            long primaryKey = (Long)selectedRow.getPrimaryKeyValue();
            billIds.add(primaryKey);
        }
        return billIds;
    }

    private void shwoUnitBusinessBill() {
        Map<String, List<Object>> map = this.getBizVoucherBill();
        List<Object> bills = map.get("sourcebill");
        List<Object> sourcebillIds = map.get("sourcebillid");
        if (null == sourcebillIds || sourcebillIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BusinessVoucherList_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        if (new HashSet<Object>(bills).size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u7c7b\u578b\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"BusinessVoucherList_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        if (sourcebillIds.size() == 1) {
            this.showBillShowParameter((String)bills.get(0), sourcebillIds.get(0));
        } else if (sourcebillIds.size() > 1) {
            this.showListShowParameter((String)bills.get(0), sourcebillIds);
        }
    }

    private void showBillShowParameter(String formId, Object id) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId(id);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showListShowParameter(String formId, List<Object> sourcebillId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        for (Object pkid : sourcebillId) {
            showParameter.addLinkQueryPkId(pkid);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

