/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.fi.ai.BizAsstacttype;
import kd.fi.ai.BizVouSubEntry;
import kd.fi.ai.BussinessVoucher;
import kd.fi.ai.CommonAssistItem;
import kd.fi.ai.formplugin.service.BizVoucherService;
import kd.fi.ai.util.AiCommonFieldUtils;
import kd.fi.ai.util.GLUtil;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;

public class BussinessVoucherEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener,
HyperLinkClickListener,
CellClickListener,
EntryGridBindDataListener {
    private static final String BUSINESSMSGDESC = "businessmsgdesc";
    private static final String QUERY_GLNO_SQL = "SELECT FID,FNUMBER FROM T_GL_VOUCHER WHERE FID = (SELECT FGLVOUCHERID FROM T_AI_BIZVOUCHER WHERE FID = ?)";
    private static final String GLBILLNOLABEL = "glbillnolabel";
    private static final String AI_BUSINESS_MSGSHOW = "ai_business_msgshow";
    private static final String BAL_DEL = "delete";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addCellClickListener((CellClickListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{BUSINESSMSGDESC, GLBILLNOLABEL});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BUSINESSMSGDESC.equals(key)) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            EntryInfo entryPageInfo = this.getModel().getEntryPageInfo("entryentity");
            int startRowIndex = entryPageInfo.getStartRowIndex();
            int index = currentRowIndex - startRowIndex;
            DynamicObjectCollection dynsCollection = this.getModel().getEntryEntity("entryentity");
            Long entryId = ((DynamicObject)dynsCollection.get(index)).getLong("id");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(AI_BUSINESS_MSGSHOW);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("info", (Object)entryId);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, AI_BUSINESS_MSGSHOW);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else if (GLBILLNOLABEL.equals(key)) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("gl_voucher");
            showParameter.setPkId(this.getModel().getValue("glvoucherid"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeBindData(EventObject e) {
        BasedataEdit vouType = (BasedataEdit)this.getView().getControl("vouchertype");
        vouType.setCaption(new LocaleString(ResManager.loadKDString((String)"\u51ed\u8bc1\u5b57\u53f7", (String)"BussinessVoucherEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0])));
        Object bizvoucherId = this.getModel().getValue("id");
        Label label = (Label)this.getControl(GLBILLNOLABEL);
        label.setText(this.getGlFnumber(bizvoucherId));
        this.setDisableField();
        this.getModel().setDataChanged(false);
    }

    private String getBizAsstStrBuilder(RowDataEntity row, Map<Long, List<BizVouSubEntry>> bizSubEntryMap, List<BizAsstacttype> bizAsstactList, int index) {
        StringBuilder sb = new StringBuilder();
        long entryId = row.getDataEntity().getLong("id");
        List<BizVouSubEntry> bizSubs = bizSubEntryMap.get(entryId);
        String message = "";
        if (null == bizSubs) {
            return message;
        }
        BizVoucherService bizService = new BizVoucherService();
        for (BizVouSubEntry bizEntry : bizSubs) {
            for (BizAsstacttype bizAsst : bizAsstactList) {
                String flexField = bizEntry.getFlexField();
                if (!flexField.equals(bizAsst.getFlexfiled())) continue;
                sb.append(bizAsst.getHeadName()).append(":");
                String type = bizAsst.getDatatype();
                String property = bizAsst.getDisplayproperty();
                Map dataSouceMap = bizAsst.getDataSouceMap();
                String value = bizEntry.getValue();
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    switch (type) {
                        case "1": {
                            DynamicObject dynamic = (DynamicObject)dataSouceMap.get(Long.valueOf(value));
                            if (null == dynamic) break;
                            String name = bizService.setNameByDisplay(dynamic, property);
                            sb.append(name);
                            break;
                        }
                        case "2": {
                            DynamicObject dynamicSub = (DynamicObject)dataSouceMap.get(Long.valueOf(value));
                            if (null == dynamicSub) break;
                            String nameSub = bizService.setNameByDisplay(dynamicSub, property);
                            sb.append(nameSub);
                            break;
                        }
                        default: {
                            sb.append(value);
                        }
                    }
                }
                sb.append(";");
            }
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return message;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object pkId = billShowParameter.getPkId();
        IDataModel model = this.getModel();
        MainEntityType cloneType = (MainEntityType)this.cloneEntityType(e.getOriginalEntityType());
        if (cloneType == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6784\u5efa\u4e1a\u52a1\u51ed\u8bc1\u516c\u5171\u7ef4\u5ea6\u65f6\uff0c\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"BussinessVoucherEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        if (model.isDataLoaded()) {
            Object value = this.getModel().getValue("book_id");
            this.preGetComAssistInfo(value != null ? Long.parseLong(value.toString()) : 0L, cloneType);
        } else {
            if (pkId == null) {
                return;
            }
            String sql = "select fbookid from t_ai_bizvoucher where fid = " + pkId;
            Long bookId = 0L;
            try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.formplugin.BussinessVoucherEdit", (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
                if (queryDataSet.hasNext()) {
                    bookId = queryDataSet.next().getLong("fbookid");
                }
            }
            this.preGetComAssistInfo(bookId, cloneType);
        }
        e.setNewEntityType(cloneType);
        this.getModel().updateCache();
    }

    private void preGetComAssistInfo(Long bookId, MainEntityType originalEntityType) {
        DynamicObject bookData = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable.id", (QFilter[])new QFilter("id", "=", (Object)bookId).toArray());
        if (bookData != null) {
            Long accounTableId = bookData.getLong("accounttable.id");
            List comAssist = AiCommonFieldUtils.getComAssist((Long)accounTableId);
            if (comAssist.isEmpty()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"comassist1"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"comassist2"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"comassist1"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"comassist2"});
            } else {
                HashSet<String> propVisable = new HashSet<String>(2);
                propVisable.add("comassist1");
                propVisable.add("comassist2");
                for (CommonAssistItem cai : comAssist) {
                    int seq = cai.getSeq();
                    if (seq > 2) continue;
                    String key = "comassist" + seq;
                    propVisable.remove(key);
                    BasedataEdit basedata = (BasedataEdit)this.getView().getControl(key);
                    basedata.setCaption(new LocaleString(cai.getComassistname()));
                    String billentityName = cai.getValuesource().toString();
                    if (cai.getValuesourcetype().equals("2")) {
                        billentityName = "bos_assistantdata_detail";
                    }
                    BasedataProp property = (BasedataProp)originalEntityType.findProperty(key);
                    property.setBaseEntityId(billentityName);
                    property.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)billentityName));
                    property.setAlias(cai.getComassistnumber());
                    property.setName(cai.getComassistname());
                    property.setDisplayName(new LocaleString(cai.getComassistname()));
                }
                if (propVisable.size() > 0) {
                    for (String prop : propVisable) {
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{prop});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{prop});
                    }
                }
            }
        }
    }

    private void setDisableField() {
        DynamicObjectCollection dynsCollection = this.getModel().getEntryEntity("entryentity");
        boolean[] fields = new boolean[]{true, true, true, true, true};
        for (DynamicObject dynamic : dynsCollection) {
            Object expiredate;
            BigDecimal price;
            BigDecimal quantity;
            Object measureunit;
            String businessnum = dynamic.getString("businessnum");
            if (StringUtils.isNotEmpty((CharSequence)businessnum)) {
                fields[0] = false;
            }
            if (null != (measureunit = dynamic.get("measureunit"))) {
                fields[1] = false;
            }
            if (null != (quantity = (BigDecimal)dynamic.get("quantity")) && quantity.signum() != 0) {
                fields[2] = false;
            }
            if (null != (price = (BigDecimal)dynamic.get("price")) && price.signum() != 0) {
                fields[3] = false;
            }
            if (null == (expiredate = dynamic.get("expiredate"))) continue;
            fields[4] = false;
        }
        if (fields[0]) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"businessnum"});
        }
        if (fields[1]) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"measureunit"});
        }
        if (fields[2]) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"quantity"});
        }
        if (fields[3]) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"price"});
        }
        if (fields[4]) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"expiredate"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().remove("cashAcctCount");
        this.getPageCache().remove("plAcctCount");
        this.getPageCache().remove("adjustment");
        this.initOriAmountAndRateType();
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        this.entryRowClick(new RowClickEvent((Object)eg, 0));
        eg.selectRows(0);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "delete": {
                QFilter filter;
                DynamicObject[] dynamics;
                Long glvoucherId = (Long)this.getModel().getValue("glvoucherid");
                if (null == glvoucherId || glvoucherId == 0L || null == (dynamics = BusinessDataServiceHelper.load((String)"ai_bizvoucher", (String)"FID", (QFilter[])(filter = new QFilter("glvoucherid", "=", (Object)glvoucherId)).toArray())) || dynamics.length <= 1) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u51ed\u8bc1\u7531\u591a\u4e2a\u4e8b\u4ef6\u751f\u6210\uff0c\u5220\u9664\u5176\u4e2d\u4e00\u4e2a\u4f1a\u5bfc\u81f4\u5176\u4ed6\u4e8b\u4ef6\u53ca\u5bf9\u5e94\u51ed\u8bc1\u540c\u6b65\u5220\u9664\u3002", (String)"BussinessVoucherEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("bizdeletevoucher".equals(operateKey) && args.getOperationResult().isSuccess()) {
            Label label = (Label)this.getControl(GLBILLNOLABEL);
            label.setText("");
            this.getModel().setValue("glvoucherid", (Object)0L);
            this.getModel().setDataChanged(false);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bizgeneratevoucher"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizdeletevoucher"});
        }
        if ("bizgeneratevoucher".equals(operateKey)) {
            Object bizvoucherId = this.getModel().getValue("id");
            Label label = (Label)this.getControl(GLBILLNOLABEL);
            label.setText(this.getGlFnumber(bizvoucherId));
            this.getModel().setDataChanged(false);
        }
    }

    public void loadData(LoadDataEventArgs e) {
        this.getModel().putContextVariable("MODEL_INIT_LOADSPLITPAGE", (Object)true);
    }

    private String getGlFnumber(Object id) {
        DataSet sourceData = DB.queryDataSet((String)BussinessVoucherEdit.class.getName(), (DBRoute)DBRoute.of((String)"ai"), (String)QUERY_GLNO_SQL, (Object[])new Object[]{id});
        String number = "";
        Long glvoucherId = 0L;
        for (Row row : sourceData) {
            number = row.getString("FNUMBER");
            glvoucherId = row.getLong("FID");
        }
        if (StringUtils.isNotEmpty((CharSequence)number)) {
            this.getModel().setValue("glvoucherid", (Object)glvoucherId);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizgeneratevoucher"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bizdeletevoucher"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bizgeneratevoucher"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizdeletevoucher"});
        }
        return number;
    }

    private void initOriAmountAndRateType() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection entyDyns = model.getEntryEntity("entryentity");
        EntryGrid grid = (EntryGrid)view.getControl("entryentity");
        Date bookDate = (Date)model.getValue("bookeddate");
        int size = this.getPageSize(entyDyns, grid);
        for (int i = 0; i < size; ++i) {
            DynamicObject dyn = (DynamicObject)entyDyns.get(i);
            if (dyn.getBigDecimal("debitori").compareTo(BigDecimal.ZERO) == 0) {
                model.setValue("oriamount", (Object)dyn.getBigDecimal("creditori"), i);
            } else {
                model.setValue("oriamount", (Object)dyn.getBigDecimal("debitori"), i);
            }
            model.setValue("ratetype", (Object)this.getRateType(i, model, bookDate), i);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List rows = e.getRows();
        ArrayList<Object> entryIds = new ArrayList<Object>();
        rows.forEach(row -> entryIds.add(row.getDataEntity().getLong("id")));
        if (entryIds.isEmpty()) {
            return;
        }
        BizVoucherService bizService = new BizVoucherService();
        Map<Long, List<BizVouSubEntry>> bizSubEntryMap = bizService.getBizVouSubEntry(entryIds);
        Set<String> flexSet = bizService.getFlexSet();
        Map<String, List<String>> valueKeyMap = bizService.getValueKeyMap();
        List<BizAsstacttype> bizAsstactList = bizService.getBizAsstacttypeList(flexSet);
        for (BizAsstacttype bizAsstacttype : bizAsstactList) {
            String flexfiled = bizAsstacttype.getFlexfiled();
            String datatype = bizAsstacttype.getDatatype();
            List<String> values = valueKeyMap.get(flexfiled);
            switch (datatype) {
                case "1": {
                    String valueSouce = bizAsstacttype.getValuesource();
                    ArrayList list = new ArrayList();
                    values.forEach(v -> {
                        if (StringUtils.isNotBlank((CharSequence)v)) {
                            list.add(Long.parseLong(v));
                        }
                    });
                    Map baseDataMap = BusinessDataServiceHelper.loadFromCache((Object[])list.toArray(), (String)valueSouce);
                    bizAsstacttype.setDataSouceMap(baseDataMap);
                    break;
                }
                case "2": {
                    ArrayList listSub = new ArrayList();
                    values.stream().forEach(v -> {
                        if (StringUtils.isNotBlank((CharSequence)v)) {
                            listSub.add(Long.parseLong(v));
                        }
                    });
                    Map subDataMap = BusinessDataServiceHelper.loadFromCache((Object[])listSub.toArray(), (String)"bos_assistantdata_detail");
                    bizAsstacttype.setDataSouceMap(subDataMap);
                    break;
                }
            }
        }
        IDataEntityProperty rateTypeProp = (IDataEntityProperty)((RowDataEntity)rows.get(0)).getDataEntity().getDataEntityType().getProperties().get((Object)BUSINESSMSGDESC);
        for (RowDataEntity row2 : rows) {
            int rowIndex = row2.getRowIndex();
            DynamicObject entryDyn = row2.getDataEntity();
            String value = this.getBizAsstStrBuilder(row2, bizSubEntryMap, bizAsstactList, rowIndex);
            rateTypeProp.setValue((Object)entryDyn, (Object)value);
            entryDyn.getDataEntityState().setBizChanged(rateTypeProp.getOrdinal(), false);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        List newRows = e.getRows().stream().map(x -> {
            BindingContext bindCtx = new BindingContext(x.getDataEntity().getDataEntityType(), x.getDataEntity(), x.getRowIndex());
            return entryGrid.getRowBindValue(bindCtx);
        }).collect(Collectors.toList());
        e.getData().put("rows", newRows);
        this.getModel().updateEntryCache(this.getModel().getEntryEntity("entryentity"));
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    private String getRateType(int rowIndex, IDataModel model, Date date) {
        long currencyId = (Long)model.getValue(BussinessVoucher.id_((String)"currency"), rowIndex);
        if (currencyId == 0L) {
            return null;
        }
        DynamicObject locCurDyn = (DynamicObject)model.getValue("localcur");
        if (locCurDyn != null) {
            return RateServiceHelper.getRateType((long)currencyId, (long)locCurDyn.getLong("id"), (Date)date).getStrValue();
        }
        return RateType.DIRECT_RATE.getStrValue();
    }

    private int getPageSize(DynamicObjectCollection col, EntryGrid grid) {
        int size;
        String split = ConfigurationUtil.getString((String)"billmodel.splitpage");
        if (grid.isSplitPage() || Boolean.parseBoolean(split)) {
            size = grid.getPageRow();
            if (size > col.size()) {
                size = col.size();
            }
        } else {
            size = col.size();
        }
        return size;
    }

    public void entryRowClick(RowClickEvent evt) {
        Control ce = (Control)evt.getSource();
        String entryname = ce.getKey();
        if ("entryentity".endsWith(entryname)) {
            IDataModel model = this.getModel();
            int entryRowCount = model.getEntryRowCount("entryentity");
            if (evt.getRow() >= entryRowCount) {
                return;
            }
            this.dealCFTotal();
            this.dealCashFlowPanel(evt.getRow());
            this.getModel().setDataChanged(false);
        }
    }

    private void dealCFTotal() {
        String cashAcctCount = this.getPageCache().get("cashAcctCount");
        if (cashAcctCount == null) {
            IDataModel m = this.getModel();
            this.getPageCache().put("cashAcctCount", "0");
            this.getPageCache().put("plAcctCount", "0");
            BigDecimal cashtotalamt = BigDecimal.ZERO;
            BigDecimal pltotalamt = BigDecimal.ZERO;
            BigDecimal cashtotalused = BigDecimal.ZERO;
            BigDecimal pltotalused = BigDecimal.ZERO;
            DynamicObjectCollection entries = m.getEntryEntity("entryentity");
            int cashCount = 0;
            int plCount = 0;
            HashMap<Long, Boolean> plAcctMap = new HashMap<Long, Boolean>();
            for (DynamicObject entry : entries) {
                boolean isPLAcct;
                DynamicObject acct = entry.getDynamicObject("account");
                if (acct == null) continue;
                if (acct != null && (acct.getBoolean("iscash") || acct.getBoolean("isbank") || acct.getBoolean("iscashequivalent"))) {
                    ++cashCount;
                    BigDecimal drLoc = entry.getBigDecimal("debitlocal");
                    BigDecimal crLoc = entry.getBigDecimal("creditlocal");
                    cashtotalamt = cashtotalamt.add(drLoc).subtract(crLoc);
                    continue;
                }
                DynamicObject mainCF = entry.getDynamicObject("maincfitem");
                if (mainCF != null) {
                    BigDecimal mainCfamt = entry.getBigDecimal("maincfamount");
                    cashtotalused = "o".equals(mainCF.getString("direction")) ? cashtotalused.subtract(mainCfamt) : cashtotalused.add(mainCfamt);
                }
                BigDecimal suppCfamt = entry.getBigDecimal("supfamount");
                pltotalused = pltotalused.add(suppCfamt);
                if (plAcctMap.get(acct.getLong("id")) == null) {
                    isPLAcct = GLUtil.isPLAcct((DynamicObject)acct);
                    plAcctMap.put(acct.getLong("id"), isPLAcct);
                } else {
                    isPLAcct = (Boolean)plAcctMap.get(acct.getLong("id"));
                }
                if (!isPLAcct) continue;
                ++plCount;
                BigDecimal drLoc = entry.getBigDecimal("debitlocal");
                BigDecimal crLoc = entry.getBigDecimal("creditlocal");
                pltotalamt = pltotalamt.add(drLoc).subtract(crLoc);
            }
            this.getPageCache().put("cashAcctCount", String.valueOf(cashCount));
            this.getPageCache().put("plAcctCount", String.valueOf(plCount));
            m.setValue("cashtotal", (Object)cashtotalamt);
            m.setValue("cashunused", (Object)cashtotalamt.subtract(cashtotalused));
            m.setValue("pltotal", (Object)pltotalamt);
            m.setValue("plunused", (Object)pltotalamt.subtract(pltotalused));
            if (cashCount == 0 && plCount == 0) {
                for (DynamicObject entry : entries) {
                    DynamicObject suppcf = entry.getDynamicObject("supcfitem");
                    if (suppcf == null) continue;
                    this.getPageCache().put("adjustment", "true");
                    break;
                }
            }
        }
    }

    private void dealCashFlowPanel(int index) {
        if (index == -1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"maincf", "maincfamt", "mcfassgrp", "cashtotal", "cashunused"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"suppcf", "suppcfamt", "pltotal", "plunused"});
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject acct = (DynamicObject)this.getModel().getValue("account", index);
        Object sourceType = model.getValue("sourcetype");
        if (acct == null || "1".equals(sourceType)) {
            this.hideCashFlow(true, true);
        } else {
            String cashAcctCount = this.getPageCache().get("cashAcctCount");
            if (cashAcctCount == null || Integer.parseInt(cashAcctCount) == 0) {
                String plAcctCount = this.getPageCache().get("plAcctCount");
                if (plAcctCount == null || Integer.parseInt(plAcctCount) == 0) {
                    if (this.getPageCache().get("adjustment") != null) {
                        this.hideCashFlow(true, true);
                        this.showCashFlow(false, true);
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{"suppcf", "suppcfamt"});
                    } else {
                        this.hideCashFlow(true, true);
                    }
                } else if (GLUtil.isPLAcct((DynamicObject)acct)) {
                    this.hideCashFlow(true, true);
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"suppcf"});
                    this.showCashFlow(false, true);
                    this.hideCashFlow(true, false);
                }
            } else if (GLUtil.isCashAcct((DynamicObject)acct)) {
                this.hideCashFlow(true, true);
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"suppcfamt"});
                if (GLUtil.isPLAcct((DynamicObject)acct)) {
                    DynamicObject mainCF = (DynamicObject)this.getModel().getValue("maincfitem", index);
                    if (mainCF != null && mainCF.getBoolean("isdealactivity")) {
                        this.showCashFlow(true, false);
                        this.hideCashFlow(false, true);
                    } else {
                        this.showCashFlow(true, true);
                        this.getView().setEnable(Boolean.valueOf(mainCF != null), new String[]{"suppcf"});
                    }
                } else {
                    DynamicObject mainCF = (DynamicObject)this.getModel().getValue("maincfitem", index);
                    if (mainCF != null && !mainCF.getBoolean("isdealactivity")) {
                        this.showCashFlow(true, false);
                        this.hideCashFlow(false, true);
                    } else {
                        this.showCashFlow(true, true);
                        this.getView().setEnable(Boolean.valueOf(mainCF != null), new String[]{"suppcf"});
                    }
                }
            }
        }
    }

    private void hideCashFlow(boolean hideMain, boolean hideSupp) {
        IDataModel model = this.getModel();
        model.beginInit();
        if (hideMain) {
            this.getPageCache().remove("isShowMain");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"maincf", "maincfamt", "mcfassgrp", "cashtotal", "cashunused"});
            model.setValue("maincf", null);
            model.setValue("mcfassgrp", null);
            model.setValue("maincfamt", (Object)0);
        }
        if (hideSupp) {
            this.getPageCache().remove("isShowSupp");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"suppcf", "suppcfamt", "pltotal", "plunused"});
            model.setValue("suppcf", null);
            model.setValue("suppcfamt", (Object)0);
        }
        model.endInit();
        this.getView().updateView("maincf");
        this.getView().updateView("mcfassgrp");
        this.getView().updateView("maincfamt");
        this.getView().updateView("suppcf");
        this.getView().updateView("suppcfamt");
    }

    private void showCashFlow(boolean showMain, boolean showSupp) {
        IPageCache cache = this.getPageCache();
        cache.put("showCashFlow", "true");
        if (showMain) {
            cache.put("isShowMain", "true");
        }
        if (showSupp) {
            cache.put("isShowSupp", "true");
        }
        IDataModel m = this.getModel();
        int index = m.getEntryCurrentRowIndex("entryentity");
        if (showMain) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"maincf", "maincfamt", "mcfassgrp", "cashtotal", "cashunused"});
            Object mainCfItem = m.getValue("maincfitem", index);
            if (null == mainCfItem) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"maincfamt"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"maincfamt"});
            }
            m.beginInit();
            m.setValue("maincf", mainCfItem);
            m.setValue("mcfassgrp", m.getValue("maincfassgrp"), index);
            m.setValue("maincfamt", m.getValue("maincfamount", index));
            m.endInit();
            this.getView().updateView("maincf");
            this.getView().updateView("mcfassgrp");
            this.getView().updateView("maincfamt");
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"maincfamt"});
        }
        if (showSupp) {
            boolean isOnlySupp = this.isOnlySupp();
            if (isOnlySupp) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"suppcf", "suppcfamt", "pltotal", "plunused"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"suppcf", "suppcfamt"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"pltotal", "plunused"});
            }
            if (isOnlySupp) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"suppcfamt"});
            }
            m.beginInit();
            m.setValue("suppcf", m.getValue("supcfitem", index));
            m.setValue("suppcfamt", m.getValue("supfamount", index));
            m.endInit();
            this.getView().updateView("suppcf");
            this.getView().updateView("suppcfamt");
        }
        cache.remove("showCashFlow");
    }

    private boolean isOnlySupp() {
        String cashAcctCount = this.getPageCache().get("cashAcctCount");
        String plAcctCount = this.getPageCache().get("plAcctCount");
        return (cashAcctCount == null || Integer.parseInt(cashAcctCount) == 0) && plAcctCount != null && Integer.parseInt(plAcctCount) != 0;
    }

    public void cellClick(CellClickEvent arg0) {
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
    }

    private EntityType cloneEntityType(MainEntityType oriType) {
        MainEntityType newType;
        try {
            newType = (MainEntityType)oriType.clone();
            newType.clearRefEntityTypeVer();
            newType.clearSubEntityTypecache();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return newType;
    }
}

