/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.accsys.AccSysUtil;
import kd.fi.ai.enums.PermissonType;

public class ImportVchTemplatePlugin
extends AbstractFormPlugin
implements UploadListener,
BeforeF7SelectListener {
    public static final String FormId_ImportFile = "botp_importfile";
    private static final String Key_FileName = "filename";
    private static final String Key_FilePanel = "filepanel";
    private static final String Key_btnOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_btnOK});
        AttachmentPanel filePanel = (AttachmentPanel)this.getControl(Key_FilePanel);
        filePanel.addUploadListener((UploadListener)this);
        OrgEdit orgEdit = (OrgEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String orgID = (String)this.getView().getFormShowParameter().getCustomParam("org");
        if (StringUtils.isNotBlank((CharSequence)orgID)) {
            this.getModel().setValue("org", (Object)Long.valueOf(orgID));
        }
    }

    public void upload(UploadEvent evt) {
    }

    public void afterUpload(UploadEvent evt) {
        List<String> uploadFileUrls = this.getUploadFileUrls(evt);
        String fieldValue = (String)this.getModel().getValue(Key_FileName);
        String[] fieldValues = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            fieldValues = StringUtils.split((String)fieldValue, (String)";");
        }
        HashSet<String> fileUrls = new HashSet<String>(uploadFileUrls.size() + fieldValues.length);
        for (String fileUrl : uploadFileUrls) {
            fileUrls.add(fileUrl);
        }
        for (String fileUrl : fieldValues) {
            fileUrls.add(fileUrl);
        }
        fieldValue = StringUtils.join((Object[])fileUrls.toArray(), (String)";");
        this.getModel().setValue(Key_FileName, (Object)fieldValue);
    }

    public void remove(UploadEvent evt) {
    }

    public void afterRemove(UploadEvent evt) {
        String fieldValue = (String)this.getModel().getValue(Key_FileName);
        String[] fieldValues = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            fieldValues = StringUtils.split((String)fieldValue, (String)";");
        }
        HashSet<String> fileUrls = new HashSet<String>(fieldValues.length);
        for (String fileUrl : fieldValues) {
            fileUrls.add(fileUrl);
        }
        List<String> removeFileUrls = this.getUploadFileUrls(evt);
        for (String fileUrl : removeFileUrls) {
            fileUrls.remove(fileUrl);
        }
        fieldValue = StringUtils.join((Object[])fileUrls.toArray(), (String)";");
        this.getModel().setValue(Key_FileName, (Object)fieldValue);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if (srcCtrl.getKey().equalsIgnoreCase(Key_btnOK)) {
            this.doOK();
        }
    }

    private void doOK() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String fileNames = (String)this.getModel().getValue(Key_FileName);
        if (StringUtils.isBlank((CharSequence)fileNames)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u6587\u4ef6(*.zip)\u3002", (String)"ImportVchTemplatePlugin_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        ret.put("file", fileNames);
        DynamicObject orgDyo = (DynamicObject)this.getModel().getValue("org");
        if (orgDyo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ImportVchTemplatePlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        ret.put("org", orgDyo.getPkValue());
        this.getView().returnDataToParent(ret);
        this.getView().close();
    }

    private List<String> getUploadFileUrls(UploadEvent evt) {
        ArrayList<String> fileUrls = new ArrayList<String>(evt.getUrls().length);
        for (Object url : evt.getUrls()) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        return fileUrls;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        Object source = arg0.getSource();
        Control sourceCtl = (Control)source;
        String key = sourceCtl.getKey();
        if ("org".equals(key)) {
            List acctOrgIds = AccSysUtil.getAcctOrgPkList((String)"ai_vchtemplate", (boolean)true, (PermissonType)PermissonType.NEW);
            QFilter h = new QFilter("org", "in", (Object)acctOrgIds);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,org.id", (QFilter[])new QFilter[]{h});
            ArrayList<Long> idList = new ArrayList<Long>();
            for (DynamicObject obj : coll) {
                idList.add(obj.getLong("org.id"));
            }
            QFilter qFilters = new QFilter("id", "in", idList);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            filterParam.getQFilters().add(qFilters);
        }
    }
}

