/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

class ListVoucherNumber
extends ListDataProvider {
    private static final String ORG = "morg";
    private static final String BOOKTYPE = "mbooktype";
    private static final String BOOK = "accountbookid";

    ListVoucherNumber() {
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(ORG, String.class, (Object)""));
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(BOOKTYPE, String.class, (Object)""));
        ArrayList<Long> ids = new ArrayList<Long>(rows.size());
        for (DynamicObject row : rows) {
            long rowid = row.getLong(BOOK);
            if (rowid == 0L) continue;
            ids.add(rowid);
        }
        Map<String, String> numberById = this.getNumberById(ids);
        if (numberById != null && numberById.size() > 0) {
            for (DynamicObject row : rows) {
                String orgAddBooktype;
                String rowid = row.get(BOOK).toString();
                if (rowid.equals("0") || (orgAddBooktype = numberById.get(rowid)) == null) continue;
                String[] split = orgAddBooktype.split("--");
                row.set(ORG, (Object)split[0]);
                row.set(BOOKTYPE, (Object)split[1]);
            }
        }
        return rows;
    }

    private Map<String, String> getNumberById(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        DynamicObject[] bookdata = BusinessDataServiceHelper.load((String)"gl_accountbook", (String)"org.name,bookstype.name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (bookdata.length > 0) {
            for (DynamicObject book : bookdata) {
                String orgid = book.get("org.name").toString();
                String booktypeid = book.get("bookstype.name").toString();
                returnMap.put(book.getPkValue().toString(), orgid + "--" + booktypeid);
            }
            return returnMap;
        }
        return null;
    }
}

