/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.mvc.list.ListDataProvider;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;

public class MapTypeListDataProvider
extends ListDataProvider {
    private String errMsg = null;

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection data = super.getData(start, limit);
        if (data.isEmpty()) {
            return data;
        }
        for (DynamicObject row : data) {
            String factorValues = (String)row.get("factorvalue");
            row.set("factorname", (Object)this.getFactorName(factorValues, row.getString("name")));
        }
        return data;
    }

    private String getFactorName(String factorValue, String mapName) {
        if (StringUtils.isEmpty((CharSequence)factorValue)) {
            return "";
        }
        String[] factorValues = factorValue.split(",");
        Object[] factorNames = new String[]{};
        try {
            factorNames = FahEntityMetaHelper.batchGetFactorName((String[])factorValues);
        }
        catch (Exception e) {
            this.errMsg = mapName + ":" + e.getMessage();
        }
        return StringUtils.join((Object[])factorNames, (String)",");
    }

    public String getErrMsg() {
        return this.errMsg;
    }
}

