/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.AiBillStructure;
import kd.fi.ai.enums.AiFiledTypeEnum;
import kd.fi.ai.util.GLUtil;

public class MetaPropertyTreeEdit
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener,
RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String GROUPNUMBER = "groupnumber";
    private static final String ID = "id";
    private static final String DATATYPE = "data_type";
    private static final String DATASCHEMA = "data_schema";
    private static final String REQUIRED = "required";
    private static final String Btn_Ok = "btn_ok";
    private static final String Btn_Cancel = "btn_cancel";
    private static final String ENTITY = "entryentity";
    private static final String PARENT = "parentNumber";
    private static final String CACHELIST = "cacheList";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{Btn_Ok, Btn_Cancel, ENTITY});
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTITY);
        entry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void setSelectRows(List<AiBillStructure> keyList, int curRow, boolean isFirst) {
        int[] selectRows = null;
        selectRows = this.getSelectRows(keyList);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTITY);
        entryGrid.selectRows(selectRows, curRow);
        if (isFirst) {
            this.getPageCache().put(CACHELIST, SerializationUtils.toJsonString(this.getBatchSelectedRowData(selectRows)));
        }
    }

    private int[] getSelectRows(List<AiBillStructure> keyList) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity(ENTITY);
        ArrayList<Integer> selectRowList = new ArrayList<Integer>();
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject dyn = (DynamicObject)entries.get(i);
            Object key = dyn.get(NUMBER);
            for (AiBillStructure structure : keyList) {
                if (!structure.getNumber().equals(key)) continue;
                selectRowList.add(i);
            }
        }
        if (selectRowList.size() == 0) {
            return new int[0];
        }
        return selectRowList.stream().mapToInt(Integer::valueOf).toArray();
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params.containsKey(ID)) {
            List list;
            String object;
            String id = (String)params.get(ID);
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_entityobject");
            this.initTree(id, meta.getString(NAME));
            if (params.containsKey("relation_mapping") && StringUtils.isNotBlank((CharSequence)(object = (String)params.get("relation_mapping"))) && !(list = (List)GLUtil.fromSerializedString((String)object)).isEmpty()) {
                this.setSelectRows(list, 0, true);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u5143\u6570\u636eID\uff0c\u65e0\u6cd5\u83b7\u53d6\u5143\u6570\u636e\u5c5e\u6027\u3002", (String)"MetaPropertyTreeEdit_01", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        this.getView().updateView(ENTITY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTITY);
        String text = searchEnterEvent.getText();
        if (entryEntity.size() != 0 && !StringUtils.isEmpty((CharSequence)text)) {
            ArrayList<Integer> indexs = new ArrayList<Integer>();
            for (int rows = 0; rows < entryEntity.size(); ++rows) {
                DynamicObject o = (DynamicObject)entryEntity.get(rows);
                if (o.getString(NAME).contains(text)) {
                    indexs.add(rows);
                    continue;
                }
                if (!o.getString(NUMBER).contains(text)) continue;
                indexs.add(rows);
            }
            if (indexs.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"MetaPropertyTreeEdit_02", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            int[] arg7 = indexs.stream().mapToInt(Integer::valueOf).toArray();
            grid.setRowBackcolor("#eff3fd", arg7);
            grid.focusCell(arg7[0], NUMBER);
        }
    }

    private void initTree(String id, String text) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.deleteAllNodes();
        treeView.setMulti(false);
        TreeNode root = new TreeNode("", id, text);
        root.setExpend(true);
        root.setType("REF");
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand(id);
        treeView.focusNode(root);
        this.initRootEntry(root);
    }

    private void initRootEntry(TreeNode root) {
        String rootId = root.getId();
        this.getPageCache().put(ID, rootId);
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)rootId, (String)"bos_entityobject");
        this.showCollection(root, (EntityType)EntityMetadataCache.getDataEntityType((String)root.getId()), meta);
    }

    private void showCollection(TreeNode root, EntityType entityType, DynamicObject meta) {
        this.getModel().deleteEntryData(ENTITY);
        if (meta != null) {
            ArrayList<AiBillStructure> list = this.getList(root, entityType, new ArrayList<AiBillStructure>(), true);
            this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
            this.getPageCache().put("list", SerializationUtils.toJsonString(list));
            this.copyProperty2Entry(list);
        }
    }

    private ArrayList<AiBillStructure> getList(TreeNode root, EntityType entityType, ArrayList<AiBillStructure> listAll, boolean isFirst) {
        DynamicPropertyCollection collection = (DynamicPropertyCollection)entityType.getProperties();
        ArrayList<AiBillStructure> list = new ArrayList<AiBillStructure>(16);
        for (IDataEntityProperty prop : collection) {
            BasedataProp bdProp;
            AiBillStructure structure = new AiBillStructure();
            if (prop.getName() != null && prop.getName().contains("_id") || NUMBER.equals(prop.getName()) || "org".equals(prop.getName()) || ID.equals(prop.getName()) || prop instanceof DynamicLocaleProperty || prop instanceof MulBasedataProp || !listAll.isEmpty() && (ID.equals(prop.getName()) || "seq".equals(prop.getName()))) continue;
            TreeNode node = new TreeNode();
            if (prop instanceof EntryProp || prop instanceof SubEntryProp) {
                EntityType subEntityType = (EntityType)((EntryProp)prop).getItemType();
                if (!isFirst) continue;
                this.getPageCache().put(PARENT, prop.getName());
                this.getList(node, subEntityType, list, false);
            }
            if (prop instanceof BasedataProp && (bdProp = (BasedataProp)prop).getBaseEntityId() != null) {
                node.setId(bdProp.getName());
                node.setText(bdProp.getDisplayName() == null ? bdProp.getName() : bdProp.getDisplayName() + "");
                node.setType(bdProp.getBaseEntityId());
                root.addChild(node);
                structure.setNumber(bdProp.getName());
                structure.setName(bdProp.getDisplayName() == null ? bdProp.getName() : bdProp.getDisplayName() + "");
                structure.setData_schema(bdProp.getBaseEntityId());
                structure.setData_type(AiFiledTypeEnum.AI_BASEDATA.getValue());
                structure.setRequired(Boolean.valueOf(bdProp.isMustInput()));
                if (prop instanceof AssistantProp) {
                    structure.setData_type(AiFiledTypeEnum.AI_ASSISTANT.getValue());
                    structure.setData_schema(((AssistantProp)prop).getAsstTypeId());
                }
                if (isFirst) {
                    structure.setGroupNumber(bdProp.getName());
                } else {
                    String parentNumber = this.getPageCache().get(PARENT);
                    structure.setGroupNumber(parentNumber);
                }
                list.add(structure);
                continue;
            }
            if (prop instanceof FieldProp) {
                FieldProp fieldProp = (FieldProp)prop;
                structure.setRequired(Boolean.valueOf(fieldProp.isMustInput()));
            } else if (prop instanceof FlexProp) {
                FlexProp flexProp = (FlexProp)prop;
                structure.setRequired(Boolean.valueOf(flexProp.isMustInput()));
            } else {
                structure.setRequired(Boolean.FALSE);
            }
            if (prop instanceof EntryProp) {
                structure.setData_type(AiFiledTypeEnum.AI_ENTRY.getValue());
            } else if (prop instanceof DecimalProp || prop instanceof LongProp) {
                structure.setData_type(AiFiledTypeEnum.AI_NUMBER.getValue());
            } else if (prop instanceof DateProp || prop instanceof DateTimeProp) {
                structure.setData_type(AiFiledTypeEnum.AI_DATE.getValue());
            } else if (prop instanceof BooleanProp) {
                structure.setData_type(AiFiledTypeEnum.AI_BOOLEAN.getValue());
            } else if (prop instanceof TextProp || prop instanceof ComboProp || prop instanceof FlexProp || prop instanceof FieldProp) {
                structure.setData_type(AiFiledTypeEnum.AI_TXT.getValue());
            }
            node.setId(prop.getName());
            node.setText(prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName() + "");
            root.addChild(node);
            structure.setNumber(prop.getName());
            structure.setName(prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName() + "");
            if (isFirst) {
                structure.setGroupNumber(prop.getName());
            } else {
                String parentNumber = this.getPageCache().get(PARENT);
                structure.setGroupNumber(parentNumber);
            }
            if (StringUtils.isBlank((CharSequence)structure.getData_type()) && structure.getGroupNumber().equals(structure.getNumber())) {
                structure.setData_type(AiFiledTypeEnum.AI_ENTRY.getValue());
            }
            list.add(structure);
        }
        listAll.addAll(list);
        return list;
    }

    private void copyProperty2Entry(ArrayList<AiBillStructure> list) {
        if (!list.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTITY, list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.getModel().setValue(GROUPNUMBER, (Object)list.get(i).getGroupNumber(), i);
                this.getModel().setValue(NUMBER, (Object)list.get(i).getNumber(), i);
                this.getModel().setValue(NAME, (Object)list.get(i).getName(), i);
                this.getModel().setValue(DATASCHEMA, (Object)list.get(i).getData_schema(), i);
                this.getModel().setValue(REQUIRED, (Object)list.get(i).getRequired(), i);
                this.getModel().setValue(DATATYPE, (Object)list.get(i).getData_type(), i);
            }
            this.getView().updateView(ENTITY);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        boolean isNewModel = "true".equals(this.getView().getFormShowParameter().getCustomParam("new"));
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        String nodeId = evt.getNodeId().toString();
        String listString = this.getPageCache().get("list");
        if (this.isRoot(nodeId)) {
            List cacheList;
            String rootString = this.getPageCache().get("root");
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rootString, TreeNode.class);
            this.initRootEntry(root);
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get(CACHELIST)) && !(cacheList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHELIST), AiBillStructure.class)).isEmpty()) {
                this.setSelectRows(cacheList, 0, false);
            }
        } else if (StringUtils.isNotBlank((CharSequence)listString)) {
            List cacheList;
            ArrayList list = (ArrayList)SerializationUtils.fromJsonStringToList((String)listString, AiBillStructure.class);
            ArrayList<AiBillStructure> listEntry = new ArrayList<AiBillStructure>(8);
            this.getModel().deleteEntryData(ENTITY);
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(GROUPNUMBER, new Object[0]);
            vs.addField(NUMBER, new Object[0]);
            vs.addField(NAME, new Object[0]);
            vs.addField(DATATYPE, new Object[0]);
            vs.addField(DATASCHEMA, new Object[0]);
            vs.addField(REQUIRED, new Object[0]);
            list.stream().filter(a -> !isNewModel && nodeId.equals(a.getNumber()) || nodeId.equals(a.getGroupNumber()) && !nodeId.equals(a.getNumber())).forEach(dynamic -> vs.addRow(new Object[]{dynamic.getGroupNumber(), dynamic.getNumber(), dynamic.getName(), dynamic.getData_type(), dynamic.getData_schema(), dynamic.getRequired()}));
            model.batchCreateNewEntryRow(ENTITY, vs);
            this.getView().updateView(ENTITY);
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get(CACHELIST)) && !(cacheList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHELIST), AiBillStructure.class)).isEmpty()) {
                for (AiBillStructure aiBillStructure : cacheList) {
                    if (nodeId.equals(aiBillStructure.getGroupNumber()) && !nodeId.equals(aiBillStructure.getNumber())) {
                        listEntry.add(aiBillStructure);
                    }
                    if (isNewModel || !nodeId.equals(aiBillStructure.getNumber())) continue;
                    listEntry.add(aiBillStructure);
                }
                if (!listEntry.isEmpty()) {
                    this.setSelectRows(listEntry, 0, false);
                }
            }
        }
    }

    private boolean isRoot(String id) {
        return id.equals(this.getPageCache().get(ID));
    }

    public void click(EventObject evt) {
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        String focusId = treeView.getTreeState().getFocusNodeId();
        if (Btn_Cancel.equals(key)) {
            this.getView().close();
        } else if (Btn_Ok.equals(key)) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTITY);
            int[] rows = entry.getSelectRows();
            if (this.isRoot(focusId)) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(this.getBatchSelectedRowData(rows)));
                this.getView().close();
            } else if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get(CACHELIST))) {
                List cacheList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHELIST), AiBillStructure.class);
                if (!cacheList.isEmpty()) {
                    List<AiBillStructure> newList = this.getBatchSelectedRowData(rows);
                    HashSet<String> groupNums = new HashSet<String>(8);
                    if (!newList.isEmpty()) {
                        for (AiBillStructure structure : newList) {
                            groupNums.add(structure.getGroupNumber());
                        }
                    } else {
                        groupNums.add(focusId);
                    }
                    Iterator iterator = cacheList.iterator();
                    while (iterator.hasNext()) {
                        AiBillStructure structure;
                        structure = (AiBillStructure)iterator.next();
                        if (!groupNums.contains(structure.getGroupNumber())) continue;
                        iterator.remove();
                    }
                    cacheList.addAll(newList);
                    this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)cacheList));
                    this.getView().close();
                }
            } else {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(this.getBatchSelectedRowData(rows)));
                this.getView().close();
            }
        }
    }

    private List<AiBillStructure> getBatchSelectedRowData(int[] row) {
        ArrayList<AiBillStructure> list = new ArrayList<AiBillStructure>(row.length);
        for (int i = 0; i < row.length; ++i) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTITY, row[i]);
            AiBillStructure aiBillStructure = new AiBillStructure();
            aiBillStructure.setNumber(rowEntity.getString(NUMBER));
            aiBillStructure.setName(rowEntity.getString(NAME));
            aiBillStructure.setData_type(rowEntity.getString(DATATYPE));
            aiBillStructure.setData_schema(rowEntity.getString(DATASCHEMA));
            aiBillStructure.setRequired(Boolean.valueOf(rowEntity.getBoolean(REQUIRED)));
            aiBillStructure.setGroupNumber(rowEntity.getString(GROUPNUMBER));
            list.add(aiBillStructure);
        }
        return list;
    }
}

