/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportRowSet;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.cache.DistributeCache;
import kd.fi.ai.enums.CheckBoxEnum;
import kd.fi.bd.util.filter.QFilterBuilder;

public class NoVoucherBillForm
extends AbstractReportFormPlugin {
    private DistributeCache cache = new DistributeCache(CacheModule.DAPNTABLEIDS);
    private static final String NOVOUCHERBILLIDS = "novoucherbill_ids";

    public void initialize() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.setEntityNumber("ai_dapbill");
        this.setVoucherFilterFields(filterGrid);
    }

    private void setVoucherFilterFields(FilterGrid filterGrid) {
        ArrayList<String> filterFileds = new ArrayList<String>();
        filterFileds.add("billno");
        filterGrid.setFilterFieldKeys(filterFileds);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long orgid = RequestContext.get().getOrgId();
        HasPermOrgResult resutlt = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
        if (resutlt.hasAllOrgPerm()) {
            this.getModel().setValue("org", (Object)orgid);
        } else {
            List orgIds = resutlt.getHasPermOrgs();
            if (orgIds != null && !orgIds.isEmpty()) {
                HashSet orgIdSet = new HashSet(orgIds);
                if (!orgIdSet.contains(orgid)) {
                    orgid = (Long)orgIds.get(0);
                }
                this.getModel().setValue("org", (Object)orgid);
            }
        }
        List orgs = resutlt.getHasPermOrgs();
        if (orgs.size() > 0) {
            // empty if block
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        QFilter modeltypeQfilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        QFilter voucherQfilter = new QFilter("voucher", "=", (Object)CheckBoxEnum.TRUE.getValue());
        QFilter appFilter = new QFilter("bizappid.deploystatus", "=", (Object)"2");
        qFilters.add(modeltypeQfilter);
        qFilters.add(voucherQfilter);
        qFilters.add(appFilter);
        List<String> idList = new ArrayList(16);
        if (StringUtils.isNotBlank((CharSequence)this.cache.get(NOVOUCHERBILLIDS))) {
            idList = (List)SerializationUtils.fromJsonString((String)this.cache.get(NOVOUCHERBILLIDS), List.class);
        } else {
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_entityobject", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
            for (DynamicObject dynamicObject : dys) {
                String billType = dynamicObject.getString("id");
                try {
                    String hasDataTable;
                    DBRoute route = DBRoute.of((String)DapBuildVoucherCommonUtil.getDBRouteKey((String)billType));
                    String querySql = "select count(1) num from %s";
                    String black = DapBuildVoucherCommonUtil.getBlackTableName((String)billType);
                    querySql = String.format(querySql, black);
                    boolean result = DapBuildVoucherCommonUtil.getDistributeHasDapWBill((String)billType);
                    if (!result || !StringUtils.isNotBlank((CharSequence)(hasDataTable = this.queryBlackTable(route, querySql, dynamicObject.getString("id"))))) continue;
                    idList.add(hasDataTable);
                }
                catch (Exception e2) {}
            }
            this.cache.put(NOVOUCHERBILLIDS, SerializationUtils.toJsonString(idList));
        }
        QFilter idFilter = new QFilter("id", "in", idList);
        qFilters.add(idFilter);
        this.getPageCache().put("qFilters", SerializationUtils.toJsonString(qFilters));
        if (idList.size() > 0) {
            this.getModel().setValue("sourcebill", idList.get(0));
        }
        Date now = new Date();
        this.getModel().setValue("endtime", (Object)now);
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        c.add(2, -6);
        Date m3 = c.getTime();
        this.getModel().setValue("starttime", (Object)m3);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getLong("org") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"NoVoucherBillForm_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (null == filterInfo.getValue("sourcebill")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"NoVoucherBillForm_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (null == filterInfo.getValue("starttime")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"NoVoucherBillForm_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (null != filterInfo.getValue("sourcebill")) {
            String billType = ((DynamicObject)filterInfo.getValue("sourcebill")).getString("number");
            this.getPageCache().put("billType", billType);
            boolean result = DapBuildVoucherCommonUtil.getDistributeHasDapWBill((String)billType);
            if (!result) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u8868\u5c1a\u672a\u521b\u5efa\uff0c\u8be5\u5355\u636e\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"NoVoucherBillForm_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            HasPermOrgResult resutlt = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
            if (!resutlt.hasAllOrgPerm()) {
                qFilters.add(new QFilter("id", "in", (Object)resutlt.getHasPermOrgs()));
            }
        });
        BasedataEdit sourcebill = (BasedataEdit)this.getControl("sourcebill");
        sourcebill.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            List qFilters2 = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("qFilters"), QFilter.class);
            qFilters.addAll(qFilters2);
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowData = control.getReportModel().getRowData(rowIndex);
            String name = evt.getFieldName();
            if ("sourcebillno".equals(name)) {
                Long billid = rowData.getLong("sourcebillid");
                String billType = ((DynamicObject)this.getQueryParam().getFilter().getValue("sourcebill")).getString("number");
                this.showBillEditForm(billid, billType);
            }
        });
    }

    private void showBillEditForm(Long billid, String sourceBillTypeId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(sourceBillTypeId);
        showParameter.setPkId((Object)billid);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("exportexcel".equals(operateKey)) {
            ReportList control = (ReportList)this.getControl("reportlistap");
            int allcount = control.getReportModel().getRowCount();
            int[] selectRows = control.getEntryState().getSelectedRows();
            if (selectRows.length > 0 && selectRows.length < allcount) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4ec5\u652f\u6301\u5168\u90e8\u5bfc\u51fa\u3002", (String)"NoVoucherBillForm_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        HashSet<Long> set;
        ReportList control;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("donothing".equals(operateKey)) {
            control = (ReportList)this.getControl("reportlistap");
            int[] selectRows = control.getEntryState().getSelectedRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u6570\u636e\u3002", (String)"NoVoucherBillForm_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            IReportListModel reportModel = control.getReportModel();
            set = new HashSet<Long>(12);
            for (int i : selectRows) {
                set.add(reportModel.getRowData(i).getLong("sourcebillid"));
            }
            int successCount = selectRows.length;
            this.getPageCache().put("set", SerializationUtils.toJsonString(set));
            this.getPageCache().put("count", SerializationUtils.toJsonString((Object)successCount));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u5355\u636e\u4e0d\u751f\u6210\u51ed\u8bc1\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"NoVoucherBillForm_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("contentChange1"));
        }
        if ("alldonothing".equals(operateKey)) {
            control = (ReportList)this.getControl("reportlistap");
            ReportListModel reportModel = (ReportListModel)control.getReportModel();
            int rowCount = control.getReportModel().getRowCount();
            set = new HashSet(12);
            if (rowCount == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u6570\u636e\u3002", (String)"NoVoucherBillForm_7", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            ReportRowSet data = reportModel.getReportTaskResult().getData(0, rowCount);
            while (data.next()) {
                set.add((Long)data.getObject("sourcebillid"));
            }
            this.getPageCache().put("set", SerializationUtils.toJsonString(set));
            this.getPageCache().put("count", SerializationUtils.toJsonString((Object)rowCount));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u53d6\u6d88\u67e5\u8be2\u6761\u4ef6\u4e0b\u7684\u6240\u6709\u8bb0\u5f55\u4e0d\u751f\u6210\u51ed\u8bc1\uff1f", (String)"NoVoucherBillForm_8", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("contentChange1"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        MessageBoxResult result = evt.getResult();
        if ("contentChange1".equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)result)) {
            String billType = this.getPageCache().get("billType");
            String tableName = DapBuildVoucherCommonUtil.getBlackTableName((String)billType);
            DBRoute route = DBRoute.of((String)DapBuildVoucherCommonUtil.getDBRouteKey((String)billType));
            Set idSet = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("set"), Set.class);
            QFilter qFilter = new QFilter("id", "in", (Object)idSet);
            OperateOption option = OperateOption.create();
            MainEntityType mEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
            String org = mEntityType.getMainOrg();
            DynamicObject[] dyns = BusinessDataServiceHelper.load((String)billType, (String)("id," + org + "," + kd.fi.ai.util.DapBuildVoucherCommonUtil.getBillNoFormBill((String)billType)), (QFilter[])qFilter.toArray());
            HashSet<Long> sourceidSet = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : dyns) {
                sourceidSet.add(dynamicObject.getLong("id"));
            }
            HashSet deleteSet = new HashSet(16);
            deleteSet.addAll(idSet);
            deleteSet.removeAll(sourceidSet);
            if (deleteSet.size() > 0) {
                String joinIds = QFilterBuilder.buildSQLParamHolder((int)deleteSet.size());
                String string = "delete from %s where fsourcebillid in %s ";
                String deleteSql = String.format(string, tableName, joinIds);
                DB.execute((DBRoute)route, (String)deleteSql, (Object[])deleteSet.toArray());
            }
            try {
                OperationServiceHelper.executeOperate((String)"backnogenvoucher", (String)billType, (Object[])sourceidSet.toArray(), (OperateOption)option);
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\uff1a\u201c%s\u201d\u3002", (String)"NoVoucherBillForm_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), billType) + e.getMessage());
            }
            int successCount = Integer.parseInt(this.getPageCache().get("count"));
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u201c%s\u201d\u6761\u3002", (String)"NoVoucherBillForm_9", (String)"fi-ai-formplugin", (Object[])new Object[0]), successCount));
        }
    }

    private String queryBlackTable(DBRoute route, String querySql, String table) {
        try (DataSet ds = DB.queryDataSet((String)"kd.bos.ext.fi.ai.DapVoucherUtil", (DBRoute)route, (String)querySql);){
            for (Row row : ds) {
                if (row.getLong("num") <= 0L) continue;
                String string = table;
                return string;
            }
        }
        return null;
    }
}

