/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.accountref.AccountVersionReplaceParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ai.ComAssistData;
import kd.fi.ai.ComAssistResultDataCol;
import kd.fi.ai.CommonAssistItem;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.util.AiCommonFieldUtils;
import kd.fi.ai.util.SetExpandFieldValueUtil;
import kd.fi.ai.util.TraceSingleVoucherUtil;

public class PreViewFomrPlugin
extends AbstractFormPlugin {
    public static final String PARAM_ENTITYNAME = "entityname";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
    }

    private void preGetComAssistInfo(Long bookId, MainEntityType originalEntityType) {
        DynamicObject bookData = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable.id", (QFilter[])new QFilter("id", "=", (Object)bookId).toArray());
        if (bookData != null) {
            Long accounTableId = bookData.getLong("accounttable.id");
            List comAssist = AiCommonFieldUtils.getComAssist((Long)accounTableId);
            if (comAssist.isEmpty()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"comassist1"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"comassist2"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"comassist1"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"comassist2"});
            } else {
                EntryProp entryProp = (EntryProp)originalEntityType.getProperty("entries");
                DynamicObjectType entryType = entryProp.getDynamicCollectionItemPropertyType();
                HashSet<String> propVisable = new HashSet<String>(2);
                propVisable.add("comassist1");
                propVisable.add("comassist2");
                for (CommonAssistItem cai : comAssist) {
                    int seq = cai.getSeq();
                    if (seq > 2) continue;
                    String key = "comassist" + seq;
                    propVisable.remove(key);
                    BasedataEdit basedata = (BasedataEdit)this.getView().getControl(key);
                    basedata.setCaption(new LocaleString(cai.getComassistname()));
                    String billentityName = cai.getValuesource().toString();
                    if (cai.getValuesourcetype().equals("2")) {
                        billentityName = "bos_assistantdata_detail";
                    }
                    BasedataProp property = (BasedataProp)entryType.getProperty(key);
                    property.setBaseEntityId(billentityName);
                    property.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)billentityName));
                    property.setDisplayName(new LocaleString(cai.getComassistname()));
                }
                if (propVisable.size() > 0) {
                    for (String prop : propVisable) {
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{prop});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{prop});
                    }
                }
            }
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        GLVoucher voucher = (GLVoucher)SerializationUtils.fromJsonString((String)(customParams.get("voucher") + ""), GLVoucher.class);
        MainEntityType originalEntityType = e.getOriginalEntityType();
        this.preGetComAssistInfo(voucher.getBookId(), originalEntityType);
        this.getModel().updateCache();
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        GLVoucher voucher = (GLVoucher)SerializationUtils.fromJsonString((String)(customParams.get("voucher") + ""), GLVoucher.class);
        this.changeAccount(voucher);
        IDataModel model = this.getModel();
        model.setValue("org", (Object)voucher.getOrgId());
        model.setValue("period", (Object)voucher.getPeriodId());
        model.setValue("booktype", (Object)voucher.getBookTypeId());
        model.setValue("vouchertype", (Object)voucher.getVchTypeId());
        model.setValue("bizdate", (Object)voucher.getBizDate());
        model.setValue("bookeddate", (Object)voucher.getBookedDate());
        model.setValue("attachment", (Object)voucher.getAttachment());
        model.setValue("textfield", (Object)voucher.getDescription());
        model.setValue("localbur", (Object)voucher.getLocalcur());
        String templateId = voucher.getTemplateId();
        model.setValue("templateid", (Object)templateId);
        DynamicObject dataEntity = model.getDataEntity(true);
        SetExpandFieldValueUtil.setExpandFieldValue((DynamicObject)dataEntity, (Map)voucher.getExpandFieldValue(), (Long)voucher.getOrgId());
        List voucherentry = voucher.getEntryRows();
        this.genVoucherEntry(dataEntity, voucherentry, voucher.getOrgId());
        this.setEntryVisable(dataEntity.getDynamicObjectCollection("entries"));
        Object vpre = customParams.get("vchtemplateprevoucher");
        if (vpre != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"save"});
        }
        this.setCommonAssistData(voucherentry);
    }

    private void setCommonAssistData(List<GLVoucherEntry> voucherentry) {
        int index = 0;
        for (GLVoucherEntry gl : voucherentry) {
            ComAssistResultDataCol comAssist = gl.getComAssist();
            Object comassist1 = null;
            Object comassist2 = null;
            Set result = comAssist.getResult();
            for (ComAssistData rs : result) {
                String fieldKey;
                switch (fieldKey = rs.getFieldKey()) {
                    case "comassist1": {
                        comassist1 = rs.getResult();
                        break;
                    }
                    case "comassist2": {
                        comassist2 = rs.getResult();
                    }
                }
            }
            this.getModel().setValue("comassist1", comassist1, index);
            this.getModel().setValue("comassist2", comassist2, index);
            ++index;
        }
        this.getView().updateView();
    }

    private void changeAccount(GLVoucher voucher) {
        Long periodId = voucher.getPeriodId();
        HashSet<Long> accountIds = new HashSet<Long>(100);
        DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)periodId, (String)"bd_period");
        List entrys = voucher.getEntryRows();
        for (IVoucherEntry entry : entrys) {
            accountIds.add(entry.getAccountId());
        }
        Map account = BusinessDataServiceHelper.loadFromCache((Object[])accountIds.toArray(), (String)"bd_accountview");
        for (IVoucherEntry entry : voucher.getEntryRows()) {
            this.doChangeAccRef(entry, voucher.getOrgId(), period, voucher.getBookTypeId(), (DynamicObject)account.get(entry.getAccountId()));
        }
    }

    private void doChangeAccRef(IVoucherEntry voucherEntry, long orgid, DynamicObject period, long bookTypeId, DynamicObject account) {
        if (account == null || period == null) {
            return;
        }
        AccountVersionReplaceParam rep = new AccountVersionReplaceParam(orgid, account.getLong("masterid"), 0L, 0L, "", period, bookTypeId, account, voucherEntry.getAssgrpId());
        DynamicObject newAccount = AccountRefUtils.getCurAccountForDap((AccountVersionReplaceParam)rep);
        voucherEntry.setAccountId(newAccount.getLong("id"));
        voucherEntry.setAssgrpId(rep.getAssgrpId());
    }

    private void genVoucherEntry(DynamicObject dataEntity, List<GLVoucherEntry> voucherentry, long orgId) {
        AbstractFormDataModel formModel = (AbstractFormDataModel)this.getModel();
        formModel.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("edescription", new Object[0]);
        vs.addField("account", new Object[0]);
        vs.addField("assgrp", new Object[0]);
        vs.addField("measureunit", new Object[0]);
        vs.addField("quantity", new Object[0]);
        vs.addField("price", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("oriamount", new Object[0]);
        vs.addField("localrate", new Object[0]);
        vs.addField("debitlocal", new Object[0]);
        vs.addField("creditlocal", new Object[0]);
        vs.addField("maincfitem", new Object[0]);
        vs.addField("maincfassgrp", new Object[0]);
        vs.addField("maincfamount", new Object[0]);
        vs.addField("expiredate", new Object[0]);
        vs.addField("businessnum", new Object[0]);
        voucherentry.stream().forEach(dynamic -> {
            BigDecimal amo = dynamic.getOriCredit().compareTo(BigDecimal.ZERO) == 0 ? dynamic.getOriDebit() : dynamic.getOriCredit();
            vs.addRow(new Object[]{dynamic.getDescription(), dynamic.getAccountId(), dynamic.getAssgrpId(), dynamic.getUnitId(), dynamic.getQty(), dynamic.getPrice(), dynamic.getOriCurrencyId(), amo, dynamic.getLocalExchangeRate(), dynamic.getLocalDebit(), dynamic.getLocalCredit(), dynamic.getMaincfitemID(), dynamic.getMaincfassgrp(), dynamic.getMaincfamount(), dynamic.getExpireDate(), dynamic.getBusinessNum()});
            this.setExpandField(dynamic.getExpandFieldValue(), vs, orgId);
        });
        formModel.batchCreateNewEntryRow("entries", vs);
        formModel.endInit();
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{dataEntity}, (IDataEntityType)this.getModel().getDataEntityType());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        if ("save".equals(key)) {
            this.showGenVchTip();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("ai_genvchtip".equals(actionId)) {
            Map map;
            String data = (String)closedCallBackEvent.getReturnData();
            String genResultTip = ResManager.loadKDString((String)"\u91cd\u65b0\u751f\u6210\u51ed\u8bc1\u5df2\u7ed3\u675f\uff0c\u8bf7\u67e5\u770b\u51ed\u8bc1\u751f\u6210\u62a5\u544a\u786e\u8ba4\u662f\u5426\u6210\u529f\u3002", (String)"PreViewFomrPlugin_2", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            boolean isSuccess = false;
            if (StringUtils.isNotBlank((CharSequence)data) && (map = (Map)SerializationUtils.fromJsonString((String)data, Map.class)) != null) {
                String opResultStr = (String)map.get("OperationResult");
                String billIdStr = (String)map.get("billids");
                if (StringUtils.isNotEmpty((CharSequence)opResultStr) && StringUtils.isNotEmpty((CharSequence)billIdStr)) {
                    OperationResult opResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)opResultStr, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
                    List billIds = (List)SerializationUtils.fromJsonString((String)billIdStr, List.class);
                    if (opResult != null && opResult.isSuccess() && billIds != null && !billIds.isEmpty()) {
                        String entityName = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_ENTITYNAME);
                        Set<Long> voucherIds = this.getVoucherIds(billIds, entityName);
                        if (!voucherIds.isEmpty()) {
                            isSuccess = true;
                            this.showVoucher(voucherIds);
                        }
                    } else {
                        String errorMsg = (String)map.get("error");
                        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                            genResultTip = errorMsg;
                        } else if (opResult != null) {
                            genResultTip = this.collectErrorResult(opResult);
                        }
                    }
                }
            }
            if (!isSuccess) {
                this.getView().showTipNotification(genResultTip);
            }
        }
    }

    private void showGenVchTip() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object billId = customParams.get("billId");
        String isevent = (String)customParams.get("isevent");
        Set billIds = (Set)SerializationUtils.fromJsonString((String)((String)billId), Set.class);
        String entityName = customParams.get(PARAM_ENTITYNAME) + "";
        Object tempId = customParams.get("tempId");
        OperateOption create = OperateOption.create();
        HashMap map = new HashMap();
        ArrayList ids = new ArrayList();
        ids.add(tempId);
        Object id = billIds.iterator().next();
        map.put(id, ids);
        create.setVariableValue("tempId", SerializationUtils.toJsonString(map));
        String originEntityName = entityName;
        if (Boolean.parseBoolean(isevent)) {
            originEntityName = "ai_event";
        }
        if (entityName.startsWith("fah_e_")) {
            originEntityName = "ai_event";
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("ai_genvchtip");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.getCustomParams().put("ids", SerializationUtils.toJsonString((Object)billIds));
        param.getCustomParams().put("option", SerializationUtils.toJsonString((Object)create.getVariables()));
        param.getCustomParams().put("entityid", originEntityName);
        param.getCustomParams().put("pageid", this.getView().getPageId());
        param.getCustomParams().put("operateKey", "generatevoucher");
        param.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "ai_genvchtip"));
        this.getView().showForm(param);
    }

    private String collectErrorResult(OperationResult opResult) {
        if (opResult == null || opResult.isSuccess()) {
            return "";
        }
        StringBuilder errorCol = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)opResult.getMessage())) {
            errorCol.append(opResult.getMessage());
        } else {
            List errorInfos = opResult.getAllErrorInfo();
            int i = 0;
            for (OperateErrorInfo errorInfo : errorInfos) {
                if (StringUtils.isNotBlank((CharSequence)errorInfo.getMessage())) {
                    if (errorInfo.getMessage().endsWith("\u3002") || errorInfo.getMessage().endsWith(",")) {
                        errorCol.append(errorInfo.getMessage());
                    } else if (i == errorInfos.size() - 1) {
                        errorCol.append(errorInfo.getMessage()).append("\u3002");
                    } else {
                        errorCol.append(errorInfo.getMessage()).append(",");
                    }
                }
                ++i;
            }
        }
        return errorCol.toString();
    }

    private String getErrorMsg(String entityName, Set<Long> billIds, String isevent) {
        String msg = null;
        if (billIds.size() == 1 && !Boolean.parseBoolean(isevent)) {
            DynamicObject bill;
            String sta;
            boolean exists = QueryServiceHelper.exists((String)entityName, (Object)billIds.toArray()[0]);
            if (!exists) {
                msg = ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002", (String)"PreViewFomrPlugin_0", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            }
            List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityName);
            String status = "C";
            for (Map map : dataEntityOperate) {
                if (!"audit".equals(map.get("type")) || !(map.get("parameter") instanceof Map)) continue;
                Map m = (Map)map.get("parameter");
                status = (String)m.get("value");
                break;
            }
            if ((sta = (bill = BusinessDataServiceHelper.loadSingle((Object)billIds.iterator().next(), (String)entityName, (String)"id,billstatus")).getString("billstatus")) != null && sta.length() > 0 && (sta.charAt(0) < status.charAt(0) ? sta.charAt(0) < 'C' : sta.charAt(0) < status.charAt(0))) {
                msg = ResManager.loadKDString((String)"\u8bf7\u5ba1\u6838\u5355\u636e\u3002", (String)"PreViewFomrPlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            }
        }
        return msg;
    }

    private Set<Long> getVoucherIds(List<Object> successIds, String entityName) {
        HashSet<Long> set = new HashSet<Long>(100);
        QFilter[] qFilters = new QFilter[]{new QFilter("billtype.id", "=", (Object)entityName), new QFilter("sourcebillid", "in", successIds)};
        String algoKey = "kd.fi.ai.formplugin.PreViewFomrPlugin.getVoucherIds";
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ai_daptracker", (String)"voucherid", (QFilter[])qFilters, null);){
            for (Row row : dataset) {
                set.add(row.getLong("voucherid"));
            }
        }
        return set;
    }

    private void showVoucher(Set<Long> voucherids) {
        if (voucherids.size() == 1) {
            long billId = voucherids.iterator().next();
            long orgId = 0L;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"TraceVoucher_queryvoucher", (String)"gl_voucher", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)}, null);){
                for (Row row : ds) {
                    orgId = row.getLong("org");
                }
            }
            TraceSingleVoucherUtil.showVoucher((Long)billId, (Long)orgId, (IFormView)this.getView());
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("gl_voucher");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            for (Long pkid : voucherids) {
                showParameter.addLinkQueryPkId((Object)pkid);
            }
            showParameter.getCustomParams().put("org", "");
            showParameter.getCustomParams().put("booktype", "");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void setEntryVisable(DynamicObjectCollection voucherentry) {
        boolean isQty = false;
        boolean isCash = false;
        boolean currency = false;
        boolean isaccheck = false;
        DynamicObject account = null;
        for (DynamicObject entry : voucherentry) {
            if (isQty && isCash && currency && isaccheck) break;
            account = entry.getDynamicObject("account");
            if (account == null) {
                return;
            }
            if (!isQty && account.getBoolean("isqty")) {
                isQty = true;
            }
            if (!isCash && (account.getBoolean("iscash") || account.getBoolean("isbank") || account.getBoolean("iscashequivalent"))) {
                isCash = true;
            }
            if (!currency && !"nocurrency".equals(account.getString("acctcurrency"))) {
                currency = true;
            }
            if (isaccheck || !account.getBoolean("accheck")) continue;
            isaccheck = true;
        }
        this.getView().setVisible(Boolean.valueOf(isQty), new String[]{"measureunit", "quantity", "price"});
        this.getView().setVisible(Boolean.valueOf(isCash), new String[]{"maincfitem", "maincfassgrp", "maincfamount"});
        this.getView().setVisible(Boolean.valueOf(currency), new String[]{"localrate", "currency", "oriamount"});
        this.getView().setVisible(Boolean.valueOf(isaccheck), new String[]{"expiredate", "businessnum"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"suppcfitem", "suppcfamount"});
    }

    private void setExpandField(Map<String, Object> expandFieldValue, TableValueSetter vs, long orgId) {
        MainEntityType voucherType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection propertys1 = voucherType.getProperties();
        EntryProp entryProp = (EntryProp)propertys1.get((Object)"entries");
        DataEntityPropertyCollection propertys = entryProp._collectionItemPropertyType.getProperties();
        for (Map.Entry<String, Object> entry : expandFieldValue.entrySet()) {
            String fieldKey = entry.getKey();
            if (!propertys.containsKey((Object)fieldKey)) continue;
            IDataEntityProperty prop = (IDataEntityProperty)propertys.get((Object)fieldKey);
            Class type = prop.getPropertyType();
            Object value = entry.getValue();
            if (type.equals(DynamicObject.class)) {
                if (value instanceof String) {
                    BasedataProp baseProp = (BasedataProp)prop;
                    String entityId = baseProp.getBaseEntityId();
                    String numberProp = baseProp.getNumberProp();
                    ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
                    QFilter numberFilter = new QFilter(numberProp, "=", value);
                    filterList.add(numberFilter);
                    QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId);
                    if (orgFilter != null) {
                        filterList.add(orgFilter);
                    }
                    List id = QueryServiceHelper.queryPrimaryKeys((String)entityId, (QFilter[])filterList.toArray(new QFilter[0]), (String)numberProp, (int)1);
                    vs.addField(fieldKey, new Object[]{id.isEmpty() ? null : id.get(0)});
                    continue;
                }
                vs.addField(fieldKey, new Object[]{value});
                continue;
            }
            if (type.equals(Date.class)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date date = null;
                if (value instanceof String) {
                    try {
                        date = sdf.parse(value + "");
                    }
                    catch (ParseException e) {
                        throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                    }
                } else {
                    date = value instanceof Long ? new Date((Long)value) : (Date)value;
                }
                if (date != null) {
                    try {
                        date = sdf.parse(sdf.format(date));
                    }
                    catch (ParseException e) {
                        throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                    }
                }
                vs.addField(fieldKey, new Object[]{date});
                continue;
            }
            vs.addField(fieldKey, new Object[]{value});
        }
    }
}

