/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplAgrs;
import kd.fi.ai.VchTplAgrss;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.cache.CacheBuildTree;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.CreateFormList;
import kd.fi.ai.util.EntityFieldUtil;

public class VchAsstSetEdit
extends AbstractFormPlugin {
    public static final String FormId_VchAsstSet = "ai_asstset";
    public static final String CacheKey_VchAsstJson = "asstJson";
    private static String Key_VchAsstEntry = "vchasstentry";
    private static String Key_Asst = "asst";
    private static String Key_AsstId = "asstid";
    private static String Key_AsstNumber = "asstnumber";
    private static String Key_FFilterDescription = "ffilterdescription";
    private static String Key_FFilter = "ffilter";
    private static String Key_btnOK = "btnok";
    private static String Key_btnCancel = "btncancel";
    private static final String NON_FIELDS = "nonFields";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel, Key_FFilterDescription});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_Asst});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        CacheBuildTree.setPageCacheByType((FormShowParameter)this.getView().getFormShowParameter(), (IPageCache)this.getPageCache());
        this.getPageCache().put("booktype", this.getView().getFormShowParameter().getCustomParam("booktype") + "");
        this.getPageCache().put("orgid", this.getView().getFormShowParameter().getCustomParam("orgid") + "");
        String index = this.getView().getFormShowParameter().getCustomParam("index") + "";
        String str = (String)this.getView().getFormShowParameter().getCustomParam(CacheKey_VchAsstJson + index);
        if (!StringUtils.isEmpty((CharSequence)str)) {
            VchTplAgrss vchTplAgrss = (VchTplAgrss)SerializationUtils.fromJsonString((String)str, VchTplAgrss.class);
            this.setVchGroupSet(vchTplAgrss);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String cacheValue;
            String entitynumber;
            String currentFormId;
            VchTplAgrss vchTplAgrss = this.getVchGroupSet();
            VchReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)vchTplAgrss, (String)(currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key")), (String)(entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber")), (String)(cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView())));
            if (returnData.isStatus()) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
                this.getView().close();
            } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
                this.getView().showTipNotification(returnData.getMessage());
            }
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        } else if (Key_FFilterDescription.equalsIgnoreCase(ctlSource.getKey())) {
            this.showConditionForm();
        } else if (Key_Asst.equalsIgnoreCase(ctlSource.getKey())) {
            this.showBaseDataList();
        }
    }

    private void showBaseDataList() {
        FormShowParameter showParameter;
        String assttypeid = this.getView().getFormShowParameter().getCustomParams().get("assttype") + "";
        DynamicObject assttype = BusinessDataServiceHelper.loadSingle((Object)assttypeid, (String)"bd_asstacttype");
        String valueType = assttype.getString("valuetype");
        if ("1".equals(valueType)) {
            String srcEntityNumber = assttype.getString("valuesource.number");
            this.getPageCache().put("srcEntityNumber", srcEntityNumber);
            if (StringUtils.isBlank((CharSequence)srcEntityNumber)) {
                return;
            }
            showParameter = CreateFormList.createShowListForm((String)srcEntityNumber, (IPageCache)this.getPageCache());
        } else if ("2".equals(valueType)) {
            showParameter = CreateFormList.createShowListForm((String)"bos_assistantdata_detail", (IPageCache)this.getPageCache());
            ListShowParameter listShowParameter = (ListShowParameter)showParameter;
            ListFilterParameter filterParam = new ListFilterParameter();
            filterParam.setFilter(new QFilter("group", "=", (Object)assttype.getLong("assistanttype.id")));
            listShowParameter.setListFilterParameter(filterParam);
            listShowParameter.setCaption(assttype.getString("assistanttype.name"));
        } else {
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, Key_Asst);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Key_FFilterDescription.equalsIgnoreCase(actionId)) {
            if (closedCallBackEvent.getReturnData() != null) {
                String returnStr = (String)closedCallBackEvent.getReturnData();
                VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)returnStr, VchReturnData.class);
                this.receiveFilter(retData.getDataStr());
            }
        } else if (Key_Asst.equalsIgnoreCase(actionId) && closedCallBackEvent.getReturnData() != null) {
            DynamicObject one;
            String srcEntityNumber;
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows == null || rows.size() == 0) {
                return;
            }
            int subindex = this.getModel().getEntryCurrentRowIndex(Key_VchAsstEntry);
            this.getModel().setValue(Key_AsstId, (Object)rows.get(0).getPrimaryKeyValue().toString(), subindex);
            this.getModel().setValue(Key_AsstNumber, (Object)rows.get(0).getNumber(), subindex);
            this.getModel().setValue(Key_Asst, (Object)rows.get(0).getName(), subindex);
            if (StringUtils.isEmpty((CharSequence)rows.get(0).getNumber()) && StringUtils.isNotEmpty((CharSequence)(srcEntityNumber = this.getPageCache().get("srcEntityNumber"))) && (one = BusinessDataServiceHelper.loadSingle((Object)rows.get(0).getPrimaryKeyValue().toString(), (String)srcEntityNumber)) != null) {
                this.getModel().setValue(Key_AsstNumber, (Object)one.getString("number"), subindex);
                this.getModel().setValue(Key_Asst, (Object)one.getString("name"), subindex);
            }
        }
    }

    private void setVchGroupSet(VchTplAgrss vchTplAgrss) {
        int rowCount = this.getModel().getEntryRowCount(Key_VchAsstEntry);
        if (rowCount < vchTplAgrss.getItems().size()) {
            this.getModel().batchCreateNewEntryRow(Key_VchAsstEntry, vchTplAgrss.getItems().size() - rowCount);
        }
        MainEntityType mainEntityType = this.getMainEntityType();
        for (int i = 0; i < vchTplAgrss.getItems().size(); ++i) {
            VchTplAgrs vchTplAgrs = (VchTplAgrs)vchTplAgrss.getItems().get(i);
            VchTplExpression filterObj = vchTplAgrs.getFilterSet();
            this.getModel().setValue(Key_Asst, (Object)vchTplAgrs.getAsstName(), i);
            this.getModel().setValue(Key_AsstId, (Object)vchTplAgrs.getAsstid(), i);
            this.getModel().setValue(Key_AsstNumber, (Object)vchTplAgrs.getAsstNumber(), i);
            this.getModel().setValue(Key_FFilter, (Object)SerializationUtils.toJsonString((Object)filterObj), i);
            String dsp = BuildTree.multiLangDesc((String)filterObj.getDescription().toString(), (String)filterObj.getExprTran(), () -> BuildTree.tranVchTplFormula((CRCondition)filterObj, (MainEntityType)mainEntityType));
            if (StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(Key_FFilterDescription, (Object)dsp, i);
        }
    }

    private VchTplAgrss getVchGroupSet() {
        VchTplAgrss vchTplAgrss = new VchTplAgrss();
        int rowCount = this.getModel().getEntryRowCount(Key_VchAsstEntry);
        for (int row = 0; row < rowCount; ++row) {
            String asstidStr;
            VchTplAgrs vchTplAgrs = new VchTplAgrs();
            String filter = (String)this.getModel().getValue(Key_FFilter, row);
            if (!StringUtils.isBlank((CharSequence)filter)) {
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filter, VchTplExpression.class);
                vchTplAgrs.setFilterSet(filterObj);
            }
            if (StringUtils.isEmpty((CharSequence)(asstidStr = this.getModel().getValue(Key_AsstId, row) + ""))) continue;
            vchTplAgrs.setAsstid(asstidStr);
            String asstName = this.getModel().getValue(Key_Asst, row) + "";
            String asstNumber = this.getModel().getValue(Key_AsstNumber, row) + "";
            vchTplAgrs.setAsstName(asstName);
            vchTplAgrs.setAsstNumber(asstNumber);
            vchTplAgrss.getItems().add(vchTplAgrs);
        }
        return vchTplAgrss;
    }

    private void showConditionForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_condition");
        int row = this.getModel().getEntryCurrentRowIndex(Key_VchAsstEntry);
        String conditionJson = (String)this.getModel().getValue(Key_FFilter, row);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", this.getView().getFormShowParameter().getCustomParam("billEntityNumber"));
        showParameter.getCustomParams().put("treenodes", this.getView().getFormShowParameter().getCustomParam("treenodes"));
        showParameter.setCustomParam("ai_button_key", this.getView().getFormShowParameter().getCustomParam("ai_button_key"));
        showParameter.setCustomParam("ai_vchtemplatecachekey", this.getView().getFormShowParameter().getCustomParam("ai_vchtemplatecachekey"));
        boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        showParameter.getCustomParams().put("isevent", isEvent);
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get((String)(isEvent ? "event" : "type"));
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        CacheBuildTree.setBuildByType((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, Key_FFilterDescription));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveFilter(String filterJson) {
        int row = this.getModel().getEntryCurrentRowIndex(Key_VchAsstEntry);
        if (StringUtils.isBlank((CharSequence)filterJson)) {
            this.getModel().setValue(Key_FFilter, (Object)"", row);
            this.getModel().setValue(Key_FFilterDescription, (Object)"", row);
        } else {
            VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filterJson, VchTplExpression.class);
            this.getModel().setValue(Key_FFilter, (Object)filterJson, row);
            String dsp = filterObj.getDescription().toString();
            if (StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(Key_FFilterDescription, (Object)dsp, row);
        }
    }

    private MainEntityType getMainEntityType() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber");
        Boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        return BuildTree.getMainEntityType((String)sourceBill, (boolean)(isEvent != null ? isEvent : false));
    }
}

