/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplCashflow;
import kd.fi.ai.VchTplCashflowConst;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.DateUtil;
import kd.fi.ai.util.EntityFieldUtil;

public class VchCashflowSetEdit
extends AbstractFormPlugin {
    public static final String FormId_VchCashSet = "ai_cashflowconst";
    private static String Key_btnOK = "btnok";
    private static String Key_btnCancel = "btncancel";
    private static String Key_VchGrpEntry = "entryentity";
    private static String Key_FFilterDescription = "ffilterdescription";
    private static String Key_FFilter = "ffilter";
    private static String Key_CashFlow = "cashflow";
    private static String CASHFLOWCAHCE = "cashflowcache";
    private static final String PROPERTY_END_DATE = "enddate";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String strObj = (String)customParams.get("vchcashflowset");
        if (StringUtils.isNotBlank((CharSequence)strObj)) {
            VchTplCashflow cashflow = (VchTplCashflow)SerializationUtils.fromJsonString((String)strObj, VchTplCashflow.class);
            this.setVchCashflow(cashflow);
            this.getPageCache().put(CASHFLOWCAHCE, strObj);
        }
        BasedataEdit cashFlowBD = (BasedataEdit)this.getControl(Key_CashFlow);
        QFilter endDateFilter = new QFilter(PROPERTY_END_DATE, "=", (Object)DateUtil.getEndDate());
        cashFlowBD.setQFilter(endDateFilter);
    }

    private void setVchCashflow(VchTplCashflow cashflow) {
        int rowCount = this.getModel().getEntryRowCount(Key_VchGrpEntry);
        if (rowCount < cashflow.getVchFixData().size()) {
            this.getModel().batchCreateNewEntryRow(Key_VchGrpEntry, cashflow.getVchFixData().size() - rowCount);
        }
        MainEntityType mainEntityType = this.getMainEntityType();
        for (int i = 0; i < cashflow.getVchFixData().size(); ++i) {
            VchTplCashflowConst vchTplCashflowConst = (VchTplCashflowConst)cashflow.getVchFixData().get(i);
            VchTplExpression filterObj = vchTplCashflowConst.getFilterSet();
            this.getModel().setValue(Key_CashFlow, (Object)vchTplCashflowConst.getCashflowConstId(), i);
            this.getModel().setValue(Key_FFilter, (Object)SerializationUtils.toJsonString((Object)filterObj), i);
            String dsp = BuildTree.multiLangDesc((String)filterObj.getDescription().toString(), (String)filterObj.getExprTran(), () -> BuildTree.tranVchTplFormula((CRCondition)filterObj, (MainEntityType)mainEntityType));
            if (StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(Key_FFilterDescription, (Object)dsp, i);
        }
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_FFilterDescription, Key_btnOK, Key_btnCancel});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_FFilterDescription.equals(ctlSource.getKey())) {
            this.showConditionForm();
        } else if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            VchTplCashflow vchTplCashflow = this.getVchGroupSet();
            if (vchTplCashflow != null) {
                String cacheValue;
                String entitynumber;
                String currentFormId;
                VchReturnData returnData;
                if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get(CASHFLOWCAHCE))) {
                    String strObj = this.getPageCache().get(CASHFLOWCAHCE);
                    VchTplCashflow cashflow = (VchTplCashflow)SerializationUtils.fromJsonString((String)strObj, VchTplCashflow.class);
                    vchTplCashflow.setVchFixSuppcfData(cashflow.getVchFixSuppcfData());
                    vchTplCashflow.setNewsuppcfitemdesc(cashflow.getNewsuppcfitemdesc());
                }
                if ((returnData = EntityFieldUtil.validateDiffEntry((Object)vchTplCashflow, (String)(currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key")), (String)(entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber")), (String)(cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView())))).isStatus()) {
                    this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
                    this.getView().close();
                } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
                    this.getView().showTipNotification(returnData.getMessage());
                }
            }
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    private void showConditionForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_condition");
        int row = this.getModel().getEntryCurrentRowIndex(Key_VchGrpEntry);
        String conditionJson = (String)this.getModel().getValue(Key_FFilter, row);
        showParameter.getCustomParams().put("formula", conditionJson);
        boolean isevent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        String billNumber = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber");
        showParameter.getCustomParams().put("isevent", isevent);
        showParameter.getCustomParams().put("event", isevent ? "true" : "");
        showParameter.getCustomParams().put("entitynumber", billNumber);
        showParameter.getCustomParams().put("build", billNumber);
        showParameter.getCustomParams().put("treenodes", this.getView().getFormShowParameter().getCustomParam("treenodes"));
        showParameter.setCustomParam("ai_button_key", this.getView().getFormShowParameter().getCustomParam("ai_button_key"));
        showParameter.setCustomParam("ai_vchtemplatecachekey", this.getView().getFormShowParameter().getCustomParam("ai_vchtemplatecachekey"));
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get((String)(isevent ? "event" : "type"));
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, Key_FFilterDescription));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Key_FFilterDescription.equalsIgnoreCase(actionId) && closedCallBackEvent.getReturnData() != null) {
            String returnStr = (String)closedCallBackEvent.getReturnData();
            VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)returnStr, VchReturnData.class);
            this.receiveFilter(retData.getDataStr());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData data = e.getChangeSet()[0];
        String propName = e.getProperty().getName();
        int currentRow = data.getRowIndex();
        if (Key_FFilterDescription.equals(propName) && StringUtils.isBlank((Object)this.getModel().getValue(Key_FFilterDescription, currentRow))) {
            this.getModel().setValue(Key_FFilter, null, currentRow);
        }
    }

    private void receiveFilter(String filterJson) {
        int row = this.getModel().getEntryCurrentRowIndex(Key_VchGrpEntry);
        if (StringUtils.isBlank((CharSequence)filterJson)) {
            this.getModel().setValue(Key_FFilter, (Object)"", row);
            this.getModel().setValue(Key_FFilterDescription, (Object)"", row);
        } else {
            VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filterJson, VchTplExpression.class);
            this.getModel().setValue(Key_FFilter, (Object)filterJson, row);
            String dsp = filterObj.getDescription().toString();
            if (StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(Key_FFilterDescription, (Object)dsp, row);
        }
    }

    private VchTplCashflow getVchGroupSet() {
        VchTplCashflow vchTplCashflow = new VchTplCashflow();
        int rowCount = this.getModel().getEntryRowCount(Key_VchGrpEntry);
        StringBuilder sBuilder = new StringBuilder();
        for (int row = 0; row < rowCount; ++row) {
            VchTplCashflowConst VchTplCashflowConst2 = new VchTplCashflowConst();
            String filter = (String)this.getModel().getValue(Key_FFilter, row);
            if (!StringUtils.isBlank((CharSequence)filter)) {
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filter, VchTplExpression.class);
                VchTplCashflowConst2.setFilterSet(filterObj);
            }
            if (this.getModel().getValue(Key_CashFlow, row) != null) {
                Long accountid = ((DynamicObject)this.getModel().getValue(Key_CashFlow, row)).getLong("id");
                VchTplCashflowConst2.setCashflowConstId(accountid.longValue());
                String accountName = ((DynamicObject)this.getModel().getValue(Key_CashFlow, row)).getString("fullname");
                VchTplCashflowConst2.setCashflowConstName(accountName);
                String accountNumber = ((DynamicObject)this.getModel().getValue(Key_CashFlow, row)).getString("number");
                VchTplCashflowConst2.setCashflowConstNumber(accountNumber);
                if (row > 0) {
                    sBuilder.append('/');
                }
                sBuilder.append(accountNumber).append(accountName);
            }
            vchTplCashflow.getVchFixData().add(VchTplCashflowConst2);
        }
        vchTplCashflow.setNewconstdesc(sBuilder.toString());
        return vchTplCashflow;
    }

    private MainEntityType getMainEntityType() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber");
        Boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        return BuildTree.getMainEntityType((String)sourceBill, (boolean)(isEvent != null ? isEvent : false));
    }
}

