/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplCreator;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.cache.CacheBuildTree;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityFieldUtil;
import kd.fi.ai.util.EntityTreeUtil;

public class VchCreatorEdit
extends AbstractFormPlugin {
    public static final String FORMID = "ai_vchcreatorset";
    private static final String NON_FIELDS = "nonFields";
    public static final String CacheKey_VchCreatorJson = "vchcreatorset";
    private static final String FIELD_SOURCETYPE = "sourcetype";
    private static final String KEY_FIELDEXP = "fieldexp";
    private static final String KEY_FIELDEXPDESC = "fieldexpdesc";
    private static final String FIELD_CONST = "creatorconst";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    public static final String ISHEAD = "isHead";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL, KEY_FIELDEXPDESC});
    }

    public void afterCreateNewData(EventObject e) {
        String str;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber");
        boolean isevent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        MainEntityType srcMainEntityType = null;
        if (StringUtils.isNotBlank((CharSequence)sourceBill)) {
            srcMainEntityType = isevent ? AiEventMetaUtil.getEntityType((Object)Long.valueOf(sourceBill)) : EntityMetadataCache.getDataEntityType((String)sourceBill);
            boolean isHead = (Boolean)this.getView().getFormShowParameter().getCustomParam(ISHEAD);
            this.fillExprFields(srcMainEntityType, KEY_FIELDEXPDESC, isHead, null);
        }
        if (StringUtils.isNotBlank((CharSequence)(str = (String)customParams.get(CacheKey_VchCreatorJson)))) {
            VchTplCreator vchTplCreator = (VchTplCreator)SerializationUtils.fromJsonString((String)str, VchTplCreator.class);
            this.setVchTplCreator(vchTplCreator, srcMainEntityType);
        } else {
            this.getModel().setValue(FIELD_SOURCETYPE, (Object)"fix");
        }
        CacheBuildTree.setPageCache((FormShowParameter)this.getView().getFormShowParameter(), (IPageCache)this.getPageCache());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData data = e.getChangeSet()[0];
        String propName = e.getProperty().getName();
        if (KEY_FIELDEXPDESC.equals(propName) && StringUtils.isBlank((Object)data.getNewValue())) {
            this.getModel().setValue(KEY_FIELDEXP, (Object)"");
            this.getModel().setValue(KEY_FIELDEXPDESC, (Object)"");
        }
    }

    private void fillExprFields(MainEntityType srcMainET, String cacheKey, boolean isHead, Class<?> fieldType) {
        if (srcMainET == null) {
            this.getPageCache().put(cacheKey, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)srcMainET);
            option.setReadEntryEntity(!isHead);
            option.setExprType(ExpressionType.Formula);
            option.setFieldType(fieldType);
            option.setIncludeID(true);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            this.getPageCache().put(NON_FIELDS + cacheKey, SerializationUtils.toJsonString((Object)result.getNonFields()));
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put(cacheKey, toJson);
        }
    }

    private void setVchTplCreator(VchTplCreator vchTplCreator, MainEntityType mainEntityType) {
        IDataModel model = this.getModel();
        model.setValue(FIELD_SOURCETYPE, (Object)(vchTplCreator.getSourcetype() == null ? "fix" : vchTplCreator.getSourcetype()));
        model.setValue(FIELD_CONST, (Object)vchTplCreator.getConstid());
        VchTplExpression expression = vchTplCreator.getFieldExp();
        if (expression != null) {
            String desp = expression.getExpression();
            desp = mainEntityType != null ? BuildTree.multiLangDesc((String)expression.getDescription().toString(), (String)expression.getExprTran(), () -> BuildTree.tranVchTplFormula((CRCondition)expression, (MainEntityType)mainEntityType)) : "";
            String json = SerializationUtils.toJsonString((Object)expression);
            model.setValue(KEY_FIELDEXP, (Object)json);
            model.setValue(KEY_FIELDEXPDESC, (Object)desp);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "fieldexpdesc": {
                this.showFormulaForm();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnok": {
                this.returnData();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (KEY_FIELDEXPDESC.equalsIgnoreCase(actionId)) {
            this.receiveExpressionSet(closedCallBackEvent);
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(KEY_FIELDEXP, (Object)"");
                this.getModel().setValue(KEY_FIELDEXPDESC, (Object)"");
            } else {
                VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)str, VchReturnData.class);
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)retData.getDataStr(), VchTplExpression.class);
                this.getModel().setValue(KEY_FIELDEXP, (Object)retData.getDataStr());
                String desp = filterObj.getDescription().toString();
                if (StringUtils.isEmpty((CharSequence)desp)) {
                    desp = filterObj.getExprTran();
                }
                this.getModel().setValue(KEY_FIELDEXPDESC, (Object)desp);
            }
        }
    }

    private void showFormulaForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_formula");
        String expression = (String)this.getModel().getValue(KEY_FIELDEXP);
        showParameter.getCustomParams().put("formula", expression);
        showParameter.getCustomParams().put("treenodes", this.getPageCache().get(KEY_FIELDEXPDESC));
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get("nonFieldsfieldexpdesc"));
        boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        showParameter.getCustomParams().put("isevent", isEvent);
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber");
        showParameter.getCustomParams().put("entitynumber", sourceBill);
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get((String)(isEvent ? "event" : "type"));
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCustomParam("ai_vchtemplatecachekey", (Object)EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView()));
        showParameter.setCustomParam("ai_button_key", (Object)"ai_expression-fieldexpdesc");
        this.getPageCache().put("srcMainEntityType", "VchCreatorEdit");
        CacheBuildTree.setBuild((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_FIELDEXPDESC));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void returnData() {
        VchTplCreator vchTplCreator = this.getVchTplCreator();
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)vchTplCreator));
        this.getView().close();
    }

    private VchTplCreator getVchTplCreator() {
        String fieldExp;
        VchTplCreator vchTplCreator = new VchTplCreator();
        IDataModel model = this.getModel();
        String sourceType = model.getValue(FIELD_SOURCETYPE).toString();
        vchTplCreator.setSourcetype(sourceType);
        DynamicObject constcf = (DynamicObject)model.getValue(FIELD_CONST);
        if ("fix".equalsIgnoreCase(sourceType) && constcf != null) {
            vchTplCreator.setConstid(constcf.getLong("id"));
            vchTplCreator.setDescription(constcf.getString("number") + " " + constcf.getString("name"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(fieldExp = (String)model.getValue(KEY_FIELDEXP)))) {
            VchTplExpression fieldExpObj = (VchTplExpression)SerializationUtils.fromJsonString((String)fieldExp, VchTplExpression.class);
            vchTplCreator.setFieldExp(fieldExpObj);
        }
        return vchTplCreator;
    }
}

