/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplDc;
import kd.fi.ai.VchTplDcs;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.cache.CacheBuildTree;
import kd.fi.ai.enums.DebitCreditEnum;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.EntityFieldUtil;

public class VchDcSetEdit
extends AbstractFormPlugin {
    public static final String FormId_VchDcSet = "ai_dcset";
    public static final String CacheKey_VchDcJson = "vchdcset";
    private static String Key_VchGrpEntry = "vchgrpentry";
    private static String Key_Dc = "dc";
    private static String Key_FFilterDescription = "ffilterdescription";
    private static String Key_FFilter = "ffilter";
    private static String Key_btnOK = "btnok";
    private static String Key_btnCancel = "btncancel";
    private static final String NON_FIELDS = "nonFields";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel, Key_FFilterDescription});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        CacheBuildTree.setPageCache((FormShowParameter)this.getView().getFormShowParameter(), (IPageCache)this.getPageCache());
        String str = (String)this.getView().getFormShowParameter().getCustomParam(CacheKey_VchDcJson);
        if (!StringUtils.isBlank((CharSequence)str)) {
            VchTplDcs vchTempGrps = (VchTplDcs)SerializationUtils.fromJsonString((String)str, VchTplDcs.class);
            this.setVchGroupSet(vchTempGrps);
        }
    }

    public void click(EventObject evt) {
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String cacheValue;
            String entitynumber;
            String currentFormId;
            VchTplDcs vchTempGrps = this.getVchGroupSet();
            VchReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)vchTempGrps, (String)(currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key")), (String)(entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber")), (String)(cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView())));
            if (returnData.isStatus()) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
                this.getView().close();
            } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
                this.getView().showTipNotification(returnData.getMessage());
            }
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        } else if (Key_FFilterDescription.equalsIgnoreCase(ctlSource.getKey())) {
            this.showConditionForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Key_FFilterDescription.equalsIgnoreCase(actionId) && closedCallBackEvent.getReturnData() != null) {
            String returnStr = (String)closedCallBackEvent.getReturnData();
            VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)returnStr, VchReturnData.class);
            this.receiveFilter(retData.getDataStr());
        }
    }

    private void setVchGroupSet(VchTplDcs vchTempGrps) {
        int rowCount = this.getModel().getEntryRowCount(Key_VchGrpEntry);
        if (rowCount < vchTempGrps.getItems().size()) {
            this.getModel().batchCreateNewEntryRow(Key_VchGrpEntry, vchTempGrps.getItems().size() - rowCount);
        }
        MainEntityType mainEntityType = this.getMainEntityType();
        for (int i = 0; i < vchTempGrps.getItems().size(); ++i) {
            VchTplDc vchTempGrp = (VchTplDc)vchTempGrps.getItems().get(i);
            VchTplExpression filterObj = vchTempGrp.getFilterSet();
            this.getModel().setValue(Key_Dc, (Object)vchTempGrp.getDc(), i);
            this.getModel().setValue(Key_FFilter, (Object)SerializationUtils.toJsonString((Object)filterObj), i);
            String dsp = BuildTree.multiLangDesc((String)filterObj.getDescription().toString(), (String)filterObj.getExprTran(), () -> BuildTree.tranVchTplFormula((CRCondition)filterObj, (MainEntityType)mainEntityType));
            if (StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(Key_FFilterDescription, (Object)dsp, i);
        }
    }

    private VchTplDcs getVchGroupSet() {
        VchTplDcs vchTempGrps = new VchTplDcs();
        int rowCount = this.getModel().getEntryRowCount(Key_VchGrpEntry);
        for (int row = 0; row < rowCount; ++row) {
            String dc;
            VchTplDc vchTempGrp = new VchTplDc();
            String filter = (String)this.getModel().getValue(Key_FFilter, row);
            if (!StringUtils.isBlank((CharSequence)filter)) {
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filter, VchTplExpression.class);
                vchTempGrp.setFilterSet(filterObj);
            }
            if (StringUtils.isNotEmpty((CharSequence)(dc = (String)this.getModel().getValue(Key_Dc, row)))) {
                vchTempGrp.setDc(dc);
                vchTempGrp.setDcName(DebitCreditEnum.parseByValue((String)dc).getDescription());
            }
            vchTempGrps.getItems().add(vchTempGrp);
        }
        return vchTempGrps;
    }

    private void showConditionForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_condition");
        int row = this.getModel().getEntryCurrentRowIndex(Key_VchGrpEntry);
        String conditionJson = (String)this.getModel().getValue(Key_FFilter, row);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", this.getView().getFormShowParameter().getCustomParam("billEntityNumber"));
        showParameter.getCustomParams().put("treenodes", this.getView().getFormShowParameter().getCustomParam("treenodes"));
        showParameter.setCustomParam("ai_vchtemplatecachekey", (Object)EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView()));
        boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        showParameter.getCustomParams().put("isevent", isEvent);
        showParameter.setCustomParam("ai_button_key", (Object)"ai_dcset-fdcdesc");
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get((String)(isEvent ? "event" : "type"));
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        CacheBuildTree.setBuild((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, Key_FFilterDescription));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveFilter(String filterJson) {
        int row = this.getModel().getEntryCurrentRowIndex(Key_VchGrpEntry);
        if (StringUtils.isBlank((CharSequence)filterJson)) {
            this.getModel().setValue(Key_FFilter, (Object)"", row);
            this.getModel().setValue(Key_FFilterDescription, (Object)"", row);
        } else {
            VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filterJson, VchTplExpression.class);
            this.getModel().setValue(Key_FFilter, (Object)filterJson, row);
            String dsp = filterObj.getDescription().toString();
            if (StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(Key_FFilterDescription, (Object)dsp, row);
        }
    }

    private MainEntityType getMainEntityType() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber");
        Boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        return BuildTree.getMainEntityType((String)sourceBill, (boolean)(isEvent != null ? isEvent : false));
    }
}

