/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.fi.ai.accsys.AccSysUtil;
import kd.fi.ai.enums.PermissonType;

public class VchEntryTypeList
extends AbstractListPlugin {
    private static final String IS_CLICK_ORG = "isClickOrg";

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List fieldName = (List)args.getSearchClickEvent().getCurrentCommonFilter().get("FieldName");
        if (!fieldName.isEmpty() && "acctorg.id".equals(fieldName.get(0))) {
            List orgList = (List)args.getSearchClickEvent().getCurrentCommonFilter().get("Value");
            this.getPageCache().put("acctorg", orgList.get(0).toString());
            this.getPageCache().put(IS_CLICK_ORG, "yes");
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        String acctorg = this.getPageCache().get("acctorg");
        if (null != acctorg && acctorg.trim().length() > 0) {
            parameter.setCustomParam("acctorg", (Object)acctorg);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        this.setAcctOrg(listFilterColumns);
    }

    private void setAcctOrg(List<FilterColumn> listFilterColumns) {
        for (FilterColumn listFilter : listFilterColumns) {
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            if (!"acctorg.name".equals(commFilter.getFieldName())) continue;
            List comboItems = AccSysUtil.getAcctOrgComboItem((String)"ai_vchentrytype", (boolean)false, (PermissonType)PermissonType.VIEW);
            commFilter.setComboItems(comboItems);
            if (null != comboItems && comboItems.size() > 0 && StringUtils.isEmpty((CharSequence)this.getPageCache().get(IS_CLICK_ORG))) {
                String defaultOrgid = this.getDefaultId(comboItems);
                this.getPageCache().put("org", defaultOrgid);
                commFilter.setDefaultValue(defaultOrgid);
                commFilter.setDefValue(defaultOrgid);
                commFilter.setMustInput(false);
            }
            return;
        }
    }

    private String getDefaultId(List<ComboItem> items) {
        Long currOrgId = RequestContext.get().getOrgId();
        for (int i = 0; i < items.size(); ++i) {
            Long nextId;
            if (null == items.get(i) || items.get(i).getValue().length() == 0 || (nextId = Long.valueOf(Long.parseLong(items.get(i).getValue()))).longValue() != currOrgId.longValue()) continue;
            return currOrgId.toString();
        }
        String defaultStr = items.get(0).getValue();
        return defaultStr;
    }
}

