/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.VchTplVoucherType;
import kd.fi.ai.VchTplVoucherTypes;
import kd.fi.ai.cache.CacheBuildTree;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.EntityFieldUtil;

public class VchGroupSetEdit
extends AbstractFormPlugin {
    public static final String FormId_VchGroupSet = "ai_vchgroupset";
    public static final String CacheKey_VchGroupJson = "vchgroupset";
    public static final String CacheKey_OrgID = "orgid";
    private static String Key_VchGrpEntry = "vchgrpentry";
    private static String Key_FVchGroupID = "fvchgroupid";
    private static String Key_FFilterDescription = "ffilterdescription";
    private static String Key_FFilter = "ffilter";
    private static String Key_btnOK = "btnok";
    private static String Key_btnCancel = "btncancel";
    private static final String NON_FIELDS = "nonFields";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel, Key_FFilterDescription});
    }

    public void afterCreateNewData(EventObject e) {
        Object orgIdObj;
        super.afterCreateNewData(e);
        String str = (String)this.getView().getFormShowParameter().getCustomParam(CacheKey_VchGroupJson);
        if (!StringUtils.isBlank((CharSequence)str)) {
            VchTplVoucherTypes vchTempGrps = (VchTplVoucherTypes)SerializationUtils.fromJsonString((String)str, VchTplVoucherTypes.class);
            this.setVchGroupSet(vchTempGrps);
        }
        if (null != (orgIdObj = this.getView().getFormShowParameter().getCustomParam(CacheKey_OrgID))) {
            Long orgid = null;
            orgid = Long.parseLong(orgIdObj.toString());
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (Long)orgid);
            if (qFilter != null) {
                BasedataEdit acct = (BasedataEdit)this.getControl(Key_FVchGroupID);
                acct.setQFilter(qFilter);
            }
        }
        CacheBuildTree.setPageCache((FormShowParameter)this.getView().getFormShowParameter(), (IPageCache)this.getPageCache());
    }

    public void click(EventObject evt) {
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String cacheValue;
            String entitynumber;
            String currentFormId;
            VchTplVoucherTypes vchTempGrps = this.getVchGroupSet();
            VchReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)vchTempGrps, (String)(currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key")), (String)(entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber")), (String)(cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView())));
            if (returnData.isStatus()) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
                this.getView().close();
            } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
                this.getView().showTipNotification(returnData.getMessage());
            }
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        } else if (Key_FFilterDescription.equalsIgnoreCase(ctlSource.getKey())) {
            this.showConditionForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Key_FFilterDescription.equalsIgnoreCase(actionId) && closedCallBackEvent.getReturnData() != null) {
            String returnStr = (String)closedCallBackEvent.getReturnData();
            VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)returnStr, VchReturnData.class);
            this.receiveFilter(retData.getDataStr());
        }
    }

    private void setVchGroupSet(VchTplVoucherTypes vchTempGrps) {
        int rowCount = this.getModel().getEntryRowCount(Key_VchGrpEntry);
        if (rowCount < vchTempGrps.getItems().size()) {
            this.getModel().batchCreateNewEntryRow(Key_VchGrpEntry, vchTempGrps.getItems().size() - rowCount);
        }
        MainEntityType mainType = this.getMainEntityType();
        for (int i = 0; i < vchTempGrps.getItems().size(); ++i) {
            VchTplVoucherType vchTempGrp = (VchTplVoucherType)vchTempGrps.getItems().get(i);
            VchTplExpression filterObj = vchTempGrp.getFilterSet();
            this.getModel().setValue(Key_FVchGroupID, (Object)vchTempGrp.getVchGrpId(), i);
            this.getModel().setValue(Key_FFilter, (Object)SerializationUtils.toJsonString((Object)filterObj), i);
            String dsp = BuildTree.multiLangDesc((String)filterObj.getDescription().toString(), (String)filterObj.getExprTran(), () -> BuildTree.tranVchTplFormula((CRCondition)filterObj, (MainEntityType)mainType));
            if (StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(Key_FFilterDescription, (Object)dsp, i);
        }
    }

    private VchTplVoucherTypes getVchGroupSet() {
        VchTplVoucherTypes vchTempGrps = new VchTplVoucherTypes();
        int rowCount = this.getModel().getEntryRowCount(Key_VchGrpEntry);
        for (int row = 0; row < rowCount; ++row) {
            DynamicObject vchGrpObj;
            VchTplVoucherType vchTempGrp = new VchTplVoucherType();
            String filter = (String)this.getModel().getValue(Key_FFilter, row);
            if (!StringUtils.isBlank((CharSequence)filter)) {
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filter, VchTplExpression.class);
                vchTempGrp.setFilterSet(filterObj);
            }
            if ((vchGrpObj = (DynamicObject)this.getModel().getValue(Key_FVchGroupID, row)) != null) {
                vchTempGrp.setVchGrpId(((Long)vchGrpObj.getPkValue()).longValue());
                vchTempGrp.setVchGrpNumber(vchGrpObj.getString("number"));
                ILocaleString name = vchGrpObj.getLocaleString("name");
                if (name != null) {
                    for (Map.Entry entry : name.entrySet()) {
                        vchTempGrp.getVchGrpName().setItem((String)entry.getKey(), entry.getValue());
                    }
                }
            }
            vchTempGrps.getItems().add(vchTempGrp);
        }
        return vchTempGrps;
    }

    private void showConditionForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_condition");
        int row = this.getModel().getEntryCurrentRowIndex(Key_VchGrpEntry);
        String conditionJson = (String)this.getModel().getValue(Key_FFilter, row);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", this.getView().getFormShowParameter().getCustomParam("billEntityNumber"));
        showParameter.getCustomParams().put("treenodes", this.getView().getFormShowParameter().getCustomParam("treenodes"));
        boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        showParameter.getCustomParams().put("isevent", isEvent);
        showParameter.setCustomParam("ai_vchtemplatecachekey", (Object)EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView()));
        showParameter.setCustomParam("ai_button_key", (Object)"ai_expression-fvchtypedesc");
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get((String)(isEvent ? "event" : "type"));
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        CacheBuildTree.setBuild((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, Key_FFilterDescription));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveFilter(String filterJson) {
        int row = this.getModel().getEntryCurrentRowIndex(Key_VchGrpEntry);
        if (StringUtils.isBlank((CharSequence)filterJson)) {
            this.getModel().setValue(Key_FFilter, (Object)"", row);
            this.getModel().setValue(Key_FFilterDescription, (Object)"", row);
        } else {
            VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filterJson, VchTplExpression.class);
            this.getModel().setValue(Key_FFilter, (Object)filterJson, row);
            String dsp = filterObj.getDescription().toString();
            if (StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(Key_FFilterDescription, (Object)dsp, row);
        }
    }

    private MainEntityType getMainEntityType() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber");
        Boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        return BuildTree.getMainEntityType((String)sourceBill, (boolean)(isEvent != null ? isEvent : false));
    }
}

