/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.cache.CacheBuildTree;
import kd.fi.ai.util.AiCommonFieldUtils;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;

public class VchReCommonFieldPlugin
extends AbstractFormPlugin {
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String SOURCEBILL = "sourcebill";
    private static final String TARGETBILL = "targetbill";
    private static final String SOURCEDATA = "sourcedata";
    private static final String TARGETDATA = "targetdata";
    private static final String TARGETFIR = "targetfir";
    private static final String SOURCEDATAINFO = "sourcedatainfo";
    private static final String TARGETDATAINFO = "targetdatainfo";
    private static final String INFO = "info";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SOURCEDATA, TARGETDATA, KEY_BTNOK, KEY_BTNCANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject source = (DynamicObject)this.getView().getParentView().getModel().getValue("fsourcebill");
        DynamicObjectCollection target = (DynamicObjectCollection)this.getView().getParentView().getModel().getValue("relationbills");
        Object commonfield = this.getView().getFormShowParameter().getCustomParam("recommonfield");
        this.setValueToForm(source, target, commonfield);
    }

    private void setValueToForm(DynamicObject source, DynamicObjectCollection target, Object commonfield) {
        IDataModel model = this.getModel();
        model.setValue(SOURCEBILL, source.getPkValue());
        List newitems = AiCommonFieldUtils.returnComboItem((DynamicObjectCollection)target, (String)"id");
        ComboEdit cmedit = (ComboEdit)this.getView().getControl(TARGETBILL);
        cmedit.setComboItems(newitems);
        model.setValue(TARGETBILL, (Object)((ComboItem)newitems.get(0)).getValue());
        model.setValue(TARGETFIR, ((DynamicObject)target.get(0)).getDynamicObject(1).get("id"));
        if (StringUtils.isNotBlank((Object)commonfield)) {
            model.setValue(INFO, commonfield);
            String value = (String)model.getValue(TARGETBILL);
            DynamicObject srcbill = (DynamicObject)model.getValue(SOURCEBILL);
            this.setInfoData(srcbill.getString("number") + "-" + value);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        if (Objects.equals(SOURCEDATA, key)) {
            DynamicObject source = (DynamicObject)this.getModel().getValue(SOURCEBILL);
            this.getField((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)source.getString("number")), SOURCEDATA);
        } else if (Objects.equals(TARGETDATA, key)) {
            String tarbill = (String)this.getModel().getValue(TARGETBILL);
            if (StringUtils.isEmpty((CharSequence)tarbill)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u5355\u3002", (String)"VchReCommonFieldPlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject target = (DynamicObject)this.getModel().getValue(TARGETFIR);
            this.getField((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)target.getString("number")), TARGETDATA);
        } else if (Objects.equals(KEY_BTNOK, key)) {
            this.returnCommonInfo();
        } else if (Objects.equals(KEY_BTNCANCEL, key)) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (name) {
            case "targetbill": {
                if (StringUtils.isNotBlank((Object)newValue)) {
                    this.getModel().setValue(TARGETFIR, newValue);
                    DynamicObject srcbill = (DynamicObject)this.getModel().getValue(SOURCEBILL);
                    this.setInfoData(srcbill.getString("number") + "-" + newValue);
                    break;
                }
                this.getModel().setValue(SOURCEDATA, (Object)"");
                this.getModel().setValue(SOURCEDATAINFO, (Object)"");
                this.getModel().setValue(TARGETDATA, (Object)"");
                this.getModel().setValue(TARGETDATAINFO, (Object)"");
                break;
            }
            case "sourcedatainfo": {
                DynamicObject srcbill = (DynamicObject)this.getModel().getValue(SOURCEBILL);
                String srcdata = (String)this.getModel().getValue(SOURCEDATA);
                this.updateInfoData(srcbill.getString("number"), srcdata, changeData.getNewValue());
                break;
            }
            case "targetdatainfo": {
                String tarbill = (String)this.getModel().getValue(TARGETBILL);
                String tardata = (String)this.getModel().getValue(TARGETDATA);
                this.updateInfoData(tarbill, tardata, changeData.getNewValue());
                break;
            }
            case "sourcedata": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getModel().setValue(SOURCEDATAINFO, (Object)"");
                break;
            }
            case "targetdata": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getModel().setValue(TARGETDATAINFO, (Object)"");
            }
        }
    }

    private void setInfoData(String key) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue(SOURCEDATA, (Object)"");
        model.setValue(SOURCEDATAINFO, (Object)"");
        model.setValue(TARGETDATA, (Object)"");
        model.setValue(TARGETDATAINFO, (Object)"");
        model.endInit();
        this.getView().updateView(SOURCEDATA);
        this.getView().updateView(TARGETDATA);
        if (key == null) {
            return;
        }
        Object info = model.getValue(INFO);
        if (info == null || info == "") {
            return;
        }
        Map infoData = (Map)SerializationUtils.fromJsonString((String)((String)info), Map.class);
        String result = (String)infoData.get(key);
        if (result == null) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        DynamicObject srcbill = (DynamicObject)model.getValue(SOURCEBILL);
        String tarbill = (String)model.getValue(TARGETBILL);
        String srcstr = (String)data.get(srcbill.getString("number"));
        String tarstr = (String)data.get(tarbill);
        model.beginInit();
        if (srcstr != null && !"".equals(srcstr)) {
            String[] sstr = srcstr.split("-");
            model.setValue(SOURCEDATA, (Object)sstr[0]);
            model.setValue(SOURCEDATAINFO, (Object)sstr[1]);
        }
        if (tarstr != null && !"".equals(tarstr)) {
            String[] tstr = tarstr.split("-");
            model.setValue(TARGETDATA, (Object)tstr[0]);
            model.setValue(TARGETDATAINFO, (Object)tstr[1]);
        }
        model.endInit();
        this.getView().updateView(SOURCEDATA);
        this.getView().updateView(TARGETDATA);
    }

    private void updateInfoData(String dataKey, String showdata, Object dataValue) {
        if (dataKey == null || dataValue == null || dataValue == "") {
            return;
        }
        DynamicObject srcbill = (DynamicObject)this.getModel().getValue(SOURCEBILL);
        String tarbill = (String)this.getModel().getValue(TARGETBILL);
        Object info = this.getModel().getValue(INFO);
        Map result = info == null || info == "" ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)((String)info), Map.class);
        String key = srcbill.getString("number") + "-" + tarbill;
        String datas = (String)result.get(key);
        Map<String, String> data = datas == null || "".equals(datas) ? new HashMap<String, String>() : (Map)SerializationUtils.fromJsonString((String)datas, Map.class);
        data.put(dataKey, showdata + "-" + (String)dataValue);
        result.put(key, SerializationUtils.toJsonString(data));
        this.addShowData(result);
        this.getModel().setValue(INFO, (Object)SerializationUtils.toJsonString(result));
    }

    private void addShowData(Map<String, String> result) {
        DynamicObject srcbill = (DynamicObject)this.getModel().getValue(SOURCEBILL);
        DynamicObject tarbill = (DynamicObject)this.getModel().getValue(TARGETFIR);
        Object src = this.getModel().getValue(SOURCEDATA);
        Object tar = this.getModel().getValue(TARGETDATA);
        String sn = srcbill.getString("name");
        String tn = tarbill.getString("name");
        if (src != null) {
            sn = sn + "-" + src;
        }
        if (tar != null) {
            tn = tn + "-" + tar;
        }
        String msg = sn + ":" + tn;
        String strs = result.get("str");
        Map<String, String> str = new HashMap();
        if (strs != null && !"".equals(strs)) {
            str = (Map)SerializationUtils.fromJsonString((String)strs, Map.class);
        }
        String key = srcbill.getString("name") + "and" + tarbill.getString("name");
        str.put(key, msg);
        result.put("str", SerializationUtils.toJsonString(str));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    private void getField(IDataEntityType entityType, String key) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType(entityType);
        option.setReadEntryEntity(false);
        option.setExprType(ExpressionType.Formula);
        option.setIncludeID(true);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
        TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
        String toJson = SerializationUtils.toJsonString((Object)tree);
        this.showFormulaForm(entityType.getName(), toJson, key);
    }

    private void showFormulaForm(String entityName, String fieldNodes, String key) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("billEntityNumber", (Object)entityName);
        showParameter.setFormId("ai_formula");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("entitynumber", (Object)entityName);
        showParameter.setCustomParam(SOURCEBILL, (Object)entityName);
        this.getPageCache().put("srcMainEntityType", "VchReCommonFieldPlugin");
        this.getPageCache().put("build", entityName);
        CacheBuildTree.setBuild((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        IDataModel model = this.getModel();
        if (returnData != null && SOURCEDATA.equals(actionId)) {
            VchReturnData data = (VchReturnData)SerializationUtils.fromJsonString((String)returnData.toString(), VchReturnData.class);
            VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)data.getDataStr(), VchTplExpression.class);
            model.setValue(SOURCEDATA, (Object)filterObj.getExprDesc());
            model.setValue(SOURCEDATAINFO, (Object)filterObj.getExpression());
        } else if (returnData != null && TARGETDATA.equals(actionId)) {
            VchReturnData data = (VchReturnData)SerializationUtils.fromJsonString((String)returnData.toString(), VchReturnData.class);
            VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)data.getDataStr(), VchTplExpression.class);
            model.setValue(TARGETDATA, (Object)filterObj.getExprDesc());
            model.setValue(TARGETDATAINFO, (Object)filterObj.getExpression());
        }
    }

    private void returnCommonInfo() {
        LinkedList<String> dataQueue;
        IDataModel model = this.getModel();
        DynamicObject sourceBill = (DynamicObject)model.getValue(SOURCEBILL);
        String number = sourceBill.getString("number");
        String targeBill = (String)model.getValue(TARGETBILL);
        if (StringUtils.isEmpty((CharSequence)targeBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u5355\u3002", (String)"VchReCommonFieldPlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        String sourceField = (String)model.getValue(SOURCEDATAINFO);
        if (StringUtils.isEmpty((CharSequence)sourceField)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VchReCommonFieldPlugin_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        String targetField = (String)model.getValue(TARGETDATAINFO);
        if (StringUtils.isEmpty((CharSequence)targetField)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VchReCommonFieldPlugin_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        MainEntityType targetEntityType = MetadataServiceHelper.getDataEntityType((String)targeBill);
        String[] sourceArr = sourceField.split("\\.");
        String[] targeArr = targetField.split("\\.");
        IDataEntityProperty sourceProperty = null;
        IDataEntityProperty targetProperty = null;
        if (sourceArr.length > 1) {
            dataQueue = new LinkedList<String>();
            for (String fieldStr : sourceArr) {
                dataQueue.add(fieldStr);
            }
            sourceProperty = this.getDataEntityProperty(sourceEntityType, sourceProperty, dataQueue);
        } else {
            sourceProperty = sourceEntityType.findProperty(sourceField);
        }
        if (targeArr.length > 1) {
            dataQueue = new LinkedList();
            for (String fieldStr : targeArr) {
                dataQueue.add(fieldStr);
            }
            targetProperty = this.getDataEntityProperty(sourceEntityType, targetProperty, dataQueue);
        } else {
            targetProperty = targetEntityType.findProperty(targetField);
        }
        if (null != sourceProperty && null != targetProperty && !targetProperty.getPropertyType().equals(sourceProperty.getPropertyType())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5\u4e0e\u76ee\u6807\u5355\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"VchReCommonFieldPlugin_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        this.getView().returnDataToParent(model.getValue(INFO));
        this.getView().close();
    }

    private IDataEntityProperty getDataEntityProperty(MainEntityType sourceEntityType, IDataEntityProperty property, Queue<String> dataQueue) {
        if (dataQueue.isEmpty()) {
            return property;
        }
        String field = dataQueue.poll();
        BasedataProp dynamicObject = null;
        property = sourceEntityType.findProperty(field);
        if (property != null && property.getPropertyType().getName().equals("kd.bos.dataentity.entity.DynamicObject")) {
            dynamicObject = (BasedataProp)property;
        }
        if (null != dynamicObject && !dataQueue.isEmpty()) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)dynamicObject.getBaseEntityId());
            property = this.getDataEntityProperty(entityType, property, dataQueue);
        }
        return property;
    }
}

