/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.operate.OpFieldValueReader;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.dap.DapCache;
import kd.fi.ai.dap.DapCacheMultiLangProcessUtil;
import kd.fi.ai.dap.DapConfig;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;

public class VchTempletePreVoucher {
    public static final String FORM_PARAM_IS_VCH_TEMPLATE_PREVIEW = "isVchTemplatePreView";
    private static final String Key_Condition = "condition";

    public static void preViewVoucher(IFormView view, String tempId) {
        IDataModel model = view.getModel();
        Object entityName = model.getValue("fsourcebill_id");
        List<Object> pks = null;
        if ("ai_eventclass".equals(entityName)) {
            entityName = "ai_event";
            pks = VchTempletePreVoucher.getEventInfo(model, entityName);
        } else {
            pks = VchTempletePreVoucher.getSourceInfo(model, entityName);
        }
        if (pks == null || pks != null && pks.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u6570\u636e\uff0c\u4e0d\u80fd\u9884\u89c8\u3002", (String)"VchTempletePreVoucher_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        OperateOption create = OperateOption.create();
        create.setVariableValue("previewpageid", view.getPageId());
        String preKey = VchTempletePreVoucher.getPreVoucherKey(entityName + "");
        if (StringUtils.isBlank((CharSequence)preKey)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0a\u4e0d\u5b58\u5728\u9884\u89c8\u64cd\u4f5c\uff0c\u8bf7\u914d\u7f6e\u3002", (String)"VchTempletePreVoucher_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        OperationResult executeOperate = null;
        HashSet<Object> sourceIds = new HashSet<Object>(512);
        int index = 0;
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(tempId);
        for (Object pk : pks) {
            sourceIds.add(pk);
            if (sourceIds.size() < 500 && ++index != pks.size()) continue;
            HashMap<Object, ArrayList<String>> map = new HashMap<Object, ArrayList<String>>(1);
            map.put(pk, ids);
            create.setVariableValue("tempId", SerializationUtils.toJsonString(map));
            create.setVariableValue("multidap", "true");
            create.setVariableValue("ignoretemplateunique", "true");
            create.setVariableValue("vchtemplateprevoucher", "true");
            executeOperate = OperationServiceHelper.executeOperate((String)preKey, (String)(entityName + ""), (Object[])sourceIds.toArray(), (OperateOption)create);
            if (executeOperate.isSuccess()) break;
            sourceIds.clear();
        }
        IAppCache cache = AppCache.get((String)"gl");
        if (executeOperate != null && executeOperate.isSuccess()) {
            String string = (String)cache.get("accSys_" + view.getPageId() + "_perviewvoucher", String.class);
            String entityname = (String)cache.get("accSys_" + view.getPageId() + "_entityname", String.class);
            String billIdStr = (String)cache.get("accSys_" + view.getPageId() + "_billid", String.class);
            if (StringUtils.isNotBlank((CharSequence)string)) {
                FormShowParameter form = new FormShowParameter();
                form.setFormId("ai_previewvoucher");
                form.setCustomParam("voucher", (Object)string);
                form.setCustomParam("tempId", (Object)tempId);
                form.setCustomParam("billId", (Object)billIdStr);
                form.setCustomParam("entityname", (Object)entityname);
                form.setCustomParam("vchtemplateprevoucher", (Object)"true");
                form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                form.setStatus(OperationStatus.VIEW);
                view.showForm(form);
            }
        } else if (executeOperate != null && executeOperate.getAllErrorOrValidateInfo().size() > 0) {
            OpFieldValueReader fieldValueReader = OpFieldValueReader.get((IFormView)view);
            List errors = executeOperate.getAllErrorInfo();
            for (OperateErrorInfo error : errors) {
                String billNo = fieldValueReader.getBillNo(error.getPkValue());
                billNo = billNo == null ? "" : billNo + ": ";
                error.setMessage(billNo + error.getMessage());
            }
            view.showOperationResult(executeOperate, ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"VchTempletePreVoucher_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        cache.remove("accSys_" + view.getPageId() + "_perviewvoucher");
    }

    public static void selectForPreVoucher(AbstractFormPlugin plugin, String actionId) {
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        String entityName = (String)model.getValue("fsourcebill_id");
        LinkedList<QFilter> listQf = new LinkedList<QFilter>();
        if ("ai_eventclass".equals(entityName)) {
            entityName = "ai_event";
        } else if (entityName.startsWith("fah_e_")) {
            listQf.add(new QFilter("eventclass.number", "=", (Object)entityName.substring(6)));
            listQf.add(new QFilter("org", "=", model.getValue("createorg_id")));
            listQf.add(new QFilter("status", "=", (Object)"1"));
            entityName = "ai_event";
        } else {
            DynamicObject tempObj;
            String fxml;
            Long tempId = ObjectConverterFactory.getLong((Object)plugin.getPageCache().get("cache_pkvalue"), (Long)-1L);
            if (tempId != -1L && StringUtils.isNotEmpty((CharSequence)(fxml = (tempObj = BusinessDataServiceHelper.loadSingleFromCache((Object)tempId, (String)"ai_vchtemplate", (String)"fxml")).getString("fxml")))) {
                VCHTemplate vchTemplate = VCHTemplate.deserializeFromString((String)fxml, null);
                VCHTemplate template = DapCacheMultiLangProcessUtil.processTemplateLang((VCHTemplate)vchTemplate);
                String finalEntityName = entityName;
                Optional.of(template).map(VCHTemplate::getFilterSet).map(CRCondition::getFilterCondition).map(cond -> new FilterBuilder(EntityMetadataCache.getDataEntityType((String)finalEntityName), cond)).map(fb -> {
                    fb.buildFilter();
                    return fb.getQFilter();
                }).ifPresent(listQf::add);
            }
        }
        String preKey = VchTempletePreVoucher.getPreVoucherKey(entityName);
        if (StringUtils.isBlank((CharSequence)preKey)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0a\u4e0d\u5b58\u5728\u9884\u89c8\u64cd\u4f5c\uff0c\u8bf7\u914d\u7f6e\u3002", (String)"VchTempletePreVoucher_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityName, (boolean)false);
        showParameter.setCustomParam(FORM_PARAM_IS_VCH_TEMPLATE_PREVIEW, (Object)"true");
        showParameter.setPageMode(2);
        showParameter.setSqlQuery(true);
        showParameter.getListFilterParameter().setQFilters(listQf);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        view.showForm((FormShowParameter)showParameter);
    }

    public static void preViewVoucherUseSelect(IFormView view, String tempId, Object pk) {
        String entityName = (String)view.getModel().getValue("fsourcebill_id");
        if ("ai_eventclass".equals(entityName)) {
            entityName = "ai_event";
        }
        String preKey = VchTempletePreVoucher.getPreVoucherKey(entityName);
        OperateOption create = OperateOption.create();
        create.setVariableValue("previewpageid", view.getPageId());
        HashSet<Object> sourceIds = new HashSet<Object>(1);
        sourceIds.add(pk);
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(tempId);
        HashMap<Object, ArrayList<String>> map = new HashMap<Object, ArrayList<String>>(1);
        map.put(pk, ids);
        create.setVariableValue("tempId", SerializationUtils.toJsonString(map));
        create.setVariableValue("multidap", "true");
        create.setVariableValue("ignoretemplateunique", "true");
        create.setVariableValue("vchtemplateprevoucher", "true");
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)preKey, (String)entityName, (Object[])sourceIds.toArray(), (OperateOption)create);
        sourceIds.clear();
        IAppCache cache = AppCache.get((String)"gl");
        if (executeOperate != null && executeOperate.isSuccess()) {
            String previewvoucher = (String)cache.get("accSys_" + view.getPageId() + "_perviewvoucher", String.class);
            String entityname = (String)cache.get("accSys_" + view.getPageId() + "_entityname", String.class);
            String billIdStr = (String)cache.get("accSys_" + view.getPageId() + "_billid", String.class);
            if (StringUtils.isNotBlank((CharSequence)previewvoucher)) {
                FormShowParameter form = new FormShowParameter();
                form.setFormId("ai_previewvoucher");
                form.setCustomParam("voucher", (Object)previewvoucher);
                form.setCustomParam("tempId", (Object)tempId);
                form.setCustomParam("billId", (Object)billIdStr);
                form.setCustomParam("entityname", (Object)entityname);
                form.setCustomParam("vchtemplateprevoucher", (Object)"true");
                form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                form.setStatus(OperationStatus.VIEW);
                view.showForm(form);
            }
        } else if (executeOperate != null && executeOperate.getAllErrorOrValidateInfo().size() > 0) {
            OpFieldValueReader fieldValueReader = OpFieldValueReader.get((IFormView)view);
            List errors = executeOperate.getAllErrorInfo();
            for (OperateErrorInfo error : errors) {
                String billNo = fieldValueReader.getBillNo(error.getPkValue());
                billNo = billNo == null ? "" : billNo + ": ";
                error.setMessage(billNo + error.getMessage());
            }
            view.showOperationResult(executeOperate, ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"VchTempletePreVoucher_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        cache.remove("accSys_" + view.getPageId() + "_perviewvoucher");
    }

    private static Set<Object> getAcctOrgsFromAccountingSys(Object bizOrgID) {
        String selectFields = "id,bizorgentry.bizorg bizorg,bizorgentry.bizacctorg bizacctorg";
        QFilter orgqf = new QFilter("bizorgentry.bizacctorg", "=", bizOrgID);
        DynamicObjectCollection bizColl = QueryServiceHelper.query((String)"bd_accountingsys", (String)selectFields, (QFilter[])new QFilter[]{orgqf});
        return bizColl.stream().map(e -> e.get("bizorg")).collect(Collectors.toSet());
    }

    private static List<Object> getSourceInfo(IDataModel model, Object entityName) {
        DapConfig cg = DapCache.getDapConfigCache((String)entityName.toString());
        QFilter qFilter = VchTempletePreVoucher.getQFilterInfo(model, cg, entityName);
        if (qFilter != null) {
            return QueryServiceHelper.queryPrimaryKeys((String)(entityName + ""), (QFilter[])qFilter.toArray(), null, (int)100000);
        }
        return new ArrayList<Object>(1);
    }

    private static String getPreVoucherKey(String entityname) {
        List opts = EntityMetadataCache.getDataEntityOperate((String)entityname);
        String genVoucherOptName = "";
        for (Map opt : opts) {
            String optKey = (String)opt.get("type");
            if (!optKey.equalsIgnoreCase("previewvoucher")) continue;
            genVoucherOptName = (String)opt.get("key");
        }
        return genVoucherOptName;
    }

    private static List<Object> getEventInfo(IDataModel model, Object entityName) {
        DapConfig cg = DapCache.getDapConfigCache((String)"ai_eventclass", (long)((Long)model.getValue("eventclass_id")));
        QFilter orgQF = VchTempletePreVoucher.getQFilterInfo(model, cg, entityName);
        if (orgQF != null) {
            orgQF.and(new QFilter("eventclass", "=", model.getValue("eventclass_id")));
        } else {
            orgQF = new QFilter("eventclass", "=", model.getValue("eventclass_id"));
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"ai_event", (QFilter[])orgQF.toArray(), null, (int)100000);
    }

    private static QFilter getQFilterInfo(IDataModel model, DapConfig cg, Object entityName) {
        Object org = model.getValue("createorg_id");
        Set<Object> orgIds = VchTempletePreVoucher.getAcctOrgsFromAccountingSys(org);
        orgIds.add(org);
        List orgFields = cg.getBizOrgFields();
        QFilter orgQF = null;
        if ("ai_event".equalsIgnoreCase(entityName.toString())) {
            orgQF = new QFilter("org", "in", orgIds);
        } else {
            for (int i = 0; i < orgFields.size(); ++i) {
                if (orgQF == null) {
                    orgQF = new QFilter((String)orgFields.get(i), "in", orgIds);
                    continue;
                }
                orgQF.or(new QFilter((String)orgFields.get(i), "in", orgIds));
            }
        }
        return orgQF;
    }
}

