/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin.importhandler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ai.formplugin.AcctTableField;
import kd.fi.v2.fah.dao.sys.SysBasePropDataDaoImpl;

public class AccountMapTypeImportHandler {
    private static final String BASEFACTOR = "basefactorshow";
    private static final String ASSTFACTOR = "asstfactorshow";
    public static final String ENTITY_BOSORG = "bos_org";
    public static final String ENTITY_ACCOUNTVIEW = "bd_accountview";
    public static final String PRE_ASSISTANT = "[2]";
    public static final String PRE_BDINFOIMPORT = "{X}";
    public static final String ENTITY_ASSISTDATAGROUP = "bos_assistantdatagroup";
    public static final String ENTITY_ASSISTDATAGROUPDETAIL = "bos_assistantdata_detail";
    public static final String KEY_PLACEHOLDER = "%s_%s";
    public static Set<String> NOFILTER = new HashSet<String>(3);

    public void beforeImporChecktData(BeforeImportDataEventArgs e) {
        JSONArray entrys;
        Map sourceData = e.getSourceData();
        Object inputOrg = sourceData.get("createorg");
        if (null == inputOrg) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AccountMapTypeImportHandler_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Map orgMap = (Map)inputOrg;
        Object inputAccTable = sourceData.get("mulaccttable");
        if (null == inputAccTable) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u76ee\u6807\u79d1\u76ee\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AccountMapTypeImportHandler_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String orgNumber = (String)orgMap.get("number");
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_BOSORG, (String)"id", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
        if (org == null) {
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u7f16\u7801%s\u7684\u6838\u7b97\u7ec4\u7ec7\u76ee\u6807\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AccountMapTypeImportHandler_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), orgNumber));
            e.setCancel(true);
            return;
        }
        Object inputEntries = sourceData.get("entryentity");
        if (null == inputEntries) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u79d1\u76ee\u53d6\u503c\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AccountMapTypeImportHandler_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        JSONArray jSONArray = entrys = inputAccTable instanceof JSONArray ? (JSONArray)inputEntries : (JSONArray)JSONArray.parse((String)JSON.toJSONString(inputEntries));
        if (entrys.isEmpty()) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u79d1\u76ee\u53d6\u503c\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AccountMapTypeImportHandler_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        HashSet acctTableNumber = new HashSet(1);
        entrys.forEach(v -> {
            Map m = (Map)v;
            JSONObject accttable = (JSONObject)m.get("accfieldtable");
            if (accttable != null) {
                acctTableNumber.add(accttable.getString("number"));
            }
        });
        QFilter qaccounttableid = new QFilter("accounttable.number", "in", acctTableNumber).and(new QFilter("enable", "=", (Object)"1"));
        HashMap account = new HashMap();
        DynamicObject[] temp = SysBasePropDataDaoImpl.queryBaseDataObjects((String)ENTITY_ACCOUNTVIEW, (Long)org.getLong("id"), (String)String.join((CharSequence)",", "id", "number", "accounttable.number"), (QFilter[])new QFilter[]{qaccounttableid});
        DynamicObjectCollection tempCollection = new DynamicObjectCollection();
        tempCollection.addAll(Arrays.asList(temp));
        tempCollection.forEach(v -> account.put(String.format(KEY_PLACEHOLDER, v.getString("number"), v.getString("accounttable.number")), v.getLong("id")));
        int rowIndex = 1;
        for (Object o : entrys) {
            Map m = (Map)o;
            JSONObject acct = (JSONObject)m.get("accfield");
            JSONObject accttable = (JSONObject)m.get("accfieldtable");
            if (accttable == null || acct == null) continue;
            String number = String.format(KEY_PLACEHOLDER, acct.getString("number"), accttable.getString("number"));
            if (!account.containsKey(number)) {
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u5f53\u524d\u7ec4\u7ec7\u7684\u201c%2$s\u201d\u79d1\u76ee\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AccountMapTypeImportHandler_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), rowIndex, number));
                e.setCancel(true);
                return;
            }
            acct.put("id", account.get(number));
            ++rowIndex;
        }
        sourceData.put("entryentity", entrys);
    }

    /*
     * WARNING - void declaration
     */
    public void setSourceDataToModel(IDataModel model, IFormView view) {
        ArrayList<QFilter> filterList;
        model.setValue("status", (Object)"C");
        model.setValue("enable", (Object)"1");
        model.setValue("creator", (Object)RequestContext.get().getUserId());
        Long orgId = (Long)model.getValue("org_id");
        DynamicObject dyOrg = (DynamicObject)model.getValue("createorg");
        String ctrStractegy = BaseDataServiceHelper.getBdCtrlStrgy((String)"ai_accountmaptype", (String)dyOrg.getString("id"));
        if (StringUtils.isEmpty((CharSequence)ctrStractegy)) {
            ctrStractegy = "5";
        }
        model.setValue("ctrlstrategy", (Object)ctrStractegy);
        String selectFields = "id,number,name";
        HashMap<String, String> fieldEntryNameMap = new HashMap<String, String>();
        HashMap<String, List<String>> fieldEntryValueMap = new HashMap<String, List<String>>();
        HashMap<String, String> fieldAssisNumberMap = new HashMap<String, String>();
        HashMap<String, String> fieldBaseDataNumberMap = new HashMap<String, String>();
        HashMap<String, Set<String>> subAssisNumberMap = new HashMap<String, Set<String>>();
        HashMap<String, List<String>> subBaseDataNumberMap = new HashMap<String, List<String>>();
        HashMap<String, Map> numberIdMapByType = new HashMap<String, Map>();
        HashMap<String, Map> numberNameMapByType = new HashMap<String, Map>();
        Object objEntryEntities = model.getValue("entryentity");
        String factorNumber = "";
        String factorValue = "";
        String assInfoValue = "";
        if (objEntryEntities == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u53d6\u503c\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMapTypeImportHandler_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection entryEntities = (DynamicObjectCollection)objEntryEntities;
        DynamicObjectCollection factorimport = (DynamicObjectCollection)model.getValue("factorimport");
        boolean isFactorEmpty = true;
        for (DynamicObject dynamicObject : factorimport) {
            for (int i = 0; i < 10; ++i) {
                factorNumber = dynamicObject.getString("factornumber" + (i + 1));
                factorValue = dynamicObject.getString("factorvalue" + (i + 1));
                if (factorNumber.equals("") && factorValue.equals("")) continue;
                isFactorEmpty = false;
                if (factorNumber.startsWith(PRE_ASSISTANT)) {
                    assInfoValue = factorNumber.substring(3);
                    fieldEntryNameMap.put(ASSTFACTOR + i, assInfoValue);
                    fieldEntryValueMap.computeIfAbsent(ASSTFACTOR + i, key -> new ArrayList(10)).add(factorValue);
                    continue;
                }
                fieldEntryNameMap.put(BASEFACTOR + i, this.splitMark(factorNumber));
                fieldEntryValueMap.computeIfAbsent(BASEFACTOR + i, key -> new ArrayList(10)).add(factorValue);
            }
        }
        if (isFactorEmpty) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u81f3\u5c11\u4e00\u7ec4\u5f71\u54cd\u56e0\u7d20\u3002", (String)"AccountMapTypeImportHandler_11", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        this.fillAssisBaseDataMap(fieldEntryNameMap, fieldAssisNumberMap, fieldBaseDataNumberMap);
        if (!fieldAssisNumberMap.isEmpty()) {
            ArrayList<QFilter> filterList2 = new ArrayList<QFilter>(10);
            filterList2.add(new QFilter("number", "in", fieldAssisNumberMap.values()));
            Map map = SysBasePropDataDaoImpl.queryBaseDataMap((String)ENTITY_ASSISTDATAGROUP, (Long)orgId, (String)selectFields, (QFilter[])filterList2.toArray(new QFilter[0]));
            for (Map.Entry ety : map.entrySet()) {
                Map numberIdMap = numberIdMapByType.computeIfAbsent(ENTITY_ASSISTDATAGROUP, k -> new HashMap());
                numberIdMap.put(((DynamicObject)ety.getValue()).getString("number"), ((DynamicObject)ety.getValue()).getString("id"));
                Map numberNameMap = numberNameMapByType.computeIfAbsent(ENTITY_ASSISTDATAGROUP, k -> new HashMap());
                numberNameMap.put(((DynamicObject)ety.getValue()).getString("number"), ((DynamicObject)ety.getValue()).getString("name"));
            }
        }
        this.fillSubAssisBaseDataMap(fieldEntryNameMap, fieldEntryValueMap, subAssisNumberMap, subBaseDataNumberMap);
        if (!subAssisNumberMap.isEmpty()) {
            for (Map.Entry entry : subAssisNumberMap.entrySet()) {
                String string = (String)((Map)numberIdMapByType.get(ENTITY_ASSISTDATAGROUP)).get(fieldAssisNumberMap.get(entry.getKey()));
                filterList = new ArrayList<QFilter>(10);
                QFilter groupFilter = new QFilter("group", "=", (Object)Long.valueOf(string));
                filterList.add(groupFilter);
                filterList.add(new QFilter("number", "in", entry.getValue()));
                Map subAssistantMap = SysBasePropDataDaoImpl.queryBaseDataMap((String)ENTITY_ASSISTDATAGROUPDETAIL, (Long)orgId, (String)selectFields, (QFilter[])filterList.toArray(new QFilter[0]));
                ArrayList newList = new ArrayList((Collection)entry.getValue());
                if (subAssistantMap == null || subAssistantMap.isEmpty()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f71\u54cd\u56e0\u7d20\u4e3a\u201c%s\u201d\u7684\u8f85\u52a9\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AccountMapTypeImportHandler_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", newList)));
                }
                if (newList.size() > subAssistantMap.size()) {
                    ArrayList subAssistDataList = new ArrayList(subAssistantMap.size());
                    for (Map.Entry entry2 : subAssistantMap.entrySet()) {
                        subAssistDataList.add(((DynamicObject)entry2.getValue()).getString("number"));
                    }
                    Map map = subAssistDataList.parallelStream().collect(Collectors.toMap(Function.identity(), Function.identity(), (oldData, newData) -> newData));
                    List list = newList.parallelStream().filter(str -> !tempMap.containsKey(str)).collect(Collectors.toList());
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f71\u54cd\u56e0\u7d20\u4e3a\u201c%s\u201d\u7684\u8f85\u52a9\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AccountMapTypeImportHandler_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", list)));
                }
                for (Map.Entry entry3 : subAssistantMap.entrySet()) {
                    Map map = numberIdMapByType.computeIfAbsent(string, k -> new HashMap());
                    map.put(((DynamicObject)entry3.getValue()).getString("number"), ((DynamicObject)entry3.getValue()).getString("id"));
                    Map map2 = numberNameMapByType.computeIfAbsent(string, k -> new HashMap());
                    map2.put(((DynamicObject)entry3.getValue()).getString("number"), ((DynamicObject)entry3.getValue()).getString("name"));
                }
            }
        }
        if (!subBaseDataNumberMap.isEmpty()) {
            String entityName = "";
            for (Map.Entry entry : subBaseDataNumberMap.entrySet()) {
                entityName = (String)fieldBaseDataNumberMap.get(entry.getKey());
                filterList = new ArrayList(10);
                QFilter numberFilter = new QFilter("number", "in", entry.getValue());
                filterList.add(numberFilter);
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
                if (entityType.getAllFields().get("enable") != null) {
                    filterList.add(new QFilter("enable", "=", (Object)"1"));
                }
                Map subBaseDataMap = SysBasePropDataDaoImpl.queryBaseDataMap((String)entityName, (Long)(NOFILTER.contains(entityName) ? null : orgId), (String)selectFields, (QFilter[])filterList.toArray(new QFilter[0]));
                ArrayList newList = new ArrayList(new HashSet((Collection)entry.getValue()));
                if (subBaseDataMap == null || subBaseDataMap.isEmpty()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f71\u54cd\u56e0\u7d20\u4e3a\u201c%s\u201d\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AccountMapTypeImportHandler_7", (String)"fi-ai-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", newList)));
                }
                if (newList.size() > subBaseDataMap.size()) {
                    ArrayList<String> arrayList = new ArrayList<String>(subBaseDataMap.size());
                    for (Map.Entry entry4 : subBaseDataMap.entrySet()) {
                        arrayList.add(((DynamicObject)entry4.getValue()).getString("number"));
                    }
                    Map map = arrayList.parallelStream().collect(Collectors.toMap(Function.identity(), Function.identity(), (oldData, newData) -> newData));
                    List list = newList.parallelStream().filter(str -> !tempMap.containsKey(str)).collect(Collectors.toList());
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f71\u54cd\u56e0\u7d20\u4e3a\u201c%s\u201d\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AccountMapTypeImportHandler_7", (String)"fi-ai-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", list)));
                }
                for (Map.Entry entry5 : subBaseDataMap.entrySet()) {
                    Map map = numberIdMapByType.computeIfAbsent(entityName, k -> new HashMap());
                    map.put(((DynamicObject)entry5.getValue()).getString("number"), ((DynamicObject)entry5.getValue()).getString("id"));
                    String baseDataName = ((DynamicObject)entry5.getValue()).getDataEntityType().getDisplayName().getLocaleValue();
                    Map numberNameMap = numberNameMapByType.computeIfAbsent(entityName, k -> new HashMap());
                    numberNameMap.put(((DynamicObject)entry5.getValue()).getString("number"), baseDataName);
                }
            }
        }
        StringBuffer factoryValue = new StringBuffer();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer factorvalue_asstdata = new StringBuffer();
        HashSet<String> factorNameList = new HashSet<String>(5);
        String curValue = "";
        String curName = "";
        for (Map.Entry entry : fieldEntryNameMap.entrySet()) {
            curValue = (String)entry.getValue();
            if (((String)entry.getKey()).startsWith(ASSTFACTOR) && factorvalue_asstdata.indexOf((String)((Map)numberIdMapByType.get(ENTITY_ASSISTDATAGROUP)).get(curValue)) == -1) {
                factorvalue_asstdata.append((String)((Map)numberIdMapByType.get(ENTITY_ASSISTDATAGROUP)).get(curValue)).append(",");
                factoryValue.append((String)((Map)numberIdMapByType.get(ENTITY_ASSISTDATAGROUP)).get(curValue)).append(",");
                continue;
            }
            if (!((String)entry.getKey()).startsWith(BASEFACTOR) || stringBuffer2.indexOf(curValue) != -1) continue;
            stringBuffer2.append(curValue).append(",");
            factoryValue.append(curValue).append(",");
        }
        model.setValue("factorvalue_asstdata", (Object)this.convertToString(factorvalue_asstdata));
        model.setValue("factorvalue_basedata", (Object)this.convertToString(stringBuffer2));
        model.setValue("factorvalue", (Object)this.convertToString(factoryValue));
        DynamicObjectCollection fieldMapEntries = (DynamicObjectCollection)model.getValue("fieldmapentry");
        DynamicObjectType dynamicObjectType = fieldMapEntries.getDynamicObjectType();
        fieldMapEntries.clear();
        boolean bl = false;
        String string = "";
        String entryValueKey = "";
        for (Map.Entry ety : fieldEntryValueMap.entrySet()) {
            void var32_71;
            int n;
            entryValueKey = (String)ety.getKey();
            if (((String)ety.getKey()).startsWith(ASSTFACTOR)) {
                n = 1;
                String string2 = (String)((Map)numberIdMapByType.get(ENTITY_ASSISTDATAGROUP)).get(fieldEntryNameMap.get(ety.getKey()));
                curName = (String)((Map)numberNameMapByType.get(ENTITY_ASSISTDATAGROUP)).get(fieldEntryNameMap.get(ety.getKey()));
                if (StringUtils.isEmpty((CharSequence)curName)) {
                    DynamicObject dyAssist = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ASSISTDATAGROUP);
                    curName = dyAssist.getDataEntityType().getDisplayName().getLocaleValue();
                }
            } else {
                n = 0;
                String string3 = (String)fieldEntryNameMap.get(ety.getKey());
                curName = "";
                if (StringUtils.isEmpty((CharSequence)curName)) {
                    DynamicObject dySubBase = BusinessDataServiceHelper.newDynamicObject((String)string3);
                    curName = dySubBase.getDataEntityType().getDisplayName().getLocaleValue();
                }
            }
            for (int i = 0; i < ((List)ety.getValue()).size(); ++i) {
                Map dataMap;
                DynamicObject dyData;
                if (n == 0) {
                    dyData = BusinessDataServiceHelper.newDynamicObject((String)((String)fieldEntryNameMap.get(ety.getKey())));
                    dataMap = (Map)numberIdMapByType.get(fieldEntryNameMap.get(ety.getKey()));
                } else {
                    dyData = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ASSISTDATAGROUP);
                    String asstGroupId = (String)((Map)numberIdMapByType.get(ENTITY_ASSISTDATAGROUP)).get(fieldEntryNameMap.get(ety.getKey()));
                    dataMap = (Map)numberIdMapByType.get(asstGroupId);
                }
                String subNumber = (String)((List)ety.getValue()).get(i);
                if (!Objects.nonNull(dataMap)) continue;
                dyData.set("id", dataMap.get(subNumber));
                dyData.set("number", (Object)subNumber);
                if (i >= entryEntities.size()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5f02\u5e38\uff0c\u6570\u7ec4\u8d8a\u754c\uff0c\u53ef\u80fd\u539f\u56e0\u662f\u672a\u5220\u9664\u8868\u683c\u4e2d\u7684\u5206\u5f55\u5185\u7801\u3002\u8bf7\u68c0\u67e5\u3002", (String)"AccountMapTypeImportHandler_8", (String)"fi-ai-formplugin", (Object[])new Object[0]), new Object[0]));
                }
                ((DynamicObject)entryEntities.get(i)).set(entryValueKey.replace("show", ""), (Object)dyData);
            }
            if (!factorNameList.add(curName)) continue;
            stringBuffer.append(curName).append(",");
            DynamicObject dyFieldMap = new DynamicObject(dynamicObjectType);
            dyFieldMap.set("datatype", (Object)n);
            dyFieldMap.set("fieldkey", ety.getKey());
            dyFieldMap.set("entityid", (Object)var32_71);
            dyFieldMap.set("fieldname", (Object)curName);
            fieldMapEntries.add((Object)dyFieldMap);
        }
        int updateRow = entryEntities.size() - factorimport.size();
        this.checkDirtyEntry(entryEntities, updateRow);
        model.setValue("factorname", (Object)this.convertToString(stringBuffer));
        ArrayList<AcctTableField> acctTbList = new ArrayList<AcctTableField>(10);
        DynamicObjectCollection mulaccttable = (DynamicObjectCollection)model.getValue("mulaccttable");
        int accStartIndex = 0;
        for (DynamicObject accttable : mulaccttable) {
            AcctTableField field = new AcctTableField();
            String fieldKey = "accfieldshow" + accStartIndex++;
            field.setFieldKey(fieldKey);
            DynamicObject acctTb = accttable.getDynamicObject("fbasedataid");
            field.setAcctTableId(acctTb.getLong("id"));
            field.setAcctTableName(acctTb.getString("name"));
            acctTbList.add(field);
        }
        this.saveAcctTableMapToModel(model, acctTbList);
    }

    private void saveAcctTableMapToModel(IDataModel model, List<AcctTableField> acctList) {
        model.deleteEntryData("acctmapentry");
        for (AcctTableField acctTableField : acctList) {
            int rowIndex = model.createNewEntryRow("acctmapentry");
            model.setValue("entryaccttable", (Object)acctTableField.getAcctTableId(), rowIndex);
            model.setValue("acctfieldkey", (Object)acctTableField.getFieldKey(), rowIndex);
        }
    }

    private String convertToString(StringBuffer sbInfo) {
        if (sbInfo == null || sbInfo.length() == 0) {
            return "";
        }
        if (sbInfo.length() > 0) {
            sbInfo = sbInfo.deleteCharAt(sbInfo.length() - 1);
        }
        return sbInfo.toString();
    }

    private void fillSubAssisBaseDataMap(Map<String, String> fieldEntryNameMap, Map<String, List<String>> fieldEntryValueMap, Map<String, Set<String>> subAssisNumberMap, Map<String, List<String>> subBaseDataNumberMap) {
        for (Map.Entry<String, List<String>> ety : fieldEntryValueMap.entrySet()) {
            List numberVals = ety.getValue().stream().filter(p -> StringUtils.isNotBlank((CharSequence)p)).collect(Collectors.toList());
            if (numberVals == null || numberVals.isEmpty()) continue;
            if (ety.getKey().startsWith(ASSTFACTOR)) {
                Set subAssisNumberSet = subAssisNumberMap.computeIfAbsent(ety.getKey(), k -> new HashSet());
                subAssisNumberSet.addAll(numberVals);
                continue;
            }
            subBaseDataNumberMap.put(ety.getKey(), numberVals);
        }
    }

    private void fillAssisBaseDataMap(Map<String, String> fieldEntryNameMap, Map<String, String> fieldAssisNumberMap, Map<String, String> fieldBaseDataNumberMap) {
        for (Map.Entry<String, String> ety : fieldEntryNameMap.entrySet()) {
            if (ety.getKey().startsWith(ASSTFACTOR)) {
                fieldAssisNumberMap.put(ety.getKey(), ety.getValue());
                continue;
            }
            fieldBaseDataNumberMap.put(ety.getKey(), ety.getValue());
        }
    }

    private String splitMark(String entityNumber) {
        if (entityNumber.startsWith(PRE_BDINFOIMPORT)) {
            entityNumber = entityNumber.substring(3);
        }
        return entityNumber;
    }

    private void checkDirtyEntry(DynamicObjectCollection entryEntities, int updateRow) {
        if (entryEntities.isEmpty()) {
            return;
        }
        DynamicObjectCollection clone = (DynamicObjectCollection)entryEntities.clone();
        entryEntities.clear();
        for (DynamicObject row : clone) {
            Boolean tipCheck = false;
            for (int i = 0; i < 10; ++i) {
                DynamicObject bf = row.getDynamicObject("basefactor" + i);
                DynamicObject af = row.getDynamicObject("asstfactor" + i);
                if (bf != null || af != null) {
                    tipCheck = true;
                }
                if (((DynamicObject)clone.get(updateRow)).get("accfield") == null || bf != null || af != null) continue;
                tipCheck = true;
            }
            if (!tipCheck.booleanValue()) continue;
            row.set("accfield", ((DynamicObject)clone.get(updateRow)).get("accfield"));
            entryEntities.add((Object)row);
            if (++updateRow < clone.size()) continue;
            break;
        }
    }

    static {
        NOFILTER.add("bd_accountbanks");
        NOFILTER.add("cas_accountcash");
        NOFILTER.add("am_accountbank");
    }
}

