/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.task;

import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.ai.util.DateUtil;

public class ClearVchReportTask
extends AbstractTask {
    private static final DBRoute DBROUTE_FI = DBRoute.of((String)"fi");
    private static final String KEY_AI_BUILDREPORT = "ai_buildreport";
    private static final int MAX_COUNT = 10000000;
    private static final Log LOGGER = LogFactory.getLog((String)ClearVchReportTask.class.getName());
    private static final String rangDateCountSql = "select count(*) from t_ai_buildreport where  fcreatetime between  ? and ?;";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            if ("TRUE".equals(map.get("TRUNCATE"))) {
                this.truncateClear();
            } else {
                this.deleteClear(map);
            }
            LOGGER.info("clear success");
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
    }

    private void deleteClear(Map<String, Object> map) {
        int dayAgo = this.getDayAgo(map);
        this.doAction(dayAgo);
    }

    private void truncateClear() {
        DB.execute((DBRoute)DBROUTE_FI, (String)"truncate table t_ai_buildreport;truncate table t_ai_buildreportentry;");
    }

    private void doAction(int daysAgo) {
        Date minDate = this.getDate(" createtime asc");
        Date maxDate = this.getDate(" createtime desc");
        int daysDiff = Math.max((int)((maxDate.getTime() - minDate.getTime()) / 86400000L), 15);
        if (daysDiff < daysAgo) {
            LOGGER.info(" daysDiff <  daysAgo");
            return;
        }
        Date endDay = DateUtil.addDay((Date)maxDate, (int)Math.negateExact(Math.abs(daysAgo)));
        LOGGER.info(" Clear up date between {} and {}", (Object)minDate, (Object)endDay);
        this.deleteRangVchReport(minDate, endDay);
    }

    private int getDayAgo(Map<String, Object> map) {
        int DaysAgo = 15;
        try {
            DaysAgo = Math.max(Integer.parseInt(map.get("DaysAgo").toString()), 15);
            LOGGER.info(" Clean up data before {} days", (Object)DaysAgo);
        }
        catch (Exception e1) {
            LOGGER.info(" default  Clean up data before {} days", (Object)DaysAgo);
        }
        return DaysAgo;
    }

    private Date getDate(String orderByStr) {
        DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)KEY_AI_BUILDREPORT, (String)"createtime", null, (String)orderByStr, (int)1);
        if (ds.hasNext()) {
            return ds.next().getDate("createtime");
        }
        return new Date();
    }

    private void deleteRangVchReport(Date begin, Date end) {
        if (begin.compareTo(end) > 0) {
            return;
        }
        Date rangMonthDate = DateUtil.addMonth((Date)begin, (int)1);
        Object[] params = new Object[]{begin, rangMonthDate};
        Integer count = (Integer)DB.query((DBRoute)DBROUTE_FI, (String)rangDateCountSql, (Object[])params, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt(1);
            }
            return 0;
        });
        if (count > 10000000) {
            this.deleteMinRangeVchReport(begin);
            this.deleteRangVchReport(rangMonthDate, end);
        } else {
            this.deleteVchReport(begin, end);
        }
    }

    private void deleteMinRangeVchReport(Date begin) {
        for (int i = 0; i < 8; ++i) {
            Date end = DateUtil.addDay((Date)begin, (int)4);
            this.deleteVchReport(begin, end);
            begin = end;
        }
    }

    private void deleteVchReport(Date begin, Date end) {
        QFilter filter = new QFilter("createtime", ">=", (Object)begin);
        filter.and(new QFilter("createtime", "<=", (Object)end));
        int count = DeleteServiceHelper.delete((String)KEY_AI_BUILDREPORT, (QFilter[])filter.toArray());
        LOGGER.info("{} ~ {} \u5220\u9664\u6570\u636e\u6761\u6570:{}", new Object[]{begin, end, count});
    }
}

