/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.entity.property.AccountProp;
import kd.bos.ext.fi.metadata.field.AccountField;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.fi.ai.formplugin.AcctTableField;
import kd.fi.ai.formplugin.DSField;

public class DynamicModifyViewAndModelUtil {
    private static final String BOS_ASSISTANTDATA_DETAIL = "bos_assistantdata_detail";

    public static void createDynamicFieldEdit(IFormView view, String entryKey, List<DSField> dsFieldList, List<AcctTableField> acctFieldList) {
        EntryAp entryAp = DynamicModifyViewAndModelUtil.createDynamicEntryAp(entryKey, dsFieldList, acctFieldList);
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryKey);
        List entryFieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : entryFieldEdits) {
            fieldEdit.setView(view);
            entryGrid.getItems().add(fieldEdit);
        }
    }

    public static EntryAp createDynamicEntryAp(String entryKey, List<DSField> dsFieldList, List<AcctTableField> acctFieldList) {
        EntryAp entryAp = DynamicModifyViewAndModelUtil.createDynamicDsEntryAp(entryKey, dsFieldList);
        EntryAp acctEntryAp = DynamicModifyViewAndModelUtil.createDynamicAcctEntryAp(entryKey, acctFieldList);
        entryAp.getItems().addAll(acctEntryAp.getItems());
        return entryAp;
    }

    private static EntryAp createDynamicDsEntryAp(String entryKey, List<DSField> dsFieldList) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(entryKey);
        String displayProp = "number,name";
        for (int i = 0; i < dsFieldList.size(); ++i) {
            BasedataField field;
            EntryFieldAp fieldAp = new EntryFieldAp();
            DSField entryField = dsFieldList.get(i);
            String columnKey = entryField.getFieldKey();
            fieldAp.setId(columnKey);
            fieldAp.setKey(columnKey);
            fieldAp.setName(entryField.getFieldName());
            fieldAp.setWidth(new LocaleString("140px"));
            fieldAp.setFireUpdEvt(false);
            fieldAp.setFreeze(false);
            fieldAp.setLock("");
            fieldAp.setQuickAddNew(false);
            if ("0".equals(entryField.getDataType())) {
                field = new BasedataField();
                field.setId(columnKey);
                field.setKey(columnKey);
                field.setBaseEntityId(entryField.getEntityId());
                field.setDisplayProp(displayProp);
                field.setViewDetail(false);
                fieldAp.setField((Field)field);
            } else if ("1".equals(entryField.getDataType())) {
                field = new AssistantField();
                field.setId(columnKey);
                field.setKey(columnKey);
                field.setBaseEntityId(BOS_ASSISTANTDATA_DETAIL);
                field.setAsstParentId(entryField.getEntityId());
                field.setAsstTypeId(entryField.getEntityId());
                field.setDisplayProp(displayProp);
                field.setEntityMetadata((EntityMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)BOS_ASSISTANTDATA_DETAIL, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity));
                field.setViewDetail(false);
                fieldAp.setField((Field)field);
            }
            entryAp.getItems().add(fieldAp);
        }
        return entryAp;
    }

    public static EntryAp createDynamicAcctEntryAp(String entryKey, List<AcctTableField> acctFieldList) {
        String displayProp = "number,name";
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(entryKey);
        for (int i = 0; i < acctFieldList.size(); ++i) {
            EntryFieldAp fieldAp = new EntryFieldAp();
            AcctTableField entryField = acctFieldList.get(i);
            String columnKey = entryField.getFieldKey();
            fieldAp.setId(columnKey);
            fieldAp.setKey(columnKey);
            fieldAp.setName(new LocaleString(entryField.getAcctTableName()));
            fieldAp.setWidth(new LocaleString("140px"));
            fieldAp.setFireUpdEvt(false);
            fieldAp.setFreeze(false);
            fieldAp.setLock("");
            fieldAp.setQuickAddNew(false);
            AccountField field = new AccountField();
            field.setId(columnKey);
            field.setKey(columnKey);
            field.setDisplayFullname(true);
            field.setViewDetail(true);
            field.setDisplayProp(displayProp);
            fieldAp.setField((Field)field);
            entryAp.getItems().add(fieldAp);
        }
        return entryAp;
    }

    public static void rebuildEntityType(MainEntityType mainEntityType, String entryKey, List<DSField> entryFields, List<AcctTableField> acctEntryFields) {
        EntryProp entry = (EntryProp)mainEntityType.getProperty(entryKey);
        DynamicObjectType entryType = entry.getDynamicCollectionItemPropertyType();
        for (int i = 0; i < entryFields.size(); ++i) {
            DynamicProperty propRefId;
            DSField entryField = entryFields.get(i);
            String columnKey = entryField.getFieldKey();
            DynamicProperty property = entryType.getProperty(columnKey);
            if (property != null) {
                entryType.getProperties().remove((Object)property);
            }
            if ((propRefId = entryType.getProperty(columnKey + "_id")) == null) continue;
            entryType.getProperties().remove((Object)propRefId);
        }
        DataEntityPropertyCollection propColl = entryType.getProperties();
        Iterator propIter = propColl.iterator();
        while (propIter.hasNext()) {
            IDataEntityProperty prop = (IDataEntityProperty)propIter.next();
            String propName = prop.getName();
            if (!(propName.startsWith("accfieldshow") && !propName.equals("accfieldshow") || propName.startsWith("basefactorshow") && !propName.equals("basefactorshow")) && (!propName.startsWith("asstfactorshow") || propName.equals("asstfactorshow"))) continue;
            propIter.remove();
        }
        DynamicModifyViewAndModelUtil.rebuildByDSEntityType(mainEntityType, entryKey, entryFields);
        DynamicModifyViewAndModelUtil.rebuildByAcctEntityType(mainEntityType, entryKey, acctEntryFields);
        mainEntityType.createPropIndexsNoCache();
    }

    private static MainEntityType rebuildByDSEntityType(MainEntityType mainEntityType, String entryKey, List<DSField> entryFields) {
        EntryProp entry = (EntryProp)mainEntityType.getProperty(entryKey);
        DynamicObjectType entryType = entry.getDynamicCollectionItemPropertyType();
        BasedataProp dsBasedataProp = null;
        BasedataProp baseDataProp = (BasedataProp)entryType.getProperty("basefactorshow");
        AssistantProp dsAssistantProp = null;
        AssistantProp assistantProp = (AssistantProp)entryType.getProperty("asstfactorshow");
        for (int i = 0; i < entryFields.size(); ++i) {
            DSField entryField = entryFields.get(i);
            String columnKey = entryField.getFieldKey();
            LocaleString name = entryField.getFieldName();
            if ("0".equals(entryField.getDataType())) {
                try {
                    dsBasedataProp = (BasedataProp)baseDataProp.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new KDBizException(e.getMessage());
                }
                dsBasedataProp.setBaseEntityId(entryField.getEntityId());
                dsBasedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entryField.getEntityId()));
                dsBasedataProp.setAlias(columnKey);
                dsBasedataProp.setName(columnKey);
                dsBasedataProp.setDisplayName(name);
                entryType.addProperty((DynamicProperty)dsBasedataProp);
                DynamicModifyViewAndModelUtil.addRefIdProp(entryField, dsBasedataProp, entryType);
                continue;
            }
            if (!"1".equals(entryField.getDataType())) continue;
            try {
                dsAssistantProp = (AssistantProp)assistantProp.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException(e.getMessage());
            }
            dsAssistantProp.setAsstParentId(entryField.getEntityId());
            dsAssistantProp.setAsstTypeId(entryField.getEntityId());
            dsAssistantProp.setAlias(columnKey);
            dsAssistantProp.setName(columnKey);
            dsAssistantProp.setDisplayName(name);
            entryType.addProperty((DynamicProperty)dsAssistantProp);
            DynamicModifyViewAndModelUtil.addRefIdProp(entryField, (BasedataProp)dsAssistantProp, entryType);
        }
        return mainEntityType;
    }

    private static void addRefIdProp(DSField entryField, BasedataProp dp, DynamicObjectType entryType) {
        BasedataEntityType baseEntityType = null;
        baseEntityType = dp instanceof AssistantProp ? (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)BOS_ASSISTANTDATA_DETAIL) : (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entryField.getEntityId());
        String refPropName = dp.getName() + "_id";
        if (baseEntityType.getPrimaryKey().getPropertyType() == String.class) {
            VarcharProp pRefId = new VarcharProp(true);
            pRefId.setPrimaryKey(false);
            pRefId.setDbIgnore(true);
            pRefId.setName(refPropName);
            dp.setRefIdPropName(refPropName);
            dp.setRefIdProp((IDataEntityProperty)pRefId);
            entryType.addProperty((DynamicProperty)pRefId);
        } else {
            LongProp pRefId2 = new LongProp(true);
            pRefId2.setPrimaryKey(false);
            pRefId2.setDbIgnore(true);
            pRefId2.setName(refPropName);
            dp.setRefIdPropName(refPropName);
            dp.setRefIdProp((IDataEntityProperty)pRefId2);
            entryType.addProperty((DynamicProperty)pRefId2);
        }
    }

    private static MainEntityType rebuildByAcctEntityType(MainEntityType mainEntityType, String entryKey, List<AcctTableField> entryFields) {
        EntryProp entry = (EntryProp)mainEntityType.getProperty(entryKey);
        DynamicObjectType entryType = entry.getDynamicCollectionItemPropertyType();
        AccountProp accProp = null;
        AccountProp baseDataProp = (AccountProp)entryType.getProperty("accfieldshow");
        for (int i = 0; i < entryFields.size(); ++i) {
            AcctTableField entryField = entryFields.get(i);
            String columnKey = entryField.getFieldKey();
            String name = entryField.getAcctTableName();
            try {
                accProp = (AccountProp)baseDataProp.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException(e.getMessage());
            }
            accProp.setBaseEntityId("bd_accountview");
            accProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
            accProp.setAlias(columnKey);
            accProp.setName(columnKey);
            accProp.setDisplayName(new LocaleString(name));
            accProp.setDisplayFullname(true);
            entryType.addProperty((DynamicProperty)accProp);
            DynamicModifyViewAndModelUtil.addRefIdProp(entryField, (BasedataProp)accProp, entryType);
        }
        return mainEntityType;
    }
}

