/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.edah.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.lang.constant.Constable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.BindingContext;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.fi.ai.cache.CacheHelper;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.cache.DistributeCache;
import kd.fi.ai.util.TimeUtils;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.utils.ICommonDataValueUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class EdahApphomeEdit
extends AbstractFormPlugin {
    private static String EVENTNUM = "eventnum";
    private static String EVENTHOUSENUM = "eventhousenum";
    private Long orgId = 0L;
    private List<String> typeLists1 = new ArrayList<String>();
    private List<String> typeLists2 = new ArrayList<String>();
    private String firstDayOfLastMonth = TimeUtils.getFirstDayOfLastMonth();
    private String firstDayOfMonth = TimeUtils.getFirstDayOfMonth();
    private String firstDayOfNextMonth = TimeUtils.getFirstDayOfNextMonth();
    private static final String MAP_KEY_TYPES = "types";
    private static final String MAP_KEY_NUMS = "nums";
    private static final String MAP_KEY_LNUMS = "lnums";
    private static final String sql1 = "select b.fnumber fnumber ,count(1) fnum from t_ai_event a , t_ai_eventclass b  where a.feventclass = b.fid and a.fstatus='1'  and a.forg = ? and a.fcreatetime >=to_date(?) and a.fcreatetime <to_date(?) group by b.fnumber order by count(b.fnumber) desc";
    private static final String sql2 = "select fsourcebill ,count(1) num from t_ai_bizvoucher  where forgid = ? and fcreatetime >=to_date(?) and fcreatetime <to_date(?) group by fsourcebill  order by count(fsourcebill) desc";
    private static final String CACHE_SUFFIX_CHART_DATA = "CHARTDATA";
    private static final String CACHE_SUFFIX_FINISHED = "FINISHED";

    public void initialize() {
        super.initialize();
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String callBackName = e.getName();
        this.doClientCallBack(callBackName);
    }

    private HashMap<String, Integer> getEventnumLastMonth() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.formplugin.EdahApphomeEdit", (DBRoute)DBRoute.of((String)"fi"), (String)sql1, (Object[])new Object[]{this.orgId, this.firstDayOfLastMonth, this.firstDayOfMonth});){
            Iterator iterator = queryDataSet.iterator();
            ORM orm = ORM.create();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                int num = row.getInteger("FNUM");
                String type = row.getString("FNUMBER");
                String name = this.getDataModelName(orm, type);
                if (!StringUtils.isEmpty((String)name)) {
                    type = name;
                }
                map.put(type, num);
            }
        }
        return map;
    }

    private String getDataModelName(ORM orm, String number) {
        DynamicObjectCollection datamodel = orm.query("fah_ext_datamodel", "id,name", new QFilter[]{new QFilter("number", "=", (Object)number)}, "status desc,versionnum desc", 1);
        if (!datamodel.isEmpty()) {
            return ((DynamicObject)datamodel.get(0)).getString("name");
        }
        return "";
    }

    private HashMap<String, List<Object>> getEventnumMonth() {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(2);
        ArrayList<String> types = new ArrayList<String>(5);
        ArrayList<Integer> nums = new ArrayList<Integer>(5);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.formplugin.EdahApphomeEdit", (DBRoute)DBRoute.of((String)"fi"), (String)sql1, (Object[])new Object[]{this.orgId, this.firstDayOfMonth, this.firstDayOfNextMonth});){
            Iterator iterator = queryDataSet.iterator();
            ORM orm = ORM.create();
            for (int i = 5; iterator.hasNext() && i > 0; --i) {
                Row row = (Row)iterator.next();
                int num = row.getInteger("FNUM");
                String type = row.getString("FNUMBER");
                String name = this.getDataModelName(orm, type);
                if (!StringUtils.isEmpty((String)name)) {
                    type = name;
                }
                types.add(type);
                nums.add(num);
            }
        }
        map.put(MAP_KEY_TYPES, types);
        map.put(MAP_KEY_NUMS, nums);
        return map;
    }

    private HashMap<String, Integer> getEventhousenumLastMonth() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.formplugin.EdahApphomeEdit", (DBRoute)DBRoute.of((String)"fi"), (String)sql2, (Object[])new Object[]{this.orgId, this.firstDayOfLastMonth, this.firstDayOfMonth});){
            for (Row row : queryDataSet) {
                int num = row.getInteger("NUM");
                String type = row.getString("FSOURCEBILL");
                map.put(type, num);
            }
        }
        return map;
    }

    private HashMap<String, List<Object>> getEventhousenumMonth() {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(2);
        ArrayList<String> types = new ArrayList<String>(5);
        ArrayList<Integer> nums = new ArrayList<Integer>(5);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.formplugin.EdahApphomeEdit", (DBRoute)DBRoute.of((String)"fi"), (String)sql2, (Object[])new Object[]{this.orgId, this.firstDayOfMonth, this.firstDayOfNextMonth});){
            Iterator iterator = queryDataSet.iterator();
            for (int i = 5; iterator.hasNext() && i > 0; --i) {
                Row row = (Row)iterator.next();
                int num = row.getInteger("NUM");
                String type = row.getString("FSOURCEBILL");
                types.add(type);
                nums.add(num);
            }
        }
        map.put(MAP_KEY_TYPES, types);
        map.put(MAP_KEY_NUMS, nums);
        return map;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.orgId = ObjectConverterFactory.getLong((Object)kd.fi.ai.mservice.builder.helper.CacheHelper.getOrg((String)"org"), (Long)0L);
        if (this.orgId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"EdahApphomeEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        } else {
            this.loadChartData(EVENTNUM, this::getEventNumData);
            this.loadChartData(EVENTHOUSENUM, this::getEventHouseNumData);
        }
    }

    private Axis setHandlechartXaxisTick(HistogramChart customchart, String type, List<String> types) {
        int i;
        int size;
        Axis xaxis = customchart.createXAxis(ResManager.loadKDString((String)"", (String)"EdahApphomeEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), AxisType.category);
        ArrayList<String> xDimensions = new ArrayList<String>(5);
        if (EVENTNUM.equals(type)) {
            if (types != null) {
                size = types.size() <= 5 ? types.size() : 5;
                for (i = 0; i < size; ++i) {
                    xDimensions.add(types.get(i));
                    this.typeLists1.add(types.get(i));
                }
            }
        } else if (EVENTHOUSENUM.equals(type) && types != null) {
            size = types.size() <= 5 ? types.size() : 5;
            for (i = 0; i < size; ++i) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)types.get(i));
                if (entityType.getDisplayName() != null) {
                    xDimensions.add(entityType.getDisplayName().toString());
                } else {
                    xDimensions.add(types.get(i));
                }
                this.typeLists2.add(types.get(i));
            }
        }
        xaxis.setCategorys(xDimensions);
        xaxis.setPosition(Position.bottom);
        xaxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        int[] aa = new int[]{0, 0, -25, -35};
        map.put("padding", aa);
        xaxis.setPropValue("nameTextStyle", map);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        xaxis.setPropValue("axisTick", axisTick);
        this.setLineColor(xaxis, "#999999");
        return xaxis;
    }

    private void setHandleChartData(HistogramChart customchart, List<Integer> curMonthData, List<Integer> lastMonthData) {
        Axis taskNumberAxis = customchart.createYAxis(ResManager.loadKDString((String)"(\u6761\u6570)", (String)"EdahApphomeEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), AxisType.value);
        taskNumberAxis.setPosition(Position.insideTopLeft);
        taskNumberAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, Object> map = new HashMap<String, Object>();
        int[] aa = new int[]{0, 0, 5, -45};
        map.put("padding", aa);
        taskNumberAxis.setPropValue("nameTextStyle", map);
        BarSeries expireSeries = customchart.createBarSeries(ResManager.loadKDString((String)"\u4e0a\u6708", (String)"EdahApphomeEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        expireSeries.setBarWidth("20px");
        expireSeries.setAnimationDuration(2000);
        Number[] handleTaskData = ICommonDataValueUtil.isEmptyObject(lastMonthData) ? new Integer[5] : lastMonthData.toArray(new Integer[5]);
        expireSeries.setData(handleTaskData);
        map = new HashMap();
        HashMap<String, HashMap<String, Object>> normap = new HashMap<String, HashMap<String, Object>>();
        map.put("color", "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#1E90FF'}, {\"offset\": 1, \"color\": '#1E90FF'}])");
        normap.put("normal", map);
        expireSeries.setPropValue("itemStyle", normap);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        expireSeries.addFuncPath(list);
        expireSeries.setLabel((Label)null);
        BarSeries expireSeries2 = customchart.createBarSeries(ResManager.loadKDString((String)"\u672c\u6708", (String)"EdahApphomeEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        expireSeries2.setBarWidth("20px");
        expireSeries2.setAnimationDuration(2000);
        Number[] handleTaskData2 = ICommonDataValueUtil.isEmptyObject(curMonthData) ? new Integer[5] : curMonthData.toArray(new Integer[5]);
        expireSeries2.setData(handleTaskData2);
        map = new HashMap();
        normap = new HashMap();
        map.put("color", "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#008000'}, {\"offset\": 1, \"color\": '#008000'}])");
        normap.put("normal", map);
        expireSeries2.setPropValue("itemStyle", normap);
        list = new ArrayList();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        expireSeries2.addFuncPath(list);
        expireSeries2.setLabel((Label)null);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        taskNumberAxis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        taskNumberAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(taskNumberAxis, "#999999");
        customchart.setShowLegend(true);
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setShowTooltip(true);
        customchart.bindData((BindingContext)null);
    }

    private Integer[] getHandleChartData(String type, List<String> typeLists) {
        Integer[] num;
        block2: {
            block3: {
                num = new Integer[5];
                if (typeLists == null) break block2;
                if (!EVENTNUM.equals(type)) break block3;
                HashMap<String, Integer> map = this.getEventnumLastMonth();
                for (int i = 0; i < typeLists.size(); ++i) {
                    num[i] = map.get(typeLists.get(i));
                }
                break block2;
            }
            if (!EVENTHOUSENUM.equals(type)) break block2;
            HashMap<String, Integer> map = this.getEventhousenumLastMonth();
            for (int i = 0; i < typeLists.size(); ++i) {
                num[i] = map.get(typeLists.get(i));
            }
        }
        return num;
    }

    private Integer[] getHandleChartData2(String type) {
        Integer[] num;
        block4: {
            List<Object> nums;
            HashMap<String, List<Object>> mapTypes;
            block3: {
                List<Object> nums2;
                num = new Integer[5];
                if (!EVENTNUM.equals(type)) break block3;
                HashMap<String, List<Object>> mapTypes2 = this.getEventnumMonth();
                if (mapTypes2 == null || (nums2 = mapTypes2.get(MAP_KEY_NUMS)) == null) break block4;
                int size = nums2.size() <= 5 ? nums2.size() : 5;
                for (int i = 0; i < size; ++i) {
                    num[i] = (Integer)nums2.get(i);
                }
                break block4;
            }
            if (EVENTHOUSENUM.equals(type) && (mapTypes = this.getEventhousenumMonth()) != null && (nums = mapTypes.get(MAP_KEY_NUMS)) != null) {
                int size = nums.size() <= 5 ? nums.size() : 5;
                for (int i = 0; i < size; ++i) {
                    num[i] = (Integer)nums.get(i);
                }
            }
        }
        return num;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private void doClientCallBack(String chartName) {
        HistogramChart chart = (HistogramChart)this.getControl(chartName);
        String pageId = this.getView().getPageId();
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.aieventclass);
        String keyFinish = MessageFormat.format("{0}.{1}.{2}", pageId, chartName, CACHE_SUFFIX_FINISHED);
        if (chart != null && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)cache.get(keyFinish))) {
            this.getView().hideLoading();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{chartName});
            String keyData = MessageFormat.format("{0}.{1}.{2}", pageId, chartName, CACHE_SUFFIX_CHART_DATA);
            Map chartData = (Map)FahSerializeHelper.fromJsonString((String)cache.get(keyData), Map.class);
            if (chartData != null) {
                List types;
                Object typeArr = chartData.get(MAP_KEY_TYPES);
                Object curMData = chartData.get(MAP_KEY_NUMS);
                if (!(ICommonDataValueUtil.isEmptyObject(typeArr) || ICommonDataValueUtil.isEmptyObject(curMData) || ICommonDataValueUtil.isEmptyObject((Object)(types = ((JSONArray)typeArr).toJavaList(String.class))))) {
                    List curMonthData = ((JSONArray)curMData).toJavaList(Integer.class);
                    Object lastMData = chartData.get(MAP_KEY_LNUMS);
                    ArrayList<Integer> lastMonthData = ICommonDataValueUtil.isEmptyObject(lastMData) ? new ArrayList() : ((JSONArray)lastMData).toJavaList(Integer.class);
                    this.setHandlechartXaxisTick(chart, chartName, types);
                    this.setHandleChartData(chart, curMonthData, lastMonthData);
                    chart.setMargin(Position.left, "40px");
                    chart.setMargin(Position.top, "30px");
                    chart.setLegendPropValue("itemWidth", (Object)10);
                    chart.setLegendPropValue("itemHeight", (Object)10);
                }
            }
            this.clearCache(pageId, chartName);
        } else {
            this.getView().addClientCallBack(chartName, Integer.valueOf(500));
        }
    }

    private void loadChartData(String chartName, Supplier<Map<String, List<Object>>> dataGetFunc) {
        HistogramChart chart = (HistogramChart)this.getControl(chartName);
        if (chart != null) {
            chart.clearData();
            this.getView().showLoading(null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{chartName});
            this.getView().addClientCallBack(chartName, Integer.valueOf(500));
            String pageId = this.getView().getPageId();
            ThreadPools.executeOnce((String)chartName, () -> this.asyncLoadChart(pageId, chartName, dataGetFunc));
        }
    }

    private void asyncLoadChart(String pageId, String chartName, Supplier<Map<String, List<Object>>> dataGetFunc) {
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.aieventclass);
        String key = MessageFormat.format("{0}.{1}.{2}", pageId, chartName, CACHE_SUFFIX_CHART_DATA);
        cache.put(key, FahSerializeHelper.toJsonString(dataGetFunc.get()));
        key = MessageFormat.format("{0}.{1}.{2}", pageId, chartName, CACHE_SUFFIX_FINISHED);
        cache.put(key, key);
    }

    private Map<String, List<Object>> getEventNumData() {
        HashMap<String, List<Object>> currMonthData = this.getEventnumMonth();
        List<String> types = ((List)currMonthData.get(MAP_KEY_TYPES)).stream().map(Object::toString).collect(Collectors.toList());
        Integer[] lastMonthNums = this.getHandleChartData(EVENTNUM, types);
        currMonthData.put(MAP_KEY_LNUMS, Arrays.asList((Object[])lastMonthNums));
        return currMonthData;
    }

    private Map<String, List<Object>> getEventHouseNumData() {
        HashMap<String, List<Object>> currMonthData = this.getEventhousenumMonth();
        List<String> types = ((List)currMonthData.get(MAP_KEY_TYPES)).stream().map(Object::toString).collect(Collectors.toList());
        Integer[] lastMonthNums = this.getHandleChartData(EVENTHOUSENUM, types);
        currMonthData.put(MAP_KEY_LNUMS, Arrays.asList((Object[])lastMonthNums));
        return currMonthData;
    }

    private void clearCache(String pageId, String chartName) {
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.aieventclass);
        String key = MessageFormat.format("{0}.{1}.{2}", pageId, chartName, CACHE_SUFFIX_FINISHED);
        String key1 = MessageFormat.format("{0}.{1}.{2}", pageId, chartName, CACHE_SUFFIX_CHART_DATA);
        cache.remove(key);
        cache.remove(key1);
    }
}

