/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.edah.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.TreeMenu;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeMenuClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.accsys.AccSysUtil;
import kd.fi.ai.enums.PermissonType;
import kd.fi.ai.mservice.builder.helper.CacheHelper;
import kd.fi.bd.util.QFBuilder;
import kd.fi.v2.fah.utils.ParamUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class EdahHomePlugin
extends AbstractFormPlugin
implements ClickListener,
TreeMenuClickListener {
    private static final String ORG = "org";
    private Long org = 0L;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List hasPermOrgIds = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
        if (hasPermOrgIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4e8b\u4ef6\u5e93\u9996\u9875\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EdahHomePlugin_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(ORG, "in", (Object)hasPermOrgIds);
        Map mainBooks = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)ORG, (QFilter[])qfBuilder.toArray());
        List mainOrgIds = mainBooks.values().stream().map(x -> x.getLong("org_id")).collect(Collectors.toList());
        if (!mainOrgIds.isEmpty()) {
            this.org = AccSysUtil.getDefaultAcctOrg(mainOrgIds);
            this.getModel().setValue(ORG, (Object)this.org);
            CacheHelper.putOrg((String)ORG, (String)this.org.toString());
        }
        if (ParamUtils.isNewClientOfBizVoucher()) {
            Set ids = ParamUtils.getOldMenuIds();
            this.getPageCache().put("oldMenuIds", JSON.toJSONString((Object)ids));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty prop = e.getProperty();
        ChangeData[] change = e.getChangeSet();
        DynamicObject newValue = (DynamicObject)change[0].getNewValue();
        if (ORG.equals(prop.getName()) && newValue != null) {
            String org = newValue.getString("id");
            this.refreshView(org);
        }
    }

    private void setCacheDate(String org) {
        if (null != org) {
            this.getModel().setValue(ORG, (Object)org);
            CacheHelper.putOrg((String)ORG, (String)org);
        }
    }

    private void refreshView(String org) {
        this.setCacheDate(org);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeMenu treeMenu = (TreeMenu)this.getControl("navigationbar");
        treeMenu.addTreeMenuClickListener((TreeMenuClickListener)this);
    }

    public void treeMenuClick(TreeNodeEvent evt) {
        this.isAllowOpenForm(evt.getNodeId());
    }

    public void treeMenuDoubleClick(TreeNodeEvent evt) {
        this.isAllowOpenForm(evt.getNodeId());
    }

    private void isAllowOpenForm(Object menuId) {
        Set oldMenuIds;
        String oldMenu = this.getPageCache().get("oldMenuIds");
        if (StringUtils.isEmpty((String)oldMenu) || (oldMenuIds = (Set)JSON.parseObject((String)oldMenu, HashSet.class)).contains(menuId)) {
            // empty if block
        }
    }
}

