/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class FahDeleteVoucherConfirmPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label more = (Label)this.getControl("more");
        more.addClickListener((ClickListener)this);
        Button check = (Button)this.getControl("check");
        check.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object opresult = this.getView().getFormShowParameter().getCustomParam("opresult");
        Object sourceId = this.getView().getFormShowParameter().getCustomParam("sourceId");
        Object entityname = this.getView().getFormShowParameter().getCustomParam("entityname");
        if (opresult != null && sourceId != null && entityname != null) {
            OperationResult opResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)((String)opresult), (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
            Set srcIds = (Set)SerializationUtils.fromJsonString((String)((String)sourceId), Set.class);
            String billType = (String)entityname;
            this.buildOperateResult(opResult, billType, srcIds);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("more")) {
            this.showMoreErrorInfo();
        } else if (key.equals("check")) {
            this.showMoreBill();
        }
    }

    private void showMoreErrorInfo() {
        FormShowParameter formShow = new FormShowParameter();
        formShow.setFormId("ai_showoperateionresult");
        formShow.setCustomParam("opresult", this.getView().getFormShowParameter().getCustomParam("opresult"));
        formShow.setCustomParam("sourceId", this.getView().getFormShowParameter().getCustomParam("sourceId"));
        formShow.setCustomParam("entityname", this.getView().getFormShowParameter().getCustomParam("entityname"));
        formShow.getCustomParams().put("pageid", this.getView().getFormShowParameter().getCustomParam("pageid"));
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        formShow.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "ai_showoperateionresult"));
        this.getView().showForm(formShow);
    }

    private void showMoreBill() {
        FormShowParameter formShow = new FormShowParameter();
        formShow.setFormId("ai_deletevoucher_billlist");
        formShow.setCustomParam("opresult", this.getView().getFormShowParameter().getCustomParam("opresult"));
        formShow.setCustomParam("sourceId", this.getView().getFormShowParameter().getCustomParam("sourceId"));
        formShow.setCustomParam("entityname", this.getView().getFormShowParameter().getCustomParam("entityname"));
        formShow.getCustomParams().put("pageid", this.getView().getFormShowParameter().getCustomParam("pageid"));
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        formShow.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "ai_deletevoucher_billlist"));
        this.getView().showForm(formShow);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (key.equals("ai_deletevoucher_billlist") || key.equals("ai_showoperateionresult")) {
            Object returnData = closedCallBackEvent.getReturnData();
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void buildOperateResult(OperationResult opResult, String billType, Set<Long> srcIds) {
        List successPkIds = opResult.getSuccessPkIds();
        int succSize = successPkIds.size();
        int allSize = srcIds.size();
        int errorSize = allSize - succSize;
        Label labelap = (Label)this.getControl("labelap");
        labelap.setText(this.genErrorLabelap(allSize, succSize, errorSize));
        List errorInfo = opResult.getAllErrorOrValidateInfo();
        int dataSize = 0;
        for (IOperateInfo error : errorInfo) {
            String key = "labelap" + ++dataSize;
            if (dataSize > 4) break;
            Label lab = (Label)this.getControl(key);
            lab.setText(error.getMessage());
        }
        if (dataSize == 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap2", "labelap3", "labelap4", "more"});
        }
        if (dataSize == 2) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap3", "labelap4", "more"});
        }
        if (dataSize == 3) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap4", "more"});
        }
        if (dataSize == 4) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"more"});
        }
    }

    private String genErrorLabelap(int allSize, int succSize, int errorSize) {
        return String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c\u5220\u9664\u51ed\u8bc1\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"FahDeleteVoucherConfirmPlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), allSize, succSize, errorSize);
    }
}

