/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.admin.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassHelper {
    public static Set<Class<?>> getClzFromPkg(String pkg) {
        LinkedHashSet classes = new LinkedHashSet();
        String pkgDirName = pkg.replace('.', '/');
        try {
            Enumeration<URL> urls = ClassHelper.class.getClassLoader().getResources(pkgDirName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassHelper.findClassesByFile(pkg, filePath, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                ClassHelper.findClassesByJar(pkg, jar, classes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static void findClassesByFile(String pkgName, String pkgPath, Set<Class<?>> classes) {
        File dir = new File(pkgPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirFiles = dir.listFiles(pathname -> pathname.isDirectory() || pathname.getName().endsWith("class"));
        if (dirFiles == null || dirFiles.length == 0) {
            return;
        }
        for (File f : dirFiles) {
            if (f.isDirectory()) {
                ClassHelper.findClassesByFile(pkgName + "." + f.getName(), pkgPath + "/" + f.getName(), classes);
                continue;
            }
            String className = f.getName();
            className = className.substring(0, className.length() - 6);
            Class<?> clz = ClassHelper.loadClass(pkgName + "." + className);
            if (clz == null) continue;
            classes.add(clz);
        }
    }

    private static void findClassesByJar(String pkgName, JarFile jar, Set<Class<?>> classes) {
        String pkgDir = pkgName.replace(".", "/");
        Enumeration<JarEntry> entry = jar.entries();
        while (entry.hasMoreElements()) {
            Class<?> claze;
            String className;
            JarEntry jarEntry = entry.nextElement();
            String name = jarEntry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (jarEntry.isDirectory() || !name.startsWith(pkgDir) || !name.endsWith(".class") || !(className = name.substring(0, name.length() - 6).replace("/", ".")).startsWith(pkgName) || (claze = ClassHelper.loadClass(className)) == null) continue;
            classes.add(claze);
        }
    }

    private static Class<?> loadClass(String fullClzName) {
        try {
            return Class.forName(fullClzName);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void tryAccessMethods(Object targetObj) {
        if (targetObj == null) {
            return;
        }
        for (Method method : targetObj.getClass().getDeclaredMethods()) {
            try {
                switch (method.getParameterCount()) {
                    case 0: {
                        method.invoke(targetObj, new Object[0]);
                        break;
                    }
                    case 1: {
                        method.invoke(targetObj, ClassHelper.getClassTypeValue(method.getParameterTypes()[0]));
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Object getClassTypeValue(Class<?> typeClass) {
        if (typeClass == Integer.TYPE || typeClass == Integer.class) {
            return 0;
        }
        if (typeClass == Short.TYPE || typeClass == Short.class) {
            return 0;
        }
        if (typeClass == Byte.TYPE || typeClass == Byte.class) {
            return 0;
        }
        if (typeClass == Double.TYPE || typeClass == Double.class) {
            return 0.0;
        }
        if (typeClass == Float.TYPE || typeClass == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (typeClass == Long.TYPE || typeClass == Long.class) {
            return 0L;
        }
        if (typeClass == String.class) {
            return "";
        }
        if (typeClass == Character.TYPE || typeClass == Character.class) {
            return Character.valueOf('1');
        }
        if (typeClass == Boolean.TYPE || typeClass == Boolean.class) {
            return true;
        }
        if (typeClass == BigDecimal.class) {
            return new BigDecimal(0);
        }
        if (typeClass == Date.class) {
            return new Date();
        }
        try {
            return typeClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }
}

