/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.devtools;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.cache.common.SimpleDataDistributeCacheService;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.event.DispatchFieldInfo;
import kd.fi.v2.fah.event.DispatchZoneFieldSettingInfo;
import kd.fi.v2.fah.event.DispatchZoneInfo;
import kd.fi.v2.fah.formplugin.devtools.pojo.FahEventDto;
import kd.fi.v2.fah.formplugin.devtools.task.JSONTestTask;
import kd.fi.v2.fah.formplugin.devtools.util.PerformanceUtil;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.utils.StringUtils;

public class PerformanceTestPlugin
extends AbstractFormPlugin {
    private static final SimpleDataDistributeCacheService cache = SimpleDataDistributeCacheService.getInstance();
    private static final String CACHEKEY_PREFIX = "LJXTEST_REDIS_PREFIX";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_test1", "btn_test2", "btn_test3", "btn_test4"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_test1": {
                this.testDBvsRedisMultiThread();
                break;
            }
            case "btn_test2": {
                this.testJDBCvsDB();
                break;
            }
            case "btn_test3": {
                try {
                    this.testTimeOut();
                    break;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            case "btn_test4": {
                this.updateDipsatchData();
                break;
            }
        }
    }

    private void updateDipsatchData() {
        Long dispatchid;
        String sql = "select fid,fdispatchinparams,fcreateorg from t_fah_evt_disp_scheme";
        HashMap<Long, Object> inParamMap = new HashMap<Long, Object>(16);
        HashMap<Long, Long> orgMap = new HashMap<Long, Long>(16);
        DataSet dataSet = DB.queryDataSet((String)"updateDipsatchData", (DBRoute)FAHCommonConstant.AI, (String)sql);
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String inparamStr = row.getString("fdispatchinparams");
                if (!StringUtils.isNotEmpty((String)inparamStr) || " ".equals(inparamStr)) continue;
                inParamMap.put(row.getLong("fid"), SerializationUtils.fromJsonString((String)inparamStr, Map.class));
                orgMap.put(row.getLong("fid"), row.getLong("fcreateorg"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fdispatchid,fparamfield,fparamvaluesource,fvaluezone from t_fah_evt_disp_paramcfg where (");
        for (Map.Entry entry : orgMap.entrySet()) {
            sb.append("(fdispatchid = ").append(entry.getKey()).append(" and forgid = ").append(entry.getValue()).append(")").append(" or ");
        }
        sb.deleteCharAt(sb.lastIndexOf("r"));
        sb.deleteCharAt(sb.lastIndexOf("o"));
        sb.append(")");
        HashMap<Long, Set> zonemap = new HashMap<Long, Set>(16);
        HashMap<String, Set> hashMap = new HashMap<String, Set>(16);
        DataSet dataSet2 = DB.queryDataSet((String)"updateDipsatchData2", (DBRoute)FAHCommonConstant.AI, (String)sb.toString());
        Object object2 = null;
        try {
            while (dataSet2.hasNext()) {
                Row row = dataSet2.next();
                dispatchid = row.getLong("fdispatchid");
                String paramfield = row.getString("fparamfield");
                String paramvaluesource = row.getString("fparamvaluesource");
                String valuezone = row.getString("fvaluezone");
                zonemap.computeIfAbsent(dispatchid, o -> new HashSet(16)).add(valuezone);
                hashMap.computeIfAbsent(dispatchid + valuezone, o -> new HashSet(16)).add(new PairTuple((Object)paramfield, (Object)paramvaluesource));
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet2 != null) {
                if (object2 != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        HashMap<Long, DispatchZoneFieldSettingInfo> resultMap = new HashMap<Long, DispatchZoneFieldSettingInfo>(16);
        for (Map.Entry entry : zonemap.entrySet()) {
            dispatchid = (Long)entry.getKey();
            DispatchZoneFieldSettingInfo cacheData = new DispatchZoneFieldSettingInfo();
            int index = 0;
            for (String zone : (Set)entry.getValue()) {
                String key = dispatchid + zone;
                Set fieldCfgs = (Set)hashMap.get(key);
                DispatchZoneInfo zoneInfo = new DispatchZoneInfo();
                zoneInfo.setIndex(ObjectConverterFactory.getString((Object)index++));
                zoneInfo.setZone(zone);
                if (fieldCfgs == null || fieldCfgs.isEmpty()) {
                    zoneInfo.setEnable(Boolean.valueOf(false));
                } else {
                    zoneInfo.setEnable(Boolean.valueOf(true));
                }
                if (zoneInfo.getEnable().booleanValue()) {
                    LinkedList<DispatchFieldInfo> list = new LinkedList<DispatchFieldInfo>();
                    for (PairTuple fieldCfg : fieldCfgs) {
                        DispatchFieldInfo fieldInfo = new DispatchFieldInfo();
                        fieldInfo.setDbfield((String)fieldCfg.getKey());
                        fieldInfo.setFieldsource((String)fieldCfg.getValue());
                        fieldInfo.setFieldname((String)((Map)((Map)inParamMap.get(dispatchid)).get(zone)).get(fieldInfo.getDbfield()));
                        list.add(fieldInfo);
                    }
                    zoneInfo.setFieldSettings(list);
                }
                cacheData.add((Object)zoneInfo);
            }
            resultMap.put(dispatchid, cacheData);
        }
        this.saveResultMap(resultMap);
    }

    private void saveResultMap(Map<Long, DispatchZoneFieldSettingInfo> resultMap) {
        String sql = "update t_fah_evt_disp_scheme set ffieldsetting = ? where fid = ?";
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        for (Map.Entry<Long, DispatchZoneFieldSettingInfo> entry : resultMap.entrySet()) {
            Object[] param = new Object[]{FahSerializeHelper.toJsonString((Object)entry.getValue()), entry.getKey()};
            params.add(param);
        }
        DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)sql, params);
    }

    private void testTimeOut() throws InterruptedException {
    }

    private String translateToString(List<byte[]> values) {
        StringBuilder sb = new StringBuilder();
        for (byte[] value : values) {
            if (value != null) {
                sb.append(new String(value));
                continue;
            }
            sb.append("null");
        }
        return sb.toString();
    }

    private String translateToString(byte[] value) {
        if (value != null) {
            return new String(value);
        }
        return "null";
    }

    private void testDBvsRedisMultiThread() {
        LinkedList<Future> result = new LinkedList<Future>();
        List<FahEventDto> data = PerformanceUtil.getEventDtos((Integer)this.getModel().getValue("headsize"), (Integer)this.getModel().getValue("linesize"));
        for (int i = 1; i <= 40; ++i) {
            JSONTestTask task = new JSONTestTask(i, data, (Boolean)this.getModel().getValue("flag"));
            Future submit = ThreadService.submit((Callable)task, (TaskType)TaskType.FEA_EXPORT_TASK);
            result.add(submit);
        }
        try {
            StringBuilder sb = new StringBuilder();
            for (Future future : result) {
                String message = (String)future.get();
                System.out.println(message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void testJDBCvsDB() {
        String headSql = "INSERT INTO t_fah_event_header (fid, fnumber, forgid, fsrc_systype, fsrc_sysid, fsrc_billtype, fsrc_billno, fsrc_billid, fsourceentry, fsourceentryid, fevtclassid, fevttypeid, fbizdate, fbookeddate, fruleid, fruleversion, fdispatchid, fdispatchversion, fevtlinecnt, fcreatestage, fcreatestatus, fneedacct, fbizdatastatus, fispreview, frelateid, freversestatus, fcreatetime, fmodifytime, fcreatorid, fmodifierid, frequestid, fpartitiongrpcode) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        Integer headSize = (Integer)this.getModel().getValue("headsize");
        Integer lineSize = (Integer)this.getModel().getValue("linesize");
        List<FahEventDto> data = PerformanceUtil.getEventDtos(headSize, lineSize);
        PairTuple<List<Object[]>, List<Object[]>> params = PerformanceUtil.generateInsertParams(data);
        try (TXHandle tx = TX.requiresNew();){
            try {
                long startTime = new Date().getTime();
                long endTime = new Date().getTime();
                double jdbcTime = (double)(endTime - startTime) / 1000.0;
                List headPKS = data.stream().map(o -> o.getFid()).collect(Collectors.toList());
                SqlBuilder deleteSql1 = new SqlBuilder();
                deleteSql1.appendIn("delete from t_fah_event_header where fid ", headPKS);
                DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteSql1);
                startTime = new Date().getTime();
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)headSql, (List)((List)params.getKey()));
                endTime = new Date().getTime();
                double dbTime = (double)(endTime - startTime) / 1000.0;
                SqlBuilder deleteSql2 = new SqlBuilder();
                deleteSql2.appendIn("delete from t_fah_event_header where fid ", headPKS);
                DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteSql2);
                this.getModel().setValue("message", (Object)("JDBC insert time:" + jdbcTime + " DB insert time:" + dbTime));
            }
            catch (Exception e) {
                tx.markRollback();
                this.getModel().setValue("message", (Object)e.getMessage());
            }
        }
    }
}

