/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.util.EventUtil;
import kd.fi.v2.fah.utils.FahMappingUtils;
import kd.fi.v2.fah.utils.LicenseUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class FahAccountPurposeEdit
extends AbstractFormPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("accountbook".equals(e.getProperty().getName())) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            int index = e.getChangeSet()[0].getRowIndex();
            Set<Long> selectAcctbook = this.getSelectAcctbook();
            if (newValue != oldValue) {
                this.setValueToEntry((DynamicObject)newValue, index);
            }
            if (oldValue != null) {
                selectAcctbook.remove(((DynamicObject)oldValue).getLong("id"));
            }
            if (newValue != null) {
                selectAcctbook.add(((DynamicObject)newValue).getLong("id"));
            }
            this.cacheSelectAcctbook(selectAcctbook);
            BasedataEdit acctBookEdit = (BasedataEdit)this.getControl("accountbook");
            acctBookEdit.setQFilter(new QFilter("id", "not in", selectAcctbook));
        }
    }

    private Set<Long> getSelectAcctbook() {
        Set<Long> selectAcctbook;
        if (!StringUtils.isEmpty((String)this.getPageCache().get("selectAcctbook"))) {
            selectAcctbook = (Set)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("selectAcctbook"));
        } else {
            selectAcctbook = new HashSet<Long>();
            this.cacheSelectAcctbook(selectAcctbook);
        }
        return selectAcctbook;
    }

    private void cacheSelectAcctbook(Set<Long> selectAcctbook) {
        this.getPageCache().put("selectAcctbook", SerializationUtils.serializeToBase64(selectAcctbook));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            Set<Long> selectAcctbook = this.getSelectAcctbook();
            for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
                DynamicObject accountBook = (DynamicObject)this.getModel().getValue("accountbook", i);
                this.setValueToEntry(accountBook, i);
                selectAcctbook.add(accountBook.getLong("id"));
            }
            if (QueryServiceHelper.exists((String)"fah_evt_acctgroup", (QFilter[])new QFilter[]{new QFilter("acctpurpose.id", "=", this.getModel().getValue("id"))})) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name"});
            }
            this.getModel().setDataChanged(false);
            this.cacheSelectAcctbook(selectAcctbook);
            BasedataEdit acctBookEdit = (BasedataEdit)this.getControl("accountbook");
            acctBookEdit.setQFilter(new QFilter("id", "not in", selectAcctbook));
        }
        if (!OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save"});
        }
    }

    private void setValueToEntry(DynamicObject value, int index) {
        IDataModel dataModel = this.getModel();
        if (value == null) {
            dataModel.setValue("accountingsys", null, index);
            dataModel.setValue("accountorg", null, index);
            dataModel.setValue("accounttype", null, index);
            dataModel.setValue("accounttable", null, index);
            dataModel.setValue("periodtype", null, index);
            dataModel.setValue("basecurrency", null, index);
            dataModel.setValue("exratetable", null, index);
        } else {
            dataModel.setValue("accountingsys", (Object)value.getString("accountingsys.name"), index);
            dataModel.setValue("accountorg", (Object)value.getLong("org.id"), index);
            dataModel.setValue("accounttype", (Object)value.getString("bookstype.name"), index);
            dataModel.setValue("accounttable", (Object)value.getString("accounttable.name"), index);
            dataModel.setValue("periodtype", (Object)value.getString("periodtype.name"), index);
            dataModel.setValue("basecurrency", (Object)value.getString("basecurrency.name"), index);
            dataModel.setValue("exratetable", (Object)value.getString("exratetable.name"), index);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            Map numbers;
            LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
            this.getModel().clearNoDataRow();
            if (FahMappingUtils.isNumberRepeat((String)"fah_evt_accountpurpose", (String)((String)this.getModel().getValue("number")), (Object)this.getModel().getValue("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FahAccountPurposeEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (!(numbers = EventUtil.getAcctBookNumbers(this.getSelectAcctbook(), (Object)this.getModel().getValue("id"))).isEmpty()) {
                StringBuilder msg = new StringBuilder();
                numbers.forEach((k, v) -> msg.append(String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\uff1a\u201c%1$s\u201d \u5df2\u5728\u5176\u4ed6\u6838\u7b97\u76ee\u7684\uff1a\u201c%2$s\u201d \u4e2d\u914d\u7f6e\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\u3002", (String)"FahAccountPurposeEdit_11", (String)"fi-ai-formplugin", (Object[])new Object[0]), k, v)).append("\n"));
                this.getView().showErrorNotification(msg.toString());
                args.setCancel(true);
            }
            LinkedHashSet<Long> accountOrgIds = new LinkedHashSet<Long>(16);
            LinkedHashSet<String> accountOrgNumbers = new LinkedHashSet<String>(16);
            for (DynamicObject row : this.getModel().getEntryEntity("entryentity")) {
                Long accountOrgId = row.getLong("accountorg.id");
                if (accountOrgIds.contains(accountOrgId)) {
                    String number = row.getString("accountorg.name") + "(" + row.getString("accountorg.number") + ")";
                    accountOrgNumbers.add(number);
                    continue;
                }
                accountOrgIds.add(accountOrgId);
            }
            if (!accountOrgNumbers.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6838\u7b97\u7ec4\u7ec7\u5728\u5f53\u524d\u6838\u7b97\u76ee\u7684\u4e0b\u6709\u591a\u4e2a\u8d26\u7c3f\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\uff1a\u201c%1$s\u201d\u3002", (String)"FahAccountPurposeEdit_12", (String)"fi-ai-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", accountOrgNumbers)));
                args.setCancel(true);
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        Set<Long> selectAcctbook = this.getSelectAcctbook();
        for (int i : rowIndexs) {
            selectAcctbook.remove(this.getModel().getValue("accountbook_id", i));
        }
        this.cacheSelectAcctbook(selectAcctbook);
        BasedataEdit acctBookEdit = (BasedataEdit)this.getControl("accountbook");
        acctBookEdit.setQFilter(new QFilter("id", "not in", selectAcctbook));
    }
}

