/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.dao.event.FahEventRuleDao;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.EvtReferenceFieldDto;
import kd.fi.v2.fah.utils.EventRuleUtils;
import kd.fi.v2.fah.utils.ExtractFieldUtils;
import kd.fi.v2.fah.utils.FahAcctRuleUtils;

public class FahAsstactSetPlugin
extends AbstractFormPlugin {
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String ASSGRP = "assgrp";
    private static final String ASSGRPDATA = "assgrpdata";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ASSTACT_ID = "asstactid";
    private static final String VALUE_TYPE = "valuetype";
    private static final String VALUE_SOURCE = "valuesource";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL, ASSGRP});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String sourceModel = (String)this.getView().getFormShowParameter().getCustomParam("SOURCE_MODEL");
        if (!StringUtils.isBlank((CharSequence)sourceModel)) {
            DynamicExtractFieldValueSetData fieldValueSetData = (DynamicExtractFieldValueSetData)SerializationUtils.deSerializeFromBase64((String)sourceModel);
            List fieldValueSetList = fieldValueSetData.getFieldValueSetList();
            if (null == fieldValueSetList) {
                return;
            }
            LinkedHashMap<Integer, List> asstactMap = new LinkedHashMap<Integer, List>();
            for (DynamicExtractFieldValueSet fieldValueSet : fieldValueSetList) {
                asstactMap.computeIfAbsent(fieldValueSet.getGroupSeq(), t -> new ArrayList()).add(fieldValueSet);
            }
            ArrayList<DynamicExtractFieldValueSetData> rows = new ArrayList<DynamicExtractFieldValueSetData>(asstactMap.size());
            for (List row : asstactMap.values()) {
                DynamicExtractFieldValueSetData rowData = new DynamicExtractFieldValueSetData();
                rowData.setBranchId(fieldValueSetData.getBranchId());
                rowData.setMultiBranch(fieldValueSetData.isMultiBranch());
                rowData.setFieldValueSetList(row);
                rows.add(rowData);
            }
            if (!rows.isEmpty()) {
                this.getModel().deleteEntryData(ENTRYENTITY);
                for (DynamicExtractFieldValueSetData data : rows) {
                    long referenceFieldId;
                    EvtReferenceFieldDto referenceFieldDto;
                    List valueSetList = data.getFieldValueSetList();
                    if (null == valueSetList || valueSetList.isEmpty()) {
                        return;
                    }
                    DynamicExtractFieldValueSet valueSet = (DynamicExtractFieldValueSet)valueSetList.get(0);
                    Long asstActId = valueSet.getAsstActId();
                    int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
                    this.getModel().setValue(ASSTACT_ID, (Object)asstActId, rowIndex);
                    DynamicObject asstact = (DynamicObject)this.getModel().getValue(ASSTACT_ID, rowIndex);
                    if (null == asstact) continue;
                    this.getModel().setValue(VALUE_TYPE, (Object)asstact.getString(VALUE_TYPE), rowIndex);
                    this.getModel().setValue(VALUE_SOURCE, (Object)asstact.getString("valuesource.id"), rowIndex);
                    String textValue = valueSet.getTextValue();
                    if (ExtractTypeEnum.SOURCE_FIELD == valueSet.getGetValueType()) {
                        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)((String)this.getView().getFormShowParameter().getCustomParam("billType")));
                        this.getModel().setValue(ASSGRP, (Object)FahAcctRuleUtils.getFieldLongName((String)textValue, (MainEntityType)mainEntityType), rowIndex);
                    } else if (ExtractTypeEnum.MAPPING == valueSet.getGetValueType()) {
                        Long mappingGroupId = valueSet.getMappingGroupId();
                        DynamicObject obj = QueryServiceHelper.queryOne((String)"fah_valmap_type_group", (String)"name", (QFilter[])new QFilter("id", "=", (Object)mappingGroupId).toArray());
                        if (null != obj) {
                            this.getModel().setValue(ASSGRP, (Object)obj.getString("name"), rowIndex);
                        }
                    } else if (ExtractTypeEnum.RELATION == valueSet.getGetValueType()) {
                        this.getModel().setValue(ASSGRP, (Object)ExtractTypeEnum.RELATION.getDesc().loadKDString(), rowIndex);
                    } else if (ExtractTypeEnum.REFERENCE_FIELD == valueSet.getGetValueType() && StringUtils.isNotBlank((CharSequence)textValue) && null != (referenceFieldDto = FahEventRuleDao.queryReferenceFieldById((Long)(referenceFieldId = Long.parseLong(textValue))))) {
                        String captionPrefix = "";
                        if (referenceFieldDto.getEvtLineId() == 0L) {
                            captionPrefix = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"FahDynFieldValSetDetailEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]);
                        } else {
                            String customParam = (String)this.getView().getFormShowParameter().getCustomParam("dyn_param");
                            if (null != customParam) {
                                Map param = (Map)SerializationUtils.deSerializeFromBase64((String)customParam);
                                String ruleLineName = (String)param.get("EVT_RULE_LINE_NAME");
                                captionPrefix = null != ruleLineName ? ruleLineName : "";
                            }
                        }
                        this.getModel().setValue(ASSGRP, (Object)(captionPrefix + "." + referenceFieldDto.getFieldName()), rowIndex);
                    }
                    this.getModel().setValue(ASSGRPDATA, (Object)SerializationUtils.serializeToBase64((Object)data), rowIndex);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty prop = e.getProperty();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if (ASSTACT_ID.equals(prop.getName())) {
            DynamicObject asstact = (DynamicObject)changeData.getNewValue();
            String valueType = null;
            String valueSource = null;
            if (null != asstact) {
                valueType = asstact.getString(VALUE_TYPE);
                valueSource = asstact.getString("valuesource.id");
            }
            this.getModel().setValue(VALUE_TYPE, (Object)valueType, rowIndex);
            this.getModel().setValue(VALUE_SOURCE, (Object)valueSource, rowIndex);
            this.getModel().setValue(ASSGRP, (Object)"", rowIndex);
            this.getModel().setValue(ASSGRPDATA, (Object)"", rowIndex);
        } else if (ASSGRP.equals(prop.getName()) && StringUtils.isBlank((Object)changeData.getNewValue())) {
            this.getModel().setValue(ASSGRPDATA, (Object)"", rowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnDataMapping;
        super.closedCallBack(event);
        if (null == event) {
            return;
        }
        String actionId = event.getActionId();
        if (ASSGRP.equals(actionId) && null != (returnDataMapping = (Map)event.getReturnData())) {
            this.getModel().setValue(ASSGRP, returnDataMapping.get("dynFldDesc"));
            this.getModel().setValue(ASSGRPDATA, returnDataMapping.get("dynFldVal"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "assgrp": {
                int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
                DynamicObject asstact = (DynamicObject)this.getModel().getValue(ASSTACT_ID);
                if (null == asstact) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"FahAsstactSetPlugin_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long sourcePageId = (Long)this.getView().getFormShowParameter().getCustomParam("sourcePageId");
                String assgrpdata = (String)this.getModel().getValue(ASSGRPDATA, index);
                DynamicExtractFieldValueSetData model = null;
                if (StringUtils.isNotBlank((CharSequence)assgrpdata) && null != (model = (DynamicExtractFieldValueSetData)SerializationUtils.deSerializeFromBase64((String)assgrpdata)) && !model.getFieldValueSetList().isEmpty()) {
                    ((DynamicExtractFieldValueSet)model.getFieldValueSetList().get(0)).setShowName((String)this.getModel().getValue(ASSGRP));
                }
                String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("sourceBill");
                String entryNumber = (String)this.getView().getFormShowParameter().getCustomParam("entryNumber");
                Map param = ExtractFieldUtils.buildTreeParamOfAsst((DynamicObject)asstact, (String)sourceBill, (String)entryNumber);
                this.getView().getFormShowParameter().setCustomParam("param", (Object)JSON.toJSONString((Object)param));
                EventRuleUtils.showDynamicExtractFieldForm((IFormView)this.getView(), (Long)sourcePageId, (IFormPlugin)this, (String)"fah_asstact_set", (String)ASSGRP, (String)sourceBill, (String)entryNumber, (DynamicExtractFieldValueSetData)model);
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnok": {
                DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
                if (entity.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u672a\u8bbe\u7f6e\u3002", (String)"FahAsstactSetPlugin_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicExtractFieldValueSetData returnData = new DynamicExtractFieldValueSetData();
                returnData.setAsstAct(true);
                int seq = 0;
                ArrayList<DynamicExtractFieldValueSet> totalValueSet = new ArrayList<DynamicExtractFieldValueSet>();
                HashSet<Long> asstActIdSet = new HashSet<Long>();
                for (DynamicObject row : entity) {
                    Long asstActId = row.getLong("asstactid.id");
                    if (!asstActIdSet.add(asstActId)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u4e0d\u80fd\u91cd\u590d\u3002", (String)"FahAsstactSetPlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String assgrpData = row.getString(ASSGRPDATA);
                    if (0L == asstActId) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FahAsstactSetPlugin_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (StringUtils.isBlank((CharSequence)assgrpData)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u503c\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FahAsstactSetPlugin_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicExtractFieldValueSetData data = (DynamicExtractFieldValueSetData)SerializationUtils.deSerializeFromBase64((String)assgrpData);
                    List valueSetList = data.getFieldValueSetList();
                    if (null != valueSetList) {
                        for (DynamicExtractFieldValueSet valueSet : valueSetList) {
                            valueSet.setGroupSeq(Integer.valueOf(seq));
                            valueSet.setAsstActId(asstActId);
                            totalValueSet.add(valueSet);
                        }
                    }
                    ++seq;
                }
                if (!totalValueSet.isEmpty()) {
                    returnData.setBranchId((Long)((DynamicExtractFieldValueSet)totalValueSet.get(0)).getId());
                }
                returnData.setFieldValueSetList(totalValueSet);
                HashMap<String, String> result = new HashMap<String, String>(2);
                result.put("dynFldVal", SerializationUtils.serializeToBase64((Object)returnData));
                result.put("dynFldDesc", ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"FahAsstactSetPlugin_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                this.getView().returnDataToParent(result);
                this.getView().close();
            }
        }
    }
}

