/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.EntryFieldApWrapper;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.dao.BizDimDao;
import kd.fi.v2.fah.element.Element;
import kd.fi.v2.fah.element.EntryElement;
import kd.fi.v2.fah.element.TextElement;
import kd.fi.v2.fah.formplugin.eventcenter.FahBizDimEntryGridControl;
import kd.fi.v2.fah.task.FahTaskStatus;
import kd.fi.v2.fah.task.FahTaskStatusPushService;
import kd.fi.v2.fah.utils.LicenseUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class FahBizDataQuery
extends AbstractFormPlugin
implements ProgresssListener,
RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String QUERYHISTORYENTRY = "queryhistoryentry";
    public static final String TOTAL_DATA_CACHE = "totalDataCache";
    public static final String DIM_COLUMN_LIST = "DimColumnList";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"queryvalue"});
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap1"});
        ProgressBar bar = this.getProgressBar();
        bar.addProgressListener((ProgresssListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(QUERYHISTORYENTRY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void onProgress(ProgressEvent progressEvent) {
        FahTaskStatusPushService fahTaskStatusPushService = FahBizDataQuery.getTaskStatusPushService((Long)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("batchId")));
        FahTaskStatus taskStatus = fahTaskStatusPushService.getStatus();
        int pct = null == taskStatus ? 0 : taskStatus.getPercent();
        Label progress = (Label)this.getControl("progresstext");
        if (pct != 99) {
            progressEvent.setProgress(pct);
            if (taskStatus != null) {
                String msg = taskStatus.getMsg();
                this.getModel().setValue("executioninformation_tag", (Object)msg);
                progress.setText(msg);
            }
        } else {
            this.showData();
            progressEvent.setProgress(pct);
            String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u7ef4\u5ea6\u67e5\u8be2\u5b8c\u6210", (String)"DimGroupInfoQueryService_8", (String)"fi-ai-business", (Object[])new Object[0]);
            progress.setText(msg);
            this.getModel().setValue("executioninformation_tag", (Object)msg);
            this.getProgressBar().stop();
        }
        this.getView().updateView("flexpanelap3");
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        if (QUERYHISTORYENTRY.equals(((EntryGrid)evt.getSource()).getKey())) {
            IDataModel dataModel = this.getModel();
            dataModel.setValue("queryplaninfo_tag", dataModel.getValue("entryqueryplaninfo"));
            this.getView().updateView("flexpanelap3");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DataSet dataSet = BizDimDao.getQueryHistory();
        IDataModel dataModel = this.getModel();
        int i = 0;
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            dataModel.createNewEntryRow(QUERYHISTORYENTRY);
            Date startdata = row.getDate("fcreatedt");
            Date enddata = row.getDate("fcompleteddt");
            dataModel.setValue("startdata", (Object)sdf.format(startdata), i);
            dataModel.setValue("enddata", (Object)sdf.format(enddata), i);
            dataModel.setValue("entryqueryplaninfo", (Object)row.getString("fQueryPlanInfo"), i);
            dataModel.setValue("id", (Object)row.getString("ftransid"), i);
            Long timeDiff = (enddata.getTime() - startdata.getTime()) / 1000L;
            dataModel.setValue("timeconsuming", (Object)(timeDiff + "." + (enddata.getTime() - startdata.getTime()) % 1000L + ResManager.loadKDString((String)"\u79d2", (String)"FahBizDataQuery_10", (String)"fi-ai-formplugin", (Object[])new Object[0])), i);
            ++i;
        }
        dataSet.close();
    }

    public void click(EventObject evt) {
        super.click(evt);
        if ("queryvalue".equals(((Control)evt.getSource()).getKey())) {
            String number = "defValue";
            String value = (String)this.getModel().getValue("queryvalue");
            DynamicObject asstacttype = (DynamicObject)this.getModel().getValue("asstacttype");
            String fieldtype = null;
            String baseprop = null;
            String assistprop = null;
            switch (asstacttype.getString("datatype")) {
                case "1": {
                    fieldtype = "1";
                    baseprop = asstacttype.getString("valuesource.number");
                    number = "defValueDesign";
                    break;
                }
                case "2": {
                    fieldtype = "2";
                    baseprop = "bos_assistantdata_detail";
                    assistprop = asstacttype.getString("assistanttype.number");
                    number = "defValueDesign";
                    break;
                }
                case "3": {
                    fieldtype = "6";
                    break;
                }
                case "4": {
                    fieldtype = "5";
                    break;
                }
                case "5": {
                    fieldtype = "3";
                    break;
                }
                case "6": {
                    fieldtype = "0";
                }
            }
            FormShowParameter dynamicValueImput = new FormShowParameter();
            dynamicValueImput.setFormId("fah_dynamic_valueimput");
            dynamicValueImput.getOpenStyle().setShowType(ShowType.Modal);
            dynamicValueImput.setStatus(OperationStatus.EDIT);
            dynamicValueImput.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "FahDynamicValueImput"));
            dynamicValueImput.setCustomParam("number", (Object)number);
            dynamicValueImput.setCustomParam("value", (Object)value);
            dynamicValueImput.setCustomParam("fieldtype", (Object)fieldtype);
            dynamicValueImput.setCustomParam("isFromBizDataQuery", (Object)"true");
            dynamicValueImput.setCustomParam("baseprop", (Object)baseprop);
            dynamicValueImput.setCustomParam("assistprop", (Object)assistprop);
            dynamicValueImput.setCustomParam("isMul", (Object)"true");
            this.getView().showForm(dynamicValueImput);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        if ("FahDynamicValueImput".equals(evt.getActionId()) && (returnData = evt.getReturnData()) != null) {
            IDataModel dataModel = this.getModel();
            DynamicObject asstacttype = (DynamicObject)this.getModel().getValue("asstacttype");
            String datatype = asstacttype.getString("datatype");
            LinkedList<Object> value = new LinkedList<Object>();
            switch (DataValueTypeEnum.getEnumByAsstActType((String)datatype)) {
                case BaseProp: 
                case AssistProp: {
                    HashMap valueMap = (HashMap)SerializationUtils.fromJsonString((String)((String)returnData), Map.class);
                    if (valueMap.isEmpty()) break;
                    dataModel.setValue("queryvalue", (Object)((List)valueMap.get("name")).stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
                    dataModel.setValue("valuejson", (Object)SerializationUtils.serializeToBase64(valueMap.get("id")));
                    break;
                }
                case String: {
                    Object objectValue = SerializationUtils.fromJsonString((String)((String)returnData), String.class);
                    value.add(objectValue);
                    dataModel.setValue("valuejson", (Object)SerializationUtils.serializeToBase64(value));
                    dataModel.setValue("queryvalue", objectValue);
                    break;
                }
                case Bool: {
                    break;
                }
                case Decimal: {
                    int percision = asstacttype.getInt("percision");
                    Object objectValue = SerializationUtils.fromJsonString((String)((String)returnData), BigDecimal.class);
                    BigDecimal roundedDecimal = ((BigDecimal)objectValue).setScale(percision, RoundingMode.HALF_UP);
                    value.add(roundedDecimal);
                    dataModel.setValue("valuejson", (Object)SerializationUtils.serializeToBase64(value));
                    dataModel.setValue("queryvalue", (Object)roundedDecimal.toString());
                    break;
                }
                case Date: {
                    Object objectValue = SerializationUtils.fromJsonString((String)((String)returnData), Date.class);
                    String format = "1".equals(asstacttype.getString("dateformat")) ? "yyyy-MM-dd" : "yyyy-MM";
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    String formattedDate = sdf.format(objectValue);
                    try {
                        value.add(sdf.parse(formattedDate));
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                    dataModel.setValue("valuejson", (Object)SerializationUtils.serializeToBase64(value));
                    dataModel.setValue("queryvalue", (Object)formattedDate);
                }
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRYENTITY});
    }

    private ProgressBar getProgressBar() {
        return (ProgressBar)this.getControl("progressbarap");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btnquery".equals(itemKey)) {
            long batchId = DB.genLongId((String)"t_fah_temp_trans");
            ProgressBar bar = this.getProgressBar();
            bar.start();
            bar.setPercent(0);
            Label progress = (Label)this.getControl("progresstext");
            progress.setText(ResManager.loadKDString((String)"\u5f00\u59cb\u67e5\u8be2", (String)"FahBizDataQuery_12", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            this.getPageCache().remove(TOTAL_DATA_CACHE);
            Date startdata = new Date();
            this.getPageCache().put("startdata", SerializationUtils.serializeToBase64((Object)startdata));
            this.getPageCache().put("batchId", SerializationUtils.serializeToBase64((Object)batchId));
            ThreadService.execute(() -> this.executeTask(batchId), (TaskType)TaskType.FAH_MASTER_DATA_VALIDATE);
        } else if ("btndelete".equals(itemKey)) {
            int[] indexs;
            HashSet<Long> ids = new HashSet<Long>(8);
            IDataModel dataModel = this.getModel();
            for (int index : indexs = ((EntryGrid)this.getView().getControl(QUERYHISTORYENTRY)).getSelectRows()) {
                ids.add((Long)dataModel.getValue("id", index));
            }
            if (!ids.isEmpty()) {
                BizDimDao.deleteHistory(ids);
                this.getModel().deleteEntryRows(QUERYHISTORYENTRY, indexs);
            }
            this.getView().updateView(QUERYHISTORYENTRY);
        }
    }

    private void showData() {
        FahTaskStatusPushService fahTaskStatusPushService = FahBizDataQuery.getTaskStatusPushService((Long)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("batchId")));
        Map msgMap = (Map)SerializationUtils.deSerializeFromBase64((String)fahTaskStatusPushService.getStatus().getMsg());
        List ids = (List)msgMap.get("ids");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select tr.fnumber,tr.forgid,tr.fcreatetime,tr.fid eventid,tr.fsrc_billno,tr.fsrc_billid,tr.fevtclassid,tr.fevttypeid,te.fentryid evtlineid,te.flinetypeid,te.fsrcbillentryid,te.fdimgrpvalid,th.fbooktypeid,th.forgid org,th.fperiodid,tl.faccountid,tl.fassgrpid from t_fah_event_header tr join t_fah_event_line te on tr.fid = te.fid left join t_fah_ae_headers th on tr.fid = th.fsrceventid left join t_fah_ae_lines tl on th.fid = tl.fid ", new Object[0]);
        if (ids != null && !ids.isEmpty()) {
            if (ids.size() > 500000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u547d\u4e2d\u7684\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u589e\u52a0\u8fc7\u6ee4\u6761\u4ef6\u540e\u67e5\u8be2\u3002", (String)"", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            sqlBuilder.appendIn(" where te.fentryid", ids.toArray());
        } else {
            sqlBuilder.append("where 1!=1", new Object[0]);
        }
        sqlBuilder.append(" and tr.fstatus = ?", new Object[]{"4"});
        sqlBuilder.append(" and th.fstatus = ?", new Object[]{"4"});
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);
             DataSet copyDateSet = dataSet.copy();){
            IDataModel model = this.getModel();
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int pageRow = grid.getPageRow();
            int startRowIndex = 0;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
            entryEntities.clear();
            entryEntities.setStartRowIndex(0);
            HashSet<Long> totalDataIds = new HashSet<Long>();
            for (Row row : copyDateSet) {
                totalDataIds.add(row.getLong("evtlineid"));
            }
            this.getPageCache().put(TOTAL_DATA_CACHE, SerializationUtils.serializeToBase64(totalDataIds));
            model.beginInit();
            FahBizDataQuery.queryRows(model, pageRow, startRowIndex, dataSet, this.getPageCache().get(DIM_COLUMN_LIST));
            model.setDataChanged(false);
            ((EntryGrid)this.getView().getControl(ENTRYENTITY)).getEntryState().setCurrentPageIndex(Integer.valueOf(1));
            dataEntity.getDataEntityState().setEntryRowCount(ENTRYENTITY, totalDataIds.size());
            dataEntity.getDataEntityState().setEntryPageSize(ENTRYENTITY, pageRow);
            dataEntity.getDataEntityState().setEntryStartRowIndex(ENTRYENTITY, startRowIndex);
            this.getView().updateView(ENTRYENTITY);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRYENTITY});
        }
        Date enddata = new Date();
        Date startdata = (Date)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("startdata"));
        Long batchId = (Long)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("batchId"));
        IDataModel dataModel = this.getModel();
        dataModel.createNewEntryRow(QUERYHISTORYENTRY);
        int index = dataModel.getEntryRowCount(QUERYHISTORYENTRY) - 1;
        dataModel.setValue("startdata", (Object)sdf.format(startdata), index);
        dataModel.setValue("enddata", (Object)sdf.format(enddata), index);
        Long timeDiff = (enddata.getTime() - startdata.getTime()) / 1000L;
        dataModel.setValue("timeconsuming", (Object)(timeDiff + "." + (enddata.getTime() - startdata.getTime()) % 1000L + ResManager.loadKDString((String)"\u79d2", (String)"FahBizDataQuery_10", (String)"fi-ai-formplugin", (Object[])new Object[0])), index);
        dataModel.setValue("id", (Object)batchId, index);
        String msg = (String)msgMap.get("msg");
        dataModel.setValue("entryqueryplaninfo_tag", (Object)msg, index);
        BizDimDao.insertQueryHistory((Long)batchId, (Date)startdata, (Date)enddata, (String)msg);
        dataModel.setValue("queryplaninfo_tag", (Object)msg);
        this.getView().updateView(QUERYHISTORYENTRY);
    }

    private void executeTask(Long batchId) {
        FahTaskStatusPushService fahTaskStatusPushService = FahBizDataQuery.getTaskStatusPushService(batchId);
        fahTaskStatusPushService.updateStatus(0);
        IDataModel model = this.getModel();
        BizDimDao.queryBizDimDateSet((IDataModel)model, (long)batchId);
    }

    private static FahTaskStatusPushService getTaskStatusPushService(Long taskId) {
        return new FahTaskStatusPushService("FahBizDataQuery", taskId);
    }

    public static void queryRows(IDataModel model, int pageRow, int startRowIndex, DataSet dataSet, String dimColumn) {
        HashMap<Integer, Long> dimGrpValIds = new HashMap<Integer, Long>(pageRow);
        int rowIndex = 0;
        for (Row row : dataSet.limit(startRowIndex, pageRow)) {
            model.createNewEntryRow(ENTRYENTITY);
            model.setValue("eorg", (Object)row.getLong("forgid"), rowIndex);
            model.setValue("eventid", (Object)row.getLong("eventid"), rowIndex);
            model.setValue("linetypeid", (Object)row.getLong("flinetypeid"), rowIndex);
            model.setValue("sourcebillnumber", (Object)row.getString("fsrc_billno"), rowIndex);
            model.setValue("sourcebillid", (Object)row.getLong("fsrc_billid"), rowIndex);
            model.setValue("sourcebillentryid", (Object)row.getLong("fsrcbillentryid"), rowIndex);
            model.setValue("eventclass", (Object)row.getLong("fevtclassid"), rowIndex);
            model.setValue("eventtype", (Object)row.getLong("fevttypeid"), rowIndex);
            model.setValue("period", (Object)row.getLong("fperiodid"), rowIndex);
            model.setValue("org", (Object)row.getLong("org"), rowIndex);
            model.setValue("booktype", (Object)row.getLong("fbooktypeid"), rowIndex);
            model.setValue("accountid", (Object)row.getLong("faccountid"), rowIndex);
            model.setValue("assgrp", (Object)row.getLong("fassgrpid"), rowIndex);
            dimGrpValIds.put(rowIndex, row.getLong("fdimgrpvalid"));
            ++rowIndex;
        }
        Map dimData = BizDimDao.queryDimData(new ArrayList(dimGrpValIds.values()));
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)dimColumn)) {
            List dimList = (List)SerializationUtils.deSerializeFromBase64((String)dimColumn);
            for (String dimNum : dimList) {
                for (Map.Entry indexAndDim : dimGrpValIds.entrySet()) {
                    Map dimVal = (Map)dimData.get(indexAndDim.getValue());
                    if (null == dimVal) continue;
                    model.setValue(dimNum, dimVal.get(dimNum), ((Integer)indexAndDim.getKey()).intValue());
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Map<Integer, Long> asstActTypeIdMap = this.getAsstActTypeIdMap();
        if ("asstacttype".equals(propertyName)) {
            if (newValue == null) {
                asstActTypeIdMap.remove(e.getChangeSet()[0].getRowIndex());
            } else {
                asstActTypeIdMap.put(e.getChangeSet()[0].getRowIndex(), ((DynamicObject)newValue).getLong("id"));
            }
        }
        this.cacheAsstActTypeIdMap(asstActTypeIdMap);
    }

    private void cacheAsstActTypeIdMap(Map<Integer, Long> asstActTypeIdMap) {
        this.getPageCache().put("asstActTypeIdMap", SerializationUtils.serializeToBase64(asstActTypeIdMap));
    }

    protected Map<Integer, Long> getAsstActTypeIdMap() {
        Map<Integer, Long> asstActTypeIdMap = !StringUtils.isEmpty((String)this.getView().getPageCache().get("asstActTypeIdMap")) ? (Map)SerializationUtils.deSerializeFromBase64((String)this.getView().getPageCache().get("asstActTypeIdMap")) : new TreeMap<Integer, Long>();
        return asstActTypeIdMap;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        Map<Integer, Long> asstActTypeIdMap = this.getAsstActTypeIdMap();
        IDataModel dataModel = this.getModel();
        for (int rowIndex : rowIndexs) {
            Object asstActType = dataModel.getValue("asstacttype", rowIndex);
            if (asstActType == null) continue;
            asstActTypeIdMap.remove(rowIndex);
        }
        this.cacheAsstActTypeIdMap(asstActTypeIdMap);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if ("btnquery".equals(evt.getItemKey())) {
            EntryElement element = this.getEntryElement();
            DynamicObjectCollection asstActTypes = null;
            if (!this.getAsstActTypeIdMap().isEmpty()) {
                asstActTypes = QueryServiceHelper.query((String)"ai_asstacttype", (String)"name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.getAsstActTypeIdMap().values().toArray())});
            }
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.cacheElements(this.getElementList(asstActTypes));
            this.entryBuild();
            this.getView().updateView(ENTRYENTITY);
        }
    }

    public void entryBuild() {
        this.getEntryElement().build(this.getView());
    }

    private void cacheElements(LinkedList<Element> elementList) {
        if (elementList != null) {
            this.getPageCache().put("elementList", SerializationUtils.serializeToBase64(elementList));
        }
    }

    private LinkedList<Element> getElements() {
        if (this.getPageCache().get("elementList") != null) {
            return (LinkedList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("elementList"));
        }
        return new LinkedList<Element>();
    }

    private EntryElement getEntryElement() {
        EntryElement entryElement = new EntryElement(ENTRYENTITY, true, false);
        if (!this.getElements().isEmpty()) {
            entryElement.setItems(this.getElements());
        }
        entryElement.setSplitPage(false);
        FormMetadata metadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"fah_bizdataquery", (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"fah_bizdataquery", (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
        EntryAp ap = new EntryAp();
        EntryFieldApWrapper wrapper = new EntryFieldApWrapper();
        for (ControlAp v : metadata.getItems()) {
            if (!ENTRYENTITY.equals(v.getKey())) continue;
            ap = (EntryAp)v;
            for (ControlAp controlAp : ap.getItems()) {
                ((EntryFieldAp)controlAp).setField(entityMetadata.getFieldByKey(controlAp.getKey()));
                wrapper.setSrcAp((EntryFieldAp)controlAp);
                wrapper.clearFormMetadata();
            }
        }
        entryElement.setAp(ap);
        return entryElement;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException var5) {
            throw new KDException((Throwable)var5, new ErrorCode("LoadCustomControlMetasSample", var5.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        this.getEntryElement().registerEntryProp(entryType);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        EntryElement entryElement = this.getEntryElement();
        ArrayList<EntryElement> items = new ArrayList<EntryElement>(entryElement.getItems());
        if (!items.isEmpty()) {
            items.add(entryElement);
            Optional<Element> first = items.stream().filter(x -> x.getName().equals(e.getKey())).findFirst();
            Control control = null;
            if (first.isPresent()) {
                Element element = first.get();
                control = element.getControl(this.getView());
                e.setControl(control);
            }
        }
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)e.getKey(), (CharSequence)ENTRYENTITY)) {
            FahBizDimEntryGridControl entryGrid = new FahBizDimEntryGridControl();
            entryGrid.setView(this.getView());
            entryGrid.setKey(ENTRYENTITY);
            entryGrid.setEntryKey(ENTRYENTITY);
            entryGrid.setSplitPage(true);
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                this.findControl(ENTRYENTITY);
            }
            if (oldGrid instanceof EntryGrid) {
                entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
            }
            e.setControl((Control)entryGrid);
        }
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return this.findControl(key, root.getItems());
    }

    private Control findControl(String key, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)key, (CharSequence)ctl.getKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findControl(key, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }

    private LinkedList<Element> getElementList(DynamicObjectCollection collection) {
        LinkedList<Element> entryElementList = new LinkedList<Element>();
        LinkedList<String> dimColumnList = new LinkedList<String>();
        if (collection != null && !collection.isEmpty()) {
            for (DynamicObject row : collection) {
                String fieldNumber = row.getString("number").toLowerCase();
                String fieldName = row.getString("name");
                TextElement element = new TextElement(fieldNumber, fieldName, ENTRYENTITY);
                entryElementList.add((Element)element);
                dimColumnList.add(fieldNumber);
            }
        }
        this.getPageCache().put(DIM_COLUMN_LIST, SerializationUtils.serializeToBase64(dimColumnList));
        return entryElementList;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        if (!LicenseUtil.hasFahLicenseWithUser()) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\u4e2d\u4f1a\u8ba1\u4e8b\u4ef6\u5e93\u5e94\u7528\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FahEventListPlugin_3", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(msg);
        } else {
            super.preOpenForm(e);
        }
    }
}

