/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.flex.MappingValueDaoImpl;
import kd.fi.v2.fah.models.MappingValueTypeOrg;
import kd.fi.v2.fah.utils.StringUtils;

public class FahBizDimOrgSetEdit
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static String ORGTYPE = "10";
    private static String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        boolean isFromEventRule;
        List orglist;
        super.afterCreateNewData(e);
        this.getModel().setValue("groupname", this.getView().getFormShowParameter().getCustomParam("groupName"));
        String orgCache = (String)this.getView().getFormShowParameter().getCustomParam("orgList");
        if (StringUtils.isNotEmpty((String)orgCache)) {
            orglist = (List)SerializationUtils.deSerializeFromBase64((String)orgCache);
        } else {
            MappingValueDaoImpl dao = new MappingValueDaoImpl();
            orglist = dao.queryOrgRecordsByTypeId(this.getTypeId());
        }
        Label lblTip = (Label)this.getControl("labelap");
        lblTip.setText(ResManager.loadKDString((String)"\u4e00\u4e2a\u4e1a\u52a1\u7ef4\u5ea6\u7ec4\u5408\u4e0b\uff0c\u9002\u7528\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u5728\u4e0d\u540c\u5206\u7ec4\u4e2d\u91cd\u590d\u3002", (String)"FahBizDimOrgSetEdit_01", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        this.setValueByOrgList(orglist);
        boolean bl = isFromEventRule = this.getView().getFormShowParameter().getCustomParam("isFromEventRule") != null;
        if (isFromEventRule) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity", "add_row", "delete_row"});
        }
    }

    private void setValueByOrgList(List<MappingValueTypeOrg> orglist) {
        if (orglist == null || orglist.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, orglist.size());
        int index = 0;
        for (MappingValueTypeOrg org : orglist) {
            this.getModel().setValue("number", (Object)org.getNumber(), index);
            this.getModel().setValue("name", (Object)org.getName(), index);
            this.getModel().setValue("orgid", org.getId(), index);
            this.getModel().setValue("iscustom", (Object)org.isCustom(), index);
            this.getModel().setValue("description", (Object)org.getDescription(), index);
            ++index;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "add_row": {
                this.showOrgTreeForm();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRYENTITY);
            ArrayList<MappingValueTypeOrg> result = new ArrayList<MappingValueTypeOrg>(rows.size());
            for (DynamicObject row : rows) {
                MappingValueTypeOrg org = new MappingValueTypeOrg(Long.valueOf(row.getLong("orgid")), row.getString("number"), row.getString("name"), row.getString("description"), row.getString("orgtype"), Boolean.valueOf(row.getBoolean("iscustom")));
                result.add(org);
            }
            this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(result));
            this.getView().close();
        }
    }

    private void showOrgTreeForm() {
        ListShowParameter para = new ListShowParameter();
        para.setHasRight(true);
        para.setLookUp(true);
        para.setBillFormId("bos_org");
        para.setShowTitle(false);
        para.setFormId("bos_orgtreelistf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setSelectedRows((Object[])this.getEntryOrgIDs().toArray(new Long[0]));
        para.setMultiSelect(true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "orgrangeSelected"));
        this.getView().showForm((FormShowParameter)para);
    }

    private Set<Long> getEntryOrgIDs() {
        HashSet<Long> result = new HashSet<Long>();
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject row : rows) {
            result.add(row.getLong("orgid"));
        }
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("orgrangeSelected".equals(actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            Set<Long> selectedIds = this.getSelectedIds();
            Set ids = returnData.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toSet());
            ids.removeAll(selectedIds);
            if (!ids.isEmpty()) {
                for (ListSelectedRow row : returnData) {
                    if (!ids.contains((Long)row.getPrimaryKeyValue())) continue;
                    int i = this.getModel().createNewEntryRow(ENTRYENTITY);
                    this.getModel().setValue("number", (Object)row.getNumber(), i);
                    this.getModel().setValue("name", (Object)row.getName(), i);
                    this.getModel().setValue("orgid", row.getPrimaryKeyValue(), i);
                    this.getModel().setValue("iscustom", (Object)Boolean.FALSE, i);
                    this.setDisable(i, this.isSelectCustom());
                }
            }
        }
    }

    private Set<Long> getSelectedIds() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRYENTITY);
        return rows.stream().map(o -> o.getLong("orgid")).collect(Collectors.toSet());
    }

    private void setDisable(int index, boolean isRemarkDisabled) {
        this.getView().setEnable(Boolean.FALSE, index, new String[]{"number"});
        this.getView().setEnable(Boolean.FALSE, index, new String[]{"name"});
        if (isRemarkDisabled) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"description"});
        }
    }

    private Long getTypeId() {
        return ObjectConverterFactory.getLong((Object)this.getView().getFormShowParameter().getCustomParam("groupId"));
    }

    private Boolean isSelectCustom() {
        if ("selectCustom".equals(this.getView().getFormShowParameter().getCustomParam("mode"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

