/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.ai.util.AiEventClassEditUtil;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.models.event.eventrule.ConstantValue;
import kd.fi.v2.fah.utils.StringUtils;

public class FahConstantValueEdit
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(FahConstantValueEdit.class);
    private static final String[] fields = new String[]{"integerfield", "checkboxfield", "decimalfield", "textfield", "datetimefield", "basedatafield", "assistdatafield", "assistdatainput", "basedatainput", "itemclasstypefield"};
    private static String BASEPROP = "BASEPROP";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("basedatafield");
        basedataEdit.addBeforeF7SelectListener(evt -> {
            QFilter filter = new QFilter("modeltype", "=", (Object)"BaseFormModel");
            List<String> numbers = AiEventClassEditUtil.getBasedataInfoWithoutExt(this.getView().getPageId());
            QFilter typeFilter = new QFilter("number", "not in", numbers);
            filter.and(typeFilter);
            ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
            list.getListFilterParameter().setFilter(filter);
        });
        Object assistdatafield = this.getModel().getValue("assistdatafield");
        if (assistdatafield != null) {
            BasedataEdit assistEdit = (BasedataEdit)this.getView().getControl("assistdatainput");
            assistEdit.addBeforeF7SelectListener(evt -> {
                ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
                List qFilters = list.getListFilterParameter().getQFilters();
                QFilter qFilter = new QFilter("group.id", "=", (Object)((DynamicObject)assistdatafield).getLong("id"));
                qFilters.add(qFilter);
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String value = (String)this.getView().getFormShowParameter().getCustomParam("value");
        if (StringUtils.isNotEmpty((String)value)) {
            ConstantValue constantValue = (ConstantValue)SerializationUtils.fromJsonString((String)value, ConstantValue.class);
            DataValueTypeEnum type = constantValue.getDataType();
            this.getModel().setValue("datatype", (Object)ObjectConverterFactory.getString((Object)type.getCode()));
            this.switchVisiableFieldsByDataType(type);
            Object param_value = constantValue.getValue();
            if (type == DataValueTypeEnum.BaseProp) {
                String formId = constantValue.getBaseProp();
                this.getPageCache().put(BASEPROP, formId);
                this.dynamicReviseBaseData(formId);
                this.switchVisableFields("basedatafield", "basedatainput");
                this.changeMainEntityType(formId);
                this.getModel().setValue("basedatafield", (Object)formId);
                this.getModel().setValue("basedatainput", param_value);
            } else if (type == DataValueTypeEnum.AssistProp) {
                this.switchVisableFields("assistdatafield", "assistdatainput");
                Long assistType = constantValue.getAssistProp();
                this.getModel().setValue("assistdatafield", (Object)assistType);
                this.getModel().setValue("assistdatainput", param_value);
            } else if (type == DataValueTypeEnum.Date) {
                this.getModel().setValue("datetimefield", param_value);
            } else if (type == DataValueTypeEnum.Decimal) {
                this.getModel().setValue("decimalfield", param_value);
            } else if (type == DataValueTypeEnum.Int) {
                this.getModel().setValue("integerfield", param_value);
            } else if (type == DataValueTypeEnum.Bool) {
                this.getModel().setValue("checkboxfield", param_value);
            } else if (type == DataValueTypeEnum.String) {
                this.getModel().setValue("textfield", param_value);
            }
            String detailSelect = (String)this.getView().getFormShowParameter().getCustomParam("detailselect");
            if (Boolean.TRUE.toString().equals(detailSelect)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"datatype", "basedatafield", "assistdatafield"});
            }
        } else {
            this.switchVisableFields("");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "datatype": {
                DataValueTypeEnum type = DataValueTypeEnum.getEnum((String)((String)newValue));
                this.switchVisiableFieldsByDataType(type);
                break;
            }
            case "basedatafield": {
                if (newValue != null) {
                    String formId = ((DynamicObject)this.getModel().getValue("basedatafield")).getString("number");
                    this.getPageCache().put(BASEPROP, formId);
                    this.dynamicReviseBaseData(formId);
                    this.switchVisableFields("basedatafield", "basedatainput");
                    this.changeMainEntityType(formId);
                    break;
                }
                this.switchVisableFields("basedatafield");
                break;
            }
            case "assistdatafield": {
                if (newValue != null) {
                    this.switchVisableFields("assistdatafield", "assistdatainput");
                    break;
                }
                this.switchVisableFields("assistdatafield");
            }
        }
    }

    private void switchVisiableFieldsByDataType(DataValueTypeEnum type) {
        switch (type) {
            case Int: {
                this.switchVisableFields("integerfield");
                break;
            }
            case Bool: {
                this.switchVisableFields("checkboxfield");
                break;
            }
            case Decimal: {
                this.switchVisableFields("decimalfield");
                break;
            }
            case String: {
                this.switchVisableFields("textfield");
                break;
            }
            case Date: {
                this.switchVisableFields("datetimefield");
                break;
            }
            case BaseProp: {
                this.switchVisableFields("basedatafield");
                break;
            }
            case AssistProp: {
                this.switchVisableFields("assistdatafield");
            }
        }
    }

    private void changeMainEntityType(String formId) {
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        ItemClassTypeProp prop = (ItemClassTypeProp)dataEntityType.getProperty("itemclasstypefield");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        prop.setItemType((DynamicObjectType)mainEntityType);
        ArrayList<String> baseEntityIds = new ArrayList<String>(1);
        baseEntityIds.add(formId);
        prop.setBaseEntityIds(baseEntityIds);
    }

    private void dynamicReviseBaseData(String formId) {
        IDataModel model = this.getModel();
        ItemClassTypeEdit selectDimTypeFields = (ItemClassTypeEdit)this.getView().getControl("itemclasstypefield");
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(1);
        ComboItem comboItem = new ComboItem();
        comboItem.setId(formId);
        comboItem.setValue(formId);
        comboItem.setCaption(new LocaleString(formId));
        propertyItems.add(comboItem);
        selectDimTypeFields.setComboItems(propertyItems);
        model.setValue("itemclasstypefield", (Object)formId);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType entitytype = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)entitytype.clone();
        }
        catch (CloneNotSupportedException var6) {
            logger.error(var6.getMessage(), (Throwable)var6);
            throw new KDBizException((Throwable)var6, BosErrorCode.systemError, new Object[0]);
        }
        ItemClassTypeProp prop = (ItemClassTypeProp)newMainType.getProperty("itemclasstypefield");
        String formId = this.getPageCache().get(BASEPROP);
        if (!StringUtils.isEmpty((String)formId)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
            prop.setItemType((DynamicObjectType)mainEntityType);
            ArrayList<String> baseEntityIds = new ArrayList<String>(1);
            baseEntityIds.add(formId);
            prop.setBaseEntityIds(baseEntityIds);
            e.setNewEntityType(newMainType);
        }
    }

    private void switchVisableFields(String ... field) {
        LinkedList fieldList = new LinkedList();
        Arrays.stream(fields).forEach(o -> fieldList.add(o));
        if (field != null && field.length > 0) {
            fieldList.removeAll(Arrays.asList(field));
            this.getView().setVisible(Boolean.TRUE, field);
        }
        this.getView().setVisible(Boolean.FALSE, fieldList.toArray(new String[0]));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (key = ctlSource.getKey()) {
            case "btnok": {
                ConstantValue result = new ConstantValue();
                String datatype = (String)this.getModel().getValue("datatype");
                DataValueTypeEnum typeEnum = DataValueTypeEnum.getEnum((String)datatype);
                result.setDataType(typeEnum);
                if (DataValueTypeEnum.BaseProp == typeEnum) {
                    DynamicObject basedatainput = (DynamicObject)this.getModel().getValue("basedatainput");
                    if (basedatainput == null) {
                        this.getView().close();
                        return;
                    }
                    result.setBaseProp(((DynamicObject)this.getModel().getValue("basedatafield")).getString("number"));
                    result.setValue((Object)basedatainput.getLong("id"));
                    String baseDataName = ((DynamicObject)this.getModel().getValue("basedatafield")).getString("name");
                    result.setName(baseDataName + "\uff1a" + basedatainput.getString("name"));
                } else if (DataValueTypeEnum.AssistProp == typeEnum) {
                    DynamicObject assistdatainput = (DynamicObject)this.getModel().getValue("assistdatainput");
                    if (assistdatainput == null) {
                        this.getView().close();
                        return;
                    }
                    result.setAssistProp(Long.valueOf(((DynamicObject)this.getModel().getValue("assistdatafield")).getLong("id")));
                    result.setValue((Object)assistdatainput.getLong("id"));
                    String assistDataName = ((DynamicObject)this.getModel().getValue("assistdatafield")).getString("name");
                    result.setName(assistDataName + "\uff1a" + assistdatainput.getString("name"));
                } else if (DataValueTypeEnum.Date == typeEnum) {
                    result.setValue(this.getModel().getValue("datetimefield"));
                } else if (DataValueTypeEnum.Int == typeEnum) {
                    result.setValue(this.getModel().getValue("integerfield"));
                } else if (DataValueTypeEnum.Decimal == typeEnum) {
                    result.setValue(this.getModel().getValue("decimalfield"));
                } else if (DataValueTypeEnum.String == typeEnum) {
                    result.setValue(this.getModel().getValue("textfield"));
                } else if (DataValueTypeEnum.Bool == typeEnum) {
                    result.setValue(this.getModel().getValue("checkboxfield"));
                }
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)result));
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
            }
        }
    }
}

