/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchFormulaFilterSetRow;
import kd.fi.ai.VchFormulaFilterset;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.cache.CacheBuildTree;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityFieldUtil;
import kd.fi.ai.util.EntityTreeUtil;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.utils.StringUtils;

public class FahDynFieldValSetEdit
extends AbstractFormPlugin {
    private static final String NON_FIELDS = "nonFields";
    private static final String ENTRY_VCHSETENTRY = "fieldsetentry";
    private static final String KEY_FIELDEXPDESC = "fieldexpdesc";
    private static final String KEY_FIELDEXP = "fieldexp";
    private static final String KEY_FFILTER = "filter";
    private static final String KEY_FFILTERDESCRIPTION = "ffilterdescription";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    public static final String CACHEKEY_DYNFIELD_FILTERSETJSON = "dynFieldFilterSetJson";
    private static final String BUILD = "build";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL, KEY_FIELDEXPDESC, KEY_FFILTERDESCRIPTION});
    }

    public void afterCreateNewData(EventObject e) {
        String sourceBill;
        super.afterCreateNewData(e);
        String filterJson = (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_DYNFIELD_FILTERSETJSON);
        if (!kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)filterJson)) {
            VchExpireDate expireDate = (VchExpireDate)SerializationUtils.fromJsonString((String)filterJson, VchExpireDate.class);
            this.setVchFormulaFilterSet((VchFormulaFilterset)expireDate);
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("sourceBill")))) {
            MainEntityType srcMainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
            this.fillExprFields(srcMainEntityType, KEY_FIELDEXPDESC, null);
            this.fillExprFields(srcMainEntityType, KEY_FFILTERDESCRIPTION, null);
        }
        this.getView().getFormShowParameter().setCustomParam(BUILD, (Object)sourceBill);
        this.getPageCache().put(BUILD, (String)this.getView().getFormShowParameter().getCustomParam(BUILD));
        CacheBuildTree.setPageCacheByType((FormShowParameter)this.getView().getFormShowParameter(), (IPageCache)this.getPageCache());
    }

    private void fillExprFields(MainEntityType srcMainET, String cacheKey, Class<?> fieldType) {
        if (srcMainET == null) {
            this.getPageCache().put(cacheKey, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)srcMainET);
            option.setReadEntryEntity(true);
            option.setExprType(ExpressionType.Formula);
            option.setFieldType(fieldType);
            option.setIncludeID(true);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            this.getPageCache().put(NON_FIELDS + cacheKey, SerializationUtils.toJsonString((Object)result.getNonFields()));
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put(cacheKey, toJson);
        }
    }

    protected void setVchFormulaFilterSet(VchFormulaFilterset vchFormulaFilterSet) {
        int rowCount = this.getModel().getEntryRowCount(ENTRY_VCHSETENTRY);
        if (rowCount < vchFormulaFilterSet.getItems().size()) {
            this.getModel().batchCreateNewEntryRow(ENTRY_VCHSETENTRY, vchFormulaFilterSet.getItems().size() - rowCount);
        }
        for (int i = 0; i < vchFormulaFilterSet.getItems().size(); ++i) {
            VchFormulaFilterSetRow vchFormulaFilterRow = (VchFormulaFilterSetRow)vchFormulaFilterSet.getItems().get(i);
            VchTplExpression fieldExp = vchFormulaFilterRow.getFieldExp();
            this.getModel().setValue(KEY_FIELDEXP, (Object)SerializationUtils.toJsonString((Object)fieldExp), i);
            String fieldExpDesc = fieldExp.getDescription().toString();
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)fieldExpDesc)) {
                fieldExpDesc = fieldExp.getExprTran();
            }
            this.getModel().setValue(KEY_FIELDEXPDESC, (Object)fieldExpDesc, i);
            VchTplExpression filterObj = vchFormulaFilterRow.getFilterSet();
            this.getModel().setValue(KEY_FFILTER, (Object)SerializationUtils.toJsonString((Object)filterObj), i);
            String dsp = filterObj.getDescription().toString();
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(KEY_FFILTERDESCRIPTION, (Object)dsp, i);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "fieldexpdesc": {
                this.showFormulaForm();
                break;
            }
            case "ffilterdescription": {
                this.showConditionForm();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnok": {
                this.returnData();
                this.getView().close();
                break;
            }
        }
    }

    private void returnData() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY_VCHSETENTRY);
        if (entity.isEmpty()) {
            return;
        }
        DynamicExtractFieldValueSetData fieldValueData = new DynamicExtractFieldValueSetData();
        ArrayList<DynamicExtractFieldValueSet> fieldValueSetList = new ArrayList<DynamicExtractFieldValueSet>(entity.size());
        for (int i = 0; i < entity.size(); ++i) {
            DynamicObject row = (DynamicObject)entity.get(i);
            String fieldExp = row.getString(KEY_FIELDEXP);
            String filterStr = row.getString(KEY_FFILTER);
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)fieldExp)) continue;
            DynamicExtractFieldValueSet fieldValueSet = (DynamicExtractFieldValueSet)SerializationUtils.deSerializeFromBase64((String)fieldExp);
            fieldValueSet.setBranchSeq(Integer.valueOf(i));
            fieldValueSet.setExpressionValue(filterStr);
            fieldValueSetList.add(fieldValueSet);
            if (i != 0) continue;
            fieldValueData.setBranchId((Long)fieldValueSet.getId());
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (!fieldValueSetList.isEmpty()) {
            fieldValueData.setMultiBranch(true);
            fieldValueData.setFieldValueSetList(fieldValueSetList);
            String dataStr = SerializationUtils.serializeToBase64((Object)fieldValueData);
            result.put("dynFldVal", dataStr);
            result.put("dynFldDesc", this.getModel().getValue(KEY_FIELDEXPDESC, 0));
        }
        this.getView().returnDataToParent(result);
    }

    private void showConditionForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_condition");
        int row = this.getModel().getEntryCurrentRowIndex(ENTRY_VCHSETENTRY);
        String conditionJson = (String)this.getModel().getValue(KEY_FFILTER, row);
        showParameter.getCustomParams().put("formula", conditionJson);
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("sourceBill");
        showParameter.getCustomParams().put("entitynumber", sourceBill);
        showParameter.getCustomParams().put("treenodes", this.getPageCache().get(KEY_FFILTERDESCRIPTION));
        showParameter.setCustomParam("ai_vchtemplatecachekey", (Object)EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView()));
        showParameter.setCustomParam("ai_button_key", (Object)"ai_expression-fvchtypedesc");
        String funcsXML = this.getPageCache().get("functiontypes");
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        CacheBuildTree.setBuildByType((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_FFILTERDESCRIPTION));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showFormulaForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fah_dyn_extfld_setdetail");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_FIELDEXPDESC));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("sourcePage", this.getView().getFormShowParameter().getCustomParam("sourcePage"));
        showParameter.setCustomParam("sourcePageId", this.getView().getFormShowParameter().getCustomParam("sourcePageId"));
        showParameter.setCustomParam("sourcePageField", this.getView().getFormShowParameter().getCustomParam("sourcePageField"));
        showParameter.setCustomParam("entryNumber", this.getView().getFormShowParameter().getCustomParam("entryNumber"));
        showParameter.setCustomParam("source_bill_field_vals", this.getView().getFormShowParameter().getCustomParam("source_bill_field_vals"));
        if (StringUtils.isNotEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("sourceBill")))) {
            showParameter.setCustomParam("sourceBill", this.getView().getFormShowParameter().getCustomParam("sourceBill"));
        }
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (KEY_FIELDEXPDESC.equalsIgnoreCase(actionId)) {
            this.receiveExpressionSet(closedCallBackEvent);
        }
        if (KEY_FFILTERDESCRIPTION.equalsIgnoreCase(actionId) && closedCallBackEvent.getReturnData() != null) {
            String returnStr = (String)closedCallBackEvent.getReturnData();
            VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)returnStr, VchReturnData.class);
            this.receiveFilter(retData.getDataStr());
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_VCHSETENTRY);
            if (kd.bos.dataentity.utils.StringUtils.isBlank((Object)returnData) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)((String)returnData.get("dynFldVal")))) {
                this.getModel().setValue(KEY_FIELDEXP, (Object)"", rowIndex);
                this.getModel().setValue(KEY_FIELDEXPDESC, (Object)"", rowIndex);
            } else {
                String dataStr = (String)returnData.get("dynFldVal");
                DynamicExtractFieldValueSet fieldValueSet = (DynamicExtractFieldValueSet)SerializationUtils.deSerializeFromBase64((String)dataStr);
                fieldValueSet.setBranchSeq(Integer.valueOf(rowIndex));
                this.getModel().setValue(KEY_FIELDEXP, (Object)SerializationUtils.serializeToBase64((Object)fieldValueSet), rowIndex);
                this.getModel().setValue(KEY_FIELDEXPDESC, returnData.get("dynFldDesc"), rowIndex);
            }
        }
    }

    private void receiveFilter(String filterJson) {
        int row = this.getModel().getEntryCurrentRowIndex(ENTRY_VCHSETENTRY);
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)filterJson)) {
            this.getModel().setValue(KEY_FFILTER, (Object)"", row);
            this.getModel().setValue(KEY_FFILTERDESCRIPTION, (Object)"", row);
        } else {
            VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filterJson, VchTplExpression.class);
            this.getModel().setValue(KEY_FFILTER, (Object)filterJson, row);
            String dsp = filterObj.getDescription().toString();
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(KEY_FFILTERDESCRIPTION, (Object)dsp, row);
        }
    }
}

