/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.utils.StringUtils;

public class FahEventDispatchSchemeEntryEdit
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_addrow"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("valuezone", (Object)this.getValueZone());
        String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
        if (StringUtils.isNotEmpty((String)number)) {
            this.getModel().setValue("number", (Object)number);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key) && !this.validateCanSave()) {
            args.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getValue("id") != null && (Long)this.getModel().getValue("id") != 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        int index = 0;
        for (DynamicObject obj : entryentity) {
            this.getModel().setValue("rule_name", (Object)obj.getDynamicObject("evtgenrule").getString("name"), index);
            ++index;
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_addrow": {
                ListShowParameter parameter = new ListShowParameter();
                parameter.setFormId("bos_templatetreelistf7");
                parameter.setLookUp(true);
                parameter.setBillFormId("fah_evt_gen_rule");
                parameter.setMultiSelect(true);
                parameter.setSelectedRows(this.getSelectRowPks());
                QFilter qFilter = new QFilter("sourceentry", "=", (Object)this.getValueZone());
                qFilter.and("group", "=", (Object)this.getSourceBill());
                parameter.getListFilterParameter().setFilter(qFilter);
                StyleCss css = new StyleCss();
                css.setWidth("960");
                css.setHeight("580");
                parameter.getOpenStyle().setInlineStyleCss(css);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "event_rule"));
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if (StringUtils.isEmpty((Object)returnData)) {
            return;
        }
        switch (event.getActionId()) {
            case "event_rule": {
                this.getModel().deleteEntryData(ENTRYENTITY);
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, ((ListSelectedRowCollection)returnData).size());
                int index = 0;
                for (ListSelectedRow data : (ListSelectedRowCollection)returnData) {
                    this.getModel().setValue("evtgenrule", data.getPrimaryKeyValue(), index++);
                }
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("evtgenrule".equals(propertyName)) {
            if (null != newValue) {
                this.getModel().setValue("rule_name", (Object)((DynamicObject)newValue).getString("name"), e.getChangeSet()[0].getRowIndex());
            } else {
                this.getModel().setValue("rule_name", null);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key)) {
            this.getView().returnDataToParent((Object)ObjectConverterFactory.getLong((Object)this.getModel().getValue("id")));
            this.getView().close();
        }
    }

    private boolean validateCanSave() {
        DynamicObjectCollection objs = this.getModel().getEntryEntity(ENTRYENTITY);
        if (objs == null || objs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u4e8b\u4ef6\u89c4\u5219\u5206\u5f55\u3002", (String)"FahEventDispatchSchemeEntryEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String getSourceBill() {
        return (String)this.getView().getFormShowParameter().getCustomParam("sourceBill");
    }

    private String getValueZone() {
        return (String)this.getView().getFormShowParameter().getCustomParam("zone");
    }

    private Object[] getSelectRowPks() {
        DynamicObjectCollection objs = this.getModel().getEntryEntity(ENTRYENTITY);
        List list = objs.stream().map(o -> o.getDynamicObject("evtgenrule").getLong("id")).collect(Collectors.toList());
        return list.toArray();
    }
}

