/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.utils.LicenseUtil;

public class FahEventListPlugin
extends AbstractListPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"generatexla", "generategl"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getCustomParam("isInContainer") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"genbizdimgrp"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblclose"});
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumns = args.getSchemeFilterColumns();
        ListIterator iterator = filterColumns.listIterator();
        HashSet<String> noShowFieldNames = new HashSet<String>();
        noShowFieldNames.add("billstatus");
        noShowFieldNames.add("createtime");
        noShowFieldNames.add("creator.number");
        noShowFieldNames.add("creator.name");
        noShowFieldNames.add("modifier.number");
        noShowFieldNames.add("modifier.name");
        noShowFieldNames.add("modifytime");
        noShowFieldNames.add("auditor.number");
        noShowFieldNames.add("auditor.name");
        noShowFieldNames.add("auditdate");
        while (iterator.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)iterator.next();
            if (!noShowFieldNames.contains(filterColumn.getFieldName())) continue;
            iterator.remove();
        }
        args.getCommonFilterColumns().removeIf(v -> "createtime".equals(v.getFieldName()));
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            if (this.getRequestId() == null) continue;
            filterColumn.setDefaultValue(null);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent hyperClick = args.getHyperLinkClickEvent();
        String key = hyperClick.getFieldName();
        if ("sourcebillno".equals(key)) {
            args.setCancel(true);
            BillList billList = (BillList)this.getControl("BillListAp");
            BillShowParameter showParameter = new BillShowParameter();
            DynamicObject event = QueryServiceHelper.queryOne((String)"fah_event", (String)"src_billtype,src_billid", (QFilter[])new QFilter[]{new QFilter("id", "=", billList.getFocusRowPkId())});
            showParameter.setFormId(event.getString("src_billtype"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPkId((Object)event.getLong("src_billid"));
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("rule_number".equals(key)) {
            args.setCancel(true);
            BillList billList = (BillList)this.getControl("BillListAp");
            DynamicObject event = QueryServiceHelper.queryOne((String)"fah_event", (String)"rule.id ruleid", (QFilter[])new QFilter[]{new QFilter("id", "=", billList.getFocusRowPkId())});
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("fah_evt_gen_rule");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPkId((Object)event.getString("ruleid"));
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("billno".equals(key)) {
            if (this.getView().getFormShowParameter().getCustomParam("isInContainer") != null) {
                args.setCancel(true);
                ListShowParameter listshowParameter = (ListShowParameter)this.getView().getFormShowParameter();
                BillList billList = (BillList)this.getControl("BillListAp");
                BillShowParameter showParameter = new BillShowParameter();
                DynamicObject event = QueryServiceHelper.queryOne((String)"fah_event", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", billList.getFocusRowPkId())});
                showParameter.setFormId("fah_event");
                showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
                showParameter.setPkId((Object)event.getLong("id"));
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setCustomParam("isInContainer", (Object)true);
                showParameter.setCustomParam("linkids", (Object)JSON.toJSONString((Object)listshowParameter.getLinkQueryPkIdCollection()));
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if ("relate".equals(key)) {
            args.setCancel(true);
            BillShowParameter bill = new BillShowParameter();
            bill.setFormId("fah_event");
            BillList billList = (BillList)this.getControl("BillListAp");
            DynamicObject event = QueryServiceHelper.queryOne((String)"fah_event", (String)"relateid", (QFilter[])new QFilter[]{new QFilter("id", "=", billList.getFocusRowPkId())});
            bill.setPkId((Object)event.getLong("relateid"));
            bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bill.setHasRight(true);
            this.getView().showForm((FormShowParameter)bill);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("eventgenlines".equals(args.getOperateKey()) || "viewsubledger".equals(args.getOperateKey()) || "genbizdimgrp".equals(args.getOperateKey())) {
            // empty if block
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        super.billClosedCallBack(e);
        this.reload();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long requestId = this.getRequestId();
        if (requestId != null) {
            e.getQFilters().add(new QFilter("requestid", "in", (Object)requestId));
        }
        e.getQFilters().add(new QFilter("status", "=", (Object)"4"));
    }

    private Long getRequestId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("requestId");
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        if (!LicenseUtil.hasFahLicenseWithUser()) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\u4e2d\u4f1a\u8ba1\u4e8b\u4ef6\u5e93\u5e94\u7528\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FahEventListPlugin_3", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(msg);
        } else {
            super.preOpenForm(e);
        }
    }

    private static class MyListDataProvider
    extends ListDataProvider {
        private MyListDataProvider() {
        }

        public void setListFields(List<ListField> keyFields) {
            ListField relateId = new ListField("relateid");
            relateId.setFieldName("relateid");
            keyFields.add(relateId);
            super.setListFields(keyFields);
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("relate", String.class, (Object)""));
            HashSet<Long> relateIds = new HashSet<Long>(16);
            for (DynamicObject row : rows) {
                long relateId = row.getLong("relateid");
                if (relateId == 0L) continue;
                relateIds.add(relateId);
            }
            DynamicObjectCollection datas = QueryServiceHelper.query((String)"fah_event", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", relateIds)});
            HashMap relateMap = new HashMap(16);
            datas.forEach(v -> relateMap.put(v.getLong("id"), v.getString("billno")));
            for (DynamicObject row : rows) {
                long relateId = row.getLong("relateid");
                if (relateId == 0L) continue;
                row.set("relate", relateMap.get(relateId));
            }
            return rows;
        }
    }
}

