/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.v2.fah.constant.enums.EvtRelationEnum;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.EvtRuleRelationDetailsDto;
import kd.fi.v2.fah.models.event.eventrule.EvtRuleRelationFieldMappingDto;
import kd.fi.v2.fah.models.event.eventrule.EvtRuleRelationPluginDto;
import kd.fi.v2.fah.utils.ExtractFieldUtils;
import kd.fi.v2.fah.utils.FahAcctRuleUtils;

public class FahEvtRelationSetEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String Key_btnOK = "btnok";
    private static final String Key_btnCancel = "btncancel";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String SUBENTRY_ID = "subentryid";
    private static final String LINE_TYPE = "linetype";
    private static final String EVENT_RULE = "eventrule";
    private static final String BILL_TYPE = "billtype";
    private static final String RELATION_TYPE = "relationtype";
    private static final String RELATION = "relation";
    private static final String RELATION_VAL = "relationval";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel, RELATION});
        BasedataEdit eventRuleEdit = (BasedataEdit)this.getControl(EVENT_RULE);
        eventRuleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
        if (StringUtils.isEmpty((CharSequence)data)) {
            DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            Long lineType = (Long)this.getView().getFormShowParameter().getCustomParam(LINE_TYPE);
            for (int i = 0; i < entity.size(); ++i) {
                this.getModel().setValue(LINE_TYPE, (Object)lineType, i);
            }
        } else {
            this.setHistoryData(data);
        }
    }

    private void setHistoryData(String data) {
        List dataList = (List)JSON.parseObject((String)data, (TypeReference)new TypeReference<List<EvtRuleRelationDetailsDto>>(){}, (Feature[])new Feature[0]);
        if (!dataList.isEmpty()) {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, dataList.size());
            for (int i = 0; i < dataList.size(); ++i) {
                EvtRuleRelationDetailsDto dto = (EvtRuleRelationDetailsDto)dataList.get(i);
                this.getModel().setValue(SUBENTRY_ID, (Object)dto.getSubEntryId(), i);
                this.getModel().setValue(LINE_TYPE, (Object)dto.getLineType(), i);
                this.getModel().setValue(EVENT_RULE, (Object)dto.getEventRule(), i);
                this.getModel().setValue(BILL_TYPE, (Object)dto.getBillType(), i);
                this.getModel().setValue(RELATION_TYPE, (Object)dto.getRelationType(), i);
                if (EvtRelationEnum.BOTP == EvtRelationEnum.getEnum((String)dto.getRelationType())) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{RELATION});
                }
                if (!StringUtils.isNotEmpty((CharSequence)dto.getRelationVal())) continue;
                if (EvtRelationEnum.BILL_FIELD == EvtRelationEnum.getEnum((String)dto.getRelationType())) {
                    String relationDesc = FahEvtRelationSetEdit.getRelationDesc(dto.getRelationVal());
                    this.getModel().setValue(RELATION, (Object)relationDesc, i);
                    this.getModel().setValue(RELATION_VAL, (Object)dto.getRelationVal(), i);
                    continue;
                }
                if (EvtRelationEnum.PLUGIN != EvtRelationEnum.getEnum((String)dto.getRelationType())) continue;
                EvtRuleRelationPluginDto pluginDto = (EvtRuleRelationPluginDto)JSON.parseObject((String)dto.getRelationVal(), EvtRuleRelationPluginDto.class);
                this.getModel().setValue(RELATION, (Object)pluginDto.getDescription(), i);
                this.getModel().setValue(RELATION_VAL, (Object)dto.getRelationVal(), i);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        super.afterAddRow(e);
        Long lineType = (Long)this.getView().getFormShowParameter().getCustomParam(LINE_TYPE);
        for (RowDataEntity rowData : rowDataEntities = e.getRowDataEntities()) {
            this.getModel().setValue(LINE_TYPE, (Object)lineType, rowData.getRowIndex());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "btnok": {
                DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                if (entity.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u914d\u7f6e\u4e00\u884c\u6570\u636e\u3002", (String)"FahEvtRelationSetEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                int rowIndex = 1;
                LinkedHashMap<Integer, List> error = new LinkedHashMap<Integer, List>();
                for (DynamicObject row : entity) {
                    Object relation;
                    String string;
                    DynamicObject eventrule = row.getDynamicObject(EVENT_RULE);
                    if (null == eventrule) {
                        error.computeIfAbsent(rowIndex, t -> new ArrayList()).add(ResManager.loadKDString((String)"\u5173\u8054\u4e8b\u4ef6\u89c4\u5219", (String)"FahEvtRelationSetEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                    if (StringUtils.isEmpty((CharSequence)(string = row.getString(RELATION_TYPE)))) {
                        error.computeIfAbsent(rowIndex, t -> new ArrayList()).add(ResManager.loadKDString((String)"\u5173\u8054\u5173\u7cfb", (String)"FahEvtRelationSetEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    } else if (!EvtRelationEnum.BOTP.getCode().equals(string) && StringUtils.isEmpty((CharSequence)(relation = row.getString(RELATION)))) {
                        error.computeIfAbsent(rowIndex, t -> new ArrayList()).add(ResManager.loadKDString((String)"\u5173\u8054\u903b\u8f91\u8bbe\u7f6e", (String)"FahEvtRelationSetEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                    ++rowIndex;
                }
                if (!error.isEmpty()) {
                    StringBuilder errorInfo = new StringBuilder();
                    int count = 0;
                    for (Map.Entry entry : error.entrySet()) {
                        errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u7684", (String)"FahEvtRelationSetEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), entry.getKey()));
                        for (String info : (List)entry.getValue()) {
                            errorInfo.append(info).append("\uff0c");
                        }
                        errorInfo.deleteCharAt(errorInfo.length() - 1);
                        errorInfo.append(ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"FahEvtRelationSetEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        if (++count < error.size()) {
                            errorInfo.append("\uff1b\r\n");
                            continue;
                        }
                        errorInfo.append("\u3002\r\n");
                    }
                    this.getView().showTipNotification(errorInfo.toString());
                    return;
                }
                ArrayList<EvtRuleRelationDetailsDto> data = new ArrayList<EvtRuleRelationDetailsDto>(entity.size());
                for (DynamicObject row : entity) {
                    EvtRuleRelationDetailsDto evtRuleRelationDetailsDto = new EvtRuleRelationDetailsDto();
                    evtRuleRelationDetailsDto.setSubEntryId(Long.valueOf(row.getLong(SUBENTRY_ID)));
                    evtRuleRelationDetailsDto.setLineType(Long.valueOf(row.getLong("linetype.id")));
                    evtRuleRelationDetailsDto.setEventRule(Long.valueOf(row.getLong("eventrule.id")));
                    evtRuleRelationDetailsDto.setBillType(row.getString("billtype.id"));
                    evtRuleRelationDetailsDto.setRelationType(row.getString(RELATION_TYPE));
                    evtRuleRelationDetailsDto.setRelationVal(row.getString(RELATION_VAL));
                    data.add(evtRuleRelationDetailsDto);
                }
                this.getView().returnDataToParent((Object)JSON.toJSONString(data));
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "relation": {
                EvtRelationEnum evtRelationEnum;
                String relationVal;
                DynamicObject eventRule = (DynamicObject)this.getModel().getValue(EVENT_RULE);
                if (null == eventRule) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u4e8b\u4ef6\u89c4\u5219\u3002", (String)"FahEvtRelationSetEdit_8", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object relationType = this.getModel().getValue(RELATION_TYPE);
                if (null == relationType) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u5173\u7cfb\u3002", (String)"FahEvtRelationSetEdit_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setCustomParam("sourcebill", this.getView().getFormShowParameter().getCustomParam("sourcebill"));
                formShowParameter.setCustomParam("sourcefield", this.getView().getFormShowParameter().getCustomParam("sourcefield"));
                formShowParameter.setCustomParam("targetbill", (Object)eventRule.getString("group.id"));
                DynamicObjectCollection evtRuleLine = eventRule.getDynamicObjectCollection("evtrule_line");
                if (null != evtRuleLine) {
                    Long lineType = (Long)this.getModel().getValue("linetype_id");
                    for (DynamicObject line : evtRuleLine) {
                        Long targetLineType = line.getLong("entry_linetype.id");
                        if (null == lineType || !lineType.equals(targetLineType)) continue;
                        DynamicExtractFieldValueSetData amountData = ExtractFieldUtils.loadDynamicExtractFieldValueSetData((Long)line.getLong("entry_amountid"));
                        if (null == amountData) break;
                        String amountField = ((DynamicExtractFieldValueSet)amountData.getFieldValueSetList().get(0)).getTextValue();
                        formShowParameter.setCustomParam("targetfield", (Object)amountField);
                        break;
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(relationVal = (String)this.getModel().getValue(RELATION_VAL)))) {
                    formShowParameter.getCustomParams().put("data", relationVal);
                }
                if (EvtRelationEnum.BILL_FIELD == (evtRelationEnum = EvtRelationEnum.getEnum((String)((String)relationType)))) {
                    formShowParameter.setFormId("fah_evt_relation_fieldset");
                    formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fah_evt_relation_fieldset"));
                    this.getView().showForm(formShowParameter);
                    break;
                }
                if (EvtRelationEnum.PLUGIN != evtRelationEnum) break;
                formShowParameter.setFormId("fah_evt_relationpluginset");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fah_evt_relationpluginset"));
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (name = e.getProperty().getName()) {
            case "eventrule": {
                Object newBillType = null;
                if (null != newValue) {
                    newBillType = ((DynamicObject)newValue).get("group.id");
                }
                this.getModel().setValue(BILL_TYPE, newBillType, changeData.getRowIndex());
                break;
            }
            case "relationtype": {
                boolean enable = EvtRelationEnum.BOTP != EvtRelationEnum.getEnum((String)((String)newValue));
                this.getView().setEnable(Boolean.valueOf(enable), changeData.getRowIndex(), new String[]{RELATION});
                this.getModel().setValue(RELATION, null);
                break;
            }
            case "relation": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getModel().setValue(RELATION_VAL, null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object source = evt.getSource();
        Control sourceCtl = (Control)source;
        String key = sourceCtl.getKey();
        if (EVENT_RULE.equals(key)) {
            DynamicObject lineType = (DynamicObject)this.getModel().getValue(LINE_TYPE);
            if (null == lineType) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e8b\u4ef6\u884c\u7c7b\u578b\u3002", (String)"FahEvtRelationSetEdit_7", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("evtrule_line.entry_linetype.id", "=", (Object)lineType.getLong("id"))).and(new QFilter("evtrule_line.relation", "=", (Object)Character.valueOf(' ')));
            HashSet<Long> eventRuleIds = new HashSet<Long>(10);
            DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (DynamicObject row : entity) {
                DynamicObject eventRule = row.getDynamicObject(EVENT_RULE);
                if (null == eventRule) continue;
                eventRuleIds.add(eventRule.getLong("id"));
            }
            Long evtRuleId = (Long)this.getView().getFormShowParameter().getCustomParam("evtruleId");
            if (null != evtRuleId) {
                eventRuleIds.add(evtRuleId);
            }
            if (!eventRuleIds.isEmpty()) {
                qFilter.and(new QFilter("id", "not in", eventRuleIds));
            }
            filterParam.getQFilters().add(qFilter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if (null != returnData) {
            if ("fah_evt_relation_fieldset".equals(event.getActionId())) {
                String relationDesc = FahEvtRelationSetEdit.getRelationDesc((String)returnData);
                this.getModel().setValue(RELATION, (Object)relationDesc);
                this.getModel().setValue(RELATION_VAL, returnData);
            } else if ("fah_evt_relationpluginset".equals(event.getActionId())) {
                EvtRuleRelationPluginDto pluginDto = (EvtRuleRelationPluginDto)JSON.parseObject((String)((String)returnData), EvtRuleRelationPluginDto.class);
                this.getModel().setValue(RELATION, (Object)pluginDto.getDescription());
                this.getModel().setValue(RELATION_VAL, returnData);
            }
        }
    }

    private static String getRelationDesc(String returnData) {
        if (StringUtils.isBlank((CharSequence)returnData)) {
            return "";
        }
        EvtRuleRelationFieldMappingDto mappingDto = (EvtRuleRelationFieldMappingDto)JSON.parseObject((String)returnData, EvtRuleRelationFieldMappingDto.class);
        MainEntityType srcBill = MetadataServiceHelper.getDataEntityType((String)mappingDto.getSourceBill());
        MainEntityType targetBill = MetadataServiceHelper.getDataEntityType((String)mappingDto.getTargetBill());
        String sourceDesc = (null != srcBill ? srcBill.getDisplayName() + "." : "") + FahAcctRuleUtils.getFieldLongName((String)mappingDto.getSourceField(), (MainEntityType)srcBill);
        String targetDesc = (null != targetBill ? targetBill.getDisplayName() + "." : "") + FahAcctRuleUtils.getFieldLongName((String)mappingDto.getTargetField(), (MainEntityType)targetBill);
        return sourceDesc + "\uff1b" + targetDesc;
    }
}

