/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.ai.util.ContextUtil;
import kd.fi.v2.fah.constant.enums.event.BillDataProcessErrorCategoryEnum;
import kd.fi.v2.fah.dao.GenResultDao;
import kd.fi.v2.fah.dao.event.EventTrackerDao;
import kd.fi.v2.fah.utils.ParamUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class FahGenResult
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    protected static final String ERRORENTRY = "errorentry";
    protected static final String INFOENTRY = "infoentry";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"errorflex"});
        Long requestId = (Long)this.getView().getFormShowParameter().getCustomParam("requestId");
        IDataModel model = this.getModel();
        Map infoData = GenResultDao.getStatistic((Long)requestId);
        if (!infoData.isEmpty()) {
            model.setValue("creater", infoData.get("creater"));
            model.setValue("starttime", infoData.get("starttime"));
            model.setValue("endtime", infoData.get("endtime"));
            model.setValue("count", infoData.get("count"));
            model.setValue("successcount", infoData.get("successcount"));
            model.setValue("failcount", infoData.get("failcount"));
            Label nogenevtcnt = (Label)this.getControl("nogenevtcntlab");
            nogenevtcnt.setText(String.valueOf(infoData.get("nogenevtcnt")));
            model.setValue("nogenevtcnt", infoData.get("nogenevtcnt"));
            model.setValue("exception", infoData.get("exception"));
            model.setValue("status", infoData.get("status"));
            model.setValue("buildbizdimgrptaskstatus", infoData.get("buildBizDimGrpTaskStatus"));
            model.setValue("taskno", infoData.get("taskno"));
        }
        int i = 0;
        int viewMoreMaxCount = ParamUtils.getViewMoreMaxCount();
        for (Map row : GenResultDao.getFailureReason((Long)requestId)) {
            String code = (String)row.get("fmsg_code");
            if (StringUtils.isEmpty((String)code)) continue;
            model.createNewEntryRow(ERRORENTRY);
            int errorCount = (Integer)row.get("errorcount");
            model.setValue("errorcount", (Object)errorCount, i);
            if (errorCount > viewMoreMaxCount) {
                model.setValue("viewmore", (Object)String.format(ResManager.loadKDString((String)"\u53f3\u4fa7\u4ec5\u5c55\u793a%1$s\u5f20\u5355\u636e\uff0c\u66f4\u591a\u5355\u636e\u4fe1\u606f\u8bf7\u70b9\u51fb\u5de6\u4fa7\u5931\u8d25\u5355\u636e\u6570\u91cf\u67e5\u770b\u3002", (String)"FahGenResult_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), viewMoreMaxCount), i);
            }
            model.setValue("msgcode", (Object)code, i);
            ++i;
        }
        if (i > 0) {
            this.entryRowClick(new RowClickEvent((Object)this.getControl(ERRORENTRY), 0));
            ((EntryGrid)this.getControl(ERRORENTRY)).selectRows(0);
        }
        if (this.getModel().getEntryRowCount(INFOENTRY) > 0) {
            this.entryRowClick(new RowClickEvent((Object)this.getControl(INFOENTRY), 0));
            ((EntryGrid)this.getControl(INFOENTRY)).selectRows(0);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (evt.getRow() < 0) {
            return;
        }
        String key = ((EntryGrid)evt.getSource()).getKey();
        String index = String.valueOf(evt.getRow());
        String hisIndex = this.getPageCache().get(key);
        if (ERRORENTRY.equals(key) && StringUtils.isEquals((String)index, (String)hisIndex)) {
            return;
        }
        super.entryRowClick(evt);
        IDataModel dataModel = this.getModel();
        Long requestId = (Long)this.getView().getFormShowParameter().getCustomParam("requestId");
        if (ERRORENTRY.equals(key)) {
            int viewMoreMaxCount = ParamUtils.getViewMoreMaxCount();
            dataModel.deleteEntryData(INFOENTRY);
            dataModel.beginInit();
            String code = (String)dataModel.getValue("msgcode");
            if (BillDataProcessErrorCategoryEnum.isSkip((String)code)) {
                int i = 0;
                for (Map row : GenResultDao.getSkipMsg((String)code, (Long)requestId)) {
                    dataModel.createNewEntryRow(INFOENTRY);
                    dataModel.setValue("billno", row.get("billno"), i);
                    dataModel.setValue("billtype", row.get("billtype"), i);
                    dataModel.setValue("msg", row.get("msg"), i);
                    dataModel.setValue("billid", row.get("billid"), i);
                    if (++i != viewMoreMaxCount) continue;
                    break;
                }
            } else {
                int i = 0;
                for (Map row : GenResultDao.getFailMsg((String)code, (Long)requestId)) {
                    dataModel.createNewEntryRow(INFOENTRY);
                    dataModel.setValue("billno", row.get("billno"), i);
                    dataModel.setValue("billtype", row.get("billtype"), i);
                    dataModel.setValue("dispatchrule", row.get("dispatchrule"), i);
                    dataModel.setValue("msg", row.get("msg"), i);
                    dataModel.setValue("billid", row.get("billid"), i);
                    if (++i != viewMoreMaxCount) continue;
                    break;
                }
            }
            dataModel.endInit();
            this.getView().updateView(INFOENTRY);
        } else if (INFOENTRY.equals(key)) {
            switch (BillDataProcessErrorCategoryEnum.getBillStatusErrorByCode((String)String.valueOf(dataModel.getValue("msgcode")))) {
                case UNMATCHED_GEN_RULE: {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"eventflex"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"errorflex"});
                    this.getModel().setValue("msgdetail", this.getModel().getValue("msg"));
                    break;
                }
                case BILL_STATUS_ERROR: 
                case UNMATCHED_DISPATCH_RULE: 
                case EVT_HEAD_HAS_FAILED: {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"eventflex"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"errorflex"});
                    break;
                }
                default: {
                    if (!PermissionServiceHelper.checkPermission((long)ContextUtil.getUserId(), null, null, (String)"fah_event", (String)"47150e89000000ac")) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4e8b\u4ef6\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FahGenResult_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    String billtype = (String)dataModel.getValue("billtype_id");
                    Long billId = (Long)dataModel.getValue("billid");
                    Set eventIds = GenResultDao.getEventByRequestId((Long)billId, (String)billtype, (Long)requestId);
                    if (eventIds.isEmpty()) {
                        return;
                    }
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"eventflex"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"errorflex"});
                    if (eventIds.size() == 1) {
                        BillShowParameter list = new BillShowParameter();
                        list.setFormId("fah_event");
                        list.setPkId(eventIds.toArray()[0]);
                        list.getOpenStyle().setShowType(ShowType.InContainer);
                        list.getOpenStyle().setTargetKey("eventflex");
                        list.setCustomParam("ShowType", (Object)ShowType.InContainer);
                        list.setCustomParam("isInContainer", (Object)true);
                        this.getView().showForm((FormShowParameter)list);
                        break;
                    }
                    ListShowParameter list = new ListShowParameter();
                    list.setBillFormId("fah_event");
                    LinkQueryPkIdCollection linkQueryPkIds = new LinkQueryPkIdCollection();
                    eventIds.forEach(arg_0 -> ((LinkQueryPkIdCollection)linkQueryPkIds).addLinkQueryPkId(arg_0));
                    list.setLinkQueryPkIdCollection(linkQueryPkIds);
                    list.getOpenStyle().setShowType(ShowType.InContainer);
                    list.getOpenStyle().setTargetKey("eventflex");
                    list.setCustomParam("ShowType", (Object)ShowType.InContainer);
                    list.setCustomParam("pageid", (Object)this.getView().getPageId());
                    list.setCustomParam("isInContainer", (Object)true);
                    this.getView().showForm((FormShowParameter)list);
                }
            }
        }
        dataModel.setDataChanged(false);
        this.getPageCache().put(key, index);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid errorEntry = (EntryGrid)this.getControl(ERRORENTRY);
        errorEntry.addRowClickListener((RowClickEventListener)this);
        errorEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid infoEntry = (EntryGrid)this.getControl(INFOENTRY);
        infoEntry.addRowClickListener((RowClickEventListener)this);
        infoEntry.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"nogenevtcntlab"});
    }

    public void click(EventObject evt) {
        int nogenevtcnt;
        super.click(evt);
        if ("nogenevtcntlab".equals(((Control)evt.getSource()).getKey()) && (nogenevtcnt = Integer.parseInt(String.valueOf(this.getModel().getValue("nogenevtcnt")))) != 0) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("fah_task_noevt_bills");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            Long requestId = (Long)this.getView().getFormShowParameter().getCustomParam("requestId");
            showParameter.setCustomParam("requestId", (Object)requestId);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Long requestId = (Long)this.getView().getFormShowParameter().getCustomParam("requestId");
        if ("billno".equals(evt.getFieldName())) {
            BillShowParameter bill = new BillShowParameter();
            String billType = (String)this.getModel().getValue("billtype_id");
            if (StringUtils.isEmpty((String)billType)) {
                return;
            }
            bill.setFormId(billType);
            bill.setPkId(this.getModel().getValue("billid"));
            bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bill.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)bill);
        } else if ("errorcount".equals(evt.getFieldName())) {
            ListShowParameter list = new ListShowParameter();
            list.setBillFormId("fah_report");
            list.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String msgCode = (String)this.getModel().getValue("msgcode");
            list.setCustomParam("msgCode", (Object)msgCode);
            list.setCustomParam("isSkip", (Object)BillDataProcessErrorCategoryEnum.isSkip((String)msgCode));
            list.setCustomParam("requestId", (Object)requestId);
            this.getView().showForm((FormShowParameter)list);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        Long requestId = (Long)this.getView().getFormShowParameter().getCustomParam("requestId");
        if ("viewevent".equals(itemKey)) {
            DynamicObjectCollection events = QueryServiceHelper.query((String)"fah_event", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("requestid", "=", (Object)requestId).and(new QFilter("status", "=", (Object)"4"))});
            if (!events.isEmpty()) {
                if (events.size() == 1) {
                    Long orgId = ((DynamicObject)events.get(0)).getLong("org");
                    if (PermissionServiceHelper.checkPermission((Long)ContextUtil.getUserId(), (Long)orgId, null, (String)"fah_event", (String)"47150e89000000ac") != 1) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4e8b\u4ef6\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FahGenResult_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    BillShowParameter bill = new BillShowParameter();
                    bill.setFormId("fah_event");
                    bill.setPkId((Object)((DynamicObject)events.get(0)).getLong("id"));
                    bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)bill);
                } else {
                    ListShowParameter list = new ListShowParameter();
                    list.setBillFormId("fah_event");
                    LinkQueryPkIdCollection linkQueryPkIds = new LinkQueryPkIdCollection();
                    events.forEach(v -> linkQueryPkIds.addLinkQueryPkId((Object)v.getLong("id")));
                    list.setLinkQueryPkIdCollection(linkQueryPkIds);
                    list.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)list);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u4e8b\u4ef6\u3002", (String)"FahGenResult_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
        } else if ("viewglvoucher".equals(itemKey)) {
            Map gLHeaderIds = EventTrackerDao.queryGLHeaderId((Long)requestId);
            if (!gLHeaderIds.isEmpty()) {
                if (gLHeaderIds.size() == 1) {
                    if (PermissionServiceHelper.checkPermission((Long)ContextUtil.getUserId(), (Long)((Long)gLHeaderIds.values().toArray()[0]), null, (String)"gl_voucher", (String)"47150e89000000ac") != 1) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u51ed\u8bc1\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FahGenResult_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("gl_voucher");
                    showParameter.setPkId(gLHeaderIds.keySet().toArray()[0]);
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                } else {
                    ListShowParameter showParameter = new ListShowParameter();
                    showParameter.setBillFormId("gl_voucher");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setShowFilter(false);
                    showParameter.setShowQuickFilter(false);
                    for (Object pkid : gLHeaderIds.keySet()) {
                        showParameter.addLinkQueryPkId(pkid);
                    }
                    showParameter.getCustomParams().put("org", "");
                    showParameter.getCustomParams().put("booktype", "");
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u603b\u8d26\u51ed\u8bc1\u3002", (String)"FahGenResult_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
        } else if ("viewxla".equals(itemKey)) {
            // empty if block
        }
    }
}

