/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.v2.fah.constant.enums.event.VchSummaryTypeEnum;
import kd.fi.v2.fah.constant.enums.event.VchValueSetFieldEnum;
import kd.fi.v2.fah.models.event.mergerule.CustomSummaryFieldDto;
import kd.fi.v2.fah.models.groupmerge.CustomMergeFieldConfig;
import kd.fi.v2.fah.models.groupmerge.GroupAndMergeRuleModel;
import kd.fi.v2.fah.models.groupmerge.ReBuildFieldConfig;
import kd.fi.v2.fah.utils.LicenseUtil;

public class FahGroupMergeRuleEdit
extends AbstractFormPlugin {
    private static final String CUSTOM_FIELD_SUMMARY = "customfieldsummary";
    private static final String CUSTOM_ENTRY_ENTITY = "customentryentity";
    private static final String CUSTOM_FIELD = "customfield";
    private static final String CUSTOM_FIELD_DESC = "customfielddesc";
    private static final String CUSTOM_MERGE_FIELD = "custommergefield";
    private static final String CUSTOM_FIELD_EN = "customfielden";
    private static final String FAH_CUSTOMSUMMARYFIELD = "fah_customsummaryfield";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String SRC_FIELD = "srcfield";
    private static final String SRC_FIELDKEY = "srcfieldkey";
    private static final String SRC_FIELD_DATATYPE = "datatype";
    private static final String SRC_FIELD_ENABLE = "srcfieldenable";
    private static final String FIELD_SET = "fieldset";
    private static final String FIELD_SET_VAL = "fieldsetval";
    private static final String FIELD_SET_TYPE = "fieldsettype";
    private static final String SUMMARY_TYPE = "summarytype";
    private static final String BOOK_DATE_SUMMARY = "bookdatesummary";
    private static final String BIZ_DATE_SUMMARY = "bizdatesummary";
    private static final String CREATOR_SUMMARY = "creatorsummary";
    private static final String BILL_NO_SUMMARY = "billnosummary";
    private static final String CUSTOM_FIELD_OP = "customfieldop";
    public static final String HISTORY_DATA = "historydata";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CUSTOM_MERGE_FIELD, FIELD_SET});
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        this.setFieldMustInput();
        model.deleteEntryData(ENTRY_ENTITY);
        String historyData = (String)this.getView().getFormShowParameter().getCustomParam(HISTORY_DATA);
        if (StringUtils.isBlank((CharSequence)historyData)) {
            for (VchValueSetFieldEnum fieldEnum : VchValueSetFieldEnum.values()) {
                int rowIndex = model.createNewEntryRow(ENTRY_ENTITY);
                model.setValue(SRC_FIELD, (Object)fieldEnum.getName(), rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{SRC_FIELD});
                model.setValue(SRC_FIELDKEY, (Object)fieldEnum.getCode(), rowIndex);
                model.setValue(SRC_FIELD_DATATYPE, (Object)String.valueOf(fieldEnum.getDataValueType().getCode()), rowIndex);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "btn_revisionlog"});
            GroupAndMergeRuleModel ruleMode = (GroupAndMergeRuleModel)JSON.parseObject((String)historyData, GroupAndMergeRuleModel.class);
            this.setHeaderFiled(ruleMode);
            this.setCustomMergeFiledEntry(ruleMode);
            this.setReBuildFiledEntry(ruleMode);
        }
    }

    private void setHeaderFiled(GroupAndMergeRuleModel ruleMode) {
        IDataModel model = this.getModel();
        model.setValue("number", (Object)ruleMode.getNumber());
        model.setValue("name", (Object)ruleMode.getName());
        model.setValue("group", (Object)ruleMode.getAcctPurposeId());
        model.setValue("passtogl", (Object)ruleMode.getIsClearZeroAmount());
        model.setValue("description", (Object)ruleMode.getDescription());
        model.setValue(SUMMARY_TYPE, (Object)ruleMode.getMergeType().getCode());
        model.setValue(CUSTOM_FIELD_EN, (Object)ruleMode.getEntryMergeField());
        BitSet groupField = ruleMode.getGroupDimensionAndReCalField();
        model.setValue(BOOK_DATE_SUMMARY, (Object)groupField.get(0));
        model.setValue(BIZ_DATE_SUMMARY, (Object)groupField.get(1));
        model.setValue(CREATOR_SUMMARY, (Object)groupField.get(2));
        model.setValue(BILL_NO_SUMMARY, (Object)groupField.get(3));
        model.setValue("exchangerate", (Object)groupField.get(4));
        model.setValue("unitprice", (Object)groupField.get(5));
        model.setValue("dc", (Object)groupField.get(6));
        model.setValue(CUSTOM_FIELD_SUMMARY, (Object)groupField.get(7));
        model.setValue(CUSTOM_FIELD_OP, (Object)groupField.get(8));
    }

    private void setCustomMergeField() {
        DynamicObjectCollection customEntity = this.getModel().getEntryEntity(CUSTOM_ENTRY_ENTITY);
        if (null != customEntity && !customEntity.isEmpty()) {
            StringBuilder desc = new StringBuilder();
            for (DynamicObject row : customEntity) {
                desc.append(row.getString("srcbilltype.name")).append("\uff1a").append(row.getString(CUSTOM_FIELD_DESC)).append("\uff1b");
            }
            String description = FahGroupMergeRuleEdit.getDescription(desc);
            this.getModel().setValue(CUSTOM_MERGE_FIELD, (Object)description);
        }
    }

    private void setCustomMergeFiledEntry(GroupAndMergeRuleModel ruleMode) {
        IDataModel model = this.getModel();
        List mergeFieldConfigs = ruleMode.getCustomMergeFields();
        if (null != mergeFieldConfigs && !mergeFieldConfigs.isEmpty()) {
            for (CustomMergeFieldConfig mergeFieldConfig : mergeFieldConfigs) {
                int newEntryRow = model.createNewEntryRow(CUSTOM_ENTRY_ENTITY);
                model.setValue("srcbilltype", (Object)mergeFieldConfig.getSrcBillType(), newEntryRow);
                model.setValue(CUSTOM_FIELD, (Object)mergeFieldConfig.getCustomField(), newEntryRow);
                model.setValue(CUSTOM_FIELD_DESC, (Object)mergeFieldConfig.getCustomFieldDesc(), newEntryRow);
            }
            this.setCustomMergeField();
        }
    }

    private void setReBuildFiledEntry(GroupAndMergeRuleModel ruleMode) {
        ReBuildFieldConfig[] param = ruleMode.getParam();
        IDataModel model = this.getModel();
        for (ReBuildFieldConfig reBuildField : param) {
            int rowIndex = model.createNewEntryRow(ENTRY_ENTITY);
            String srcField = reBuildField.getSrcField();
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{SRC_FIELD});
            model.setValue(SRC_FIELDKEY, (Object)srcField, rowIndex);
            model.setValue(SRC_FIELD_DATATYPE, (Object)String.valueOf(reBuildField.getDataType().getCode()), rowIndex);
            model.setValue(SRC_FIELD_ENABLE, (Object)reBuildField.isEnabled(), rowIndex);
            model.setValue(FIELD_SET_TYPE, (Object)String.valueOf(reBuildField.getSetType().getCode()), rowIndex);
            model.setValue(FIELD_SET, (Object)reBuildField.getDescription(), rowIndex);
            model.setValue(FIELD_SET_VAL, reBuildField.getValue(), rowIndex);
            VchValueSetFieldEnum fieldEnum = VchValueSetFieldEnum.getEnum((String)srcField);
            if (null == fieldEnum) continue;
            model.setValue(SRC_FIELD, (Object)fieldEnum.getName(), rowIndex);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < entity.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{SRC_FIELD});
        }
        this.setCustomMergeField();
        this.setFieldMustInput();
        this.getModel().setDataChanged(false);
    }

    private void setFieldMustInput() {
        Boolean customFieldSummary = (Boolean)this.getModel().getValue(CUSTOM_FIELD_SUMMARY);
        ((FieldEdit)this.getView().getControl(CUSTOM_MERGE_FIELD)).setMustInput(customFieldSummary.booleanValue());
        Boolean customFieldOp = (Boolean)this.getModel().getValue(CUSTOM_FIELD_OP);
        ((FieldEdit)this.getView().getControl(CUSTOM_FIELD_EN)).setMustInput(customFieldOp.booleanValue());
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if (CUSTOM_MERGE_FIELD.equals(event.getActionId()) && null != returnData) {
            this.getModel().deleteEntryData(CUSTOM_ENTRY_ENTITY);
            String data = (String)returnData;
            List dataList = (List)SerializationUtils.deSerializeFromBase64((String)data);
            if (null != dataList) {
                StringBuilder desc = new StringBuilder();
                for (CustomSummaryFieldDto fieldDto : dataList) {
                    int entryRow = this.getModel().createNewEntryRow(CUSTOM_ENTRY_ENTITY);
                    this.getModel().setValue("srcbilltype", (Object)fieldDto.getSrcBillType(), entryRow);
                    this.getModel().setValue(CUSTOM_FIELD, (Object)fieldDto.getCustomField(), entryRow);
                    this.getModel().setValue(CUSTOM_FIELD_DESC, (Object)fieldDto.getCustomFieldDesc(), entryRow);
                    Long entryId = fieldDto.getEntryId();
                    if (null != entryId && 0L != entryId) {
                        DynamicObject row = this.getModel().getEntryRowEntity(CUSTOM_ENTRY_ENTITY, entryRow);
                        row.set("id", (Object)entryId);
                    }
                    desc.append(fieldDto.getSrcBillTypeName()).append("\uff1a").append(fieldDto.getCustomFieldDesc()).append("\uff1b");
                }
                String description = FahGroupMergeRuleEdit.getDescription(desc);
                this.getModel().setValue(CUSTOM_MERGE_FIELD, (Object)description);
            }
        }
        if (FIELD_SET.equals(event.getActionId()) && null != returnData) {
            Map result = (Map)returnData;
            this.getModel().setValue(FIELD_SET, result.get("displayName"));
            this.getModel().setValue(FIELD_SET_VAL, result.get("value"));
            this.getModel().setValue(FIELD_SET_TYPE, result.get("valueSetType"));
        }
    }

    private static String getDescription(StringBuilder desc) {
        if (StringUtils.isEmpty((CharSequence)desc)) {
            return "";
        }
        String description = desc.deleteCharAt(desc.length() - 1).toString();
        if (description.length() > 200) {
            description = description.substring(0, 197) + "...";
        }
        return description;
    }

    public void click(EventObject evt) {
        FormShowParameter parameter;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (CUSTOM_MERGE_FIELD.equals(key)) {
            parameter = new FormShowParameter();
            parameter.setFormId(FAH_CUSTOMSUMMARYFIELD);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            DynamicObjectCollection customEntity = this.getModel().getEntryEntity(CUSTOM_ENTRY_ENTITY);
            if (null != customEntity && !customEntity.isEmpty()) {
                ArrayList<CustomSummaryFieldDto> data = new ArrayList<CustomSummaryFieldDto>();
                for (DynamicObject row : customEntity) {
                    CustomSummaryFieldDto fieldDto = new CustomSummaryFieldDto(Long.valueOf(row.getLong("id")), row.getString("srcbilltype.number"), row.getString("srcbilltype.name"), row.getString(CUSTOM_FIELD), row.getString(CUSTOM_FIELD_DESC));
                    data.add(fieldDto);
                }
                parameter.setCustomParam("data", (Object)SerializationUtils.serializeToBase64(data));
            }
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CUSTOM_MERGE_FIELD));
            this.getView().showForm(parameter);
        }
        if (FIELD_SET.equals(key)) {
            parameter = new FormShowParameter();
            parameter.setFormId("fah_vchfield_reset");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("fieldkey", this.getModel().getValue(SRC_FIELDKEY));
            parameter.setCustomParam(SRC_FIELD_DATATYPE, this.getModel().getValue(SRC_FIELD_DATATYPE));
            parameter.setCustomParam("fieldvalue", this.getModel().getValue(FIELD_SET_VAL));
            parameter.setCustomParam(FIELD_SET_TYPE, this.getModel().getValue(FIELD_SET_TYPE));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_SET));
            this.getView().showForm(parameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName = e.getProperty().getName()) {
            case "customfieldop": {
                if (Boolean.FALSE.equals(newValue)) {
                    this.getModel().setValue(CUSTOM_FIELD_EN, (Object)"");
                }
                ((FieldEdit)this.getView().getControl(CUSTOM_FIELD_EN)).setMustInput(((Boolean)newValue).booleanValue());
                break;
            }
            case "customfieldsummary": {
                if (Boolean.FALSE.equals(newValue)) {
                    this.getModel().setValue(CUSTOM_MERGE_FIELD, (Object)"");
                }
                ((FieldEdit)this.getView().getControl(CUSTOM_MERGE_FIELD)).setMustInput(((Boolean)newValue).booleanValue());
                break;
            }
            case "custommergefield": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getModel().deleteEntryData(CUSTOM_ENTRY_ENTITY);
                break;
            }
            case "fieldset": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getModel().setValue(FIELD_SET_VAL, (Object)"");
                this.getModel().setValue(FIELD_SET_TYPE, (Object)"");
                break;
            }
            case "summarytype": {
                this.setSrcFieldEnableBySumType(newValue);
                break;
            }
            case "bookdatesummary": {
                this.setSrcFieldEnable(newValue, VchValueSetFieldEnum.BOOKDATE.getIndex());
                break;
            }
            case "bizdatesummary": {
                this.setSrcFieldEnable(newValue, VchValueSetFieldEnum.BIZDATE.getIndex());
                break;
            }
            case "creatorsummary": {
                this.setSrcFieldEnable(newValue, VchValueSetFieldEnum.CREATOR.getIndex());
                break;
            }
        }
    }

    private void setSrcFieldEnableBySumType(Object newValue) {
        VchSummaryTypeEnum typeEnum = VchSummaryTypeEnum.getEnum((String)String.valueOf(newValue));
        if (null != typeEnum) {
            DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            switch (typeEnum) {
                case ONE_FOR_ONE: {
                    for (int i = 0; i < entity.size(); ++i) {
                        this.getModel().setValue(SRC_FIELD_ENABLE, (Object)false, i);
                    }
                    break;
                }
                case SINGLE_ALL_SUMMARY: 
                case MULTI_ALL_SUMMARY: {
                    for (int i = 0; i < entity.size(); ++i) {
                        this.getModel().setValue(SRC_FIELD_ENABLE, (Object)true, i);
                    }
                    break;
                }
                case SINGLE_MATCH_SUMMARY: 
                case MULTI_MATCH_SUMMARY: {
                    this.getModel().setValue(SRC_FIELD_ENABLE, (Object)true, VchValueSetFieldEnum.ATTACHMENT.getIndex());
                    boolean bookDateSummary = (Boolean)this.getModel().getValue(BOOK_DATE_SUMMARY);
                    this.getModel().setValue(SRC_FIELD_ENABLE, (Object)(!bookDateSummary ? 1 : 0), VchValueSetFieldEnum.BOOKDATE.getIndex());
                    boolean bizDateSummary = (Boolean)this.getModel().getValue(BIZ_DATE_SUMMARY);
                    this.getModel().setValue(SRC_FIELD_ENABLE, (Object)(!bizDateSummary ? 1 : 0), VchValueSetFieldEnum.BIZDATE.getIndex());
                    boolean creatorSummary = (Boolean)this.getModel().getValue(CREATOR_SUMMARY);
                    this.getModel().setValue(SRC_FIELD_ENABLE, (Object)(!creatorSummary ? 1 : 0), VchValueSetFieldEnum.CREATOR.getIndex());
                    break;
                }
            }
        }
    }

    private void setSrcFieldEnable(Object newValue, int index) {
        String type = (String)this.getModel().getValue(SUMMARY_TYPE);
        boolean flag = Boolean.TRUE.equals(newValue) && (VchSummaryTypeEnum.SINGLE_MATCH_SUMMARY.getCode().equals(type) || VchSummaryTypeEnum.MULTI_MATCH_SUMMARY.getCode().equals(type));
        this.getModel().setValue(SRC_FIELD_ENABLE, (Object)(!flag ? 1 : 0), index);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private boolean isEdit() {
        Object id = this.getModel().getValue("id");
        return id != null && (Long)id != 0L;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
            String summaryType = (String)this.getModel().getValue(SUMMARY_TYPE);
            if (!VchSummaryTypeEnum.SINGLE_MATCH_SUMMARY.getCode().equals(summaryType) && !VchSummaryTypeEnum.MULTI_MATCH_SUMMARY.getCode().equals(summaryType)) {
                this.getModel().setValue(BOOK_DATE_SUMMARY, (Object)false);
                this.getModel().setValue(BIZ_DATE_SUMMARY, (Object)false);
                this.getModel().setValue(CREATOR_SUMMARY, (Object)false);
                this.getModel().setValue(BILL_NO_SUMMARY, (Object)false);
                this.getModel().setValue(CUSTOM_FIELD_SUMMARY, (Object)false);
            }
        }
        if (args.getSource() instanceof Save && this.isEdit() && this.getModel().getDataChanged()) {
            this.getModel().setValue("ischange", (Object)Boolean.TRUE);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }
}

