/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.v2.fah.dao.event.FahRegBillDao;
import kd.fi.v2.fah.utils.ExtractFieldUtils;
import kd.fi.v2.fah.utils.LicenseUtil;

public class FahRegBillEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("srcbilltype");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject srcBillType = (DynamicObject)this.getModel().getValue("srcbilltype");
        if (srcBillType != null) {
            this.buildComboEditValue(srcBillType);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals("srcbilltype")) {
            this.clearAllField();
            DynamicObject srcBillType = (DynamicObject)this.getModel().getValue("srcbilltype");
            if (srcBillType == null) {
                return;
            }
            this.buildComboEditValue(srcBillType);
            this.getModel().setValue("writebackplugin", (Object)FahRegBillDao.getDapWBPlugin((String)srcBillType.getString("number")));
            this.getView().updateView("keyfieldentry");
        } else if (propName.equals("srcbillstatusfield")) {
            DynamicObject srcBillType = (DynamicObject)this.getModel().getValue("srcbilltype");
            if (srcBillType == null) {
                return;
            }
            List<ComboItem> comboItems = this.buildSrcBillStatus(srcBillType.getString("number"), (String)this.getModel().getValue("srcbillstatusfield"));
            ((ComboEdit)this.getControl("srcbillstatusval")).setComboItems(comboItems);
            this.getModel().setValue("srcbillstatusval", null);
            this.getView().updateView("keyfieldentry");
        }
    }

    private void clearAllField() {
        this.getModel().setValue("srcbillorgfield", (Object)"");
        this.getModel().setValue("srcbilldatefieldnum", null);
        this.getModel().setValue("evtstatusfieldnum", null);
        this.getModel().setValue("srcbillstatusfield", null);
        this.getModel().setValue("srcbillstatusval", null);
        ((ComboEdit)this.getControl("srcbillorgfield")).setComboItems(Collections.EMPTY_LIST);
        ((ComboEdit)this.getControl("srcbilldatefieldnum")).setComboItems(Collections.EMPTY_LIST);
        ((ComboEdit)this.getControl("evtstatusfieldnum")).setComboItems(Collections.EMPTY_LIST);
        ((ComboEdit)this.getControl("srcbillstatusfield")).setComboItems(Collections.EMPTY_LIST);
        ((ComboEdit)this.getControl("srcbillstatusval")).setComboItems(Collections.EMPTY_LIST);
    }

    private void buildComboEditValue(DynamicObject srcBillType) {
        String billNumber = srcBillType.getString("number");
        List<ComboItem> comboItems = ExtractFieldUtils.getEntityFieldFromSourcePageAndField((String)"fah_regbill", (String)"srcbillorgfield", (String)billNumber, null);
        ((ComboEdit)this.getControl("srcbillorgfield")).setComboItems((List)comboItems);
        comboItems = ExtractFieldUtils.getEntityFieldFromSourcePageAndField((String)"fah_regbill", (String)"srcbilldatefieldnum", (String)billNumber, null);
        ((ComboEdit)this.getControl("srcbilldatefieldnum")).setComboItems((List)comboItems);
        comboItems = ExtractFieldUtils.getEntityFieldFromSourcePageAndField((String)"fah_regbill", (String)"evtstatusfieldnum", (String)billNumber, null);
        ((ComboEdit)this.getControl("evtstatusfieldnum")).setComboItems((List)comboItems);
        DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("keyfieldentry");
        if ((value == null || value.isEmpty()) && comboItems != null && comboItems.size() == 1) {
            this.getModel().setValue("evtstatusfieldnum", (Object)comboItems.get(0).getValue());
        }
        comboItems = this.buildBillStatusField(billNumber);
        ((ComboEdit)this.getControl("srcbillstatusfield")).setComboItems(comboItems);
        String defaultField = (String)this.getModel().getValue("srcbillstatusfield");
        defaultField = defaultField == null || defaultField.isEmpty() ? "billstatus" : defaultField;
        this.getModel().setValue("srcbillstatusfield", (Object)defaultField);
        comboItems = this.buildSrcBillStatus(billNumber, defaultField);
        ((ComboEdit)this.getControl("srcbillstatusval")).setComboItems(comboItems);
    }

    private List<ComboItem> buildSrcBillStatus(String billNumber, String field) {
        if (billNumber == null || billNumber.isEmpty()) {
            return new ArrayList<ComboItem>();
        }
        MainEntityType billMainType = MetadataServiceHelper.getDataEntityType((String)billNumber);
        if (billMainType == null) {
            return new ArrayList<ComboItem>();
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        DynamicProperty property = billMainType.getProperty(field);
        if (property instanceof ComboProp) {
            ComboProp prop = (ComboProp)property;
            for (ValueMapItem item : prop.getComboItems()) {
                ComboItem comboItem = new ComboItem(item.getName(), item.getValue());
                items.add(comboItem);
            }
        } else if (property instanceof BooleanProp) {
            ComboItem comboItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"FahRegBillEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0])), "1");
            items.add(comboItem);
            comboItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"FahRegBillEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0])), "0");
            items.add(comboItem);
        }
        return items;
    }

    private List<ComboItem> buildBillStatusField(String billNumber) {
        MainEntityType billMainType = MetadataServiceHelper.getDataEntityType((String)billNumber);
        Map allEntities = billMainType.getAllEntities();
        allEntities.remove(billNumber);
        Map allFields = billMainType.getAllFields();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        allFields.forEach((key, value) -> {
            if (!allEntities.containsKey(value.getParent().getName()) && (value instanceof ComboProp || value instanceof BooleanProp) && StringUtils.isNotEmpty((CharSequence)value.getAlias())) {
                ComboItem comboItem = new ComboItem(value.getDisplayName(), key);
                items.add(comboItem);
            }
        });
        return items;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"srcbilltype")) {
            QFilter idDeploy = new QFilter("bizappid.deploystatus", "=", (Object)"2");
            beforeF7SelectEvent.addCustomQFilter(idDeploy);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        if (operateInfo instanceof Save) {
            LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
        }
    }
}

