/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.v2.fah.dao.event.FahRegBillDao;
import kd.fi.v2.fah.dao.task.FahRequestTaskDaoImpl;
import kd.fi.v2.fah.dto.RequestTaskBillDto;

public class FahRequestTaskBillList
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshList();
    }

    private void refreshList() {
        Long requestId = this.getRequestId();
        Map map = FahRequestTaskDaoImpl.queryBillInfoByRequestId((Long)requestId);
        Map regInfo = FahRegBillDao.batchQuerySrcOrgAndSrcDate(map.keySet());
        List billListDisplayInfo = FahRequestTaskDaoImpl.getBillListDisplayInfo((Map)regInfo, (Map)map);
        if (!billListDisplayInfo.isEmpty()) {
            this.buildEntry(billListDisplayInfo);
        }
    }

    private void buildEntry(List<RequestTaskBillDto> billListDisplayInfo) {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().batchCreateNewEntryRow("entryentity", billListDisplayInfo.size());
        for (int i = 0; i < billListDisplayInfo.size(); ++i) {
            this.getModel().setValue("billid", (Object)billListDisplayInfo.get(i).getId(), i);
            this.getModel().setValue("org", (Object)billListDisplayInfo.get(i).getOrgId(), i);
            this.getModel().setValue("billtype", (Object)billListDisplayInfo.get(i).getBillType(), i);
            this.getModel().setValue("billstatus", (Object)billListDisplayInfo.get(i).getBillStatus(), i);
            this.getModel().setValue("billnumber", (Object)billListDisplayInfo.get(i).getBillNumber(), i);
            this.getModel().setValue("sourcedate", (Object)billListDisplayInfo.get(i).getSrcDate(), i);
        }
    }

    private Long getRequestId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("requestId");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshList();
                break;
            }
            case "btn_close": {
                this.getView().close();
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key;
        switch (key = evt.getFieldName()) {
            case "billnumber": {
                int rowIndex = evt.getRowIndex();
                Long billid = (Long)this.getModel().getValue("billid", rowIndex);
                String billType = ((DynamicObject)this.getModel().getValue("billtype", rowIndex)).getString("id");
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setPkId((Object)billid);
                showParameter.setFormId(billType);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }
}

