/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.v2.fah.dao.event.EventTrackerDao;

public class FahSubLedgerEdit
extends AbstractFormPlugin
implements RowClickEventListener,
EntryGridBindDataListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BUSINESS_NUM = "businessnum";
    private static final String EXPIRE_DATE = "expiredate";
    private static final String MEASURE_UNIT = "measureunit";
    private static final String QUANTITY = "quantity";
    private static final String PRICE = "price";
    private static final String VOUCHER_NUMBER_LABLE = "vouchernumber_lable";

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{VOUCHER_NUMBER_LABLE});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        this.entryRowClick(new RowClickEvent((Object)entryGrid, 0));
        DynamicObjectCollection dyns = this.getModel().getEntryEntity(ENTRY_ENTITY);
        boolean businessVisible = false;
        boolean priceVisible = false;
        for (DynamicObject dyn : dyns) {
            if (!businessVisible && (StringUtils.isNotBlank((CharSequence)dyn.getString(BUSINESS_NUM)) || null != dyn.getDate(EXPIRE_DATE))) {
                businessVisible = true;
            }
            if (!(priceVisible || null == dyn.get(MEASURE_UNIT) && BigDecimal.ZERO.compareTo(dyn.getBigDecimal(QUANTITY)) == 0 && BigDecimal.ZERO.compareTo(dyn.getBigDecimal(PRICE)) == 0)) {
                priceVisible = true;
            }
            if (!businessVisible || !priceVisible) continue;
            break;
        }
        this.getView().setVisible(Boolean.valueOf(businessVisible), new String[]{BUSINESS_NUM, EXPIRE_DATE});
        this.getView().setVisible(Boolean.valueOf(priceVisible), new String[]{MEASURE_UNIT, QUANTITY, PRICE});
        Long id = (Long)this.getModel().getValue("id");
        Map vchMap = EventTrackerDao.queryGLVchByXlaIds(Collections.singletonList(id));
        if (!vchMap.isEmpty()) {
            Label label = (Label)this.getView().getControl(VOUCHER_NUMBER_LABLE);
            label.setText((String)vchMap.values().iterator().next());
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List rows = e.getRows();
        for (RowDataEntity row : rows) {
            DynamicObject entity = row.getDataEntity();
            BigDecimal oriDebit = entity.getBigDecimal("oridebit");
            BigDecimal oriCredit = entity.getBigDecimal("oricredit");
            entity.set("oriamount", (Object)oriDebit.add(oriCredit));
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        List newRows = e.getRows().stream().map(x -> {
            BindingContext bindCtx = new BindingContext(x.getDataEntity().getDataEntityType(), x.getDataEntity(), x.getRowIndex());
            return entryGrid.getRowBindValue(bindCtx);
        }).collect(Collectors.toList());
        e.getData().put("rows", newRows);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        IDataModel model = this.getModel();
        model.setValue("maincf", model.getValue("maincf_item", row));
        model.setValue("maincfassgrp", model.getValue("maincf_assgrp", row));
        model.setValue("maincfamount", model.getValue("maincf_amount", row));
        model.setValue("supcf", model.getValue("supcf_itemid", row));
        model.setValue("supcfamount", model.getValue("supcf_amount", row));
    }

    public void click(EventObject evt) {
        Long glVchId;
        Long id;
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (VOUCHER_NUMBER_LABLE.equals(source.getKey()) && null != (id = (Long)this.getModel().getValue("id")) && null != (glVchId = EventTrackerDao.queryGLVchIdByXlaId((Long)id))) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("gl_voucher");
            showParameter.setPkId((Object)glVchId);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

