/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.dao.event.EventTrackerDao;

public class FahSubLedgerListPlugin
extends AbstractListPlugin {
    private static final String VOUCHER_NUMBER = "vouchernumber";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("operation", String.class, (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"FahSubLedgerListPlugin_01", (String)"fi-ai-formplugin", (Object[])new Object[0])));
                rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(FahSubLedgerListPlugin.VOUCHER_NUMBER, String.class, (Object)""));
                List ids = rows.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                Map vocuherMap = EventTrackerDao.queryGLVchByXlaIds(ids);
                if (!vocuherMap.isEmpty()) {
                    for (DynamicObject row : rows) {
                        row.set(FahSubLedgerListPlugin.VOUCHER_NUMBER, vocuherMap.get(row.getLong("id")));
                    }
                }
                return rows;
            }
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkId = billList.getFocusRowPkId();
        String fieldName = args.getFieldName();
        if (null != fieldName) {
            BillShowParameter showParameter = new BillShowParameter();
            switch (fieldName) {
                case "operation": 
                case "number": {
                    String formId = billList.getBillFormId();
                    showParameter.setFormId(formId);
                    showParameter.setPkId(pkId);
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                    break;
                }
                case "vouchernumber": {
                    showParameter.setFormId("gl_voucher");
                    Long glVchId = EventTrackerDao.queryGLVchIdByXlaId((Long)((Long)pkId));
                    if (null == glVchId) break;
                    showParameter.setPkId((Object)glVchId);
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                    break;
                }
                case "mergeruleid_name": {
                    showParameter.setFormId("fah_groupmerge");
                    DynamicObject subLedger = QueryServiceHelper.queryOne((String)"fah_subledger", (String)"mergeruleid", (QFilter[])new QFilter("id", "=", pkId).toArray());
                    if (null == subLedger) break;
                    showParameter.setPkId((Object)subLedger.getLong("mergeruleid"));
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                    break;
                }
            }
        }
    }
}

