/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.dao.event.FahNoEvtBillsDao;
import kd.fi.v2.fah.dto.FahTaskNoEvtBillInfo;
import kd.fi.v2.fah.utils.StringUtils;

public class FahTaskNoEvtBillsList
extends AbstractListPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("entryseq", Integer.class, (Object)0));
                rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("srcbillentryname", String.class, (Object)""));
                HashMap<String, Set> billTypeMap = new HashMap<String, Set>(8);
                HashMap<String, Map> billTypeIdMap = new HashMap<String, Map>(8);
                for (DynamicObject row : rows) {
                    Long billId = row.getLong("srcbillid");
                    Long l = row.getLong("srcbillentryid");
                    String entryEntity = row.getString("srcbillentry");
                    String billType = row.getString("billtype_id");
                    billTypeMap.computeIfAbsent(billType, k -> new HashSet(8)).add(entryEntity);
                    Map billIdMap = billTypeIdMap.computeIfAbsent(entryEntity, k -> new HashMap(8));
                    billIdMap.computeIfAbsent(billId, k -> new HashSet(8)).add(l);
                }
                HashMap<String, EntityType> billTypeEntryEntityTypeMap = new HashMap<String, EntityType>(8);
                boolean hasEntry = false;
                for (Map.Entry entry : billTypeMap.entrySet()) {
                    String billType = (String)entry.getKey();
                    MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
                    Map allEntities = dataEntityType.getAllEntities();
                    Set entryEntities = (Set)entry.getValue();
                    for (String entryEntity : entryEntities) {
                        EntityType entityType = (EntityType)allEntities.get(entryEntity);
                        if (entityType instanceof EntryType) {
                            hasEntry = true;
                        }
                        billTypeEntryEntityTypeMap.put(entryEntity, entityType);
                    }
                }
                HashMap<String, Map<Long, Map<Long, PairTuple<Integer, Integer>>>> billTypeSeqMap = new HashMap<String, Map<Long, Map<Long, PairTuple<Integer, Integer>>>>(8);
                if (hasEntry) {
                    for (Map.Entry billTypeIdMapEntry : billTypeIdMap.entrySet()) {
                        String entryEntity = (String)billTypeIdMapEntry.getKey();
                        EntityType entityType = (EntityType)billTypeEntryEntityTypeMap.get(entryEntity);
                        if (entityType instanceof SubEntryType) {
                            Map billIdSubEntryIdMap = (Map)billTypeIdMapEntry.getValue();
                            Map<Long, Map<Long, PairTuple<Integer, Integer>>> billIdSubEntryIdSeqMap = this.queryEntrySeq(billIdSubEntryIdMap, entityType);
                            billTypeSeqMap.put(entryEntity, billIdSubEntryIdSeqMap);
                            continue;
                        }
                        if (!(entityType instanceof EntryType)) continue;
                        Map billIdEntryIdMap = (Map)billTypeIdMapEntry.getValue();
                        Map<Long, Map<Long, PairTuple<Integer, Integer>>> billIdEntryIdSeqMap = this.queryEntrySeq(billIdEntryIdMap, entityType);
                        billTypeSeqMap.put(entryEntity, billIdEntryIdSeqMap);
                    }
                }
                for (DynamicObject row : rows) {
                    Long billId = row.getLong("srcbillid");
                    Long entryId = row.getLong("srcbillentryid");
                    String entryEntity = row.getString("srcbillentry");
                    EntityType entityType = (EntityType)billTypeEntryEntityTypeMap.get(entryEntity);
                    String entryEntityDisplayName = entityType.getDisplayName().getLocaleValue();
                    if (entityType instanceof EntryType) {
                        Map billIdEntryIdSeqMap = (Map)billTypeSeqMap.get(entryEntity);
                        if (null == billIdEntryIdSeqMap) continue;
                        Map billEntryIdSeqMap = (Map)billIdEntryIdSeqMap.get(billId);
                        if (entityType instanceof SubEntryType) {
                            String fullName;
                            int subEntrySeq;
                            IDataEntityType parent = entityType.getParent();
                            String parentDisplayName = parent.getDisplayName().getLocaleValue();
                            if (null == billEntryIdSeqMap || null == billEntryIdSeqMap.get(entryId)) {
                                subEntrySeq = 0;
                                fullName = String.format("%1$s[].%2$s", parentDisplayName, entryEntityDisplayName);
                            } else {
                                subEntrySeq = (Integer)((PairTuple)billEntryIdSeqMap.get(entryId)).getValue();
                                int entrySeq = (Integer)((PairTuple)billEntryIdSeqMap.get(entryId)).getKey();
                                fullName = String.format("%1$s[%2$d].%3$s", parentDisplayName, entrySeq, entryEntityDisplayName);
                            }
                            row.set("entryseq", (Object)subEntrySeq);
                            row.set("srcbillentryname", (Object)fullName);
                            continue;
                        }
                        int entrySeq = null == billEntryIdSeqMap || null == billEntryIdSeqMap.get(entryId) ? 0 : (Integer)((PairTuple)billEntryIdSeqMap.get(entryId)).getKey();
                        row.set("srcbillentryname", (Object)entryEntityDisplayName);
                        row.set("entryseq", (Object)entrySeq);
                        continue;
                    }
                    row.set("srcbillentryname", (Object)entryEntityDisplayName);
                }
                return rows;
            }

            private Map<Long, Map<Long, PairTuple<Integer, Integer>>> queryEntrySeq(Map<Long, Set<Long>> billIdEntryIdMap, EntityType entityType) {
                HashMap<Long, Map<Long, PairTuple<Integer, Integer>>> billIdEntryIdSeqMap = new HashMap<Long, Map<Long, PairTuple<Integer, Integer>>>(8);
                if (null == billIdEntryIdMap || billIdEntryIdMap.isEmpty()) {
                    return billIdEntryIdSeqMap;
                }
                if (entityType instanceof SubEntryType) {
                    IDataEntityProperty subEntrySeqProp = ((EntryType)entityType).getSeqProperty();
                    IDataEntityType parent = entityType.getParent();
                    IDataEntityProperty entrySeqProp = ((EntryType)parent).getSeqProperty();
                    if (StringUtils.isNotEmpty((String)subEntrySeqProp.getAlias()) && StringUtils.isNotEmpty((String)entrySeqProp.getAlias())) {
                        String billType = parent.getParent().getName();
                        String subEntryName = entityType.getName();
                        String entryName = parent.getName();
                        String pk = parent.getParent().getPrimaryKey().getName();
                        String entrySeq = entryName + "." + entrySeqProp.getName();
                        String subEntryPk = entryName + "." + subEntryName + "." + entityType.getPrimaryKey().getName();
                        String subEntrySeq = entryName + "." + subEntryName + "." + subEntrySeqProp.getName();
                        String select = pk + " id," + subEntryPk + " subentryid," + entrySeq + " entryseq," + subEntrySeq + " subentryseq";
                        Set subEntryIds = billIdEntryIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                        QFilter pkQFilter = new QFilter(pk, "in", billIdEntryIdMap.keySet());
                        QFilter entryIdQFilter = new QFilter(subEntryPk, "in", subEntryIds);
                        QFilter[] qFilters = new QFilter[]{pkQFilter, entryIdQFilter};
                        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryEntrySeq", (String)billType, (String)select, (QFilter[])qFilters, null);){
                            while (dataSet.hasNext()) {
                                Row row = dataSet.next();
                                Long id = row.getLong("id");
                                Long subEntryId = row.getLong("subentryid");
                                Integer entrySeqNum = row.getInteger("entryseq");
                                Integer subEntrySeqNum = row.getInteger("subentryseq");
                                Map entryIdSeqMap = billIdEntryIdSeqMap.computeIfAbsent(id, k -> new HashMap(8));
                                entryIdSeqMap.put(subEntryId, new PairTuple((Object)entrySeqNum, (Object)subEntrySeqNum));
                            }
                        }
                    }
                } else if (entityType instanceof EntryType) {
                    IDataEntityProperty seqProperty = ((EntryType)entityType).getSeqProperty();
                    if (StringUtils.isNotEmpty((String)seqProperty.getAlias())) {
                        String billType = entityType.getParent().getName();
                        String entryName = entityType.getName();
                        String pk = entityType.getParent().getPrimaryKey().getName();
                        String entryPk = entryName + "." + entityType.getPrimaryKey().getName();
                        String select = pk + " id," + entryPk + " entryid," + entryName + "." + seqProperty.getName() + " entryseq";
                        Set entryIds = billIdEntryIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                        QFilter pkQFilter = new QFilter(pk, "in", billIdEntryIdMap.keySet());
                        QFilter entryIdQFilter = new QFilter(entryPk, "in", entryIds);
                        QFilter[] qFilters = new QFilter[]{pkQFilter, entryIdQFilter};
                        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryEntrySeq", (String)billType, (String)select, (QFilter[])qFilters, null);){
                            while (dataSet.hasNext()) {
                                Row row = dataSet.next();
                                Long id = row.getLong("id");
                                Long entryId = row.getLong("entryid");
                                Integer entrySeqNum = row.getInteger("entryseq");
                                Map entryIdSeqMap = billIdEntryIdSeqMap.computeIfAbsent(id, k -> new HashMap(8));
                                entryIdSeqMap.put(entryId, new PairTuple((Object)entrySeqNum, (Object)0));
                            }
                        }
                    }
                } else {
                    return billIdEntryIdSeqMap;
                }
                return billIdEntryIdSeqMap;
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long requestId = this.getRequestId();
        if (null == requestId) {
            return;
        }
        e.getQFilters().add(new QFilter("requestid", "=", (Object)this.getRequestId()));
    }

    private Long getRequestId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("requestId");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        if ("srcbillno".equals(args.getFieldName())) {
            args.setCancel(true);
            long pk = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            FahTaskNoEvtBillInfo noEvtBillInfo = this.queryNoEvtBillInfo(pk);
            String billType = noEvtBillInfo.getBillType();
            Long srcBillId = noEvtBillInfo.getSrcBillId();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId(billType);
            showParameter.setPkId((Object)srcBillId);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("dispatchid_name".equals(args.getFieldName())) {
            args.setCancel(true);
            long pk = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            FahTaskNoEvtBillInfo noEvtBillInfo = this.queryNoEvtBillInfo(pk);
            Long dispatchId = noEvtBillInfo.getDispatchId();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("fah_evt_dispatch_scheme");
            showParameter.setPkId((Object)dispatchId);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private FahTaskNoEvtBillInfo queryNoEvtBillInfo(long pk) {
        return FahNoEvtBillsDao.queryNoEvtBillInfo((long)pk);
    }
}

