/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.event.VchValueSetFieldEnum;
import kd.fi.v2.fah.constant.enums.event.VchValueSetSelectEnum;
import kd.fi.v2.fah.constant.enums.event.VchValueSetTypeEnum;

public class FahVchFieldResetEdit
extends AbstractFormPlugin {
    private static final String Key_btnOK = "btnok";
    private static final String Key_btnCancel = "btncancel";
    private static final String VALUE_SET_TYPE = "valuesettype";
    private static final String BASEDATA = "basedata";
    private static final String SELECT_VALUE = "selectvalue";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
    }

    public void afterCreateNewData(EventObject e) {
        String fieldValue;
        super.afterCreateNewData(e);
        this.updateValueSetType();
        this.updateValueSelectCombo();
        String fieldSetType = (String)this.getView().getFormShowParameter().getCustomParam("fieldsettype");
        if (StringUtils.isNotEmpty((CharSequence)fieldSetType) && StringUtils.isNotEmpty((CharSequence)(fieldValue = (String)this.getView().getFormShowParameter().getCustomParam("fieldvalue")))) {
            String datatype = (String)this.getView().getFormShowParameter().getCustomParam("datatype");
            if (VchValueSetTypeEnum.CONSTANT.getCode().equals(fieldSetType) && String.valueOf(DataValueTypeEnum.BaseProp.getCode()).equals(datatype)) {
                this.getModel().setValue(BASEDATA, (Object)Long.parseLong(fieldValue));
            } else {
                this.getModel().setValue(SELECT_VALUE, (Object)fieldValue);
            }
        }
    }

    private void updateValueSetType() {
        VchValueSetFieldEnum fieldEnum;
        String fieldKey = (String)this.getView().getFormShowParameter().getCustomParam("fieldkey");
        if (StringUtils.isNotEmpty((CharSequence)fieldKey) && null != (fieldEnum = VchValueSetFieldEnum.getEnum((String)fieldKey))) {
            List<VchValueSetTypeEnum> valueSetTypes = null;
            switch (fieldEnum) {
                case CREATOR: {
                    valueSetTypes = Arrays.asList(VchValueSetTypeEnum.CONSTANT, VchValueSetTypeEnum.COMMON);
                    this.getModel().setValue("itemclasstype", (Object)"bos_user");
                    break;
                }
                case ATTACHMENT: 
                case BOOKDATE: 
                case BIZDATE: {
                    valueSetTypes = Arrays.asList(VchValueSetTypeEnum.CUSTOM, VchValueSetTypeEnum.COMMON);
                    break;
                }
            }
            this.updateValueSetTypeCombo(valueSetTypes);
        }
    }

    private void updateValueSetTypeCombo(List<VchValueSetTypeEnum> valueSetTypes) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(4);
        if (null != valueSetTypes && !valueSetTypes.isEmpty()) {
            for (VchValueSetTypeEnum typeEnum : valueSetTypes) {
                ComboItem item = new ComboItem();
                item.setValue(typeEnum.getCode());
                item.setCaption(new LocaleString(typeEnum.getName()));
                items.add(item);
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(VALUE_SET_TYPE);
        comboEdit.setComboItems(items);
        if (!items.isEmpty()) {
            String fieldSetType = (String)this.getView().getFormShowParameter().getCustomParam("fieldsettype");
            if (StringUtils.isNotEmpty((CharSequence)fieldSetType)) {
                this.getModel().setValue(VALUE_SET_TYPE, (Object)fieldSetType);
            } else {
                this.getModel().setValue(VALUE_SET_TYPE, (Object)((ComboItem)items.get(0)).getValue());
            }
        }
    }

    private void updateValueSelectCombo() {
        String fieldKey = (String)this.getView().getFormShowParameter().getCustomParam("fieldkey");
        String valueSetType = (String)this.getModel().getValue(VALUE_SET_TYPE);
        List selectEnums = null;
        if (StringUtils.isNotEmpty((CharSequence)fieldKey) && StringUtils.isNotEmpty((CharSequence)valueSetType)) {
            VchValueSetTypeEnum setTypeEnum = VchValueSetTypeEnum.getEnum((String)valueSetType);
            if (null != setTypeEnum) {
                if (VchValueSetTypeEnum.CUSTOM == setTypeEnum) {
                    VchValueSetFieldEnum fieldEnum = VchValueSetFieldEnum.getEnum((String)fieldKey);
                    if (null != fieldEnum) {
                        switch (fieldEnum) {
                            case ATTACHMENT: {
                                selectEnums = VchValueSetSelectEnum.getEnumByType((String)"2");
                                break;
                            }
                            case BOOKDATE: 
                            case BIZDATE: {
                                selectEnums = VchValueSetSelectEnum.getEnumByType((String)"1");
                                break;
                            }
                        }
                    }
                } else if (VchValueSetTypeEnum.COMMON == setTypeEnum) {
                    selectEnums = VchValueSetSelectEnum.getEnumByType((String)"3");
                }
            }
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            if (null != selectEnums && !selectEnums.isEmpty()) {
                for (VchValueSetSelectEnum typeEnum : selectEnums) {
                    ComboItem item = new ComboItem();
                    item.setValue(typeEnum.getCode());
                    item.setCaption(new LocaleString(typeEnum.getName()));
                    items.add(item);
                }
            }
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl(SELECT_VALUE);
            comboEdit.setComboItems(items);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "btnok": {
                VchValueSetSelectEnum selectEnum;
                String valueSetType = (String)this.getModel().getValue(VALUE_SET_TYPE);
                if (StringUtils.isEmpty((CharSequence)valueSetType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u503c\u65b9\u5f0f\u3002", (String)"FahVchFieldResetEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                String setValue = null;
                String displayName = null;
                if (VchValueSetTypeEnum.CONSTANT.getCode().equals(valueSetType)) {
                    DynamicObject baseData = (DynamicObject)this.getModel().getValue(BASEDATA);
                    if (null != baseData) {
                        setValue = baseData.getString("id");
                        displayName = baseData.getString("name");
                    }
                } else if ((VchValueSetTypeEnum.CUSTOM.getCode().equals(valueSetType) || VchValueSetTypeEnum.COMMON.getCode().equals(valueSetType)) && null != (selectEnum = VchValueSetSelectEnum.getEnum((String)(setValue = (String)this.getModel().getValue(SELECT_VALUE))))) {
                    displayName = selectEnum.getName();
                }
                if (StringUtils.isEmpty((CharSequence)setValue)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u503c\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FahVchFieldResetEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, String> result = new HashMap<String, String>(3);
                result.put("valueSetType", valueSetType);
                result.put("value", setValue);
                result.put("displayName", displayName);
                this.getView().returnDataToParent(result);
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (VALUE_SET_TYPE.equals(propertyName)) {
            this.getModel().setValue(BASEDATA, null);
            this.getModel().setValue(SELECT_VALUE, null);
            this.updateValueSelectCombo();
        }
    }
}

