/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.fi.ai.dap.cache.CacheHelper;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.v2.fah.formplugin.eventcenter.MyTask;

public class ProcessBillDataProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String CURRTASKKEY = "currProgress";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    public static final String CACHEKEY_STARTPROPGRESS = "startprogress";
    public static final String PROGRESS_TAG = "progress_tag_cache";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String progressTag = this.getPageCache().get(PROGRESS_TAG);
        if (progressTag == null) {
            Object pageId = this.getView().getFormShowParameter().getCustomParam("pageId");
            String newPageId = pageId != null ? pageId.toString() : UUID.randomUUID().toString();
            String currTaskTag = DBServiceHelper.genStringId() + "-XLA-" + newPageId;
            this.getPageCache().put(PROGRESS_TAG, currTaskTag);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    public void onProgress(ProgressEvent arg0) {
        String progressTag = this.getPageCache().get(PROGRESS_TAG);
        DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.GenerateVoucherTaskProcess);
        String currProgress = distributeCache.get(progressTag);
        if (null == currProgress) {
            arg0.setProgress(0);
            this.start();
            this.setProgressTip(ResManager.loadKDString((String)"\u6b63\u5728\u5206\u6279\u5904\u7406\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ProcessBillDataProgressPlugin_01", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        Map cacheDataMap = (Map)SerializationUtils.fromJsonString((String)currProgress, Map.class);
        int currprogress = 0;
        String message = "";
        Object progress = cacheDataMap.get(CURRTASKKEY);
        Object info = cacheDataMap.get("currProgress_info");
        Object error = cacheDataMap.get("currProgress_error");
        if (progress != null) {
            currprogress = (Integer)progress;
        }
        if (info != null) {
            message = (String)info;
        }
        if (currprogress >= 100) {
            Object operationResult = cacheDataMap.get("operationResult");
            Object billIdStr = cacheDataMap.get("billIds");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("pageId", this.getView().getFormShowParameter().getCustomParam("pageId"));
            if (operationResult != null) {
                data.put("operationResult", operationResult.toString());
            }
            if (billIdStr != null) {
                data.put("billIds", billIdStr.toString());
            }
            if (error != null) {
                data.put("error", error.toString());
            }
            distributeCache.remove(progressTag);
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(data));
            this.getView().close();
        }
        if (error != null) {
            message = (String)error;
        }
        arg0.setProgress(currprogress);
        this.setProgressTip(message);
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl("labelap");
        lblTip.setText(tip);
    }

    private void start() {
        DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.GenerateVoucherTaskProcess);
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(CACHEKEY_STARTPROPGRESS, "true");
        result.put(CURRTASKKEY, 0);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        boolean isReverse = "true".equals(showParameter.getCustomParam("isReverse"));
        if (isReverse) {
            result.put("currProgress_info", ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55\uff0c\u6b63\u5728\u6821\u9a8c\u5f85\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55\u6570\u636e\u3002", (String)"ProcessBillDataProgressPlugin_03", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        } else {
            result.put("currProgress_info", ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u751f\u6210\u5b50\u5206\u7c7b\u8d26\uff0c\u6b63\u5728\u8c03\u7528\u5b50\u5206\u7c7b\u8d26\u64cd\u4f5c\uff0c\u6b63\u5728\u6821\u9a8c\u5f85\u751f\u6210\u5b50\u5206\u7c7b\u8d26\u6570\u636e\u3002", (String)"ProcessBillDataProgressPlugin_02", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        String progressTag = this.getPageCache().get(PROGRESS_TAG);
        distributeCache.put(progressTag, SerializationUtils.toJsonString(result));
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.setPercent(0);
        String idStr = (String)showParameter.getCustomParam("ids");
        Set idSet = (Set)SerializationUtils.fromJsonString((String)idStr, Set.class);
        String entityId = (String)showParameter.getCustomParam("entityId");
        String opKey = (String)showParameter.getCustomParam("operateKey");
        String optionStr = (String)showParameter.getCustomParam("option");
        MyTask myTask = new MyTask(RequestContext.get(), idSet, entityId, progressTag, opKey, optionStr, isReverse);
        ThreadPools.executeOnce((String)"fah_build_xla_gl_tip", (Runnable)myTask);
    }

    private void stop() {
        String progressTag = this.getPageCache().get(PROGRESS_TAG);
        DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.GenerateVoucherTaskProcess);
        String currProgress = distributeCache.get(progressTag);
        if (currProgress == null) {
            return;
        }
        Map cacheDataMap = (Map)SerializationUtils.fromJsonString((String)currProgress, Map.class);
        cacheDataMap.put("stop", true);
        distributeCache.put(progressTag, SerializationUtils.toJsonString((Object)cacheDataMap));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.stop();
    }
}

