/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.extdata;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.AiBillStructure;
import kd.fi.ai.cache.CacheHelper;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.cache.DistributeCache;
import kd.fi.ai.util.AiEventClassEditUtil;
import kd.fi.ai.util.ContextUtil;
import kd.fi.ai.util.GLUtil;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.CreateTypeEnum;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.DefaultDataFieldGroupEnum;
import kd.fi.v2.fah.constant.enums.DisPlayPropEnum;
import kd.fi.v2.fah.constant.enums.ExtDataModelSystemFieldEnum;
import kd.fi.v2.fah.constant.enums.FieldPropEnum;
import kd.fi.v2.fah.constant.enums.StatusEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldPropCfg;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.util.ExtDataModelUtils;
import kd.fi.v2.fah.utils.DataModelUtils;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.utils.LicenseUtil;
import kd.fi.v2.fah.utils.ParamUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class ExtDataModelPlugin
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener,
TreeNodeClickListener,
SearchEnterListener {
    private static final String LEFT_TREE = "treeviewap";
    private static final String MAIN_ENTRY = "mainentry";
    private static final String BAR_SAVE = "bar_save";
    private static final String BAR_PREVIEW = "bar_preview";
    private static final String BAR_CLOSE = "bar_close";
    private static final String BAR_EDIT = "bar_edit";
    private static final String BAR_PUBLISH = "bar_publish";
    private static final String BAR_ENABLE = "bar_enable";
    private static final String BAR_DISABLE = "bar_disable";
    private static final String BATCH_ADD = "btn_batchadd";
    private static final String BTN_ADDROW = "btn_addrow";
    private static final String BTN_DELETEROW = "btn_deleterow";
    private static final String BTNEDIT = "btn_edit";
    private static final String BTNDELETE = "btn_delete";
    private static final String BTNADD = "btn_add";
    private static final String GROUP_SEQ_MAP = "GROUP_SEQ_MAP";
    private static final String VCH_TEMPLATE_REF = "VCH_TEMPLATE_REF";
    private static final String REQUIRED_CONDITION = "requiredcondition";
    private static final String REQUIRED_CONDITION_TAG = "requiredcondition_tag";
    private static final String GROUP_NUMBER = "GROUP_NUMBER";
    private static final String TREENODE_CACHE = "TREENODE_CACHE";
    private static final String GROUP_SELECTED = "GROUP_SELECTED";
    private static final Log logger = LogFactory.getLog(ExtDataModelPlugin.class);
    private static final String EXT_DATA_MODEL = "EXT_DATA_MODEL";
    private static final String IS_EDITABLE = "IS_EDITABLE";
    private static final String UNPUBLISHED_MODEL_ID = "UNPUBLISHED_MODEL_ID";
    private static final String FIELD_PROPERTY = "fieldproperty";
    private DataModelCfg extDataModel;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getView().getControl(LEFT_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{BAR_SAVE, BAR_PREVIEW, BAR_CLOSE, BAR_PUBLISH, BAR_ENABLE, BAR_DISABLE});
        this.addClickListeners(new String[]{REQUIRED_CONDITION_TAG, FIELD_PROPERTY});
        Toolbar mbar = (Toolbar)this.getView().getControl("itembar");
        mbar.addItemClickListener((ItemClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        BasedataEdit baseprop = (BasedataEdit)this.getControl("baseprop");
        baseprop.addBeforeF7SelectListener(evt -> {
            QFilter filter = new QFilter("modeltype", "=", (Object)"BaseFormModel");
            List<String> numbers = AiEventClassEditUtil.getBasedataInfoWithoutExt(this.getView().getPageId());
            QFilter typeFilter = new QFilter("number", "not in", numbers);
            filter.and(typeFilter);
            ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
            list.getListFilterParameter().setFilter(filter);
        });
        BasedataEdit assistprop = (BasedataEdit)this.getControl("assistprop");
        assistprop.addBeforeF7SelectListener(evt -> {
            ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
            list.setUseOrgId(ContextUtil.getUserId());
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.initExtDataModel();
        this.setPageData();
        this.initUserInfo();
        this.initLeftTree(this.isRealEdit());
        this.switchModelStatus(this.isEditable());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getView().getFormShowParameter().getCustomParam("isCopy") != null) {
            DataModelCfg dataModel = this.getExtDataModel();
            dataModel.setId(null);
            dataModel.setMasterId(null);
            this.cacheExtDataModel(DataModelUtils.updateDataModel((DataModelCfg)dataModel));
        }
    }

    private void switchModelStatus(Boolean flag) {
        if (flag.booleanValue()) {
            this.getView().setEnable(flag, new String[]{"name", "group", "templateno", "description", "apifield", "isenable", BTNADD, BTNEDIT, BTNDELETE, BAR_SAVE, BATCH_ADD, BTN_ADDROW, BAR_PUBLISH});
        } else {
            this.getView().setEnable(flag, new String[]{"number", "name", "group", "templateno", "description", "apifield", "isenable", BTNADD, BTNDELETE, BAR_SAVE, BATCH_ADD, BTN_ADDROW, BAR_PUBLISH});
        }
    }

    private boolean isEditable() {
        if (this.getView().getFormShowParameter().getCustomParam("viewVersion") != null) {
            this.getPageCache().put(IS_EDITABLE, "false");
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_PREVIEW, BAR_EDIT, BAR_ENABLE, BAR_DISABLE, BAR_PUBLISH, BAR_SAVE});
            return false;
        }
        String status = this.getPageCache().get(IS_EDITABLE);
        if (StringUtils.isEmpty((String)status)) {
            boolean publishedStatus = DataModelDaoImpl.isPublishedStatus((Long)this.getModelId());
            this.getPageCache().put(IS_EDITABLE, ObjectConverterFactory.getString((Object)(!publishedStatus ? 1 : 0)));
            return !publishedStatus;
        }
        return ObjectConverterFactory.getBoolean((Object)status);
    }

    private void setPageData() {
        this.extDataModel = this.getExtDataModel();
        if (this.getRealModelId() != null) {
            if (this.getModelId() == null) {
                this.extDataModel.setNumber(null);
                this.extDataModel.setName(null);
                this.extDataModel.setVersion(null);
            }
            this.getModel().setValue("number", (Object)this.extDataModel.getNumber());
            this.getModel().setValue("name", (Object)this.extDataModel.getName());
            this.getModel().setValue("creator", (Object)this.extDataModel.getCreatorId());
            this.getModel().setValue("versionnum", this.extDataModel.getVersion());
            this.getModel().setValue("group", (Object)this.extDataModel.getGroup());
            this.getModel().setValue("templateno", (Object)this.extDataModel.getTemplateno());
            this.getModel().setValue("description", (Object)this.extDataModel.getDescription());
        }
    }

    private Long getModelId() {
        if (this.getView().getFormShowParameter().getCustomParam("isCopy") != null) {
            return null;
        }
        return ObjectConverterFactory.getLong((Object)this.getView().getFormShowParameter().getCustomParam("id"));
    }

    private Long getRealModelId() {
        return ObjectConverterFactory.getLong((Object)this.getView().getFormShowParameter().getCustomParam("id"));
    }

    private void initExtDataModel() {
        PairTuple pair = DataModelDaoImpl.loadFromDBById((Long)this.getRealModelId());
        this.cacheGroupNumberMap((Set)pair.getValue());
        this.cacheExtDataModel((DataModelCfg)pair.getKey());
    }

    private Map<String, Integer> getGroupSeqMap() {
        HashMap<String, Integer> groupSeq;
        if (!StringUtils.isEmpty((String)this.getPageCache().get(GROUP_SEQ_MAP))) {
            groupSeq = (HashMap<String, Integer>)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(GROUP_SEQ_MAP));
        } else {
            groupSeq = new HashMap<String, Integer>(10);
            this.cacheGroupSeqMap(groupSeq);
        }
        return groupSeq;
    }

    private Set<String> getGroupNumberSet() {
        Set<String> groupNumber;
        if (!StringUtils.isEmpty((String)this.getPageCache().get(GROUP_NUMBER))) {
            groupNumber = (Set)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(GROUP_NUMBER));
        } else {
            groupNumber = new HashSet<String>();
            this.cacheGroupNumberMap(groupNumber);
        }
        return groupNumber;
    }

    private DataModelCfg getExtDataModel() {
        if (!StringUtils.isEmpty((String)this.getPageCache().get(EXT_DATA_MODEL))) {
            this.extDataModel = (DataModelCfg)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(EXT_DATA_MODEL));
        } else {
            this.extDataModel = new DataModelCfg();
            this.cacheExtDataModel(this.extDataModel);
        }
        return this.extDataModel;
    }

    private void cacheExtDataModel(DataModelCfg extDataModel) {
        this.getPageCache().put(EXT_DATA_MODEL, SerializationUtils.serializeToBase64((Object)extDataModel));
    }

    private void cacheGroupSeqMap(Map<String, Integer> groupSeqMap) {
        this.getPageCache().put(GROUP_SEQ_MAP, SerializationUtils.serializeToBase64(groupSeqMap));
    }

    private void cacheGroupNumberMap(Set<String> groupNumber) {
        this.getPageCache().put(GROUP_NUMBER, SerializationUtils.serializeToBase64(groupNumber));
    }

    private boolean isEdit() {
        Long id = this.getModelId();
        return id != null && id != 0L;
    }

    private boolean isRealEdit() {
        Long id = this.getRealModelId();
        return id != null && id != 0L;
    }

    private void initLeftTree(boolean loadFromDB) {
        TreeView tree = (TreeView)this.getView().getControl(LEFT_TREE);
        tree.deleteAllNodes();
        Map<String, Integer> getGroupSeqMap = this.getGroupSeqMap();
        HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>(16);
        this.extDataModel = this.getExtDataModel();
        if (loadFromDB) {
            DynamicObjectCollection groups = DataModelDaoImpl.queryDataGroupsByModelId((Long)this.getRealModelId());
            HashMap<String, List<DynamicObject>> groupMap = new HashMap<String, List<DynamicObject>>();
            LinkedList<DynamicObject> roots = new LinkedList<DynamicObject>();
            for (DynamicObject group : groups) {
                String parentNumber = group.getString("parent.longnumber");
                int seq = group.getInt("dseq");
                if (!StringUtils.isEmpty((String)parentNumber)) {
                    ArrayList<DynamicObject> list;
                    if (getGroupSeqMap.get(parentNumber) == null || getGroupSeqMap.get(parentNumber) < seq) {
                        getGroupSeqMap.put(parentNumber, seq);
                    }
                    if ((list = (ArrayList<DynamicObject>)groupMap.get(parentNumber)) == null) {
                        list = new ArrayList<DynamicObject>(1);
                        list.add(group);
                    } else {
                        list.add(group);
                    }
                    groupMap.put(parentNumber, list);
                    continue;
                }
                roots.add(group);
            }
            for (DynamicObject dyn : roots) {
                TreeNode root = new TreeNode();
                DefaultDataFieldGroupEnum groupEnum = DefaultDataFieldGroupEnum.getEnumByNumber((String)dyn.getString("longnumber"));
                root.setText(null != groupEnum ? groupEnum.getValue() : dyn.getString("groupname"));
                root.setId(dyn.getString("longnumber"));
                root.setLongNumber(dyn.getString("longnumber"));
                treeNodeMap.put(root.getId().toLowerCase(), root);
                this.buildSingleTree(root, groupMap, treeNodeMap);
                tree.addNode(root);
                for (String key : groupMap.keySet()) {
                    tree.expand(key);
                }
                if (!DefaultDataFieldGroupEnum.SYSTEM.getKey().equals(dyn.getString("groupnumber"))) continue;
                tree.focusNode(root);
                this.switchEntryItemBar(Boolean.FALSE);
                this.buildEntryByGroupInfo(DefaultDataFieldGroupEnum.SYSTEM.getKey(), this.extDataModel, false);
                this.getPageCache().put(GROUP_SELECTED, DefaultDataFieldGroupEnum.SYSTEM.getKey());
            }
        } else {
            for (DefaultDataFieldGroupEnum group : DefaultDataFieldGroupEnum.values()) {
                if (DefaultDataFieldGroupEnum.CUSTOM == group) continue;
                TreeNode root = new TreeNode();
                root.setText(new LocaleString(group.getValue()).getLocaleValue());
                root.setId(group.getKey());
                treeNodeMap.put(root.getId().toLowerCase(), root);
                tree.addNode(root);
                if (group != DefaultDataFieldGroupEnum.SYSTEM) continue;
                tree.focusNode(root);
                this.switchEntryItemBar(Boolean.FALSE);
                this.buildEntryByGroupInfo(DefaultDataFieldGroupEnum.SYSTEM.getKey(), this.extDataModel, false);
                this.getPageCache().put(GROUP_SELECTED, DefaultDataFieldGroupEnum.SYSTEM.getKey());
            }
        }
        this.cacheTreeNodeMap(treeNodeMap);
        this.cacheGroupSeqMap(getGroupSeqMap);
    }

    private void cacheTreeNodeMap(Map<String, TreeNode> treeNodeMap) {
        this.getPageCache().put(TREENODE_CACHE, SerializationUtils.serializeToBase64(treeNodeMap));
    }

    private void buildSingleTree(TreeNode father, Map<String, List<DynamicObject>> groupMap, Map<String, TreeNode> treeNodeMap) {
        List<DynamicObject> sons = groupMap.get(father.getLongNumber());
        if (CollectionUtils.isEmpty(sons)) {
            return;
        }
        for (DynamicObject son : sons) {
            TreeNode sonNode = new TreeNode();
            sonNode.setText(son.getString("groupname"));
            sonNode.setId(son.getString("longnumber"));
            sonNode.setLongNumber(son.getString("longnumber"));
            sonNode.setParentid(father.getId());
            treeNodeMap.put(sonNode.getId().toLowerCase(), sonNode);
            this.buildSingleTree(sonNode, groupMap, treeNodeMap);
            father.addChild(sonNode);
        }
    }

    private void switchEntryItemBar(Boolean flag) {
        if (!this.isEditable()) {
            flag = Boolean.FALSE;
        }
        this.getView().setEnable(flag, new String[]{BTN_DELETEROW, "btn_moveup", "btn_movedown"});
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String nodeId = (String)evt.getNodeId();
        DefaultDataFieldGroupEnum node = DefaultDataFieldGroupEnum.getEnumByNumber((String)nodeId);
        try {
            this.treeNodeClick(node, nodeId);
        }
        catch (KDBizException e) {
            evt.setCancel(true);
            throw e;
        }
    }

    private void treeNodeClick(DefaultDataFieldGroupEnum clickNode, String nodeId) {
        TreeView treeview = (TreeView)this.getView().getControl(LEFT_TREE);
        TreeNode focusNode = new TreeNode();
        focusNode.setId(nodeId);
        treeview.expand(nodeId);
        treeview.focusNode(focusNode);
        this.extDataModel = this.getExtDataModel();
        String selectedGroup = this.getPageCache().get(GROUP_SELECTED);
        if (nodeId.equals(selectedGroup)) {
            return;
        }
        switch (clickNode) {
            case SYSTEM: {
                this.buildEntryByGroupInfo(nodeId, this.extDataModel, true);
                this.switchEntryItemBar(Boolean.FALSE);
                break;
            }
            case HEAD: 
            case ENTRY: {
                this.saveEntryFieldsToDataModel(selectedGroup);
                this.switchEntryItemBar(Boolean.FALSE);
                this.clearEntryEntity();
                this.getPageCache().put(GROUP_SELECTED, nodeId);
                break;
            }
            default: {
                this.buildEntryByGroupInfo(nodeId, this.extDataModel, true);
                this.switchEntryItemBar(Boolean.TRUE);
            }
        }
    }

    private void clearEntryEntity() {
        this.getModel().deleteEntryData(MAIN_ENTRY);
    }

    private void buildEntryByGroupInfo(String groupNumber, DataModelCfg extDataModel, boolean isCheckOut) {
        String selectedGroup = this.getPageCache().get(GROUP_SELECTED);
        this.getPageCache().put(GROUP_SELECTED, groupNumber);
        if (isCheckOut && selectedGroup != null && !selectedGroup.equals(groupNumber)) {
            this.saveEntryFieldsToDataModel(selectedGroup);
        }
        this.clearEntryEntity();
        DataModelFieldCollection fieldEntrys = (DataModelFieldCollection)extDataModel.get((Object)groupNumber);
        boolean isSystemFieldGroup = DefaultDataFieldGroupEnum.SYSTEM.getKey().equals(groupNumber);
        if (fieldEntrys != null && !fieldEntrys.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(MAIN_ENTRY, fieldEntrys.size());
            int index = 0;
            for (DataModelFieldCfg fieldEntry : fieldEntrys) {
                this.getModel().setValue("fieldnumber", (Object)fieldEntry.getNumber(), index);
                String fieldName = null;
                if (isSystemFieldGroup) {
                    fieldName = ExtDataModelSystemFieldEnum.getNameByNumber((String)fieldEntry.getNumber());
                }
                this.getModel().setValue("fieldname", (Object)(null != fieldName ? fieldName : fieldEntry.getName()), index);
                this.getModel().setValue("createtype", (Object)fieldEntry.getCreateType(), index);
                this.getModel().setValue("isenable", (Object)fieldEntry.getEnable(), index);
                this.getModel().setValue("apifield", (Object)fieldEntry.getApifield(), index);
                if (fieldEntry.getDataType() != null) {
                    this.getModel().setValue("datatype", (Object)fieldEntry.getDataType().getCode(), index);
                    if (DataValueTypeEnum.BaseProp == fieldEntry.getDataType()) {
                        this.getModel().setValue("baseprop", (Object)fieldEntry.getRefBaseProp(), index);
                    } else if (DataValueTypeEnum.AssistProp == fieldEntry.getDataType()) {
                        this.getModel().setValue("assistprop", (Object)fieldEntry.getRefAssistProp(), index);
                    }
                }
                this.getModel().setValue("visible", (Object)fieldEntry.isVisible(), index);
                this.getModel().setValue("required", (Object)fieldEntry.isRequired(), index);
                String requiredCondition = fieldEntry.getRequiredCondition();
                if (!StringUtils.isEmpty((String)requiredCondition)) {
                    CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)requiredCondition, CRCondition.class);
                    this.getModel().setValue(REQUIRED_CONDITION, (Object)requiredCondition, index);
                    this.getModel().setValue(REQUIRED_CONDITION_TAG, (Object)condition.getExprDesc(), index);
                }
                if (fieldEntry.getProps() != null) {
                    DataModelFieldPropCfg[] props = (DataModelFieldPropCfg[])fieldEntry.getProps().getValues();
                    this.getModel().setValue("fieldproperty_link", (Object)(props != null ? JSON.toJSONString((Object)props) : null), index);
                    this.getModel().setValue(FIELD_PROPERTY, (Object)(props != null ? this.getFieldProperty(props) : null), index);
                } else {
                    this.getModel().setValue("fieldproperty_link", null, index);
                    this.getModel().setValue(FIELD_PROPERTY, null, index);
                }
                ++index;
            }
            for (int i = 0; i < fieldEntrys.size(); ++i) {
                if (!this.isEditable()) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"fieldnumber", "fieldname", "createtype", "apifield", "isenable", "datatype", "baseprop", "assistprop", FIELD_PROPERTY, "fieldproperty_link", "visible", "required", REQUIRED_CONDITION_TAG});
                    continue;
                }
                if (!isSystemFieldGroup) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"fieldnumber", "fieldname", "createtype", "apifield", "isenable", "datatype", "baseprop", "assistprop", "required", REQUIRED_CONDITION_TAG});
            }
        }
    }

    private String getFieldProperty(Object props) {
        StringBuilder stringBuilder = new StringBuilder();
        if (props != null) {
            if (props instanceof String && (props = DataModelUtils.fromJsonToDataModelField((String)((String)props)).getValues()) == null) {
                return stringBuilder.toString();
            }
            if (props instanceof DataModelFieldPropCfg[] && ((DataModelFieldPropCfg[])props).length == 0) {
                return stringBuilder.toString();
            }
            boolean needToAppendSpliter = false;
            for (DataModelFieldPropCfg prop : (DataModelFieldPropCfg[])props) {
                String value = (String)prop.getPropValue();
                if (prop.getName().equals(FieldPropEnum.DISPLAY.getNumber())) {
                    value = DisPlayPropEnum.getNameByNumber((String)value);
                } else if (prop.getName().equals(FieldPropEnum.DEFVALUEDESIGN.getNumber())) {
                    value = prop.valueByProp("name");
                }
                if (!needToAppendSpliter) {
                    needToAppendSpliter = true;
                } else {
                    stringBuilder.append(';');
                }
                FieldPropEnum propEnum = FieldPropEnum.getEnumByNumber((String)prop.getName());
                stringBuilder.append(null != propEnum ? propEnum.getName() : prop.getDescription()).append(':').append(value);
            }
        }
        return stringBuilder.toString();
    }

    private void initUserInfo() {
        DynamicObject userInfo;
        Long creatorId = this.getExtDataModel().getCreatorId();
        if (creatorId == null || creatorId == 0L) {
            creatorId = UserServiceHelper.getCurrentUserId();
        }
        if ((userInfo = DataModelDaoImpl.queryUserInfo((Object)creatorId)) == null) {
            return;
        }
        ((Label)this.getControl("personname")).setText(userInfo.getString("name"));
        ((Label)this.getControl("persondpt")).setText(userInfo.getString("entryentity.dpt.name"));
        ((Label)this.getControl("personphone")).setText(userInfo.getString("phone"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String keyName;
        super.afterDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        switch (keyName = operateInfo.getOperateKey()) {
            case "preview": {
                this.preView();
                break;
            }
            case "edit": {
                this.edit();
                break;
            }
            case "publish": {
                if (!this.saveModel()) break;
                this.publish();
                break;
            }
            case "enabledonothing": {
                this.enable();
                break;
            }
            case "disenable": {
                this.disable();
                break;
            }
            case "newentry": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(MAIN_ENTRY);
                int[] selectRows = entryGrid.getSelectRows();
                this.getModel().setValue("createtype", (Object)CreateTypeEnum.CUSTOM.getName(), selectRows[0]);
            }
        }
    }

    private boolean saveModel() {
        this.saveHeadInfoToDataModel();
        this.saveEntryFieldsToDataModel(this.getPageCache().get(GROUP_SELECTED));
        this.extDataModel = this.getExtDataModel();
        List errorMsgList = ExtDataModelUtils.validateCanSave((DataModelCfg)this.extDataModel);
        if (errorMsgList.isEmpty()) {
            try {
                long id = DataModelDaoImpl.save((DataModelCfg)this.extDataModel);
                this.getView().getFormShowParameter().setCustomParam("id", (Object)id);
                this.getView().getFormShowParameter().setCustomParam("isCopy", null);
                this.getView().cacheFormShowParameter();
                this.extDataModel.setId(Long.valueOf(id));
                this.extDataModel.setMasterId(DataModelDaoImpl.queryMasterIdById((Long)id));
                this.cacheExtDataModel(this.extDataModel);
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_PREVIEW});
                return true;
            }
            catch (KDBizException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        } else {
            StringBuilder errorText = new StringBuilder();
            for (String s : errorMsgList) {
                errorText.append(s);
            }
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("bos_operationresult");
            parameters.setShowTitle(false);
            parameters.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"ExtDataModelPlugin_40", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            parameters.setCustomParam("errorMsg", (Object)errorText.toString());
            this.getView().showForm(parameters);
        }
        return false;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_save": {
                LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
                if (!this.saveModel()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ExtDataModelPlugin_62", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4ec5\u4fdd\u5b58\u4fee\u6539\u540e\u6a21\u578b\u8349\u7a3f\uff0c\u53ea\u6709\u53d1\u5e03\u72b6\u6001\u624d\u80fd\u6309\u7167\u4fee\u6539\u540e\u6a21\u578b\u4f20\u5165\u6570\u636e\uff0c\u662f\u5426\u9700\u8981\u53d1\u5e03\uff1f", (String)"ExtDataModelPlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("needed_publish", (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                break;
            }
            case "btn_batchadd": {
                this.add();
                break;
            }
            case "bar_close": {
                this.close();
                break;
            }
        }
    }

    private void publish() {
        Object publish;
        Long modelId = this.getModelId();
        DynamicObject model = DataModelDaoImpl.loadSingleDataModelById((Long)modelId);
        if (DataModelDaoImpl.isPublishedStatus((Long)modelId)) {
            model = DataModelDaoImpl.queryUnpublishedRecord((Long)model.getLong("masterid"));
        }
        if ((publish = DataModelDaoImpl.publish((DynamicObject)model)) == null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"ExtDataModelPlugin_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(IS_EDITABLE, "false");
            this.switchEntryItemBar(Boolean.FALSE);
            this.switchModelStatus(this.isEditable());
            this.getPageCache().remove(GROUP_SELECTED);
            this.treeNodeClick(DefaultDataFieldGroupEnum.SYSTEM, DefaultDataFieldGroupEnum.SYSTEM.getKey());
            this.updateVersionNum();
        } else if (publish instanceof String) {
            this.getView().showErrorNotification((String)publish);
        } else if (publish instanceof Map) {
            Map result = (Map)publish;
            Map<String, Map> map = Collections.singletonMap(model.getString("number"), result);
            this.getPageCache().put(VCH_TEMPLATE_REF, SerializationUtils.serializeToBase64(map));
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("show_vchtemp_ref", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u5173\u95ed", (String)"ExtDataModelPlugin_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u67e5\u770b\u6a21\u677f\u5f15\u7528", (String)"ExtDataModelPlugin_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            HashSet fields = new HashSet(16);
            result.values().stream().forEach(o -> fields.addAll(o));
            String numberFormat = ResManager.loadKDString((String)"\u3010\u5b57\u6bb5\u7f16\u7801\uff1a%s\u3011", (String)"ExtDataModelPlugin_70", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            String nameFormat = ResManager.loadKDString((String)"<\u5b57\u6bb5\u540d\u79f0\uff1a%s>", (String)"ExtDataModelPlugin_71", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            StringBuilder sb = new StringBuilder();
            DataModelCfg extDataModel1 = DataModelDaoImpl.loadModelFromCache((String)this.getExtDataModel().getNumber());
            for (String field : fields) {
                String fieldName = String.format(nameFormat, ExtDataModelUtils.getFieldNameByNumber((String)field, (DataModelCfg)extDataModel1));
                field = String.format(numberFormat, field);
                sb.append(field).append(fieldName).append("\u3001");
            }
            sb.deleteCharAt(sb.lastIndexOf("\u3001"));
            String msg = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u4e2d\u5b58\u5728\u5f15\u7528\u5b57\u6bb5\u201c%s\u201d\uff0c\u8bf7\u5148\u5220\u9664\u5f15\u7528\u3002", (String)"ExtDataModelPlugin_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), sb);
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    private void updateVersionNum() {
        this.extDataModel = this.getExtDataModel();
        DynamicObject model = DataModelDaoImpl.queryDataModelByNumber((String)this.extDataModel.getNumber());
        this.extDataModel.setId(Long.valueOf(model.getLong("id")));
        this.extDataModel.setVersion((Object)model.getInt("versionnum"));
        this.getModel().setValue("versionnum", this.extDataModel.getVersion());
        this.cacheExtDataModel(this.extDataModel);
        this.getView().getFormShowParameter().setCustomParam("id", (Object)this.extDataModel.getId());
        this.getView().cacheFormShowParameter();
    }

    private void enable() {
        block22: {
            Long modelId = this.getModelId();
            if (null == modelId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u4e0d\u5141\u8bb8\u542f\u7528\u3002", (String)"ExtDataModelPlugin_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject model = DataModelDaoImpl.loadSingleDataModelById((Long)modelId);
            if (model.getString("enable").equals("1")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u542f\u7528\u72b6\u6001\u3002", (String)"ExtDataModelPlugin_7", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            String lockKey = ExtDataModelPlugin.getLockKey(model.getString("number"));
            try (DLock lock = DLock.create((String)lockKey).fastMode();){
                if (lock.tryLock()) {
                    if (!model.getString("status").equals(StatusEnum.PUBLISHED.getCode())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u53d1\u5e03\u72b6\u6001\u7684\u6a21\u578b\u624d\u80fd\u542f\u7528\u3002", (String)"ExtDataModelPlugin_8", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (model.getString("enable").equals("0")) {
                        DataModelDaoImpl.switchEnable((String)"1", (Long)modelId);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u3002", (String)"ExtDataModelPlugin_9", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    break block22;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5e03\u5f0f\u4e8b\u52a1\u9501\u52a0\u9501\u5931\u8d25\u3002", (String)"ExtDataModelPlugin_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void disable() {
        block18: {
            Long modelId = this.getModelId();
            if (null == modelId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"ExtDataModelPlugin_11", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject model = DataModelDaoImpl.loadSingleDataModelById((Long)this.getModelId());
            if (model.getString("enable").equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"ExtDataModelPlugin_12", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            String lockKey = ExtDataModelPlugin.getLockKey(model.getString("number"));
            try (DLock lock = DLock.create((String)lockKey).fastMode();){
                if (lock.tryLock()) {
                    if (model.getString("status").equals(StatusEnum.PUBLISHED.getCode()) && model.getString("enable").equals("1")) {
                        DataModelDaoImpl.switchEnable((String)"0", (Long)modelId);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u7981\u7528\u3002", (String)"ExtDataModelPlugin_13", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    break block18;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5e03\u5f0f\u4e8b\u52a1\u9501\u52a0\u9501\u5931\u8d25\u3002", (String)"ExtDataModelPlugin_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private static String getLockKey(String number) {
        return "lockKey$datamodel$" + number;
    }

    private void edit() {
        DynamicObject record;
        if (this.isEditable()) {
            return;
        }
        this.extDataModel = this.getExtDataModel();
        Long masterId = this.extDataModel.getMasterId();
        DynamicObject model = DataModelDaoImpl.loadSingleDataModelById((Long)this.extDataModel.getId());
        if (masterId == null) {
            masterId = model.getLong("masterid");
            this.extDataModel.setMasterId(masterId);
            this.cacheExtDataModel(this.extDataModel);
        }
        if ((record = DataModelDaoImpl.queryUnpublishedRecord((Long)masterId)) != null) {
            this.getPageCache().put(UNPUBLISHED_MODEL_ID, record.getString("id"));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u5b58\u5728\u7f16\u8f91\u8bb0\u5f55\uff0c\u662f\u5426\u83b7\u53d6\u4e0a\u4e00\u6b21\u4fee\u6539\u5185\u5bb9\uff1f", (String)"ExtDataModelPlugin_14", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("editModel"));
        } else {
            Long id = DataModelDaoImpl.copyModelDyn((DynamicObject)model, (boolean)true);
            this.getPageCache().put(UNPUBLISHED_MODEL_ID, ObjectConverterFactory.getString((Object)id));
            this.refreshPageWithDraft();
        }
    }

    private void refreshPageWithDraft() {
        this.getPageCache().put(IS_EDITABLE, "true");
        Long unpublishedModelId = ObjectConverterFactory.getLong((Object)this.getPageCache().get(UNPUBLISHED_MODEL_ID));
        this.getView().getFormShowParameter().setCustomParam("id", (Object)unpublishedModelId);
        this.getView().cacheFormShowParameter();
        this.afterCreateNewData(null);
        this.getView().setEnable(Boolean.FALSE, new String[]{BAR_PREVIEW, BAR_ENABLE, BAR_DISABLE});
    }

    private void add() {
        DynamicObject template = (DynamicObject)this.getModel().getValue("templateno");
        String selectedGroup = this.getPageCache().get(GROUP_SELECTED);
        if (DefaultDataFieldGroupEnum.SYSTEM.getKey().equals(selectedGroup) || DefaultDataFieldGroupEnum.HEAD.getKey().equals(selectedGroup) || DefaultDataFieldGroupEnum.ENTRY.getKey().equals(selectedGroup)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u6839\u8282\u70b9\u65b0\u589e\u5b57\u6bb5\uff0c\u8bf7\u5148\u5728\u5de6\u4fa7\u65b0\u589e\u6216\u8005\u9009\u62e9\u660e\u7ec6\u201c\u6570\u636e\u5b57\u6bb5\u5206\u7ec4\u201d\u3002", (String)"ExtDataModelPlugin_15", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        if (template == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u6a21\u677f\u3002", (String)"ExtDataModelPlugin_16", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("operation", BATCH_ADD);
        param.put("id", template.getString("id"));
        param.put("new", "true");
        this.extDataModel = this.getExtDataModel();
        ArrayList<AiBillStructure> list = new ArrayList<AiBillStructure>(8);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MAIN_ENTRY);
        for (DynamicObject dyn : entryEntity) {
            if (!StringUtils.isNotEmpty((String)dyn.getString("fieldnumber"))) continue;
            AiBillStructure field = new AiBillStructure();
            field.setNumber(dyn.getString("fieldnumber"));
            list.add(field);
        }
        param.put("relation_mapping", GLUtil.toSerializedString(list));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_meta_property_tree");
        showParameter.setCustomParams(param);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BATCH_ADD));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void preView() {
        Long masterId;
        Long modelId = this.getModelId();
        if (null == modelId) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u4e0d\u5141\u8bb8\u9884\u89c8\u3002", (String)"ExtDataModelPlugin_17", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.EXTDATAMODEL_PREVIEW);
        String pageId = cache.get(String.valueOf(masterId = DataModelDaoImpl.queryMasterIdById((Long)modelId)));
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)pageId) && null != this.getView().getViewNoPlugin(pageId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u5df2\u5b58\u5728\u6253\u5f00\u7684\u9884\u89c8\u9875\u9762\uff0c\u65e0\u6cd5\u91cd\u590d\u9884\u89c8\u3002", (String)"ExtDataModelPlugin_18", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        String curPageId = this.getView().getPageId();
        FormShowParameter param = new FormShowParameter();
        param.setFormId("fah_ext_dmpv_progress");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("pageId", (Object)curPageId);
        param.setCustomParam("modelId", (Object)modelId);
        param.setCustomParam("masterId", (Object)masterId);
        param.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "fah_ext_dmpv_progress"));
        this.getView().showForm(param);
    }

    private void close() {
        boolean flag = false;
        try {
            this.saveEntryFieldsToDataModel(this.getPageCache().get(GROUP_SELECTED));
        }
        catch (KDBizException e) {
            flag = true;
        }
        if (flag || this.isDataModelChanged()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u76f4\u63a5\u9000\u51fa\uff1f%1$s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ExtDataModelPlugin_63", (String)"fi-ai-formplugin", (Object[])new Object[0]), "\r\n"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("dataModelChanged"));
        } else {
            this.getView().close();
        }
    }

    private boolean isDataModelChanged() {
        this.saveHeadInfoToDataModel();
        if (this.isEdit()) {
            if (this.isEditable()) {
                return DataModelDaoImpl.isModelChanged((DataModelCfg)this.getExtDataModel());
            }
            return false;
        }
        this.extDataModel = this.getExtDataModel();
        return !StringUtils.isEmpty((String)this.extDataModel.getNumber()) || !StringUtils.isEmpty((String)this.extDataModel.getName()) || !StringUtils.isEmpty((String)this.extDataModel.getDescription()) || !StringUtils.isEmpty((String)this.extDataModel.getTemplateno()) || this.extDataModel.size() != 3;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if (event.getCallBackId().equals("dataModelChanged")) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getView().close();
            }
        } else if (event.getCallBackId().equals("editModel")) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.refreshPageWithDraft();
            } else {
                DataModelDaoImpl.deleteModelAndGroupEntryInfo((Long)ObjectConverterFactory.getLong((Object)this.getPageCache().get(UNPUBLISHED_MODEL_ID)));
                Long aLong = DataModelDaoImpl.copyModelDyn((DynamicObject)DataModelDaoImpl.loadSingleDataModelById((Long)this.getModelId()), (boolean)true);
                this.getPageCache().put(UNPUBLISHED_MODEL_ID, ObjectConverterFactory.getString((Object)aLong));
                this.refreshPageWithDraft();
            }
        } else if (event.getCallBackId().equals("show_vchtemp_ref")) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("fah_vchtemplate_fldref");
                parameter.setCustomParam("map", (Object)this.getPageCache().get(VCH_TEMPLATE_REF));
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
            }
        } else if (event.getCallBackId().equals("needed_publish") && MessageBoxResult.Yes.equals((Object)result)) {
            this.publish();
        }
    }

    private void saveHeadInfoToDataModel() {
        this.extDataModel = this.getExtDataModel();
        if (this.isEdit()) {
            this.extDataModel.setId(this.getModelId());
        }
        this.extDataModel.setNumber(((String)this.getModel().getValue("number")).toLowerCase());
        this.extDataModel.setName(((ILocaleString)this.getModel().getValue("name")).getLocaleValue());
        Long groupId = ObjectConverterFactory.getLong((Object)this.getModel().getValue("group_id"));
        this.extDataModel.setGroup(groupId == null || groupId == 0L ? null : groupId);
        DynamicObject templateno = (DynamicObject)this.getModel().getValue("templateno");
        this.extDataModel.setTemplateno(templateno != null ? templateno.getString("number") : null);
        String description = (String)this.getModel().getValue("description");
        this.extDataModel.setDescription(StringUtils.isEmpty((String)description) ? null : description);
        this.cacheExtDataModel(this.extDataModel);
    }

    /*
     * WARNING - void declaration
     */
    private void saveEntryFieldsToDataModel(String selectedGroup) {
        this.extDataModel = this.getExtDataModel();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(MAIN_ENTRY);
        HashMap<String, LinkedList<Integer>> map = new HashMap<String, LinkedList<Integer>>(entrys.size());
        int sequence = 0;
        for (Object entry : entrys) {
            String string = entry.getString("fieldnumber") == null ? "" : entry.getString("fieldnumber");
            LinkedList<Integer> seqs = (LinkedList<Integer>)map.get(string);
            if (seqs == null) {
                seqs = new LinkedList<Integer>();
            }
            seqs.add(++sequence);
            map.put(string, seqs);
        }
        StringBuilder errorMsg = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            String msg = "";
            String seqStr = StringUtils.join((Object[])((List)entry.getValue()).toArray(), (String)"\u3001");
            msg = StringUtils.isEmpty((String)((String)entry.getKey())) ? String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u4e0b\u7b2c\u201c%s\u201d\u884c\u7684\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"ExtDataModelPlugin_21", (String)"fi-ai-formplugin", (Object[])new Object[0]), seqStr) : String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u4e0b\u7b2c\u201c%1$s\u201d\u884c\u6709\u201c%2$s\u201d\u7f16\u7801\u91cd\u590d\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExtDataModelPlugin_22", (String)"fi-ai-formplugin", (Object[])new Object[0]), seqStr, entry.getKey());
            errorMsg.append(msg);
        }
        if (errorMsg.length() > 0) {
            throw new KDBizException(errorMsg.toString());
        }
        DataModelFieldCollection dataModelFieldCollection = (DataModelFieldCollection)this.extDataModel.get((Object)selectedGroup);
        if (dataModelFieldCollection == null) {
            return;
        }
        dataModelFieldCollection.clear();
        if (!entrys.isEmpty()) {
            boolean bl = false;
            for (DynamicObject dataEntry : entrys) {
                void var7_11;
                DataModelFieldCfg fieldCfg = new DataModelFieldCfg(null, dataEntry.getString("fieldnumber").toLowerCase(), dataEntry.getString("fieldname"));
                fieldCfg.setCreateType(dataEntry.getString("createtype"));
                DataValueTypeEnum datatype = DataValueTypeEnum.getEnum((String)dataEntry.getString("datatype"));
                fieldCfg.setDataType(datatype);
                fieldCfg.setEnable(Boolean.valueOf(dataEntry.getBoolean("isenable")));
                fieldCfg.setApifield(dataEntry.getString("apifield"));
                if (DataValueTypeEnum.BaseProp == datatype) {
                    DynamicObject refObj = (DynamicObject)dataEntry.get("baseprop");
                    fieldCfg.setRefBaseProp(refObj == null ? null : refObj.getString("number"));
                } else if (DataValueTypeEnum.AssistProp == datatype) {
                    DynamicObject assistprop = (DynamicObject)dataEntry.get("assistprop");
                    fieldCfg.setRefAssistProp(assistprop == null ? null : Long.valueOf(assistprop.getLong("id")));
                }
                String propertyJSON = dataEntry.getString("fieldproperty_link");
                fieldCfg.setProps(DataModelUtils.fromJsonToDataModelField((String)propertyJSON));
                fieldCfg.setVisible(dataEntry.getBoolean("visible"));
                fieldCfg.setRequired(dataEntry.getBoolean("required"));
                fieldCfg.setRequiredCondition(dataEntry.getString(REQUIRED_CONDITION));
                fieldCfg.setSeq(Integer.valueOf((int)(++var7_11)));
                dataModelFieldCollection.cache((Object)fieldCfg);
            }
            dataModelFieldCollection.flush();
        } else {
            DataModelFieldCollection dataModelFieldCollection2 = (DataModelFieldCollection)this.extDataModel.get((Object)selectedGroup);
            dataModelFieldCollection2.clear();
        }
        this.cacheExtDataModel(this.extDataModel);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String selectedGroup = this.getPageCache().get(GROUP_SELECTED);
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        switch (propertyName) {
            case "datatype": {
                if (DefaultDataFieldGroupEnum.SYSTEM.getKey().equalsIgnoreCase(selectedGroup) || !this.isEditable()) break;
                BaseMutableArrayMapStorage props = new BaseMutableArrayMapStorage();
                switch (DataValueTypeEnum.getEnum((Byte)ObjectConverterFactory.getByte((Object)newValue))) {
                    case String: {
                        props.addEx((Object)new DataModelFieldPropCfg(FieldPropEnum.MAXLENGTH.getNumber(), Integer.class, (Object)"50", ResManager.loadKDString((String)"\u5b57\u6bb5\u957f\u5ea6", (String)"ExtDataModelPlugin_41", (String)"fi-ai-formplugin", (Object[])new Object[0])));
                        view.setEnable(Boolean.TRUE, rowIndex, new String[]{"required", REQUIRED_CONDITION_TAG});
                        break;
                    }
                    case AssistProp: 
                    case BaseProp: {
                        props.addEx((Object)new DataModelFieldPropCfg(FieldPropEnum.MAXLENGTH.getNumber(), Integer.class, (Object)"50", ResManager.loadKDString((String)"\u5b57\u6bb5\u957f\u5ea6", (String)"ExtDataModelPlugin_41", (String)"fi-ai-formplugin", (Object[])new Object[0])));
                        props.addEx((Object)new DataModelFieldPropCfg(FieldPropEnum.DISPLAY.getNumber(), String.class, (Object)"name", ResManager.loadKDString((String)"\u663e\u793a\u5c5e\u6027", (String)"ExtDataModelPlugin_42", (String)"fi-ai-formplugin", (Object[])new Object[0])));
                        view.setEnable(Boolean.TRUE, rowIndex, new String[]{"required", REQUIRED_CONDITION_TAG});
                        break;
                    }
                    case Decimal: {
                        props.addEx((Object)new DataModelFieldPropCfg(FieldPropEnum.SCALE.getNumber(), Integer.class, (Object)"2", ResManager.loadKDString((String)"\u5b57\u6bb5\u7cbe\u5ea6", (String)"ExtDataModelPlugin_43", (String)"fi-ai-formplugin", (Object[])new Object[0])));
                        dataModel.setValue("required", (Object)Boolean.TRUE, rowIndex);
                        dataModel.setValue(REQUIRED_CONDITION_TAG, null, rowIndex);
                        view.setEnable(Boolean.valueOf(!ParamUtils.isMustInput()), rowIndex, new String[]{"required", REQUIRED_CONDITION_TAG});
                        break;
                    }
                    case Int: {
                        props.addEx((Object)new DataModelFieldPropCfg(FieldPropEnum.SCALE.getNumber(), Integer.class, (Object)"0", ResManager.loadKDString((String)"\u5b57\u6bb5\u7cbe\u5ea6", (String)"ExtDataModelPlugin_43", (String)"fi-ai-formplugin", (Object[])new Object[0])));
                        dataModel.setValue("required", (Object)Boolean.TRUE, rowIndex);
                        dataModel.setValue(REQUIRED_CONDITION_TAG, null, rowIndex);
                        view.setEnable(Boolean.FALSE, rowIndex, new String[]{"required", REQUIRED_CONDITION_TAG});
                        break;
                    }
                    case Date: {
                        props.addEx((Object)new DataModelFieldPropCfg(FieldPropEnum.DATEFORMAT.getNumber(), String.class, (Object)"yyyy-MM-dd", ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f", (String)"ExtDataModelPlugin_44", (String)"fi-ai-formplugin", (Object[])new Object[0])));
                        view.setEnable(Boolean.TRUE, rowIndex, new String[]{"required", REQUIRED_CONDITION_TAG});
                        break;
                    }
                    default: {
                        view.setEnable(Boolean.TRUE, rowIndex, new String[]{"required", REQUIRED_CONDITION_TAG});
                    }
                }
                dataModel.setValue("fieldproperty_link", (Object)JSON.toJSONString((Object)props.getValues()), rowIndex);
                dataModel.setValue(FIELD_PROPERTY, (Object)this.getFieldProperty(props.getValues()), rowIndex);
                if (!this.isEditable()) break;
                if (DataValueTypeEnum.BaseProp.getCode() == ObjectConverterFactory.getByte((Object)newValue).byteValue()) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"assistprop"});
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"baseprop"});
                    this.getModel().setValue("assistprop", null, rowIndex);
                    break;
                }
                if (DataValueTypeEnum.AssistProp.getCode() == ObjectConverterFactory.getByte((Object)newValue).byteValue()) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"baseprop"});
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"assistprop"});
                    this.getModel().setValue("baseprop", null, rowIndex);
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"assistprop", "baseprop"});
                this.getModel().setValue("baseprop", null, rowIndex);
                this.getModel().setValue("assistprop", null, rowIndex);
                break;
            }
            case "templateno": {
                if (oldValue == null) break;
                this.reInitDataModel();
                break;
            }
            case "requiredcondition_tag": {
                if (newValue != null && !StringUtils.isEmpty((Object)newValue)) break;
                this.getModel().setValue(REQUIRED_CONDITION, null, rowIndex);
                break;
            }
            case "fieldproperty": {
                if (!StringUtils.isEmpty((Object)newValue)) break;
                dataModel.setValue("fieldproperty_link", null);
                break;
            }
            case "required": {
                if (!((Boolean)newValue).booleanValue()) {
                    this.getModel().setValue(REQUIRED_CONDITION_TAG, null, rowIndex);
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{REQUIRED_CONDITION_TAG});
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{REQUIRED_CONDITION_TAG});
                break;
            }
            case "baseprop": {
                DynamicObject data;
                BasedataEntityType bnt;
                if (newValue == null || !StringUtils.isEmpty((String)(bnt = (BasedataEntityType)(data = BusinessDataServiceHelper.newDynamicObject((String)((DynamicObject)newValue).getString("number"))).getDynamicObjectType()).getNumberProperty())) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6ca1\u6709\u7f16\u7801\uff0c\u65e0\u6cd5\u5bfc\u5165\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u57fa\u7840\u8d44\u6599\u3002", (String)"ExtDataModelPlugin_45", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("baseprop", null, rowIndex);
                return;
            }
        }
    }

    private void reInitDataModel() {
        this.extDataModel = this.getExtDataModel();
        for (DataModelFieldCollection group : (BaseMutableArrayMapStorage)this.extDataModel.getCollections()) {
            if (group.getNumber().equalsIgnoreCase(DefaultDataFieldGroupEnum.SYSTEM.getKey())) continue;
            group.clear();
        }
        this.cacheExtDataModel(this.extDataModel);
        TreeView tree = (TreeView)this.getView().getControl(LEFT_TREE);
        tree.focusNode(new TreeNode(null, DefaultDataFieldGroupEnum.SYSTEM.getKey(), null));
        this.switchEntryItemBar(Boolean.FALSE);
        this.getPageCache().put(GROUP_SELECTED, DefaultDataFieldGroupEnum.SYSTEM.getKey());
        this.buildEntryByGroupInfo(DefaultDataFieldGroupEnum.SYSTEM.getKey(), this.extDataModel, false);
    }

    private void updateGroup(DataModelCfg extDataModel, String newLongNumber, String oldLongNumber, String newGroupName, Map<String, TreeNode> treeNodeMap, Map<String, Integer> groupSeq, Set<String> groupNumber) {
        TreeView tree = (TreeView)this.getView().getControl(LEFT_TREE);
        boolean isEditNumber = !newLongNumber.equals(oldLongNumber);
        tree.deleteNode(oldLongNumber);
        TreeNode node = new TreeNode();
        node.setText(newGroupName);
        node.setId(newLongNumber);
        node.setParentid(DataModelUtils.getParentLongNumber((String)newLongNumber));
        tree.addNode(node);
        tree.focusNode(node);
        DataModelFieldCollection dataModelFieldCollection = (DataModelFieldCollection)extDataModel.get((Object)oldLongNumber);
        Set childNodeId = extDataModel.getEntryHierarchyIndexList(oldLongNumber);
        if (childNodeId.size() > 0) {
            for (String oldChildLongNumber : childNodeId) {
                String newChildLongNumber;
                DataModelFieldCollection child = (DataModelFieldCollection)extDataModel.get((Object)oldChildLongNumber);
                String string = newChildLongNumber = isEditNumber ? newLongNumber + '|' + DataModelUtils.getNumber((String)oldChildLongNumber) : oldChildLongNumber;
                if (isEditNumber) {
                    extDataModel.removeByIndex(extDataModel.getIndex((Object)oldChildLongNumber));
                    child.setNumber(newChildLongNumber);
                    extDataModel.cache((Object)child);
                }
                TreeNode childNode = new TreeNode();
                childNode.setId(newChildLongNumber);
                childNode.setParentid(newLongNumber);
                childNode.setText(child.getName());
                node.addChild(childNode);
                tree.addNode(childNode);
                tree.deleteNode(oldChildLongNumber);
                treeNodeMap.put(newChildLongNumber, childNode);
            }
        }
        treeNodeMap.remove(oldLongNumber);
        treeNodeMap.put(newLongNumber, node);
        tree.updateNode(node);
        tree.expand(newLongNumber);
        if (isEditNumber) {
            extDataModel.removeByIndex(extDataModel.getIndex((Object)oldLongNumber));
        }
        dataModelFieldCollection.setName(newGroupName);
        dataModelFieldCollection.setNumber(newLongNumber);
        if (isEditNumber) {
            extDataModel.cache((Object)dataModelFieldCollection);
        }
        if (isEditNumber) {
            groupNumber.remove(DataModelUtils.getNumber((String)oldLongNumber).toLowerCase());
            groupNumber.add(DataModelUtils.getNumber((String)newLongNumber).toLowerCase());
            groupSeq.remove(oldLongNumber);
            groupSeq.put(newLongNumber, groupSeq.get(oldLongNumber));
        }
    }

    public void closedCallBack(ClosedCallBackEvent backEvent) {
        Map preViewResult;
        Object returnData;
        super.closedCallBack(backEvent);
        String actionId = backEvent.getActionId();
        DataModelCfg extDataModel = this.getExtDataModel();
        Map<String, Integer> groupSeq = this.getGroupSeqMap();
        Set<String> groupNumber = this.getGroupNumberSet();
        Map treeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(TREENODE_CACHE));
        TreeView tree = (TreeView)this.getView().getControl(LEFT_TREE);
        if (BATCH_ADD.equals(actionId)) {
            if (backEvent.getReturnData() != null) {
                List list = SerializationUtils.fromJsonStringToList((String)backEvent.getReturnData().toString(), AiBillStructure.class);
                this.createEntry(list);
            }
        } else if ("showFieldGroup".equals(actionId)) {
            String jsonString = (String)backEvent.getReturnData();
            if (jsonString != null && !jsonString.isEmpty()) {
                Map groupMap = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
                String groupName = (String)groupMap.get("groupname");
                String longNumber = (String)groupMap.get("longnumber");
                String parentLongNumber = (String)groupMap.get("groupLongNumber");
                if (groupMap.get("status").equals("ADDNEW")) {
                    TreeNode node = new TreeNode();
                    node.setText(groupName);
                    node.setId(longNumber);
                    groupNumber.add(DataModelUtils.getNumber((String)longNumber).toLowerCase());
                    node.setParentid(parentLongNumber);
                    Long id = (Long)groupMap.get("id");
                    int seq = (Integer)groupMap.get("seq");
                    DataModelFieldCollection dataModelFieldCollection = new DataModelFieldCollection(id, longNumber, (String)groupMap.get("groupname"));
                    dataModelFieldCollection.setGroupType(DefaultDataFieldGroupEnum.getEnumByNumber((String)((String)groupMap.get("grouptype"))));
                    dataModelFieldCollection.setParentId(((DataModelFieldCollection)extDataModel.get((Object)parentLongNumber)).getId().longValue());
                    dataModelFieldCollection.setGroupSeq(seq);
                    dataModelFieldCollection.setGroupLevel(longNumber.split("\\|").length - 1);
                    groupSeq.put(parentLongNumber, seq);
                    extDataModel.cache((Object)dataModelFieldCollection);
                    this.switchEntryItemBar(Boolean.TRUE);
                    this.buildEntryByGroupInfo(longNumber, extDataModel, true);
                    tree.addNode(node);
                    tree.expand(parentLongNumber);
                    tree.focusNode(node);
                    treeNodeMap.put(longNumber, node);
                } else {
                    if (parentLongNumber.equals(longNumber) && groupName.equals(tree.getTreeState().getFocusNode().get("text"))) {
                        return;
                    }
                    this.updateGroup(extDataModel, longNumber, parentLongNumber, groupName, treeNodeMap, groupSeq, groupNumber);
                }
                extDataModel.flush();
            }
        } else if ("showFieldProp".equals(actionId)) {
            String propertyJSON = (String)backEvent.getReturnData();
            if (propertyJSON != null && !propertyJSON.isEmpty()) {
                IDataModel dataModel = this.getModel();
                String fieldNumber = (String)dataModel.getValue("fieldnumber");
                DataModelFieldCfg fieldCfg = (DataModelFieldCfg)((DataModelFieldCollection)extDataModel.get((Object)tree.getTreeState().getFocusNodeId())).get((Object)fieldNumber.toLowerCase());
                if (fieldCfg != null) {
                    fieldCfg.setProps(DataModelUtils.fromJsonToDataModelField((String)propertyJSON));
                }
                dataModel.setValue("fieldproperty_link", (Object)propertyJSON);
                dataModel.setValue(FIELD_PROPERTY, (Object)this.getFieldProperty(propertyJSON));
            }
        } else if (REQUIRED_CONDITION_TAG.equals(actionId)) {
            if (backEvent.getReturnData() != null) {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)backEvent.getReturnData().toString(), CRCondition.class);
                this.getModel().setValue(REQUIRED_CONDITION, backEvent.getReturnData());
                this.getModel().setValue(REQUIRED_CONDITION_TAG, (Object)condition.getExprDesc());
            }
        } else if ("fah_ext_dmpv_progress".equals(actionId) && null != (returnData = backEvent.getReturnData()) && null != (preViewResult = (Map)FahSerializeHelper.fromJsonString((String)returnData.toString(), Map.class))) {
            boolean success = ObjectConverterFactory.getBoolean(preViewResult.get("success"), (Boolean)Boolean.FALSE);
            if (Boolean.TRUE.equals(success)) {
                Long masterId = ObjectConverterFactory.getLong(preViewResult.get("masterId"), (Long)0L);
                FormShowParameter previewParameter = new FormShowParameter();
                previewParameter.setFormId((String)preViewResult.get("preViewFormNumber"));
                previewParameter.setStatus(OperationStatus.VIEW);
                previewParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                previewParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BAR_PREVIEW));
                previewParameter.setCustomParam("masterid", (Object)masterId);
                DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.EXTDATAMODEL_PREVIEW);
                cache.put(String.valueOf(masterId), previewParameter.getPageId());
                this.getView().showForm(previewParameter);
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9884\u89c8\u5931\u8d25\uff1a\u201c%s\u201d\u3002", (String)"ExtDataModelPlugin_19", (String)"fi-ai-formplugin", (Object[])new Object[0]), preViewResult.get("message")));
            }
        }
        this.cacheTreeNodeMap(treeNodeMap);
        this.cacheGroupNumberMap(groupNumber);
        this.cacheGroupSeqMap(groupSeq);
        this.cacheExtDataModel(extDataModel);
    }

    private void createEntry(List<AiBillStructure> list) {
        if (!list.isEmpty()) {
            ArrayList<AiBillStructure> listHead = new ArrayList<AiBillStructure>(8);
            ArrayList<AiBillStructure> listEntry = new ArrayList<AiBillStructure>(8);
            for (AiBillStructure structure : list) {
                if (kd.bos.util.StringUtils.isBlank((String)structure.getNumber()) || kd.bos.util.StringUtils.isBlank((String)structure.getGroupNumber())) continue;
                if (structure.getNumber().equals(structure.getGroupNumber())) {
                    listHead.add(structure);
                    continue;
                }
                listEntry.add(structure);
            }
            String selectedGroup = this.getPageCache().get(GROUP_SELECTED);
            if (selectedGroup.startsWith(DefaultDataFieldGroupEnum.HEAD.getKey()) && !listEntry.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5728\u6570\u636e\u5934\u5206\u7ec4\u4e0b\u6dfb\u52a0\u5355\u636e\u5206\u5f55\u8282\u70b9\u3002", (String)"ExtDataModelPlugin_46", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectedGroup.startsWith(DefaultDataFieldGroupEnum.ENTRY.getKey()) && !listHead.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5728\u6570\u636e\u5206\u5f55\u5206\u7ec4\u4e0b\u6dfb\u52a0\u5355\u636e\u5934\u8282\u70b9\u3002", (String)"ExtDataModelPlugin_47", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().deleteEntryData(MAIN_ENTRY);
            if (selectedGroup.startsWith(DefaultDataFieldGroupEnum.HEAD.getKey())) {
                this.getModel().batchCreateNewEntryRow(MAIN_ENTRY, listHead.size());
            } else if (selectedGroup.startsWith(DefaultDataFieldGroupEnum.ENTRY.getKey())) {
                this.getModel().batchCreateNewEntryRow(MAIN_ENTRY, listEntry.size());
            }
            int i = 0;
            for (AiBillStructure structure : list) {
                this.getModel().setValue("fieldnumber", (Object)structure.getNumber(), i);
                this.getModel().setValue("fieldname", (Object)structure.getName(), i);
                this.getModel().setValue("createtype", (Object)CreateTypeEnum.CUSTOM.getName(), i);
                if (DataValueTypeEnum.Decimal == DataValueTypeEnum.getEnumByNumber((String)structure.getData_type())) {
                    this.getModel().setValue("required", (Object)(!ParamUtils.isMustInput() ? 1 : 0), i);
                } else {
                    this.getModel().setValue("required", (Object)structure.getRequired(), i);
                }
                this.getModel().setValue("datatype", (Object)DataValueTypeEnum.getEnumByNumber((String)structure.getData_type()).getCode(), i);
                if (DataValueTypeEnum.AssistProp == DataValueTypeEnum.getEnumByNumber((String)structure.getData_type())) {
                    this.getModel().setValue("assistprop", (Object)structure.getData_schema(), i);
                } else if (DataValueTypeEnum.BaseProp == DataValueTypeEnum.getEnumByNumber((String)structure.getData_type())) {
                    this.getModel().setValue("baseprop", (Object)structure.getData_schema(), i);
                }
                ++i;
            }
            this.getView().updateView(MAIN_ENTRY);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        if (REQUIRED_CONDITION_TAG.equals(key)) {
            this.saveEntryFieldsToDataModel(this.getPageCache().get(GROUP_SELECTED));
            this.checkBaseAssisantPropValid();
            this.showConditionForm("false");
        } else if (FIELD_PROPERTY.equals(key)) {
            String fieldproperty;
            TreeView tree = (TreeView)this.getView().getControl(LEFT_TREE);
            FormShowParameter modelFldProp = new FormShowParameter();
            if (tree.getTreeState().getFocusNodeId().equals(DefaultDataFieldGroupEnum.SYSTEM.getKey())) {
                modelFldProp.setCustomParam("isOnlyEditDef", (Object)Boolean.TRUE);
            }
            IDataModel dataModel = this.getModel();
            String fieldNumber = (String)dataModel.getValue("fieldnumber");
            if (dataModel.getValue("datatype") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5\u7c7b\u578b\u3002", (String)"ExtDataModelPlugin_48", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            if (fieldNumber == null || fieldNumber.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b57\u6bb5\u7f16\u7801\u3002", (String)"ExtDataModelPlugin_49", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            String fieldtype = (String)dataModel.getValue("datatype");
            if (ObjectConverterFactory.getByte((Object)fieldtype).byteValue() == DataValueTypeEnum.BaseProp.getCode()) {
                if (dataModel.getValue("baseprop") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u57fa\u7840\u8d44\u6599\u3002", (String)"ExtDataModelPlugin_50", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                modelFldProp.setCustomParam("baseprop", (Object)((DynamicObject)dataModel.getValue("baseprop")).getString("number"));
            } else if (ObjectConverterFactory.getByte((Object)fieldtype).byteValue() == DataValueTypeEnum.AssistProp.getCode()) {
                if (dataModel.getValue("assistprop") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8f85\u52a9\u57fa\u7840\u8d44\u6599\u3002", (String)"ExtDataModelPlugin_51", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                modelFldProp.setCustomParam("assistprop", (Object)((DynamicObject)dataModel.getValue("assistprop")).getString("number"));
            }
            modelFldProp.setFormId("fah_ext_model_fldprop");
            modelFldProp.getOpenStyle().setShowType(ShowType.Modal);
            modelFldProp.setStatus(OperationStatus.EDIT);
            modelFldProp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showFieldProp"));
            DataModelFieldCollection select = (DataModelFieldCollection)this.getExtDataModel().get((Object)tree.getTreeState().getFocusNodeId());
            if (select != null && (fieldproperty = (String)this.getModel().getValue(FIELD_PROPERTY)) != null && !fieldproperty.isEmpty()) {
                fieldproperty = (String)this.getModel().getValue("fieldproperty_link");
                modelFldProp.setCustomParam("properties_tag", (Object)fieldproperty);
            }
            modelFldProp.setCustomParam("fieldtype", (Object)fieldtype);
            this.getView().showForm(modelFldProp);
        }
    }

    private void checkBaseAssisantPropValid() {
        for (DataModelFieldCollection group : (BaseMutableArrayMapStorage)this.getExtDataModel().getCollections()) {
            if (group.getCollections() == null) continue;
            for (DataModelFieldCfg field : (BaseMutableArrayMapStorage)group.getCollections()) {
                if (DataValueTypeEnum.BaseProp == field.getDataType() && StringUtils.isEmpty((String)field.getRefBaseProp())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u5b57\u6bb5\u57fa\u7840\u8d44\u6599\u3002", (String)"ExtDataModelPlugin_52", (String)"fi-ai-formplugin", (Object[])new Object[0]), field.getNumber()));
                }
                if (DataValueTypeEnum.AssistProp != field.getDataType() || field.getRefAssistProp() != null) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u5b57\u6bb5\u8f85\u52a9\u8d44\u6599\u3002", (String)"ExtDataModelPlugin_53", (String)"fi-ai-formplugin", (Object[])new Object[0]), field.getNumber()));
            }
        }
    }

    private void showConditionForm(String readEntry) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fah_ext_model_formula");
        int rowIndex = this.getModel().getEntryCurrentRowIndex(MAIN_ENTRY);
        String conditionJson = (String)this.getModel().getValue(REQUIRED_CONDITION, rowIndex);
        showParameter.getCustomParams().put("readentry", readEntry);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entityInfo", DynamicObjectSerializeUtil.serialize((Object[])new Object[]{this.getModel().getDataEntity(true)}, (DynamicObjectType)this.getModel().getDataEntityType()));
        showParameter.getCustomParams().put("datamodel", SerializationUtils.serializeToBase64((Object)this.getExtDataModel()));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REQUIRED_CONDITION_TAG));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        String selectedGroup = this.getPageCache().get(GROUP_SELECTED);
        switch (keyName) {
            case "newentry": {
                if (!DefaultDataFieldGroupEnum.SYSTEM.getKey().equals(selectedGroup) && !DefaultDataFieldGroupEnum.HEAD.getKey().equals(selectedGroup) && !DefaultDataFieldGroupEnum.ENTRY.getKey().equals(selectedGroup)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u6839\u8282\u70b9\u65b0\u589e\u5b57\u6bb5\uff0c\u8bf7\u5148\u5728\u5de6\u4fa7\u65b0\u589e\u6216\u8005\u9009\u62e9\u660e\u7ec6\u201c\u6570\u636e\u5b57\u6bb5\u5206\u7ec4\u201d\u3002", (String)"ExtDataModelPlugin_15", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        TreeView treeview = (TreeView)this.getView().getControl(LEFT_TREE);
        String longNumber = treeview.getTreeState().getFocusNodeId();
        String btnName = ((Control)evt.getSource()).getKey();
        this.extDataModel = this.getExtDataModel();
        switch (btnName) {
            case "btn_delete": {
                if (longNumber.equals(DefaultDataFieldGroupEnum.SYSTEM.getKey()) || longNumber.equals(DefaultDataFieldGroupEnum.HEAD.getKey()) || longNumber.equals(DefaultDataFieldGroupEnum.ENTRY.getKey())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"ExtDataModelPlugin_54", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    break;
                }
                DynamicObjectCollection entrys = this.getModel().getEntryEntity(MAIN_ENTRY);
                if (entrys != null && !entrys.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u5b58\u5728\u5b57\u6bb5\u5b9a\u4e49\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ExtDataModelPlugin_55", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (this.extDataModel.isEntryGroupEntry(longNumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u5b58\u5728\u4e0b\u7ea7\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ExtDataModelPlugin_56", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (this.isEdit() && this.NoCanDeleteEdit(this.getModelId(), this.extDataModel.getNumber(), longNumber, this.extDataModel.getVersion())) {
                    evt.setCancel(true);
                    return;
                }
                String parentNumber = DataModelUtils.getParentLongNumber((String)longNumber);
                treeview.deleteNode(longNumber);
                Map treeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(TREENODE_CACHE));
                treeNodeMap.remove(longNumber);
                this.cacheTreeNodeMap(treeNodeMap);
                Map<String, Integer> groupSeq = this.getGroupSeqMap();
                groupSeq.remove(longNumber);
                this.cacheGroupSeqMap(groupSeq);
                this.treeNodeClick(DefaultDataFieldGroupEnum.getEnumByNumber((String)parentNumber), parentNumber);
                this.extDataModel.removeByIndex(this.extDataModel.getIndex((Object)longNumber));
                Set<String> groupNumber = this.getGroupNumberSet();
                groupNumber.remove(DataModelUtils.getNumber((String)longNumber).toLowerCase());
                this.cacheGroupNumberMap(groupNumber);
                break;
            }
            case "btn_edit": {
                if (longNumber.equals(DefaultDataFieldGroupEnum.SYSTEM.getKey()) || longNumber.equals(DefaultDataFieldGroupEnum.HEAD.getKey()) || longNumber.equals(DefaultDataFieldGroupEnum.ENTRY.getKey())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u7f16\u8f91\u3002", (String)"ExtDataModelPlugin_57", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (this.isEdit() && this.NoCanDeleteEdit(this.getModelId(), this.extDataModel.getNumber(), longNumber, this.extDataModel.getVersion())) {
                    evt.setCancel(true);
                    return;
                }
                DynamicObjectCollection entrys = this.getModel().getEntryEntity(MAIN_ENTRY);
                boolean isEditNumber = entrys.isEmpty();
                this.showFieldGroup(longNumber, isEditNumber, "EDIT");
                break;
            }
            case "btn_add": {
                if (longNumber.equals(DefaultDataFieldGroupEnum.SYSTEM.getKey())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5b57\u6bb5\u7ed3\u6784\u4e0d\u80fd\u65b0\u589e\u4e0b\u7ea7\u8282\u70b9\u3002", (String)"ExtDataModelPlugin_58", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (longNumber.equals(DefaultDataFieldGroupEnum.HEAD.getKey()) || longNumber.equals(DefaultDataFieldGroupEnum.ENTRY.getKey())) {
                    this.showFieldGroup(longNumber, true, "ADDNEW");
                } else {
                    this.isOpenAddNew(longNumber);
                }
                this.saveEntryFieldsToDataModel(this.getPageCache().get(GROUP_SELECTED));
            }
        }
        this.cacheExtDataModel(this.extDataModel);
    }

    private boolean NoCanDeleteEdit(Long id, String number, String longNumber, Object version) {
        if (version == null || ObjectConverterFactory.getInteger((Object)version) == 1) {
            return false;
        }
        if (!DataModelDaoImpl.isHavingExtData((Long)id)) {
            return false;
        }
        try (DataSet rows = DataModelDaoImpl.queryLastDataModelGroupNumberByNumber((String)number, (int)ObjectConverterFactory.getInteger((Object)version));){
            if (rows != null && rows.hasNext()) {
                Row row = rows.next();
                if (DataModelUtils.getNumber((String)longNumber).equals(row.getString("fgroupnumber"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\u4e14\u5386\u53f2\u7248\u672c\u5b58\u5728\u6b64\u5206\u7ec4\uff0c\u4e0d\u80fd\u5220\u9664\u6216\u4fee\u6539\u3002", (String)"ExtDataModelPlugin_59", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private void showFieldGroup(String longNumber, boolean isEditNumber, String status) {
        this.saveEntryFieldsToDataModel(this.getPageCache().get(GROUP_SELECTED));
        DataModelCfg dataModel = this.getExtDataModel();
        FormShowParameter modelFldGrp = new FormShowParameter();
        modelFldGrp.setFormId("fah_ext_model_fldgrp");
        modelFldGrp.getOpenStyle().setShowType(ShowType.Modal);
        modelFldGrp.setStatus(OperationStatus.EDIT);
        modelFldGrp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showFieldGroup"));
        String extDataModelNumber = (String)this.getModel().getValue("number");
        modelFldGrp.setCustomParam("extDataModelNumber", (Object)extDataModelNumber);
        modelFldGrp.setCustomParam("extDataModel", (Object)SerializationUtils.serializeToBase64((Object)this.getExtDataModel()));
        modelFldGrp.setCustomParam("groupNumberSet", (Object)SerializationUtils.toJsonString(this.getGroupNumberSet()));
        modelFldGrp.setCustomParam("isEditNumber", (Object)isEditNumber);
        modelFldGrp.setCustomParam("status", (Object)status);
        modelFldGrp.setCustomParam("isEditable", (Object)this.isEditable());
        modelFldGrp.setCustomParam("currentNodeName", (Object)((DataModelFieldCollection)dataModel.get((Object)longNumber)).getName());
        modelFldGrp.setCustomParam("grouptypeName", (Object)((DataModelFieldCollection)dataModel.get((Object)DataModelUtils.getRootNumber((String)longNumber))).getName());
        modelFldGrp.setCustomParam("longNumber", (Object)longNumber);
        modelFldGrp.setCustomParam("id", (Object)((DataModelFieldCollection)dataModel.get((Object)longNumber)).getId());
        modelFldGrp.setCustomParam("seq", (Object)(this.getGroupSeqMap().get(longNumber) != null ? this.getGroupSeqMap().get(longNumber) : Integer.valueOf(0)));
        modelFldGrp.setCustomParam("groupType", (Object)((DataModelFieldCollection)dataModel.get((Object)longNumber)).getGroupType().getKey());
        this.getView().showForm(modelFldGrp);
    }

    public void initialize() {
        this.addClickListeners(new String[]{BTNEDIT, BTNDELETE, BTNADD});
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_SAVE, BAR_PREVIEW, BAR_EDIT, BAR_PUBLISH, BAR_ENABLE});
        }
    }

    private void isOpenAddNew(String longNumber) {
        String[] splitLongNumber = longNumber.split("\\|");
        if (splitLongNumber.length == 2 && splitLongNumber[0].equals(DefaultDataFieldGroupEnum.HEAD.getKey())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5934\u5206\u7ec4\u7ed3\u6784\u4e0d\u80fd\u65b0\u589e\u4e8c\u7ea7\u8282\u70b9\u3002", (String)"ExtDataModelPlugin_60", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        } else if (splitLongNumber.length == 3 && splitLongNumber[0].equals(DefaultDataFieldGroupEnum.ENTRY.getKey())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5206\u5f55\u5206\u7ec4\u4e0d\u80fd\u65b0\u589e\u4e09\u7ea7\u8282\u70b9\u3002", (String)"ExtDataModelPlugin_61", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        } else {
            this.showFieldGroup(longNumber, true, "ADDNEW");
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        List searchFields = searchEnterEvent.getSearchFields();
        if (searchFields == null || searchFields.isEmpty()) {
            return;
        }
        HashSet<String> treeIdSet = new HashSet<String>(16);
        Map treeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(TREENODE_CACHE));
        for (Map searchField : searchFields) {
            List fieldNames = (List)searchField.get("fieldName");
            List values = ((List)searchField.get("value")).stream().map(o -> o.toLowerCase()).collect(Collectors.toList());
            boolean isSearchNumber = fieldNames.contains("number");
            boolean isSearchName = fieldNames.contains("name");
            for (Map.Entry entry : treeNodeMap.entrySet()) {
                TreeNode treeNode = (TreeNode)entry.getValue();
                String longNumber = (String)entry.getKey();
                for (String searchText : values) {
                    if ((!isSearchNumber || !DataModelUtils.getNumber((String)longNumber).contains(searchText)) && (!isSearchName || !treeNode.getText().contains(searchText))) continue;
                    treeIdSet.add(longNumber);
                }
            }
        }
        if (treeIdSet.isEmpty()) {
            return;
        }
        ArrayList treeIdList = new ArrayList(treeIdSet);
        TreeView tree = (TreeView)this.getControl(LEFT_TREE);
        String selectedGroup = this.getPageCache().get(GROUP_SELECTED);
        if (StringUtils.isNotEmpty((String)selectedGroup) && treeIdList.contains(selectedGroup)) {
            int i = treeIdList.indexOf(selectedGroup);
            if (i == treeIdList.size() - 1) {
                TreeNode treeNode = (TreeNode)treeNodeMap.get(treeIdList.get(0));
                if (StringUtils.isNotEmpty((String)treeNode.getParentid())) {
                    tree.expand(treeNode.getParentid());
                }
                tree.focusNode(treeNode);
                this.getPageCache().put(GROUP_SELECTED, (String)treeIdList.get(0));
            } else {
                TreeNode treeNode = (TreeNode)treeNodeMap.get(treeIdList.get(i + 1));
                if (StringUtils.isNotEmpty((String)treeNode.getParentid())) {
                    tree.expand(treeNode.getParentid());
                }
                tree.focusNode(treeNode);
                this.getPageCache().put(GROUP_SELECTED, (String)treeIdList.get(i + 1));
            }
        } else {
            TreeNode treeNode = (TreeNode)treeNodeMap.get(treeIdList.get(0));
            if (StringUtils.isNotEmpty((String)treeNode.getParentid())) {
                tree.expand(treeNode.getParentid());
            }
            tree.focusNode(treeNode);
            this.getPageCache().put(GROUP_SELECTED, (String)treeIdList.get(0));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }
}

