/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.extdata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.DefaultDataFieldGroupEnum;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.DataModelUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class FahDataModelFieldSelector
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public static final String PARAM_DATAMODEL = "datamodel";
    public static final String CONTROL_KEY = "CONTROL_KEY";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        TreeView tree = (TreeView)this.getControl("tv_fields");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TreeView tree = (TreeView)this.getControl("tv_fields");
        tree.addNode(this.getRoot());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            this.returnDataToParent();
        } else if ("btncancel".equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        this.returnDataToParent();
    }

    private void returnDataToParent() {
        TreeView tree = (TreeView)this.getControl("tv_fields");
        if (tree.getTreeState() == null || tree.getTreeState().getFocusNodeId() == null || ((Boolean)tree.getTreeState().getFocusNode().get("isParent")).booleanValue() || tree.getTreeState().getFocusNodeId().equals(DefaultDataFieldGroupEnum.SYSTEM.getKey()) || tree.getTreeState().getFocusNodeId().equals(DefaultDataFieldGroupEnum.HEAD.getKey()) || tree.getTreeState().getFocusNodeId().equals(DefaultDataFieldGroupEnum.ENTRY.getKey())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)"FahDataModelFieldSelector_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        String[] returnData = new String[]{(String)this.getView().getFormShowParameter().getCustomParam(CONTROL_KEY), tree.getTreeState().getFocusNodeId(), (String)tree.getTreeState().getFocusNode().get("text")};
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
        this.getView().close();
    }

    private TreeNode getRoot() {
        DataModelCfg dataModel = this.getDataModel();
        TreeNode root = new TreeNode();
        root.setId(dataModel.getNumber());
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)dataModel.getName())) {
            root.setText(ResManager.loadKDString((String)"\u6839\u8282\u70b9", (String)"FahDataModelFieldSelector_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        } else {
            root.setText(dataModel.getName());
        }
        root.setIsOpened(true);
        DynamicObjectCollection groups = DataModelDaoImpl.queryDataGroupsByModelId((Long)dataModel.getId());
        HashMap<String, List<DynamicObject>> groupMap = new HashMap<String, List<DynamicObject>>();
        ArrayList<DynamicObject> defaultList = new ArrayList<DynamicObject>(3);
        for (DynamicObject group : groups) {
            String parentNumber = group.getString("parent.longnumber");
            if (!StringUtils.isEmpty((String)parentNumber)) {
                ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)groupMap.get(parentNumber);
                if (list == null) {
                    list = new ArrayList<DynamicObject>(1);
                    list.add(group);
                } else {
                    list.add(group);
                }
                if (DefaultDataFieldGroupEnum.ENTRY.getKey().equals(parentNumber) || DefaultDataFieldGroupEnum.ENTRY.getKey().equals(DataModelUtils.getParentLongNumber((String)parentNumber)) || DefaultDataFieldGroupEnum.SYSTEM.getKey().equals(parentNumber)) continue;
                groupMap.put(parentNumber, list);
                continue;
            }
            defaultList.add(group);
        }
        groupMap.put(dataModel.getNumber(), defaultList);
        this.generateRootTree(root, groupMap, dataModel);
        return root;
    }

    private void generateRootTree(TreeNode father, Map<String, List<DynamicObject>> groupMap, DataModelCfg dataModel) {
        List<DynamicObject> sons = groupMap.get(father.getId());
        if (sons == null || sons.size() == 0) {
            return;
        }
        for (DynamicObject son : sons) {
            String longnumber = son.getString("longnumber");
            TreeNode sonNode = new TreeNode();
            sonNode.setId(longnumber);
            sonNode.setText(son.getString("groupname"));
            sonNode.setIsOpened(true);
            DataModelFieldCollection dataModelFieldCollection = (DataModelFieldCollection)dataModel.get((Object)longnumber);
            if (dataModelFieldCollection != null && dataModelFieldCollection.getCollections() != null) {
                for (DataModelFieldCfg fieldCfg : (BaseMutableArrayMapStorage)dataModelFieldCollection.getCollections()) {
                    if (sonNode.getId().equals(DefaultDataFieldGroupEnum.SYSTEM.getKey())) continue;
                    TreeNode fieldNode = new TreeNode();
                    fieldNode.setId(fieldCfg.getNumber());
                    fieldNode.setText(fieldCfg.getName());
                    sonNode.addChild(fieldNode);
                }
            }
            this.generateRootTree(sonNode, groupMap, dataModel);
            father.addChild(sonNode);
        }
    }

    private DataModelCfg getDataModel() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String modelStr = (String)param.getCustomParam(PARAM_DATAMODEL);
        return (DataModelCfg)((PairTuple)SerializationUtils.deSerializeFromBase64((String)modelStr)).getKey();
    }
}

