/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.extdata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.zip.ZipFile;
import kd.fi.ai.util.ContextUtil;
import kd.fi.v2.fah.constant.ModelOperateMessage;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.constant.enums.StatusEnum;
import kd.fi.v2.fah.constant.enums.task.BackgroundTaskTypeEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.dao.log.BgTaskLogDao;
import kd.fi.v2.fah.log.LogLevelEnum;
import kd.fi.v2.fah.migration.common.DataMigrationContext;
import kd.fi.v2.fah.migration.common.IDataMigrationLogHandler;
import kd.fi.v2.fah.migration.common.IMigrationDataProcessor;
import kd.fi.v2.fah.migration.datamodels.DataModelMigrationLogHandler;
import kd.fi.v2.fah.migration.datamodels.DataModelZipMigrationHandler;
import kd.fi.v2.fah.migration.zip.IMigrationZipDataParser;
import kd.fi.v2.fah.migration.zip.IMigrationZipDataProvider;
import kd.fi.v2.fah.migration.zip.ZipFormatMigrationHelper;
import kd.fi.v2.fah.task.context.BaseBackgroundTaskContext;
import kd.fi.v2.fah.task.status.TaskStatusEnum;
import kd.fi.v2.fah.util.ExtDataModelUtils;
import kd.fi.v2.fah.utils.DataModelUtils;
import kd.fi.v2.fah.utils.LicenseUtil;
import kd.fi.v2.fah.utils.ParamUtils;
import kd.fi.v2.fah.utils.StringUtils;
import org.apache.commons.io.FileUtils;

public class FahExtDataModelTreeList
extends AbstractTreeListPlugin
implements UploadListener {
    private static final String BTNNEW = "btnnew";
    private static final String BTNEDIT = "btnedit";
    private static final String BTNDEL = "btndel";
    private static final String ROOT_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String VCH_TEMPLATE_REF = "VCH_TEMPLATE_REF";
    private static final String PAGEID = "pageid";
    private static final Log logger = LogFactory.getLog(FahExtDataModelTreeList.class);
    private static final String NEW = "new";
    private static final String COPY = "copydonothing";
    private static final String DELETE = "delmodel";
    private static final String PUBLISH = "publish";
    private static final String ENABLE = "enabledonothing";
    private static final String DISENABLE = "disenable";
    private static final String JSONEXAMPLE = "jsonexample";
    private static final String VIEWTABLENAME = "viewtablename";
    private static final String VERSIONRECORD = "versionrecord";
    private static final String EXPORT = "export";
    private static final String VIEW_MIGRATE_LOG = "viewmigratelog";
    private static final String DEFAULT_NODE_ID = "1012377";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        boolean enable = !DEFAULT_NODE_ID.equals(e.getNodeId());
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTNNEW, BTNEDIT, BTNDEL});
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeListModel treeModel = (TreeListModel)this.getTreeModel();
        treeModel.getQueryParas().put("order", "id asc");
    }

    public void upload(UploadEvent evt) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"2FMS=8GUFGGN", (String)"fah_ext_datamodel", (String)"0URT+QS1+LDR");
        if (null == result || !result.hasAllOrgPerm() && result.getHasPermOrgs().isEmpty()) {
            String billName = EntityMetadataCache.getDataEntityType((String)"fah_ext_datamodel").getDisplayName().toString();
            String msg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c\u8fc1\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FahExtDataModelTreeList_56", (String)"fi-ai-formplugin", (Object[])new Object[0]), billName);
            this.getView().showErrorNotification(msg);
            evt.setCancel(true);
            return;
        }
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String url = (String)urls[0];
            TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            DataModelMigrationLogHandler logHandler = new DataModelMigrationLogHandler();
            long taskId = DBServiceHelper.genLongIds((String)"t_fah_bgtask_log", (int)1)[0];
            DataMigrationContext context = new DataMigrationContext(Long.valueOf(taskId), BackgroundTaskTypeEnum.Ext_DataModel_Migration_Import);
            ZipFormatMigrationHelper migrationHelper = new ZipFormatMigrationHelper((BaseBackgroundTaskContext)context, (IDataMigrationLogHandler)logHandler);
            ZipFile zipFile = null;
            try (InputStream is = fileCache.getInputStream(url);){
                zipFile = (ZipFile)migrationHelper.inputStreamToMigrationFile(is);
                DataModelZipMigrationHandler migrationHandler = new DataModelZipMigrationHandler();
                migrationHelper.parseMigrationFile(zipFile, (IMigrationZipDataParser)migrationHandler, (IMigrationDataProcessor)migrationHandler);
                TaskStatusEnum taskStatus = migrationHelper.getTaskContext().getTaskStatus();
                if (TaskStatusEnum.COMPLETED == taskStatus) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u8fc1\u5165\u6210\u529f\u3002", (String)"FahExtDataModelTreeList_52", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                } else if (TaskStatusEnum.WAIN == taskStatus) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u8fc1\u5165\u6210\u529f\uff0c\u53d1\u5e03\u5931\u8d25\uff0c\u5177\u4f53\u539f\u56e0\u8bf7\u67e5\u770b\u8fc1\u5165\u8fc1\u51fa\u65e5\u5fd7\u3002", (String)"FahExtDataModelTreeList_55", (String)"fi-ai-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u8fc1\u5165\u5931\u8d25\uff0c\u5177\u4f53\u539f\u56e0\u8bf7\u67e5\u770b\u8fc1\u5165\u8fc1\u51fa\u65e5\u5fd7\u3002", (String)"FahExtDataModelTreeList_54", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                }
                this.refresh();
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fc1\u5165\u5916\u90e8\u6570\u636e\u6a21\u578b\u5931\u8d25\uff1a%s\u3002", (String)"FahExtDataModelTreeList_51", (String)"fi-ai-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            finally {
                if (zipFile != null) {
                    try {
                        FileUtils.delete((File)zipFile.getFile());
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String keyName;
        super.afterDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        switch (keyName = operateInfo.getOperateKey()) {
            case "delmodel": {
                Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
                Object[] message = DataModelDaoImpl.deleteModel((Object[])ids);
                this.refresh();
                this.clearSelection();
                this.showErrorMessage((Set)message[0], (Map)message[1], ResManager.loadKDString((String)"\u5220\u9664", (String)"FahExtDataModelTreeList_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                break;
            }
            case "publish": {
                this.publish();
                this.refresh();
                break;
            }
            case "enabledonothing": {
                this.enable();
                this.refresh();
                break;
            }
            case "disenable": {
                this.disEnable();
                this.refresh();
                break;
            }
            case "jsonexample": {
                try {
                    this.jsonExample();
                }
                catch (IOException e) {
                    logger.error("jsonExample() error", (Throwable)e);
                }
                break;
            }
            case "viewtablename": {
                Object modelId = this.getSelectedRows().get(0).getPrimaryKeyValue();
                this.viewTableName(modelId);
                break;
            }
            case "versionrecord": {
                this.versionRecord();
                break;
            }
            case "copydonothing": {
                if (this.isNew()) {
                    RefObject addConfirm = new RefObject();
                    if (!LicenseUtil.hasFahLicense() && !operateInfo.getOption().tryGetVariableValue(COPY, addConfirm)) {
                        String showMessage = ResManager.loadKDString((String)"\u65b0\u7248\u672c\u5916\u90e8\u6570\u636e\u63a5\u5165\u9700\u8981\u8d2d\u4e70\u4f1a\u8ba1\u4e8b\u4ef6\u5e93\u8bb8\u53ef\uff0c\u5426\u5219\u540e\u7eed\u6d41\u7a0b\u65e0\u6cd5\u4f7f\u7528\uff0c\u662f\u5426\u786e\u8ba4\u590d\u5236\u6a21\u578b\uff1f", (String)"FahExtDataModelTreeList_1", (String)"fi-ai-formplugin", (Object[])new Object[0]);
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(COPY, (IFormPlugin)this);
                        this.getView().showConfirm(showMessage, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                        return;
                    }
                    this.copy();
                    break;
                }
                Object primaryKey = this.getSelectedRows().get(0).getPrimaryKeyValue();
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("ai_eventclass");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setPkId(primaryKey);
                showParameter.setCustomParam("isCopy", (Object)true);
                showParameter.setHasRight(true);
                showParameter.setStatus(OperationStatus.EDIT);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "export": {
                this.export();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export() {
        Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
        QFilter filter = new QFilter("id", "in", (Object)ids);
        filter.and(new QFilter("enable", "in", (Object)"0"));
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"fah_ext_datamodel", (String)"id", (QFilter[])filter.toArray());
        if (!datas.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u542f\u7528\u72b6\u6001\u7684\u6a21\u578b\u624d\u80fd\u8fc1\u51fa\u3002", (String)"FahExtDataModelTreeList_30", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String currDateTime = dateFormat.format(new Date());
        String zipFileName = String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b_%s.zip", (String)"FahExtDataModelTreeList_49", (String)"fi-ai-formplugin", (Object[])new Object[0]), currDateTime);
        File tmpZipFile = new File(zipFileName);
        DataModelZipMigrationHandler migrationHandler = new DataModelZipMigrationHandler();
        ZipFormatMigrationHelper migrationHelper = new ZipFormatMigrationHelper(null);
        RequestContext requestContext = RequestContext.getOrCreate();
        String creatorInfo = String.format("%s:%s", requestContext.getUserName(), requestContext.getCurrUserId());
        InputStream file = null;
        try {
            ZipFile zipFile = (ZipFile)migrationHelper.createMigrationFile((IMigrationZipDataProvider)migrationHandler, tmpZipFile, creatorInfo, this.getSelectedRows().getPrimaryKeyValues());
            file = Files.newInputStream(zipFile.getFile().toPath(), new OpenOption[0]);
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipFileName, file, 60);
            String msg = String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u8fc1\u51fa\u6210\u529f\uff0c\u7f16\u7801\u5982\u4e0b\uff1a%s", (String)"FahExtDataModelTreeList_53", (String)"fi-ai-formplugin", (Object[])new Object[0]), StringUtils.join((Object[])this.getSelectedRows().stream().map(ListSelectedRow::getNumber).toArray(), (String)", "));
            BgTaskLogDao.saveTaskLog((BackgroundTaskTypeEnum)BackgroundTaskTypeEnum.Ext_DataModel_Migration_Export, (TaskStatusEnum)TaskStatusEnum.COMPLETED, Collections.singletonList(new Object[]{LogLevelEnum.Info, TaskStatusEnum.COMPLETED, msg}));
            this.getView().download(url);
        }
        catch (Exception e) {
            BgTaskLogDao.saveTaskLog((BackgroundTaskTypeEnum)BackgroundTaskTypeEnum.Ext_DataModel_Migration_Export, (TaskStatusEnum)TaskStatusEnum.FAILURE, Collections.singletonList(new Object[]{LogLevelEnum.Error, TaskStatusEnum.FAILURE, e.getMessage()}));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fc1\u51fa\u5916\u90e8\u6570\u636e\u6a21\u578b\u5931\u8d25\uff1a%s\u3002", (String)"FahExtDataModelTreeList_50", (String)"fi-ai-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (VIEW_MIGRATE_LOG.equals(itemKey)) {
            ListShowParameter param = new ListShowParameter();
            param.setBillFormId("fah_bgtask_log");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCustomParam("tasktype", Arrays.asList(BackgroundTaskTypeEnum.Ext_DataModel_Migration_Export.getStringValue(), BackgroundTaskTypeEnum.Ext_DataModel_Migration_Import.getStringValue()));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        IFormView view = this.getView();
        Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
        String selectModel = null;
        if (ids.length > 0) {
            selectModel = this.checkNewAndOldModel(ids);
            if (!StringUtils.isEmpty((String)selectModel)) {
                String message = ModelOperateMessage.getMessage((String)keyName);
                if ("old".equals(selectModel) && !StringUtils.isEmpty((String)message)) {
                    this.getView().showTipNotification(message);
                    args.setCancel(true);
                    return;
                }
            } else {
                args.setCancel(true);
                return;
            }
        }
        switch (keyName) {
            case "new": {
                TreeView treeview = (TreeView)view.getControl("treeview");
                String treeNode = treeview.getTreeState().getFocusNodeId();
                if (ROOT_ID.equals(treeNode)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u5916\u90e8\u6570\u636e\u6a21\u578b\u5206\u7ec4\u8fdb\u884c\u65b0\u589e\u3002", (String)"FahExtDataModelTreeList_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!this.isNew()) {
                    args.setCancel(true);
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("ai_eventclass");
                    showParameter.setCustomParam("group_id", (Object)treeNode);
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "oldModel"));
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setHasRight(true);
                    view.showForm((FormShowParameter)showParameter);
                    break;
                }
                RefObject addConfirm = new RefObject();
                if (LicenseUtil.hasFahLicense() || operateInfo.getOption().tryGetVariableValue("addConfirm", addConfirm)) break;
                String message = ResManager.loadKDString((String)"\u65b0\u7248\u672c\u5916\u90e8\u6570\u636e\u63a5\u5165\u9700\u8981\u8d2d\u4e70\u4f1a\u8ba1\u4e8b\u4ef6\u5e93\u8bb8\u53ef\uff0c\u5426\u5219\u540e\u7eed\u6d41\u7a0b\u65e0\u6cd5\u4f7f\u7528\uff0c\u662f\u5426\u786e\u8ba4\u65b0\u5efa\u6a21\u578b\uff1f", (String)"FahExtDataModelTreeList_3", (String)"fi-ai-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("addnew", (IFormPlugin)this);
                view.showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
                break;
            }
            case "delmodel": {
                if (StringUtils.isEmpty((String)selectModel)) {
                    args.setCancel(true);
                    break;
                }
                if ("old".equals(selectModel)) {
                    this.getView().invokeOperation("delete");
                    args.setCancel(true);
                    break;
                }
                if (ids.length > 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5220\u9664\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u65b0\u6a21\u578b\u3002", (String)"FahExtDataModelTreeList_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Map checkMap = DataModelDaoImpl.getCheckVchTemplateRefessrence((Object)ids[0]);
                if (checkMap != null) {
                    DynamicObject model = QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", ids[0])});
                    this.showVchTemplateRefessrence(model, checkMap);
                    args.setCancel(true);
                    return;
                }
                Set entryIds = DataModelDaoImpl.checkDataModelQuote((Object[])ids);
                if (entryIds.size() > 0) {
                    FormShowParameter parameters = new FormShowParameter();
                    parameters.getOpenStyle().setShowType(ShowType.Modal);
                    parameters.setFormId("fah_warring_message");
                    parameters.setCustomParam("isDataModelDelete", (Object)true);
                    parameters.setCustomParam("entryIds", (Object)SerializationUtils.toJsonString((Object)entryIds));
                    view.showForm(parameters);
                    args.setCancel(true);
                    return;
                }
                int count = this.getSelectedRows().size();
                RefObject afterConfirm = new RefObject();
                if (operateInfo.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) break;
                String message = String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u201c%1$s\u201d\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"FahExtDataModelTreeList_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), count);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DELETE, (IFormPlugin)this);
                view.showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks);
                args.setCancel(true);
                break;
            }
            case "publish": {
                if (this.getSelectedRows().size() == 1) break;
                view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u9009\u53d1\u5e03\u6570\u636e\u3002", (String)"FahExtDataModelTreeList_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "jsonexample": {
                if (this.getSelectedRows().size() == 1) break;
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u5bfc\u51fa\u3002", (String)"FahExtDataModelTreeList_7", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "viewtablename": {
                if (this.getSelectedRows().size() != 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u67e5\u770b\u8868\u540d\u3002", (String)"FahExtDataModelTreeList_8", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object modelId = this.getSelectedRows().get(0).getPrimaryKeyValue();
                DynamicObject model = QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", modelId)});
                if (model == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u4e0d\u5b58\u5728\u3002", (String)"FahExtDataModelTreeList_9", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (!model.getString("status").equals(StatusEnum.UNPUBLISHED.getCode())) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u5e03\u7684\u6a21\u578b\uff0c\u624d\u80fd\u67e5\u770b\u8868\u540d\u3002", (String)"FahExtDataModelTreeList_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "copydonothing": {
                if (this.getSelectedRows().size() != 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u590d\u5236\u3002", (String)"FahExtDataModelTreeList_11", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object primaryKey = this.getSelectedRows().get(0).getPrimaryKeyValue();
                if (this.isNew()) {
                    if (DataModelDaoImpl.isNewModel((Object)primaryKey)) break;
                    view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u590d\u5236\u3001\u65b0\u589e\u65b0\u6a21\u578b\u3002", (String)"FahExtDataModelTreeList_12", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (!DataModelDaoImpl.isNewModel((Object)primaryKey)) break;
                view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u590d\u5236\u3001\u65b0\u589e\u65e7\u6a21\u578b\u3002", (String)"FahExtDataModelTreeList_13", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if (DELETE.equals(event.getCallBackId())) {
            if (result == MessageBoxResult.Yes) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("afterconfirm", "true");
                this.getView().invokeOperation(DELETE, operateOption);
            }
        } else if (event.getCallBackId().equals("show_vchtemp_ref")) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("fah_vchtemplate_fldref");
                parameter.setCustomParam("map", (Object)this.getPageCache().get(VCH_TEMPLATE_REF));
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
            }
        } else if ("addnew".equals(event.getCallBackId())) {
            if (result == MessageBoxResult.Yes) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("addConfirm", "true");
                this.getView().invokeOperation(NEW, operateOption);
            }
        } else if (COPY.equals(event.getCallBackId()) && result == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(COPY, "true");
            this.getView().invokeOperation(COPY, operateOption);
        }
    }

    private boolean isNew() {
        return ParamUtils.useNewExtDataModel();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNNEW});
        Toolbar toolbarAp = (Toolbar)this.getControl("toolbarap");
        toolbarAp.addUploadListener((UploadListener)this);
    }

    private String checkNewAndOldModel(Object[] ids) {
        QFilter qFilterNew = new QFilter("id", "in", (Object)ids);
        qFilterNew.and(new QFilter("appversion", "=", (Object)String.valueOf(AppVersionEnum.NEW_APP.getCode())));
        QFilter qFilterOld = new QFilter("id", "in", (Object)ids);
        qFilterOld.and(new QFilter("appversion", "=", (Object)String.valueOf(AppVersionEnum.OLD_APP.getCode())));
        boolean isExistNew = false;
        boolean isExistOld = false;
        String selectModel = null;
        if (QueryServiceHelper.exists((String)"fah_ext_datamodel", (QFilter[])new QFilter[]{qFilterNew})) {
            isExistNew = true;
            selectModel = NEW;
        }
        if (QueryServiceHelper.exists((String)"fah_ext_datamodel", (QFilter[])new QFilter[]{qFilterOld})) {
            isExistOld = true;
            selectModel = "old";
        }
        if (isExistNew && isExistOld) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u65e7\u6a21\u578b\u4e0d\u80fd\u540c\u65f6\u64cd\u4f5c\u3002", (String)"FahExtDataModelTreeList_14", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return null;
        }
        return selectModel;
    }

    private void publish() {
        Object idObj = this.getSelectedRows().getPrimaryKeyValues()[0];
        Long id = ObjectConverterFactory.getLong((Object)idObj);
        DynamicObject obj = DataModelDaoImpl.loadSingleDataModelById((Long)id);
        DynamicObject model = StatusEnum.UNPUBLISHED.getCode().equals(obj.getString("status")) ? obj : DataModelDaoImpl.queryUnpublishedRecord((Long)obj.getLong("masterid"));
        Object publish = DataModelDaoImpl.publish((DynamicObject)model);
        if (publish == null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"FahExtDataModelTreeList_15", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        } else if (publish instanceof String) {
            this.getView().showErrorNotification((String)publish);
        } else if (publish instanceof Map) {
            this.showVchTemplateRefessrence(model, (Map)publish);
        }
    }

    private void showVchTemplateRefessrence(DynamicObject model, Map<Long, Set<String>> result) {
        Map<String, Map<Long, Set<String>>> map = Collections.singletonMap(model.getString("number"), result);
        this.getPageCache().put(VCH_TEMPLATE_REF, SerializationUtils.serializeToBase64(map));
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("show_vchtemp_ref", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u5173\u95ed", (String)"FahExtDataModelTreeList_16", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u67e5\u770b\u6a21\u677f\u5f15\u7528", (String)"FahExtDataModelTreeList_17", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        String msg = ExtDataModelUtils.getMsgOfResult(result, (String)model.getString("number"));
        this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    private void showErrorMessage(Set<String> successSet, Map<String, String> errorMap, String opName) {
        if (errorMap.isEmpty()) {
            String successMsg = String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"FahExtDataModelTreeList_19", (String)"fi-ai-formplugin", (Object[])new Object[0]), opName);
            this.getView().showSuccessNotification(successMsg);
            return;
        }
        if (successSet.isEmpty() && errorMap.size() == 1) {
            for (String value : errorMap.values()) {
                this.getView().showErrorNotification(value);
            }
            return;
        }
        String titleMsg = ResManager.loadKDString((String)"\u5171\u201c%1$s\u201d\u6761\u6570\u636e\uff0c\u201c%2$s\u201d\u6210\u529f\u201c%3$s\u201d\u6761\uff0c\u5931\u8d25\u201c%4$s\u201d\u6761\u3002", (String)"FahExtDataModelTreeList_20", (String)"fi-ai-formplugin", (Object[])new Object[0]);
        String title = String.format(titleMsg, successSet.size() + errorMap.size(), opName, successSet.size(), errorMap.size());
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, String> entry : errorMap.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(entry.getKey()).append("\uff1a").append(entry.getValue());
            list.add(sb.toString());
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("title", (Object)title);
        parameters.setCustomParam("errorMsg", list);
        this.getView().showForm(parameters);
    }

    private void enable() {
        Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
        HashMap<String, String> errorMap = new HashMap<String, String>();
        HashSet<String> successSet = new HashSet<String>();
        for (Object id : ids) {
            DynamicObject model = DataModelDaoImpl.loadSingleDataModelById((Long)ObjectConverterFactory.getLong((Object)id));
            String lockKey = FahExtDataModelTreeList.getLockKey(model.getString("number"));
            try (DLock lock = DLock.create((String)lockKey).fastMode();){
                if (lock.tryLock()) {
                    if (!model.getString("status").equals(StatusEnum.PUBLISHED.getCode())) {
                        errorMap.put(model.getString("number"), ResManager.loadKDString((String)"\u53ea\u6709\u53d1\u5e03\u72b6\u6001\u7684\u6a21\u578b\u624d\u80fd\u542f\u7528\u3002", (String)"FahExtDataModelTreeList_21", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (model.getString("enable").equals("1")) {
                        errorMap.put(model.getString("number"), ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u542f\u7528\u72b6\u6001\u3002", (String)"FahExtDataModelTreeList_22", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (model.getString("enable").equals("0")) {
                        DataModelDaoImpl.switchEnable((String)"1", (Long)ObjectConverterFactory.getLong((Object)id));
                    }
                    successSet.add(model.getString("number"));
                    continue;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5e03\u5f0f\u4e8b\u52a1\u9501\u52a0\u9501\u5931\u8d25\u3002", (String)"FahExtDataModelTreeList_23", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
        }
        this.showErrorMessage(successSet, errorMap, ResManager.loadKDString((String)"\u542f\u7528", (String)"FahExtDataModelTreeList_24", (String)"fi-ai-formplugin", (Object[])new Object[0]));
    }

    private void disEnable() {
        Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
        HashMap<String, String> errorMap = new HashMap<String, String>();
        HashSet<String> successSet = new HashSet<String>();
        for (Object id : ids) {
            DynamicObject model = DataModelDaoImpl.loadSingleDataModelById((Long)ObjectConverterFactory.getLong((Object)id));
            String lockKey = FahExtDataModelTreeList.getLockKey(model.getString("number"));
            try (DLock lock = DLock.create((String)lockKey).fastMode();){
                if (lock.tryLock()) {
                    if (model.getString("enable").equals("0")) {
                        errorMap.put(model.getString("number"), ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"FahExtDataModelTreeList_25", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (model.getString("status").equals(StatusEnum.PUBLISHED.getCode()) && model.getString("enable").equals("1")) {
                        DataModelDaoImpl.switchEnable((String)"0", (Long)ObjectConverterFactory.getLong((Object)id));
                    }
                    successSet.add(model.getString("number"));
                    continue;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5e03\u5f0f\u4e8b\u52a1\u9501\u52a0\u9501\u5931\u8d25\u3002", (String)"FahExtDataModelTreeList_23", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
        }
        this.showErrorMessage(successSet, errorMap, ResManager.loadKDString((String)"\u7981\u7528", (String)"FahExtDataModelTreeList_26", (String)"fi-ai-formplugin", (Object[])new Object[0]));
    }

    private static String getLockKey(String number) {
        return "lockKey$datamodel$" + number;
    }

    public void jsonExample() throws IOException {
        Long primaryKey = (Long)this.getSelectedRows().get(0).getPrimaryKeyValue();
        DynamicObject eventClass = QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)primaryKey)});
        if (null != eventClass) {
            JSONObject rootJson = DataModelUtils.buildJsonTemplate((Long)primaryKey, (int)1);
            String dataModelJson = JSON.toJSONString((Object)rootJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
            dataModelJson = dataModelJson.replaceAll("(?!\\r)\\n", "\r\n");
            String fileName = String.format(ResManager.loadKDString((String)"%1$s_%2$s_Json\u5bfc\u51fa\u683c\u5f0f\u793a\u4f8b.txt", (String)"FahExtDataModelTreeList_27", (String)"fi-ai-formplugin", (Object[])new Object[0]), eventClass.getString("name"), eventClass.getString("number"));
            try (ByteArrayInputStream input = new ByteArrayInputStream(dataModelJson.getBytes(StandardCharsets.UTF_8));){
                String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)input, 500);
                this.getView().openUrl(url);
            }
            catch (Exception e) {
                logger.error("jsonExample() error", (Throwable)e);
            }
        }
    }

    public void viewTableName(Object modelId) {
        FormShowParameter viewTableName = new FormShowParameter();
        viewTableName.setFormId("fah_ext_datatable");
        viewTableName.getOpenStyle().setShowType(ShowType.Modal);
        viewTableName.setCustomParam("id", modelId);
        this.getView().showForm(viewTableName);
    }

    public void versionRecord() {
        FormShowParameter versionRecord = new FormShowParameter();
        versionRecord.setFormId("fah_ext_model_hist");
        versionRecord.getOpenStyle().setShowType(ShowType.Modal);
        versionRecord.setCustomParam("idArrey", (Object)SerializationUtils.toJsonString((Object)this.getSelectedRows().getPrimaryKeyValues()));
        versionRecord.setStatus(OperationStatus.VIEW);
        this.getView().showForm(versionRecord);
    }

    public void beforeClick(BeforeClickEvent evt) {
        TreeView treeview;
        String treeNode;
        super.beforeClick(evt);
        String keyName = ((Control)evt.getSource()).getKey();
        if (BTNNEW.equals(keyName) && !ROOT_ID.equals(treeNode = (treeview = (TreeView)this.getView().getControl("treeview")).getTreeState().getFocusNodeId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5728\u6839\u8282\u70b9\u589e\u52a0\u5916\u90e8\u6570\u636e\u6a21\u578b\u5206\u7ec4\u3002", (String)"FahExtDataModelTreeList_28", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void copy() {
        Object primaryKey = this.getSelectedRows().get(0).getPrimaryKeyValue();
        this.isShowForCopy(true, primaryKey);
    }

    private void isShowForCopy(boolean isCopy, Object primaryKey) {
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"fah_ext_datamodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKey)});
        if (dyns == null || dyns.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u4e0d\u5b58\u5728\u3002", (String)"FahExtDataModelTreeList_9", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        Map<Object, String> pageIdMap = this.getPageId();
        String pageId = pageIdMap.get(primaryKey);
        if (!isCopy && !StringUtils.isEmpty((String)pageId) && this.getView().getViewNoPlugin(pageId) != null) {
            showParameter.setPageId(pageId);
        }
        showParameter.setFormId("fah_ext_datamodel");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("id", primaryKey);
        if (isCopy) {
            showParameter.setCustomParam("isCopy", (Object)true);
        }
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "isShowForCopy"));
        this.getView().showForm((FormShowParameter)showParameter);
        if (!isCopy) {
            pageIdMap.put(primaryKey, showParameter.getPageId());
            this.cachePageId(pageIdMap);
        }
    }

    private Map<Object, String> getPageId() {
        Map<Object, String> pageIdMap;
        if (!StringUtils.isEmpty((String)this.getPageCache().get(PAGEID))) {
            pageIdMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(PAGEID));
        } else {
            pageIdMap = new HashMap<Object, String>();
            this.cachePageId(pageIdMap);
        }
        return pageIdMap;
    }

    private void cachePageId(Map<Object, String> pageIdMap) {
        this.getPageCache().put(PAGEID, SerializationUtils.serializeToBase64(pageIdMap));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("isShowForCopy".equals(closedCallBackEvent.getActionId())) {
            this.refresh();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent hyperClick = args.getHyperLinkClickEvent();
        BillList billList = (BillList)this.getControl("BillListAp");
        if ("number".equals(hyperClick.getFieldName())) {
            args.setCancel(true);
            Object primaryKey = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            DynamicObject dataModel = QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"appversion", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKey)});
            if (dataModel == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u4e0d\u5b58\u5728\u3002", (String)"FahExtDataModelTreeList_9", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            if (ObjectConverterFactory.getByte((Object)dataModel.getString("appversion")).equals(AppVersionEnum.OLD_APP.getCode())) {
                BillShowParameter showParameter = new BillShowParameter();
                Map<Object, String> pageIdMap = this.getPageId();
                String pageId = pageIdMap.get(primaryKey);
                if (!StringUtils.isEmpty((String)pageId) && this.getView().getViewNoPlugin(pageId) != null) {
                    showParameter.setPageId(pageId);
                }
                showParameter.setFormId("ai_eventclass");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setPkId(primaryKey);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setHasRight(true);
                this.getView().showForm((FormShowParameter)showParameter);
                pageIdMap.put(primaryKey, showParameter.getPageId());
                this.cachePageId(pageIdMap);
            } else {
                this.isShowForCopy(false, primaryKey);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter filter = new QFilter("appversion", "=", (Object)ObjectConverterFactory.getCharacter((Object)AppVersionEnum.NEW_APP.getCode()));
        QFilter filter1 = new QFilter("latestversion", "=", (Object)"1");
        filter1.and(new QFilter("status", "=", (Object)StatusEnum.PUBLISHED.getCode()));
        filter1.or(new QFilter("versionnum", "=", (Object)1).and(new QFilter("status", "=", (Object)StatusEnum.UNPUBLISHED.getCode())));
        filter.and(filter1);
        filter.or(new QFilter("appversion", "=", (Object)ObjectConverterFactory.getCharacter((Object)AppVersionEnum.OLD_APP.getCode())));
        e.getQFilters().add(filter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    private void refresh() {
        this.getTreeListView().refresh();
    }

    private static class MyListDataProvider
    extends ListDataProvider {
        private MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("versionname", String.class, (Object)""));
            for (DynamicObject row : rows) {
                if (row.getString("appversion").equals(String.valueOf(AppVersionEnum.OLD_APP.getCode()))) {
                    row.set("versionname", (Object)"");
                    continue;
                }
                if (StatusEnum.UNPUBLISHED.getCode().equals(row.getString("status"))) {
                    row.set("versionname", (Object)ResManager.loadKDString((String)"\u672a\u53d1\u5e03", (String)"FahExtDataModelTreeList_29", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    continue;
                }
                row.set("versionname", (Object)row.getInt("versionnum"));
            }
            return rows;
        }
    }
}

