/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.mapping;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.Control;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.element.AccountElement;
import kd.fi.v2.fah.element.BaseDataElement;
import kd.fi.v2.fah.element.BooleanElement;
import kd.fi.v2.fah.element.ComboElement;
import kd.fi.v2.fah.element.DateElement;
import kd.fi.v2.fah.element.Element;
import kd.fi.v2.fah.element.EntryElement;
import kd.fi.v2.fah.element.MulComboElement;
import kd.fi.v2.fah.element.MulbasedataElement;
import kd.fi.v2.fah.element.TextElement;
import kd.fi.v2.fah.formplugin.mapping.FahValMapFilterUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class FahBatchAddEntry
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRYENTITY = "entryentity";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRYENTITY});
        DynamicObjectCollection fields = QueryServiceHelper.query((String)"fah_flex_struc", (String)"dseq,attnum,attname,attdatatype,refentity,fieldusagetype,reftypeid,reffieldnum,flexfieldnum", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("strucid")))}, (String)"fieldusagetype desc,dseq asc");
        LinkedList<Element> elementList = this.getElementList(fields);
        this.cacheEntryElement(elementList);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.entryBuild();
        this.getView().updateView(ENTRYENTITY);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException var5) {
            throw new KDException((Throwable)var5, new ErrorCode("LoadCustomControlMetasSample", var5.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        this.getEntryElement().registerEntryProp(entryType);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        EntryElement entryElement = this.getEntryElement();
        ArrayList<EntryElement> items = new ArrayList<EntryElement>(entryElement.getItems());
        items.add(entryElement);
        Optional<Element> first = items.stream().filter(x -> x.getName().equals(e.getKey())).findFirst();
        Control control = null;
        if (first.isPresent()) {
            Element element = first.get();
            control = element.getControl(this.getView());
            e.setControl(control);
        }
    }

    private LinkedList<Element> getElementList(DynamicObjectCollection collection) {
        LinkedList<Element> entryElementList = new LinkedList<Element>();
        HashMap<Integer, LinkedList> fieldNumberMap = new HashMap<Integer, LinkedList>(2);
        HashMap<String, Long> assistMap = new HashMap<String, Long>(4);
        HashMap<String, String> basedataForF7Map = new HashMap<String, String>(4);
        HashMap<String, Long> accountMap = new HashMap<String, Long>(4);
        HashMap<String, Long> fahValueSetMap = new HashMap<String, Long>(4);
        HashMap[] flexFieldNumMap = new HashMap[]{new HashMap(8), new HashMap(8)};
        LinkedList<String> controlList = new LinkedList<String>();
        DynamicObjectType mulBasedataProp = ((MulBasedataProp)((EntryProp)EntityMetadataCache.getDataEntityType((String)"fah_getmulbasedata").getProperty(ENTRYENTITY)).getDynamicCollectionItemPropertyType().getProperty("mulbasedatafield")).getDynamicCollectionItemPropertyType();
        for (DynamicObject field : collection) {
            String flexfieldnum = field.getString("flexfieldnum");
            String fieldNumber = field.getString("attnum").toLowerCase();
            String fieldName = field.getString("attname");
            String refEntity = field.getString("refentity");
            Long reftypeid = field.getLong("reftypeid");
            String attdatatype = field.getString("attdatatype");
            DataValueTypeEnum type = DataValueTypeEnum.getEnum((String)attdatatype);
            boolean isInput = field.getInt("fieldusagetype") == 1;
            String flexFieldType = field.getString("fieldusagetype");
            switch (type) {
                case String: {
                    TextElement textElement = new TextElement(fieldNumber, fieldName, ENTRYENTITY);
                    textElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)textElement);
                    controlList.add(fieldNumber);
                    break;
                }
                case BaseProp: {
                    BaseDataElement baseDataElement;
                    MulbasedataElement mulbasedataElement;
                    if (isInput) {
                        mulbasedataElement = new MulbasedataElement("basedata_" + fieldNumber, fieldName, refEntity, ENTRYENTITY, mulBasedataProp);
                        mulbasedataElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)mulbasedataElement);
                    } else {
                        baseDataElement = new BaseDataElement("basedata_" + fieldNumber, fieldName, refEntity, ENTRYENTITY);
                        baseDataElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)baseDataElement);
                    }
                    fieldNumber = "basedata_" + fieldNumber;
                    controlList.add(fieldNumber);
                    basedataForF7Map.put(fieldNumber, refEntity);
                    break;
                }
                case AssistProp: {
                    BaseDataElement baseDataElement;
                    MulbasedataElement mulbasedataElement;
                    if (isInput) {
                        mulbasedataElement = new MulbasedataElement("assistant_" + fieldNumber, fieldName, "bos_assistantdata_detail", ENTRYENTITY, mulBasedataProp);
                        mulbasedataElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)mulbasedataElement);
                    } else {
                        baseDataElement = new BaseDataElement("assistant_" + fieldNumber, fieldName, "bos_assistantdata_detail", ENTRYENTITY);
                        baseDataElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)baseDataElement);
                    }
                    fieldNumber = "assistant_" + fieldNumber;
                    assistMap.put(fieldNumber, reftypeid);
                    controlList.add(fieldNumber);
                    break;
                }
                case FahValueSet: {
                    BaseDataElement baseDataElement;
                    MulbasedataElement mulbasedataElement;
                    if (isInput) {
                        mulbasedataElement = new MulbasedataElement("valueset_" + fieldNumber, fieldName, "fah_flex_valueset", ENTRYENTITY, mulBasedataProp);
                        mulbasedataElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)mulbasedataElement);
                    } else {
                        baseDataElement = new BaseDataElement("valueset_" + fieldNumber, fieldName, "fah_flex_valueset", ENTRYENTITY);
                        baseDataElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)baseDataElement);
                    }
                    fieldNumber = "valueset_" + fieldNumber;
                    fahValueSetMap.put(fieldNumber, reftypeid);
                    controlList.add(fieldNumber);
                    break;
                }
                case Kingdee_AccountTable: {
                    BaseDataElement baseDataElement;
                    MulbasedataElement mulbasedataElement;
                    if (isInput) {
                        mulbasedataElement = new MulbasedataElement("accounttable_" + fieldNumber, fieldName, "bd_accountview", ENTRYENTITY, mulBasedataProp);
                        mulbasedataElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)mulbasedataElement);
                    } else {
                        baseDataElement = new AccountElement("accounttable_" + fieldNumber, fieldName, "bd_accountview", ENTRYENTITY);
                        baseDataElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)baseDataElement);
                    }
                    fieldNumber = "accounttable_" + fieldNumber;
                    accountMap.put(fieldNumber, reftypeid);
                    controlList.add(fieldNumber);
                    break;
                }
                case Kingdee_AcctAssistDim: {
                    BaseDataElement baseDataElement;
                    MulbasedataElement mulbasedataElement;
                    DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)"bd_asstacttype", (String)"valuetype,valuesource,assistanttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reftypeid)});
                    if (temp != null && "1".equals(temp.getString("valuetype"))) {
                        String basedataTypeId = temp.getString("valuesource_id");
                        if (isInput) {
                            MulbasedataElement mulbasedataElement2 = new MulbasedataElement("acctassistdim_" + fieldNumber, fieldName, basedataTypeId, ENTRYENTITY, mulBasedataProp);
                            mulbasedataElement2.setFlexFieldType(flexFieldType);
                            entryElementList.add((Element)mulbasedataElement2);
                        } else {
                            BaseDataElement baseDataElement2 = new BaseDataElement("acctassistdim_" + fieldNumber, fieldName, basedataTypeId, ENTRYENTITY);
                            baseDataElement2.setFlexFieldType(flexFieldType);
                            entryElementList.add((Element)baseDataElement2);
                        }
                        fieldNumber = "acctassistdim_" + fieldNumber;
                        basedataForF7Map.put(fieldNumber, basedataTypeId);
                    } else {
                        if (temp == null || !"2".equals(temp.getString("valuetype"))) break;
                        if (isInput) {
                            mulbasedataElement = new MulbasedataElement("acctassistdim_" + fieldNumber, fieldName, "bos_assistantdata_detail", ENTRYENTITY, mulBasedataProp);
                            mulbasedataElement.setFlexFieldType(flexFieldType);
                            entryElementList.add((Element)mulbasedataElement);
                        } else {
                            baseDataElement = new BaseDataElement("acctassistdim_" + fieldNumber, fieldName, "bos_assistantdata_detail", ENTRYENTITY);
                            baseDataElement.setFlexFieldType(flexFieldType);
                            entryElementList.add((Element)baseDataElement);
                        }
                        fieldNumber = "acctassistdim_" + fieldNumber;
                        assistMap.put(fieldNumber, temp.getLong("assistanttype_id"));
                    }
                    controlList.add(fieldNumber);
                    break;
                }
                case Kingdee_CashFlow: {
                    BaseDataElement baseDataElement;
                    MulbasedataElement mulbasedataElement;
                    if (isInput) {
                        mulbasedataElement = new MulbasedataElement("cashflow_" + fieldNumber, fieldName, "gl_cashflowitem", ENTRYENTITY, mulBasedataProp);
                        mulbasedataElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)mulbasedataElement);
                    } else {
                        baseDataElement = new BaseDataElement("cashflow_" + fieldNumber, fieldName, "gl_cashflowitem", ENTRYENTITY);
                        baseDataElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)baseDataElement);
                    }
                    fieldNumber = "cashflow_" + fieldNumber;
                    controlList.add(fieldNumber);
                    break;
                }
                case Kingdee_BillDropDownList: {
                    String refFieldNum = field.getString("reffieldnum");
                    if (isInput) {
                        MulComboElement mulComboElement = new MulComboElement("billdropdownlist_" + fieldNumber, fieldName, ENTRYENTITY, refEntity, refFieldNum, false);
                        mulComboElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)mulComboElement);
                    } else {
                        ComboElement comboElement = new ComboElement("billdropdownlist_" + fieldNumber, fieldName, ENTRYENTITY, refEntity, refFieldNum, false);
                        comboElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)comboElement);
                    }
                    fieldNumber = "billdropdownlist_" + fieldNumber;
                    controlList.add(fieldNumber);
                }
            }
            fieldNumberMap.computeIfAbsent(field.getInt("fieldusagetype"), v -> new LinkedList()).add(new Object[]{fieldNumber, type});
            flexFieldNumMap[field.getInt("fieldusagetype")].put(fieldNumber, flexfieldnum);
        }
        entryElementList.add((Element)new DateElement("effectdate", ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f", (String)"FahBatchAddEntry_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        entryElementList.add((Element)new DateElement("expiredate", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f", (String)"FahBatchAddEntry_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        entryElementList.add((Element)new BooleanElement("enable_en", ResManager.loadKDString((String)"\u542f\u7528", (String)"FahBatchAddEntry_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        this.getPageCache().put("assistMap", SerializationUtils.serializeToBase64(assistMap));
        this.getPageCache().put("accountMap", SerializationUtils.serializeToBase64(accountMap));
        this.getPageCache().put("fahValueSetMap", SerializationUtils.serializeToBase64(fahValueSetMap));
        this.getPageCache().put("basedataForF7Map", SerializationUtils.serializeToBase64(basedataForF7Map));
        this.getPageCache().put("controlList", SerializationUtils.toJsonString(controlList));
        this.getPageCache().put("flexFieldNumMap", SerializationUtils.toJsonString((Object)flexFieldNumMap));
        this.getPageCache().put("fieldNumberMap", SerializationUtils.serializeToBase64(fieldNumberMap));
        return entryElementList;
    }

    private EntryElement cacheEntryElement(LinkedList<Element> elementList) {
        EntryElement entryElement = new EntryElement(ENTRYENTITY);
        entryElement.setItems(elementList);
        this.getPageCache().put("entryentity_element", SerializationUtils.serializeToBase64((Object)entryElement));
        return entryElement;
    }

    public void entryBuild() {
        this.getEntryElement().build(this.getView());
    }

    private EntryElement getEntryElement() {
        String elements = this.getPageCache().get("entryentity_element");
        if (elements == null) {
            LinkedList<Element> elementList = new LinkedList<Element>();
            return this.cacheEntryElement(elementList);
        }
        return (EntryElement)SerializationUtils.deSerializeFromBase64((String)elements);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FahValMapFilterUtil.registerListener(this.getView(), this.getPageCache(), this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object eorgId = this.getView().getFormShowParameter().getCustomParam("eorg_id");
        FahValMapFilterUtil.beforeF7Select(evt, Long.parseLong(String.valueOf(eorgId)), this.getPageCache(), true);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.getView().returnDataToParent((Object)this.getMapDataFromEntry(this.getModel().getEntryEntity(ENTRYENTITY)));
            this.getView().close();
        }
    }

    private String getMapDataFromEntry(DynamicObjectCollection entryentity) {
        LinkedList rowListS = new LinkedList();
        List controlList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("controlList"), List.class);
        for (DynamicObject row : entryentity) {
            HashMap<String, Object> rowDataMap = new HashMap<String, Object>();
            for (String controlNumber : controlList) {
                Object value = row.get(controlNumber);
                if (controlNumber.startsWith("billdropdownlist_")) {
                    if (value.toString().contains(",")) {
                        String[] downValues = value.toString().split(",");
                        LinkedList<String> idList = new LinkedList<String>();
                        for (String downValue : downValues) {
                            if (StringUtils.isEmpty((String)downValue)) continue;
                            idList.add(downValue);
                        }
                        rowDataMap.put(controlNumber, idList);
                        continue;
                    }
                    rowDataMap.put(controlNumber, value);
                    continue;
                }
                if (value instanceof String) {
                    rowDataMap.put(controlNumber, value);
                    continue;
                }
                if (value instanceof DynamicObject) {
                    rowDataMap.put(controlNumber, value);
                    continue;
                }
                if (!(value instanceof DynamicObjectCollection) || ((DynamicObjectCollection)value).size() <= 0) continue;
                if (((DynamicObjectCollection)value).size() > 1) {
                    LinkedList<Object> idList = new LinkedList<Object>();
                    for (DynamicObject valueLine : (DynamicObjectCollection)value) {
                        idList.add(valueLine.get("fbasedataid"));
                    }
                    rowDataMap.put(controlNumber, idList);
                    continue;
                }
                rowDataMap.put(controlNumber, ((DynamicObject)((DynamicObjectCollection)value).get(0)).get("fbasedataid"));
            }
            rowDataMap.put("effectdate", row.getDate("effectdate"));
            rowDataMap.put("expiredate", row.getDate("expiredate"));
            rowDataMap.put("enable_en", row.getBoolean("enable_en"));
            rowListS.add(rowDataMap);
        }
        return SerializationUtils.serializeToBase64(rowListS);
    }
}

